/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.condition;

import ericsson.ere.RatingData;
import ericsson.ere.condition.AbstractCondition;
import ericsson.ere.interfaces.Condition;
import ericsson.ere.interfaces.ConditionV3;
import ericsson.ere.interfaces.DAGNode;
import ericsson.ere.interfaces.TariffNodeLink;
import ericsson.ere.interfaces.TariffStructureNode;
import ericsson.ere.interfaces.XMLInitializable;
import ericsson.ere.values.DoubleValue;
import ericsson.ere.values.LongValue;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class ConditionLink
extends AbstractCondition
implements TariffNodeLink,
ConditionV3 {
    protected String myTargetName = null;
    protected Condition myTargetNode = null;
    protected boolean myTargetSupportsV3 = false;

    @Override
    public XMLInitializable init(Node iterator) throws Exception {
        super.init(iterator);
        NamedNodeMap attr = iterator.getAttributes();
        this.myTargetName = attr.getNamedItem("target").getNodeValue().trim();
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCodeImpl();
        result = 31 * result + (this.myTargetName == null ? 0 : this.myTargetName.hashCode());
        result = 31 * result + (this.myTargetNode == null ? 0 : this.myTargetNode.hashCode());
        result = 31 * result + (this.myTargetSupportsV3 ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !super.equalsImpl(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConditionLink other = (ConditionLink)obj;
        if (this.myTargetName == null ? other.myTargetName != null : !this.myTargetName.equals(other.myTargetName)) {
            return false;
        }
        if (this.myTargetNode == null ? other.myTargetNode != null : !this.myTargetNode.equals(other.myTargetNode)) {
            return false;
        }
        return this.myTargetSupportsV3 == other.myTargetSupportsV3;
    }

    @Override
    public void setConditionName(String conditionName1) {
        throw new IllegalArgumentException("ConditionLink");
    }

    @Override
    public void setKey(String key1) {
        throw new IllegalArgumentException("ConditionLink");
    }

    @Override
    public void setDataType(String dataType1) {
        throw new IllegalArgumentException("ConditionLink");
    }

    @Override
    public String getConditionName() {
        throw new IllegalArgumentException("ConditionLink");
    }

    @Override
    public String getKey() {
        throw new IllegalArgumentException("ConditionLink");
    }

    @Override
    public String getDataType() {
        throw new IllegalArgumentException("ConditionLink");
    }

    @Override
    public void add(Condition child) throws Exception {
        if (this.myTargetNode != null) {
            throw new IllegalArgumentException("Link already contains child");
        }
        this.myTargetNode = child;
        this.myTargetSupportsV3 = this.myTargetNode instanceof ConditionV3;
        ((DAGNode)((Object)child)).addReferer(this);
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public boolean test(RatingData theData, DoubleValue theCost, LongValue theTime) throws Exception {
        return this.myTargetNode.test(theData, theCost, theTime);
    }

    @Override
    public long getConditionSatisfiedDuration(RatingData theData) {
        return this.myTargetNode.getConditionSatisfiedDuration(theData);
    }

    @Override
    public long getConditionUnsatisfiedDuration(RatingData theData) {
        return this.myTargetNode.getConditionUnsatisfiedDuration(theData);
    }

    @Override
    public void enter(RatingData theData) {
        if (this.myTargetSupportsV3) {
            ((ConditionV3)this.myTargetNode).enter(theData);
        }
    }

    @Override
    public boolean isReadyToLeave(RatingData theData) {
        if (this.myTargetSupportsV3) {
            return ((ConditionV3)this.myTargetNode).isReadyToLeave(theData);
        }
        return true;
    }

    @Override
    public void leave(RatingData theData) {
        if (this.myTargetSupportsV3) {
            ((ConditionV3)this.myTargetNode).leave(theData);
        }
    }

    @Override
    public boolean needsFieldToBeSet() {
        return false;
    }

    @Override
    public void setFieldName(String fieldName) {
    }

    @Override
    public String getTypename() {
        if (this.myTargetNode == null) {
            throw new IllegalArgumentException("ConditionLink - target not set");
        }
        return this.myTargetNode.getTypename();
    }

    @Override
    public DAGNode getChildAt(int index) throws IndexOutOfBoundsException {
        if (index == 0) {
            return (DAGNode)((Object)this.myTargetNode);
        }
        throw new IndexOutOfBoundsException("No child at index: " + index);
    }

    @Override
    public int getChildCount() {
        if (this.myTargetNode != null) {
            return 1;
        }
        return 0;
    }

    @Override
    public void insertChildAt(int index, DAGNode node) throws IndexOutOfBoundsException {
        if (index != 0 || this.myTargetNode != null) {
            throw new IndexOutOfBoundsException("No child at index: " + index);
        }
        this.myTargetNode = (Condition)((Object)node);
        this.myTargetSupportsV3 = this.myTargetNode instanceof ConditionV3;
        node.setParent(this);
    }

    @Override
    public void insertLinkAt(int index, DAGNode node) throws IndexOutOfBoundsException {
        if (index != 0 || this.myTargetNode != null) {
            throw new IndexOutOfBoundsException("No child at index: " + index);
        }
        this.myTargetNode = (Condition)((Object)node);
        this.myTargetSupportsV3 = this.myTargetNode instanceof ConditionV3;
        node.addReferer(this);
    }

    @Override
    protected void removeChild(DAGNode node) throws IllegalArgumentException {
        throw new IllegalArgumentException("Node not removed, structure is read-only");
    }

    @Override
    protected void removeLink(DAGNode node) throws IllegalArgumentException {
        throw new IllegalArgumentException("Node not removed, structure is read-only");
    }

    @Override
    public int getNodeType() {
        return 2;
    }

    @Override
    public boolean isLink() {
        return true;
    }

    @Override
    public String getLinkPath() {
        return this.myTargetName;
    }

    @Override
    public void setTarget(TariffStructureNode node) throws IllegalArgumentException, Exception {
        if (node == null) {
            throw new IllegalArgumentException("null target not allowed");
        }
        if (this.getChildCount() > 0) {
            if (node != this.getChildAt(0)) {
                throw new IllegalArgumentException("Link already contains child");
            }
        } else {
            this.insertLinkAt(0, node);
        }
    }
}

