/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.condition.bonus;

import ericsson.ere.RatingData;
import ericsson.ere.condition.AbstractCondition;
import ericsson.ere.interfaces.XMLInitializable;
import ericsson.ere.values.DoubleValue;
import ericsson.ere.values.LongValue;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AccumulatedBonusCondition
extends AbstractCondition {
    private long myMaxValue;
    private long myMinValue;
    public static final String TAG_MAX_VALUE = "CounterMaxValue";
    public static final String TAG_MIN_VALUE = "CounterMinValue";

    @Override
    public XMLInitializable init(Node iterator) throws Exception {
        super.init(iterator);
        String nodeValue = "";
        this.setConditionName(iterator.getChildNodes().item(0).getNodeValue().trim());
        if (iterator.hasChildNodes()) {
            NodeList children = iterator.getChildNodes();
            for (int aa = 0; aa < children.getLength(); ++aa) {
                NodeList value;
                int bb;
                String nodeName = children.item(aa).getNodeName().toLowerCase();
                if (children.item(aa).hasChildNodes() && (bb = 0) < (value = children.item(aa).getChildNodes()).getLength()) {
                    nodeValue = value.item(bb).getNodeValue();
                }
                if (nodeName.equals(TAG_MAX_VALUE.toLowerCase())) {
                    this.myMaxValue = Long.parseLong(nodeValue);
                    continue;
                }
                if (!nodeName.equals(TAG_MIN_VALUE.toLowerCase())) continue;
                this.myMinValue = Long.parseLong(nodeValue);
            }
        }
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCodeImpl();
        result = 31 * result + (int)(this.myMaxValue ^ this.myMaxValue >>> 32);
        result = 31 * result + (int)(this.myMinValue ^ this.myMinValue >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !super.equalsImpl(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AccumulatedBonusCondition other = (AccumulatedBonusCondition)obj;
        if (this.myMaxValue != other.myMaxValue) {
            return false;
        }
        return this.myMinValue == other.myMinValue;
    }

    @Override
    public boolean needsFieldToBeSet() {
        return false;
    }

    @Override
    public void setFieldName(String fieldName) {
    }

    @Override
    public boolean test(RatingData theData, DoubleValue theCost, LongValue theTime) throws Exception {
        Long currentAccumulatorValue = (Long)theData.getValueObject("Bonus counter");
        if (currentAccumulatorValue >= this.myMinValue && currentAccumulatorValue <= this.myMaxValue) {
            long maxAccumulatorIncrease = this.myMaxValue - currentAccumulatorValue + 1L;
            theData.setWorkingLong("maxAccumulatorIncrease", maxAccumulatorIncrease);
            long maxAccumulatorDecrease = this.myMinValue - currentAccumulatorValue - 1L;
            theData.setWorkingLong("maxAccumulatorDecrease", maxAccumulatorDecrease);
            theData.setWorkingLong("flagUseMaxAccumulator", 1L);
            System.out.println("TCAccumulatedUsage::test == TRUE");
            System.out.println("maxAccumulatorIncrease: " + maxAccumulatorIncrease);
            System.out.println("maxAccumulatorDecrease: " + maxAccumulatorDecrease);
            return true;
        }
        System.out.println("TCAccumulatedUsage::test == FALSE");
        return false;
    }
}

