/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.condition.date;

import com.ericsson.ere.annotations.SupersededBy;
import ericsson.ere.RatingData;
import ericsson.ere.condition.AbstractCondition;
import ericsson.ere.condition.logic.CompoundBooleanCondition;
import ericsson.ere.interfaces.XMLInitializable;
import ericsson.ere.values.DoubleValue;
import ericsson.ere.values.LongValue;
import java.util.ArrayList;
import java.util.Calendar;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Deprecated
@SupersededBy(value=com.ericsson.ere.selectiontree.conditions.date.DayOfWeek.class)
public class DayOfWeek
extends AbstractCondition {
    byte myStartDay;
    byte myStopDay;

    public DayOfWeek() {
    }

    private DayOfWeek(byte startDay, byte stopDay, String k) {
        this.myStartDay = startDay;
        this.myStopDay = stopDay;
        this.setKey(k);
    }

    @Override
    public XMLInitializable init(Node iterator) throws Exception {
        byte stopDay;
        byte startDay;
        super.init(iterator);
        String from = null;
        String to = null;
        this.setConditionName(iterator.getChildNodes().item(0).getNodeValue().trim());
        if (iterator.hasChildNodes()) {
            NodeList children = iterator.getChildNodes();
            for (int aa = 0; aa < children.getLength(); ++aa) {
                NodeList value;
                int bb;
                if (children.item(aa).getNodeName().toLowerCase().equals("From".toLowerCase())) {
                    if (!children.item(aa).hasChildNodes() || (bb = 0) >= (value = children.item(aa).getChildNodes()).getLength()) continue;
                    from = value.item(bb).getNodeValue();
                    continue;
                }
                if (!children.item(aa).getNodeName().toLowerCase().equals("To".toLowerCase()) || !children.item(aa).hasChildNodes() || (bb = 0) >= (value = children.item(aa).getChildNodes()).getLength()) continue;
                to = value.item(bb).getNodeValue();
            }
        }
        if ((startDay = Byte.parseByte(from)) > (stopDay = Byte.parseByte(to))) {
            ArrayList<Object> conds = new ArrayList<Object>(2);
            conds.add(new DayOfWeek(startDay, 6, this.getKey()));
            conds.add(new DayOfWeek(0, stopDay, this.getKey()));
            CompoundBooleanCondition c = new CompoundBooleanCondition("OR", conds);
            c.setNodeId(this.getNodeId());
            c.setTypename(this.getTypename());
            return c;
        }
        this.myStartDay = startDay;
        this.myStopDay = stopDay;
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCodeImpl();
        result = 31 * result + this.myStartDay;
        result = 31 * result + this.myStopDay;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !super.equalsImpl(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DayOfWeek other = (DayOfWeek)obj;
        if (this.myStartDay != other.myStartDay) {
            return false;
        }
        return this.myStopDay == other.myStopDay;
    }

    @Override
    public boolean test(RatingData theData, DoubleValue theCost, LongValue theTime) throws Exception {
        int dayOfWeek;
        if (theData.useTrace()) {
            theData.getTrace().println("\tDayOFWeek the key is " + this.key);
        }
        if (this.key.equals("DayOfWeek")) {
            if (theData.useTrace()) {
                theData.getTrace().println("\tDate is : " + theData.currentStartDate.getTime());
            }
            dayOfWeek = theData.currentStartDate.get(7) - 2;
        } else {
            Calendar myCalendar = (Calendar)theData.getValueObject(this.key);
            if (theData.useTrace()) {
                theData.getTrace().println("\tDate is : " + myCalendar.getTime());
            }
            dayOfWeek = myCalendar.get(7) - 2;
        }
        if (dayOfWeek < 0) {
            dayOfWeek = 6;
        }
        if (theData.useTrace()) {
            theData.getTrace().println("\tmyStartDay = " + this.myStartDay + "   myStopDay = " + this.myStopDay);
        }
        if (dayOfWeek >= this.myStartDay && dayOfWeek <= this.myStopDay) {
            long max = this.getConditionSatisfiedDuration(theData);
            theData.setCurrentMaxDuration(max);
            if (theData.useTrace()) {
                theData.getTrace().println("\tTCDayOfWeek::test : " + dayOfWeek + " => TRUE (maxDuration == " + theData.currentMaxDuration + ")");
            }
            return true;
        }
        long max = this.getConditionUnsatisfiedDuration(theData);
        theData.setCurrentMaxDuration(max);
        if (theData.useTrace()) {
            theData.getTrace().println("\tTCDayOfWeek::test : " + dayOfWeek + " => FALSE (maxDuration == " + theData.currentMaxDuration + ")");
        }
        return false;
    }

    @Override
    public boolean needsFieldToBeSet() {
        return true;
    }

    @Override
    public void setFieldName(String fieldName) {
        if (fieldName == null || fieldName.trim().length() == 0) {
            this.setKey("DayOfWeek");
        } else {
            this.setKey(fieldName);
        }
    }

    @Override
    public long getConditionSatisfiedDuration(RatingData theData) {
        long days;
        int dayOfWeek = theData.currentStartDate.get(7) - 2;
        if (dayOfWeek < 0) {
            dayOfWeek = 6;
        }
        if ((days = (long)(this.myStopDay - dayOfWeek)) < 0L) {
            days += 7L;
        }
        return days * 86400L + 86400L - theData.currentStartTime;
    }

    @Override
    public long getConditionUnsatisfiedDuration(RatingData theData) {
        long days;
        int dayOfWeek = theData.currentStartDate.get(7) - 2;
        if (dayOfWeek < 0) {
            dayOfWeek = 6;
        }
        if ((days = (long)(this.myStartDay - 1 - dayOfWeek)) < 0L) {
            days += 7L;
        }
        return days * 86400L + 86400L - theData.currentStartTime;
    }
}

