/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.condition.date;

import ericsson.ere.condition.AbstractConditionProfile;
import ericsson.ere.defs.EreDefs;
import ericsson.ere.gui.util.GuiUtil;
import ericsson.vareditor.variable.DropDownVariable;
import ericsson.vareditor.variable.VarListUtil;
import ericsson.vareditor.variable.Variable;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DayOfWeekProfile
extends AbstractConditionProfile {
    @Override
    public List<Variable> getVariables() {
        ArrayList<Variable> l = new ArrayList<Variable>(3);
        l.add(new DropDownVariable("From", 0, (Object[])EreDefs.weekdays));
        l.add(new DropDownVariable("To", 0, (Object[])EreDefs.weekdays));
        return l;
    }

    @Override
    public List<Variable> getVariables(Node iterator) {
        ArrayList<Variable> l = new ArrayList<Variable>(3);
        String from = "0";
        String to = "0";
        if (iterator.hasChildNodes()) {
            NodeList children = iterator.getChildNodes();
            for (int aa = 0; aa < children.getLength(); ++aa) {
                String v;
                NodeList value;
                int bb;
                if (children.item(aa).getNodeType() != 1) continue;
                String key = children.item(aa).getNodeName();
                if (key.equalsIgnoreCase("From") && children.item(aa).hasChildNodes() && (bb = 0) < (value = children.item(aa).getChildNodes()).getLength()) {
                    from = v = value.item(bb).getNodeValue();
                }
                if (!key.equalsIgnoreCase("To") || !children.item(aa).hasChildNodes() || (bb = 0) >= (value = children.item(aa).getChildNodes()).getLength()) continue;
                to = v = value.item(bb).getNodeValue();
            }
        }
        l.add(new DropDownVariable("From", (Object)from, 1, EreDefs.weekdays));
        l.add(new DropDownVariable("To", (Object)to, 1, EreDefs.weekdays));
        return l;
    }

    @Override
    public void printParametersImpl(PrintWriter out, int indentLevel, String indentMarker, List<Variable> variables) {
        int i;
        String from = VarListUtil.getValueStringForName(variables, "From");
        String to = VarListUtil.getValueStringForName(variables, "To");
        for (i = 0; i < indentLevel + 1; ++i) {
            out.print(indentMarker);
        }
        out.println("<From>" + from + "</" + "From" + ">");
        for (i = 0; i < indentLevel + 1; ++i) {
            out.print(indentMarker);
        }
        out.println("<To>" + to + "</" + "To" + ">");
    }

    @Override
    public String getAdditionalInfo(List<Variable> variables) {
        String from = VarListUtil.getValueStringForName(variables, "From");
        String to = VarListUtil.getValueStringForName(variables, "To");
        from = from.equals("-1") ? "Invalid" : EreDefs.weekdays[Integer.valueOf(from)];
        to = to.equals("-1") ? "Invalid" : EreDefs.weekdays[Integer.valueOf(to)];
        String info = "<b>" + this.getDescription(variables) + "</b>";
        info = info + " (" + from + "-" + to + ")";
        info = info + "\n" + this.getComment(variables);
        return GuiUtil.multilineTooltipWrapper(info);
    }
}

