/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.condition.distance;

import ericsson.ere.condition.AbstractConditionProfile;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.gui.ratingrules.ClassRepositoryGui;
import ericsson.vareditor.variable.DropDownVariable;
import ericsson.vareditor.variable.VarListUtil;
import ericsson.vareditor.variable.Variable;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DistanceConditionProfile
extends AbstractConditionProfile {
    ClassRepository myClassRep;
    ClassRepositoryGui repositoryGui;
    private static String LBL_FROM_LONG = "From Long";
    private static String LBL_FROM_LAT = "From Lat";
    private static String LBL_END_LONG = "End Long";
    private static String LBL_END_LAT = "End Lat";
    private static String LBL_DISTANCE_FIELD = "Field for Distance";

    @Override
    public List<Variable> getVariables() {
        ArrayList<Variable> l = new ArrayList<Variable>(6);
        Object[] stringFieldnames = this.myClassRep.getFieldNamesOfType(6);
        Object[] numericFieldnames = this.myClassRep.getNumericFieldNames();
        l.add(new DropDownVariable(LBL_FROM_LONG, (Object)stringFieldnames[0], stringFieldnames));
        l.add(new DropDownVariable(LBL_FROM_LAT, stringFieldnames[0], stringFieldnames));
        l.add(new DropDownVariable(LBL_END_LONG, stringFieldnames[0], stringFieldnames));
        l.add(new DropDownVariable(LBL_END_LAT, stringFieldnames[0], stringFieldnames));
        l.add(new DropDownVariable(LBL_DISTANCE_FIELD, (Object)numericFieldnames[0], numericFieldnames));
        return l;
    }

    @Override
    public List<Variable> getVariables(Node iterator) {
        ArrayList<Variable> l = new ArrayList<Variable>(6);
        Object[] stringFieldnames = this.myClassRep.getFieldNamesOfType(6);
        Object[] numericFieldnames = this.myClassRep.getNumericFieldNames();
        String fromLong = "";
        String fromLat = "";
        String endLong = "";
        String endLat = "";
        String distance = "";
        NodeList children = iterator.getChildNodes();
        for (int aa = 0; aa < children.getLength(); ++aa) {
            if (children.item(aa).getNodeType() != 1) continue;
            String nodeName = children.item(aa).getNodeName();
            String nodeValue = "";
            int bb = 0;
            NodeList value = children.item(aa).getChildNodes();
            if (bb < value.getLength()) {
                nodeValue = value.item(bb).getNodeValue();
            }
            if (nodeName.equalsIgnoreCase("FromLongitudeField")) {
                fromLong = nodeValue;
                continue;
            }
            if (nodeName.equalsIgnoreCase("FromLatitudeField")) {
                fromLat = nodeValue;
                continue;
            }
            if (nodeName.equalsIgnoreCase("EndLongitudeField")) {
                endLong = nodeValue;
                continue;
            }
            if (nodeName.equalsIgnoreCase("EndLatitudeField")) {
                endLat = nodeValue;
                continue;
            }
            if (!nodeName.equalsIgnoreCase("FieldNameToUse")) continue;
            distance = nodeValue;
        }
        l.add(new DropDownVariable(LBL_FROM_LONG, (Object)fromLong, stringFieldnames));
        l.add(new DropDownVariable(LBL_FROM_LAT, (Object)fromLat, stringFieldnames));
        l.add(new DropDownVariable(LBL_END_LONG, (Object)endLong, stringFieldnames));
        l.add(new DropDownVariable(LBL_END_LAT, (Object)endLat, stringFieldnames));
        l.add(new DropDownVariable(LBL_DISTANCE_FIELD, (Object)distance, numericFieldnames));
        return l;
    }

    @Override
    public void printParametersImpl(PrintWriter out, int indentLevel, String indentMarker, List<Variable> variables) {
        String fromLong = VarListUtil.getValueStringForName(variables, LBL_FROM_LONG);
        String fromLat = VarListUtil.getValueStringForName(variables, LBL_FROM_LAT);
        String endLong = VarListUtil.getValueStringForName(variables, LBL_END_LONG);
        String endLat = VarListUtil.getValueStringForName(variables, LBL_END_LAT);
        String distance = VarListUtil.getValueStringForName(variables, LBL_DISTANCE_FIELD);
        out.println("<FromLongitudeField>" + fromLong + "</" + "FromLongitudeField" + ">");
        out.println("<FromLatitudeField>" + fromLat + "</" + "FromLatitudeField" + ">");
        out.println("<EndLongitudeField>" + endLong + "</" + "EndLongitudeField" + ">");
        out.println("<EndLatitudeField>" + endLat + "</" + "EndLatitudeField" + ">");
        out.println("<FieldNameToUse>" + distance + "</" + "FieldNameToUse" + ">");
    }

    @Override
    public boolean needsRepository() {
        return true;
    }

    @Override
    public void setClassRepository(ClassRepository repository) {
        this.myClassRep = repository;
        this.repositoryGui = new ClassRepositoryGui(repository);
    }
}

