/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.condition.numberList;

import ericsson.ere.RatingData;
import ericsson.ere.condition.AbstractCondition;
import ericsson.ere.condition.numberList.NumberTree;
import ericsson.ere.interfaces.XMLInitializable;
import ericsson.ere.values.DoubleValue;
import ericsson.ere.values.LongValue;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NumberList
extends AbstractCondition {
    static final String TAG_NUMBER = "Number";
    boolean iAmTrueIfInList;
    NumberTree myNumbers;

    public NumberList() {
        this.iAmTrueIfInList = true;
    }

    public NumberList(boolean trueIfInList) {
        this.iAmTrueIfInList = trueIfInList;
    }

    @Override
    public XMLInitializable init(Node iterator) throws Exception {
        super.init(iterator);
        String theNumbers = "";
        this.setConditionName(iterator.getChildNodes().item(0).getNodeValue().trim());
        if (iterator.hasChildNodes()) {
            NodeList children = iterator.getChildNodes();
            for (int aa = 0; aa < children.getLength(); ++aa) {
                NodeList value;
                int bb;
                if (!children.item(aa).getNodeName().equals(TAG_NUMBER) || !children.item(aa).hasChildNodes() || (bb = 0) >= (value = children.item(aa).getChildNodes()).getLength()) continue;
                theNumbers = value.item(bb).getNodeValue();
            }
        }
        this.myNumbers = new NumberTree(theNumbers);
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCodeImpl();
        result = 31 * result + (this.iAmTrueIfInList ? 1231 : 1237);
        result = 31 * result + (this.myNumbers == null ? 0 : this.myNumbers.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !super.equalsImpl(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NumberList other = (NumberList)obj;
        if (this.iAmTrueIfInList != other.iAmTrueIfInList) {
            return false;
        }
        return !(this.myNumbers == null ? other.myNumbers != null : !this.myNumbers.equals(other.myNumbers));
    }

    @Override
    public boolean test(RatingData theData, DoubleValue theCost, LongValue theTime) throws Exception {
        boolean result;
        String numberToCheck = theData.getValueObject(this.key).toString();
        if (this.iAmTrueIfInList) {
            result = this.myNumbers.checkNumber(numberToCheck, 0);
        } else {
            boolean bl = result = !this.myNumbers.checkNumber(numberToCheck, 0);
        }
        if (theData.useTrace()) {
            theData.getTrace().println("\tNumberList.test " + numberToCheck + " => " + (result ? "TRUE" : "FALSE"));
        }
        return result;
    }

    @Override
    public boolean needsFieldToBeSet() {
        return true;
    }

    @Override
    public void setFieldName(String fieldName) {
        this.setKey(fieldName);
    }
}

