/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.condition.string;

import ericsson.ere.condition.AbstractConditionProfile;
import ericsson.vareditor.documents.StringListDocument;
import ericsson.vareditor.variable.BoolVariable;
import ericsson.vareditor.variable.MultilineStringVariable;
import ericsson.vareditor.variable.VarListUtil;
import ericsson.vareditor.variable.Variable;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class StringListProfile
extends AbstractConditionProfile {
    static String LABEL_STRING = "Strings";
    private static String LABEL_MATCH_CASE = "Match case";

    @Override
    public List<Variable> getVariables() {
        ArrayList<Variable> l = new ArrayList<Variable>();
        String defaultString = "";
        StringListDocument doc = new StringListDocument(defaultString.getClass());
        l.add(new MultilineStringVariable(LABEL_STRING, defaultString, doc));
        l.add(new BoolVariable(LABEL_MATCH_CASE, true));
        return l;
    }

    @Override
    public List<Variable> getVariables(Node iterator) {
        ArrayList<Variable> l = new ArrayList<Variable>();
        String strings = "";
        boolean match = true;
        NodeList children = iterator.getChildNodes();
        for (int aa = 0; aa < children.getLength(); ++aa) {
            NodeList value;
            int bb;
            if (children.item(aa).getNodeType() != 1) continue;
            String k = children.item(aa).getNodeName();
            if (k.equalsIgnoreCase("String") && (bb = 0) < (value = children.item(aa).getChildNodes()).getLength()) {
                strings = value.item(bb).getNodeValue();
            }
            if (!k.equalsIgnoreCase("MatchCase") || (bb = 0) >= (value = children.item(aa).getChildNodes()).getLength()) continue;
            match = Boolean.valueOf(value.item(bb).getNodeValue());
        }
        StringListDocument doc = new StringListDocument(strings.getClass());
        l.add(new MultilineStringVariable(LABEL_STRING, strings, doc));
        l.add(new BoolVariable(LABEL_MATCH_CASE, match));
        return l;
    }

    @Override
    public void printParametersImpl(PrintWriter out, int indentLevel, String indentMarker, List<Variable> variables) {
        String strings = VarListUtil.getValueStringForName(variables, LABEL_STRING);
        out.println("<String>" + strings + "</" + "String" + ">");
        boolean match = VarListUtil.getBooleanValueForName(variables, LABEL_MATCH_CASE);
        out.println("<MatchCase>" + match + "</" + "MatchCase" + ">");
    }
}

