/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.condition.time;

import ericsson.ere.condition.AbstractConditionProfile;
import ericsson.ere.gui.util.GuiUtil;
import ericsson.ere.xml.XMLUtil;
import ericsson.vareditor.variable.IntegerVariable;
import ericsson.vareditor.variable.StringVariable;
import ericsson.vareditor.variable.VarListUtil;
import ericsson.vareditor.variable.Variable;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TimeInCallSegmentProfile
extends AbstractConditionProfile {
    public static final String LBL_DENOMINATOR = "Denominator";
    public static final String LBL_REMAINDER = "Remainder(s)";

    @Override
    public List<Variable> getVariables() {
        ArrayList<Variable> l = new ArrayList<Variable>(5);
        l.add(new IntegerVariable(LBL_DENOMINATOR, 1, 1, Integer.MAX_VALUE));
        l.add(new StringVariable(LBL_REMAINDER, "0,0-0"));
        return l;
    }

    @Override
    public List<Variable> getVariables(Node iterator) {
        ArrayList<Variable> l = new ArrayList<Variable>(5);
        NodeList children = iterator.getChildNodes();
        Element denomNode = XMLUtil.getNamedElement(LBL_DENOMINATOR, children);
        Element remainderNode = XMLUtil.getNamedElement("ModulusResults", children);
        if (denomNode == null) {
            throw new IllegalArgumentException("Mandatory tag Denominator missing.");
        }
        if (remainderNode == null) {
            throw new IllegalArgumentException("Mandatory tag ModulusResults missing.");
        }
        String denominatorString = XMLUtil.getFirstTextContent(denomNode);
        String remainderString = XMLUtil.getFirstTextContent(remainderNode);
        l.add(new IntegerVariable(LBL_DENOMINATOR, denominatorString, 1, Integer.MAX_VALUE));
        l.add(new StringVariable(LBL_REMAINDER, remainderString));
        return l;
    }

    @Override
    public void printParametersImpl(PrintWriter out, int indentLevel, String indentMarker, List<Variable> variables) {
        String denom = VarListUtil.getValueStringForName(variables, LBL_DENOMINATOR);
        String remain = VarListUtil.getValueStringForName(variables, LBL_REMAINDER);
        out.println("<Denominator>" + denom + "</" + LBL_DENOMINATOR + ">");
        out.println("<ModulusResults>" + remain + "</" + "ModulusResults" + ">");
    }

    @Override
    public String getAdditionalInfo(List<Variable> variables) {
        String name = VarListUtil.getValueStringForName(variables, "Name");
        String denom = VarListUtil.getValueStringForName(variables, LBL_DENOMINATOR);
        String remain = VarListUtil.getValueStringForName(variables, LBL_REMAINDER);
        name = "<b>" + name + "</b> ";
        name = name + "Denominator: " + denom + "<p>";
        name = name + "Remainder(s): " + remain.trim() + "<p>";
        name = name + this.getComment(variables);
        return GuiUtil.multilineTooltipWrapper(name);
    }
}

