/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.datatype;

import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.datatype.EREDate;
import com.ericsson.ere.datatype.EREDateFactory;
import com.ericsson.ere.datatype.EREDateUtil;
import com.ericsson.ere.datatype.ERETime;
import com.ericsson.ere.datatype.ERETimeFactory;
import com.ericsson.ere.datatype.ERETimeUtil;
import com.ericsson.ere.datatype.ValueResolver;
import com.ericsson.ere.math.RatingDecimal;
import com.ericsson.ere.math.RatingDecimalUtil;
import com.ericsson.ere.selectiontree.util.AmountUtil;
import ericsson.ere.datatype.Amount;
import ericsson.ere.datatype.AmountStub;
import ericsson.ere.datatype.BcdString;
import ericsson.ere.datatype.ContextBasedValueResolver;
import ericsson.ere.datatype.Decimal;
import ericsson.ere.datatype.MonetaryUnits;
import ericsson.ere.datatype.OctetString;
import ericsson.ere.datatype.Time;
import ericsson.ere.datatype.UnsignedInt16;
import ericsson.ere.datatype.UnsignedInt32;
import ericsson.ere.datatype.UnsignedInt8;
import ericsson.ere.datatype.UnsignedInteger;
import ericsson.ere.datatype.UnsignedLong;
import ericsson.ere.datatype.UnsignedShort;
import ericsson.ere.datatype.factory.DefaultAmountFactory;
import ericsson.ere.datatype.interfaces.AmountFactory;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.management.DateUtil;
import ericsson.ere.util.StringUtil;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class DataType
extends Enum<DataType>
implements ValueResolver {
    public static final /* enum */ DataType UNSIGNEDINT8 = new DataType("UnsignedInt8", 2, new Class[]{UnsignedInt8.class}){

        @Override
        public Object createDefaultInstance() {
            return new UnsignedInt8(0);
        }

        @Override
        public int bitSize() {
            return 8;
        }

        @Override
        protected Object _parseValue(String str) {
            return UnsignedInt8.valueOf(str);
        }
    };
    public static final /* enum */ DataType UNSIGNEDINT16 = new DataType("UnsignedInt16", 1, new Class[]{UnsignedInt16.class}){

        @Override
        public Object createDefaultInstance() {
            return new UnsignedInt16(0);
        }

        @Override
        public int bitSize() {
            return 16;
        }

        @Override
        protected Object _parseValue(String str) {
            return UnsignedInt16.valueOf(str);
        }
    };
    public static final /* enum */ DataType UNSIGNEDINT32 = new DataType("UnsignedInt32", 0, new Class[]{UnsignedInt32.class}){

        @Override
        public Object createDefaultInstance() {
            return new UnsignedInt32(0);
        }

        @Override
        public int bitSize() {
            return 32;
        }

        @Override
        protected Object _parseValue(String str) {
            return UnsignedInt32.valueOf(str);
        }
    };
    public static final /* enum */ DataType TIME = new DataType("Time", 5, new Class[]{ERETime.class, Time.class, Calendar.class}){

        @Override
        public Object createDefaultInstance() {
            return ERETimeFactory.now();
        }

        @Override
        protected String _makeDisplayString(Object o) {
            String retVal;
            if (o instanceof ERETime) {
                ERETime time = (ERETime)o;
                retVal = EREDateUtil.isBoundaryDate(o) ? o.toString() : String.format("%04d-%02d-%02d %02d:%02d:%02d", time.getFullYear(), time.getMonthOfYear(), time.getDayOfMonth(), time.getHours(), time.getMinutes(), time.getSeconds());
            } else if (o instanceof Time) {
                Calendar cal = ((Time)o).getCalendar();
                retVal = DateUtil.format(cal.getTime(), DateUtil.TIMEOFDAY_TEXT_FORMAT[3]);
            } else {
                retVal = DateUtil.format(((Calendar)o).getTime(), DateUtil.TIMEOFDAY_TEXT_FORMAT[3]);
            }
            return retVal;
        }

        @Override
        protected String _makeParseableString(Object o) {
            String retVal;
            if (o instanceof ERETime) {
                if (ERETimeUtil.isBoundaryDate(o)) {
                    retVal = o.toString();
                } else {
                    ERETime time = (ERETime)o;
                    Date date = time.asDate();
                    retVal = DateUtil.formatISODateTime(date, true);
                }
            } else {
                Calendar cal = o instanceof Time ? ((Time)o).getCalendar() : (Calendar)o;
                retVal = DateUtil.formatISODateTime(cal, true);
            }
            return retVal;
        }

        @Override
        protected Object _parseValue(String str) {
            return ERETimeFactory.parseTimeString(str);
        }

        @Override
        protected String makeDisplayString(Object obj, ContextBasedValueResolver.ValueResolverContext context) {
            FieldDefinition field = context.getFieldDefinition();
            if (ERETimeUtil.isBoundaryDate(obj) && field != null) {
                return ERETimeUtil.getDisplayableStringForERETimeConstant((ERETime)obj, field);
            }
            return super.makeDisplayString(obj, context);
        }

        @Override
        public Object castObject(Object o) {
            Object obj = o == null ? null : (o instanceof EREDate ? ERETimeUtil.convertToERETime(o) : super.castObject(o));
            return obj;
        }
    };
    public static final /* enum */ DataType OCTETSTRING = new DataType("OctetString", 8, new Class[]{OctetString.class}){

        @Override
        public Object createDefaultInstance() {
            return new OctetString("");
        }

        @Override
        protected Object _parseValue(String str) {
            return OctetString.valueOf(str);
        }
    };
    public static final /* enum */ DataType BCDSTRING = new DataType("BcdString", 7, new Class[]{BcdString.class}){

        @Override
        public Object createDefaultInstance() {
            return new BcdString("");
        }

        @Override
        protected Object _parseValue(String str) throws Exception {
            return BcdString.valueOf(str);
        }
    };
    public static final /* enum */ DataType MONETARYUNITS = new DataType("MonetaryUnits", 3, new Class[]{MonetaryUnits.class}){

        @Override
        public Object createDefaultInstance() {
            return new MonetaryUnits(0, 0, 0);
        }

        @Override
        protected Object _parseValue(String str) {
            return new MonetaryUnits(str);
        }
    };
    public static final /* enum */ DataType DECIMAL = new DataType("Decimal", 4, new Class[]{Decimal.class}){

        @Override
        public Object createDefaultInstance() {
            return new Decimal(0, 1);
        }

        @Override
        protected Object _parseValue(String str) {
            return new Decimal(str);
        }
    };
    public static final /* enum */ DataType RATINGDECIMAL = new DataType("RatingDecimal", 20, new Class[]{RatingDecimal.class}){

        @Override
        public Object createDefaultInstance() {
            return RatingDecimal.ZERO;
        }

        @Override
        protected Object _parseValue(String str) {
            return new RatingDecimal(str);
        }

        @Override
        protected String _makeParseableString(Object o) {
            return RatingDecimalUtil.toString((RatingDecimal)o);
        }
    };
    public static final /* enum */ DataType STRING = new DataType("String", 6, new Class[]{String.class}){

        @Override
        public Object createDefaultInstance() {
            return "";
        }

        @Override
        protected Object _parseValue(String str) {
            return str;
        }
    };
    public static final /* enum */ DataType SHORT = new DataType("Short", 9, new Class[]{Short.class, Short.TYPE}){

        @Override
        public Object createDefaultInstance() {
            return (short)0;
        }

        @Override
        public int bitSize() {
            return 16;
        }

        @Override
        protected Object _parseValue(String str) {
            return Short.parseShort(str);
        }
    };
    public static final /* enum */ DataType INTEGER = new DataType("Integer", 10, new Class[]{Integer.class, Integer.TYPE}){

        @Override
        public Object createDefaultInstance() {
            return 0;
        }

        @Override
        public int bitSize() {
            return 32;
        }

        @Override
        protected Object _parseValue(String str) {
            return Integer.parseInt(str);
        }
    };
    public static final /* enum */ DataType LONG = new DataType("Long", 11, new Class[]{Long.class, Long.TYPE}){

        @Override
        public Object createDefaultInstance() {
            return 0L;
        }

        @Override
        public int bitSize() {
            return 64;
        }

        @Override
        protected Object _parseValue(String str) {
            return Long.parseLong(str);
        }
    };
    public static final /* enum */ DataType DOUBLE = new DataType("Double", 12, new Class[]{Double.class, Double.TYPE}){

        @Override
        public Object createDefaultInstance() {
            return 0.0;
        }

        @Override
        protected Object _parseValue(String str) {
            return Double.parseDouble(str);
        }
    };
    public static final /* enum */ DataType BOOLEAN = new DataType("Boolean", 13, new Class[]{Boolean.class, Boolean.TYPE}){

        @Override
        public Object createDefaultInstance() {
            return false;
        }

        @Override
        protected Object _parseValue(String str) {
            return Boolean.parseBoolean(str);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        protected Object _parseString(String str, ContextBasedValueResolver.ValueResolverContext context) throws ParseException {
            if (!context.isStrict()) return this.parseValue(str);
            if ("true".equalsIgnoreCase(str)) {
                return true;
            }
            if (!"false".equalsIgnoreCase(str)) throw new ParseException(str, 0);
            return false;
        }
    };
    public static final /* enum */ DataType DATE = new DataType("Date", 14, new Class[]{EREDate.class, Date.class}){

        @Override
        protected String _makeParseableString(Object o) {
            if (o instanceof EREDate) {
                if (EREDateUtil.isBoundaryDate(o)) {
                    return o.toString();
                }
                return DateUtil.formatISODate((EREDate)o);
            }
            return DateUtil.formatISODateTime((Date)o, true);
        }

        @Override
        protected String _makeDisplayString(Object o) {
            if (o instanceof EREDate) {
                if (EREDateUtil.isBoundaryDate(o)) {
                    return o.toString();
                }
                EREDate date = (EREDate)o;
                return String.format("%04d-%02d-%02d", date.getFullYear(), date.getMonthOfYear(), date.getDayOfMonth());
            }
            return DateUtil.format((Date)o, DateUtil.DATE_TEXT_FORMAT[0]);
        }

        @Override
        public Object createDefaultInstance() {
            return EREDateFactory.today();
        }

        @Override
        protected Object _parseValue(String str) throws Exception {
            return DateStringParser.parseValue(str);
        }

        @Override
        protected boolean _areObjectsEqual(Object firstObject, Object secondObject) {
            boolean firstObjectIsEREDate = firstObject instanceof EREDate;
            boolean secondObjectIsEREDate = secondObject instanceof EREDate;
            if (firstObjectIsEREDate && secondObjectIsEREDate) {
                return ((EREDate)firstObject).compareTo((EREDate)secondObject) == 0;
            }
            if (firstObjectIsEREDate) {
                return ((EREDate)firstObject).compareTo((Date)secondObject) == 0;
            }
            if (secondObjectIsEREDate) {
                return ((EREDate)secondObject).compareTo((Date)firstObject) == 0;
            }
            Calendar cal1 = Calendar.getInstance();
            cal1.setTime((Date)firstObject);
            Calendar cal2 = Calendar.getInstance();
            cal2.setTime((Date)secondObject);
            return cal1.get(1) == cal2.get(1) && cal1.get(2) == cal2.get(2) && cal1.get(5) == cal2.get(5);
        }

        @Override
        protected String makeDisplayString(Object obj, ContextBasedValueResolver.ValueResolverContext context) {
            FieldDefinition field = context.getFieldDefinition();
            if (EREDateUtil.isBoundaryDate(obj) && field != null) {
                return EREDateUtil.getDisplayableStringForEREDateConstant((EREDate)obj, field);
            }
            return super.makeDisplayString(obj, context);
        }

        @Override
        public Object castObject(Object o) {
            Object obj = o == null ? o : (o instanceof ERETime ? EREDateUtil.convertToEREDate(o) : super.castObject(o));
            return obj;
        }
    };
    public static final /* enum */ DataType UNSIGNEDSHORT = new DataType("UShort", 15, new Class[]{Short.class, UnsignedShort.class}){

        @Override
        public Object createDefaultInstance() {
            return (short)0;
        }

        @Override
        public int bitSize() {
            return 16;
        }

        @Override
        public String _makeDisplayString(Object o) {
            if (o instanceof UnsignedShort) {
                return ((UnsignedShort)o).toString();
            }
            return 17.UShortParser((Short)o);
        }

        @Override
        protected Object _parseValue(String str) throws Exception {
            return Integer.valueOf(str).shortValue();
        }
    };
    public static final /* enum */ DataType UNSIGNEDINT = new DataType("UInteger", 16, new Class[]{Integer.class, UnsignedInteger.class}){

        @Override
        public Object createDefaultInstance() {
            return 0;
        }

        @Override
        public int bitSize() {
            return 32;
        }

        @Override
        public String _makeDisplayString(Object o) {
            if (o instanceof UnsignedInteger) {
                return ((UnsignedInteger)o).toString();
            }
            return 18.UIntegerParser((Integer)o);
        }

        @Override
        protected Object _parseValue(String str) throws Exception {
            return Long.valueOf(str).intValue();
        }
    };
    public static final /* enum */ DataType UNSIGNEDLONG = new DataType("ULong", 17, new Class[]{Long.class, UnsignedLong.class}){

        @Override
        public Object createDefaultInstance() {
            return 0L;
        }

        @Override
        public int bitSize() {
            return 64;
        }

        @Override
        public String _makeDisplayString(Object o) {
            if (o instanceof UnsignedLong) {
                return ((UnsignedLong)o).toString();
            }
            return 19.ULongParser((Long)o);
        }

        @Override
        protected Object _parseValue(String str) throws Exception {
            return new BigInteger(str).longValue();
        }
    };
    public static final /* enum */ DataType AMOUNT = new DataType("Amount", 19, new Class[]{Amount.class, AmountStub.class}){

        @Override
        public Object createDefaultInstance() {
            return DefaultAmountFactory.getInstance().create(AmountUtil.getCurrencyCodeForLocale());
        }

        @Override
        protected Object _parseValue(String str) throws Exception {
            return AmountStringParser.parseValue(str, null);
        }

        @Override
        protected Object createDefaultInstance(ContextBasedValueResolver.ValueResolverContext context) {
            DataSet ds = context.getDataSet();
            if (context.preferLazyEvaluatedValue() && ds == null) {
                return AmountStub.create(this.createDefaultInstance().toString());
            }
            return ds != null ? AmountUtil.createDefaultAmount(ds) : this.createDefaultInstance();
        }

        @Override
        protected Object _parseString(String str, ContextBasedValueResolver.ValueResolverContext context) throws ParseException {
            DataSet ds = context.getDataSet();
            boolean preferLazy = context.preferLazyEvaluatedValue();
            if (preferLazy && ds == null) {
                return AmountStub.create(str);
            }
            return AmountStringParser.parseValue(str, ds != null ? ds.getAmountFactory() : null);
        }

        @Override
        protected boolean _areObjectsEqual(Object firstObject, Object secondObject) {
            return ((Amount)firstObject).isEqualTo((Amount)secondObject);
        }
    };
    public static final /* enum */ DataType OBJECT = new DataType("Object", 18, new Class[]{String.class}){

        @Override
        public Object createDefaultInstance() {
            return "";
        }

        @Override
        protected Object _parseValue(String str) {
            return str;
        }
    };
    public static final String STRING_MULTI_SEPARATOR = ";";
    private static final DataType[] INT_NUMERIC_NARROWING_DATA_TYPES;
    private String myTypeName;
    private int myTypeIdentifier;
    private Class<?>[] myTypeClasses;
    private static final BigInteger USHORT_MAX;
    private static final BigInteger UINT_MAX;
    private static final BigInteger ULONG_MAX;
    private static final BigDecimal DOUBLE_MAX;
    private static final BigInteger UINT8_MAX;
    private static final BigInteger SHORT_MAX;
    private static final BigInteger INTEGER_MAX;
    private static final BigInteger LONG_MAX;
    private static final BigDecimal DOUBLE_MIN;
    private static final BigInteger SHORT_MIN;
    private static final BigInteger INTEGER_MIN;
    private static final BigInteger LONG_MIN;
    private static final /* synthetic */ DataType[] $VALUES;

    public static DataType[] values() {
        return (DataType[])$VALUES.clone();
    }

    public static DataType valueOf(String name) {
        return Enum.valueOf(DataType.class, name);
    }

    private DataType(String typeName, int identifier, Class<?> ... typeClasses) {
        this.myTypeName = typeName;
        this.myTypeClasses = typeClasses;
        this.myTypeIdentifier = identifier;
    }

    public String getTypeName() {
        return this.myTypeName;
    }

    public int getTypeIdentifier() {
        return this.myTypeIdentifier;
    }

    @Deprecated
    public Class<?> getTypeClass() {
        return this.getMainTypeClass();
    }

    public Class<?> getMainTypeClass() {
        return this.myTypeClasses[0];
    }

    public Class<?>[] getTypeClasses() {
        Class[] ret = new Class[this.myTypeClasses.length];
        System.arraycopy(this.myTypeClasses, 0, ret, 0, ret.length);
        return ret;
    }

    public Object[] createArray() {
        return this.createArray(0);
    }

    public Object[] createArray(int length) {
        return (Object[])Array.newInstance(this.getMainTypeClass(), length);
    }

    public Object[] createArray(Object ... contents) {
        Class<?> argClass = contents[0].getClass();
        Class<?> typeClass = this.getMatchingTypeClass(argClass);
        if (typeClass == null) {
            throw new IllegalArgumentException("Object class does not match any type class: " + argClass);
        }
        Object[] arr = (Object[])Array.newInstance(typeClass, contents.length);
        for (int i = 0; i < contents.length; ++i) {
            if (!typeClass.isInstance(contents[i])) {
                throw new IllegalArgumentException("Object class does not match type class: " + contents[i].getClass());
            }
            arr[i] = contents[i];
        }
        return arr;
    }

    @Override
    public abstract Object createDefaultInstance();

    public static DataType lookup(String typeName) {
        if (typeName == null) {
            return null;
        }
        for (DataType dt : DataType.values()) {
            if (!dt.myTypeName.equalsIgnoreCase(typeName)) continue;
            return dt;
        }
        return null;
    }

    public static DataType lookup(int identifier) {
        for (DataType dt : DataType.values()) {
            if (dt.myTypeIdentifier != identifier) continue;
            return dt;
        }
        return null;
    }

    public static DataType fromObjectClass(Object o) {
        if (o == null) {
            return null;
        }
        return DataType.fromClass(o.getClass());
    }

    public static DataType fromClass(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        Class<?> valueClass = clazz;
        while (valueClass.isArray()) {
            valueClass = valueClass.getComponentType();
        }
        DataType ret = DataType.specialFromObjectClass(valueClass);
        if (ret == null) {
            for (DataType dt : DataType.values()) {
                if (!dt.matchesAnyTypeClass(valueClass)) continue;
                ret = dt;
                break;
            }
        }
        return ret;
    }

    private boolean matchesAnyTypeClass(Class<?> clazz) {
        return this.getMatchingTypeClass(clazz) != null;
    }

    private Class<?> getMatchingTypeClass(Class<?> clazz) {
        Class<?> ret = null;
        for (Class<?> tc : this.getTypeClasses()) {
            if (!this.typeClassMatches(tc, clazz)) continue;
            ret = tc;
            break;
        }
        return ret;
    }

    private boolean typeClassMatches(Class<?> typeClass, Class<?> candidate) {
        return typeClass.isAssignableFrom(candidate);
    }

    private static DataType specialFromObjectClass(Class<?> valueClass) {
        if (valueClass == UnsignedShort.class) {
            return UNSIGNEDSHORT;
        }
        if (valueClass == UnsignedInteger.class) {
            return UNSIGNEDINT;
        }
        if (valueClass == UnsignedLong.class) {
            return UNSIGNEDLONG;
        }
        return null;
    }

    public Object[] parseMultiValue(String stringValues) {
        try {
            return DataType.parseMultiString(stringValues, this);
        }
        catch (ParseException ex) {
            return null;
        }
    }

    public Object parseValue(String str) {
        try {
            return this.parseValueThrow(str);
        }
        catch (Exception e) {
            return null;
        }
    }

    private Object parseValueThrow(String str) throws Exception {
        return str == null ? null : this._parseValue(str);
    }

    protected abstract Object _parseValue(String var1) throws Exception;

    public final String makeParseableString(Object o) {
        if (o == null) {
            return "";
        }
        if (!this.isInstanceOfAnyTypeClass(o)) {
            throw new IllegalArgumentException("o is not of the right type (got " + o.getClass() + ") for " + this + ".");
        }
        return this._makeParseableString(o);
    }

    private boolean isInstanceOfAnyTypeClass(Object o) {
        return this.matchesAnyTypeClass(o.getClass());
    }

    protected String _makeParseableString(Object o) {
        return o.toString();
    }

    @Override
    public final String makeDisplayString(Object o) {
        if (o == null) {
            return "";
        }
        if (!this.isInstanceOfAnyTypeClass(o)) {
            throw new IllegalArgumentException("o is not of the right type (got " + o.getClass() + ") for " + this + ".");
        }
        return this._makeDisplayString(o);
    }

    @Override
    public final Object parseValueString(String s) {
        return this.parseValue(s);
    }

    @Override
    public final String makeValueString(Object o) {
        return this.makeParseableString(o);
    }

    @Override
    public final DataType getDataType() {
        return this;
    }

    protected String _makeDisplayString(Object o) {
        return o.toString();
    }

    public boolean isNumeric() {
        return Number.class.isAssignableFrom(this.getMainTypeClass()) || this.getMainTypeClass().equals(Decimal.class);
    }

    public boolean isStringType() {
        return this == STRING || this == BCDSTRING || this == OCTETSTRING;
    }

    public boolean isIntegerNumeric() {
        return this.isNumeric() && this != DECIMAL && this != RATINGDECIMAL && this != DOUBLE;
    }

    public int bitSize() {
        return -1;
    }

    public boolean isAssignableFrom(DataType other) {
        if (this == other) {
            return true;
        }
        if (this == RATINGDECIMAL && other.isNumeric()) {
            return true;
        }
        if (!this.isIntegerNumeric() || !other.isIntegerNumeric()) {
            return false;
        }
        if (this.isUnsignedNumeric() == other.isUnsignedNumeric()) {
            return this.bitSize() >= other.bitSize();
        }
        return false;
    }

    public boolean isUnsignedNumeric() {
        switch (this) {
            case UNSIGNEDINT8: 
            case UNSIGNEDINT16: 
            case UNSIGNEDINT32: 
            case UNSIGNEDSHORT: 
            case UNSIGNEDINT: 
            case UNSIGNEDLONG: {
                return true;
            }
        }
        return false;
    }

    public Number getMinimumValue() {
        if (!this.isNumeric()) {
            return null;
        }
        switch (this) {
            case SHORT: {
                return SHORT_MIN;
            }
            case INTEGER: {
                return INTEGER_MIN;
            }
            case LONG: {
                return LONG_MIN;
            }
            case UNSIGNEDINT8: 
            case UNSIGNEDINT16: 
            case UNSIGNEDINT32: 
            case UNSIGNEDSHORT: 
            case UNSIGNEDINT: 
            case UNSIGNEDLONG: {
                return BigInteger.ZERO;
            }
            case DOUBLE: {
                return DOUBLE_MIN;
            }
            case DECIMAL: 
            case RATINGDECIMAL: {
                return null;
            }
        }
        throw new AssertionError((Object)("Numeric data type not handled: " + this));
    }

    public Number getMaximumValue() {
        if (!this.isNumeric()) {
            return null;
        }
        switch (this) {
            case SHORT: {
                return SHORT_MAX;
            }
            case INTEGER: {
                return INTEGER_MAX;
            }
            case LONG: {
                return LONG_MAX;
            }
            case UNSIGNEDINT16: 
            case UNSIGNEDSHORT: {
                return USHORT_MAX;
            }
            case UNSIGNEDINT32: 
            case UNSIGNEDINT: {
                return UINT_MAX;
            }
            case UNSIGNEDLONG: {
                return ULONG_MAX;
            }
            case UNSIGNEDINT8: {
                return UINT8_MAX;
            }
            case DOUBLE: {
                return DOUBLE_MAX;
            }
            case DECIMAL: 
            case RATINGDECIMAL: {
                return null;
            }
        }
        throw new AssertionError((Object)("Numeric data type not handled: " + this));
    }

    public Object castObject(Object o) {
        Object obj;
        if (o == null || this.isInstanceOfAnyTypeClass(o)) {
            obj = o;
        } else if (!this.isInstanceOfAnyTypeClass(o) && this.isNumeric() && Number.class.isAssignableFrom(o.getClass())) {
            try {
                obj = this.parseValueThrow(o.toString());
            }
            catch (NumberFormatException e) {
                throw e;
            }
            catch (Exception e) {
                obj = null;
            }
        } else {
            obj = this.getMainTypeClass().cast(o);
        }
        return obj;
    }

    public static DataType getSmallestDataTypeForNumericValue(String value) {
        if (value == null || "".equals(value)) {
            throw new IllegalArgumentException("Not a number: " + value);
        }
        DataType ret = null;
        for (int i = INT_NUMERIC_NARROWING_DATA_TYPES.length - 1; i >= 0; --i) {
            DataType dt = INT_NUMERIC_NARROWING_DATA_TYPES[i];
            Object o = dt.parseValue(value);
            if (o == null || !dt.makeDisplayString(o).equals(value)) continue;
            ret = dt;
            break;
        }
        if (ret == null) {
            try {
                Object o = RATINGDECIMAL.parseValue(value);
                if (o == null) {
                    throw new IllegalArgumentException("Not a number: " + value);
                }
                ret = RATINGDECIMAL;
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Not a number: " + value, e);
            }
        }
        return ret;
    }

    public static DataType getLargerEnclosingDataType(DataType dt1, DataType dt2) {
        DataType ret;
        if (dt1 == null || dt2 == null) {
            throw new IllegalArgumentException("Both data types must be non-null.");
        }
        if (!dt1.isNumeric() || !dt2.isNumeric()) {
            throw new IllegalArgumentException("Both data types must be numeric.");
        }
        if (dt1 == dt2) {
            return dt1;
        }
        if (dt1 == RATINGDECIMAL || dt2 == RATINGDECIMAL) {
            return RATINGDECIMAL;
        }
        if (dt1 == DECIMAL || dt2 == DECIMAL) {
            return DECIMAL;
        }
        if (dt1 == DOUBLE || dt2 == DOUBLE) {
            return DOUBLE;
        }
        boolean differentSigns = dt1.isUnsignedNumeric() ^ dt2.isUnsignedNumeric();
        if (differentSigns) {
            DataType unsigned = dt1.isUnsignedNumeric() ? dt1 : dt2;
            DataType signed = dt1.isUnsignedNumeric() ? dt2 : dt1;
            int index = -1;
            for (int i = 0; index < 0 && i < INT_NUMERIC_NARROWING_DATA_TYPES.length; ++i) {
                if (INT_NUMERIC_NARROWING_DATA_TYPES[i] != unsigned) continue;
                index = i;
            }
            assert (index >= 0) : "Data type not found in integer numeric list: " + unsigned;
            if (index == 0) {
                ret = RATINGDECIMAL;
            } else {
                DataType found = null;
                for (int i = index - 1; found == null && i >= 0; --i) {
                    DataType candidate = INT_NUMERIC_NARROWING_DATA_TYPES[i];
                    if (candidate.isUnsignedNumeric() || candidate.bitSize() < signed.bitSize()) continue;
                    found = candidate;
                }
                ret = found == null ? RATINGDECIMAL : found;
            }
        } else {
            ret = dt1.bitSize() > dt2.bitSize() ? dt1 : dt2;
        }
        return ret;
    }

    public static String valueToString(Object value) {
        DataType dt = DataType.fromObjectClass(value);
        return dt == null ? String.valueOf(value) : dt.makeDisplayString(value);
    }

    public static String UShortParser(short shortValue) {
        return Integer.toString(shortValue & 0xFFFF);
    }

    public static int interpretAsUnsignedShort(short value) {
        return value & 0xFFFF;
    }

    public static String UIntegerParser(int intValue) {
        return Long.toString((long)intValue & 0xFFFFFFFFL);
    }

    public static long interpretAsUnsignedInteger(int value) {
        return (long)value & 0xFFFFFFFFL;
    }

    public static String ULongParser(long longValue) {
        BigInteger d = new BigInteger(Long.toHexString(longValue), 16);
        return d.toString();
    }

    public static BigInteger interpretAsUnsignedLong(long value) {
        return new BigInteger(Long.toHexString(value), 16);
    }

    public static Object convertSignedToUnsigned(Object signed, DataType dataType) {
        if (dataType == null || signed == null) {
            throw new IllegalArgumentException("Null argument(s).");
        }
        if (!(signed instanceof Number)) {
            throw new IllegalArgumentException("Value must be a number.");
        }
        Object ret = signed;
        switch (dataType) {
            case UNSIGNEDSHORT: {
                if (signed instanceof UnsignedShort) break;
                short val = ((Number)signed).shortValue();
                ret = new UnsignedShort(DataType.interpretAsUnsignedShort(val));
                break;
            }
            case UNSIGNEDINT: {
                if (signed instanceof UnsignedInteger) break;
                int val = ((Number)signed).intValue();
                ret = new UnsignedInteger(DataType.interpretAsUnsignedInteger(val));
                break;
            }
            case UNSIGNEDLONG: {
                if (signed instanceof UnsignedLong) break;
                long val = ((Number)signed).longValue();
                ret = new UnsignedLong(DataType.interpretAsUnsignedLong(val));
                break;
            }
        }
        return ret;
    }

    public ContextBasedValueResolver createContextBasedValueResolver() {
        return new ContextBasedValueResolver(this);
    }

    public static ContextBasedValueResolver createTypeIndependentContextBasedValueResolver() {
        return new ContextBasedValueResolver(null);
    }

    protected Object createDefaultInstance(ContextBasedValueResolver.ValueResolverContext context) {
        return this.createDefaultInstance();
    }

    protected final Object parseString(String str, ContextBasedValueResolver.ValueResolverContext context) throws ParseException {
        try {
            return this._parseString(str, context);
        }
        catch (RuntimeException ex) {
            throw new ParseException(str, 0);
        }
    }

    protected Object _parseString(String str, ContextBasedValueResolver.ValueResolverContext context) throws ParseException {
        return this.parseValue(str);
    }

    protected String makeParseableString(Object obj, ContextBasedValueResolver.ValueResolverContext context) {
        return this.makeParseableString(obj);
    }

    protected String makeDisplayString(Object obj, ContextBasedValueResolver.ValueResolverContext context) {
        return this.makeDisplayString(obj);
    }

    public static Object[] parseMultiString(String values, ValueResolver resolver) throws ParseException {
        Object[] ret;
        Class templateClass;
        Object templateObject = resolver.createDefaultInstance();
        Class clazz = templateClass = templateObject != null ? templateObject.getClass() : Object.class;
        if (values.length() == 0) {
            ret = (Object[])Array.newInstance(templateClass, 0);
        } else {
            String[] tokens = StringUtil.splitSemiColonSeparatedString(values);
            ret = (Object[])Array.newInstance(templateClass, tokens.length);
            int i = 0;
            for (String str : tokens) {
                Object o = resolver.parseValueString(str);
                if (o == null) {
                    throw new ParseException(str, 0);
                }
                ret[i++] = o;
            }
        }
        return ret;
    }

    public boolean areObjectsEqual(Object firstObject, Object secondObject) {
        if (!this.matchesAnyTypeClass(firstObject.getClass()) || !this.matchesAnyTypeClass(secondObject.getClass())) {
            return false;
        }
        return this._areObjectsEqual(firstObject, secondObject);
    }

    protected boolean _areObjectsEqual(Object firstObject, Object secondObject) {
        return firstObject.equals(secondObject);
    }

    static {
        $VALUES = new DataType[]{UNSIGNEDINT8, UNSIGNEDINT16, UNSIGNEDINT32, TIME, OCTETSTRING, BCDSTRING, MONETARYUNITS, DECIMAL, RATINGDECIMAL, STRING, SHORT, INTEGER, LONG, DOUBLE, BOOLEAN, DATE, UNSIGNEDSHORT, UNSIGNEDINT, UNSIGNEDLONG, AMOUNT, OBJECT};
        INT_NUMERIC_NARROWING_DATA_TYPES = new DataType[]{UNSIGNEDLONG, LONG, UNSIGNEDINT, UNSIGNEDINT32, INTEGER, UNSIGNEDSHORT, UNSIGNEDINT16, SHORT, UNSIGNEDINT8};
        USHORT_MAX = BigInteger.valueOf(65535L);
        UINT_MAX = new BigInteger("4294967295");
        ULONG_MAX = new BigInteger("18446744073709551615");
        DOUBLE_MAX = BigDecimal.valueOf(Double.MAX_VALUE);
        UINT8_MAX = BigInteger.valueOf(255L);
        SHORT_MAX = BigInteger.valueOf(32767L);
        INTEGER_MAX = BigInteger.valueOf(Integer.MAX_VALUE);
        LONG_MAX = BigInteger.valueOf(Long.MAX_VALUE);
        DOUBLE_MIN = BigDecimal.valueOf(Double.longBitsToDouble(-4503599627370497L));
        SHORT_MIN = BigInteger.valueOf(-32768L);
        INTEGER_MIN = BigInteger.valueOf(Integer.MIN_VALUE);
        LONG_MIN = BigInteger.valueOf(Long.MIN_VALUE);
    }

    public static final class AmountStringParser {
        private static final Pattern AMOUNT_STRING = Pattern.compile("([a-zA-Z_]{3}) (.*)");

        public static Amount parseValue(String value, AmountFactory factory) throws ParseException {
            RatingDecimal balance;
            String currency;
            AmountFactory usedFactory = factory == null ? DefaultAmountFactory.getInstance() : factory;
            Amount ret = null;
            Matcher matcher = AMOUNT_STRING.matcher(value);
            if (matcher.matches()) {
                currency = matcher.group(1);
                String bal = matcher.group(2);
                balance = (RatingDecimal)RATINGDECIMAL.parseValue(bal);
                if (balance == null) {
                    throw new ParseException("Invalid balance: " + bal, 0);
                }
            } else {
                throw new ParseException("Unknown amount value format: " + value, 0);
            }
            ret = usedFactory.create(balance, currency);
            return ret;
        }
    }

    private static class DateStringParser {
        static final String[] DATE_TEXT_FORMATS = new String[]{"EEE MMM dd HH:mm:ss zzz yyyy", "yyyyMMdd'T'HHmmssSSS", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd", "yyyyMMdd"};

        private DateStringParser() {
        }

        static EREDate parseValue(String s) throws ParseException {
            try {
                return EREDateFactory.parseDateString(s);
            }
            catch (IllegalArgumentException e) {
                Date date = DateUtil.stringToDate(s, DATE_TEXT_FORMATS);
                return EREDateFactory.createFromDate(date);
            }
        }
    }

    @Deprecated
    public static interface StringParser {
        public Object parseValue(DataType var1, String var2) throws Exception;
    }
}

