/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.datatype;

public class Duration {
    private int m_days;
    private int m_sec;
    private int m_msec;
    private long m_value;

    public Duration(long duration) {
        this.set(duration);
    }

    public Duration(int days, int sec, int msec) {
        this.set(days, sec, msec);
    }

    public void set(int days, int sec, int msec) {
        this.m_days = days;
        this.m_sec = sec;
        this.m_msec = msec;
        this.m_value = this.m_days * 24 * 3600 * 1000 + this.m_sec * 1000 + this.m_msec;
    }

    public void set(long duration) {
        this.m_value = duration;
        this.m_days = (int)duration / 86400000;
        this.m_sec = (int)(duration %= 86400000L) / 1000;
        this.m_msec = (int)(duration %= 1000L);
    }

    public int getDays() {
        return this.m_days;
    }

    public int getSec() {
        return this.m_sec;
    }

    public int getMsec() {
        return this.m_msec;
    }

    public long getValue() {
        return this.m_value;
    }

    public long getDurationInSeconds() {
        return this.getValue() / 1000L;
    }

    public long getDurationInMillis() {
        return this.getValue();
    }

    public Duration valueOf(String duration) throws Exception {
        return new Duration(Long.parseLong(duration));
    }

    public String toString() {
        return String.valueOf(this.getValue());
    }

    public void parse(String durationString) {
    }
}

