/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.datatype;

import ericsson.ere.datatype.interfaces.UnsignedInt;

public class UnsignedInt32
extends Number
implements UnsignedInt,
Cloneable {
    public static final long MAX_VALUE = 0xFFFFFFFFL;
    public static final long MIN_VALUE = 0L;
    public static final UnsignedInt32 ZERO = new UnsignedInt32(0L);
    public static final UnsignedInt32 MAX = new UnsignedInt32(0xFFFFFFFFL);
    private long myLongValue;

    public UnsignedInt32(int value) {
        this.setValue(value);
    }

    public UnsignedInt32(long value) {
        this.checkValue(value);
        this.setValue((int)value);
    }

    public UnsignedInt32(String str) {
        long value = Long.parseLong(str);
        this.checkValue(value);
        this.setValue((int)value);
    }

    @Override
    public byte byteValue() {
        return (byte)this.myLongValue;
    }

    @Override
    public short shortValue() {
        return (short)this.myLongValue;
    }

    @Override
    public int intValue() {
        return (int)this.myLongValue;
    }

    @Override
    public long longValue() {
        return this.myLongValue;
    }

    @Override
    public float floatValue() {
        return this.myLongValue;
    }

    @Override
    public double doubleValue() {
        return this.myLongValue;
    }

    public int intSignedValue() {
        return (int)this.myLongValue;
    }

    @Deprecated
    public void set(int value) {
        this.setValue(value);
    }

    private void setValue(int value) {
        this.myLongValue = value < 0 ? (long)value + 0xFFFFFFFFL + 1L : (long)value;
    }

    public static UnsignedInt32 valueOf(String aValue) {
        long number = Long.parseLong(aValue);
        if (number == 0L) {
            return ZERO;
        }
        if (number == 0xFFFFFFFFL) {
            return MAX;
        }
        return new UnsignedInt32(number);
    }

    public String toString() {
        return Long.toString(this.myLongValue);
    }

    public int hashCode() {
        return (int)this.myLongValue;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof UnsignedInt)) {
            return false;
        }
        return this.longValue() == ((UnsignedInt)obj).longValue();
    }

    private void checkValue(long val) {
        if (val < 0L || val > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("UnsignedInt32 value out of range: " + val);
        }
    }

    public UnsignedInt32 clone() {
        try {
            return (UnsignedInt32)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError((Object)ex);
        }
    }
}

