/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.defs;

import ericsson.ere.defs.FieldStructure;
import ericsson.ere.interfaces.FieldHierarchyNode;
import ericsson.ere.xml.XMLUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.w3c.dom.Node;

public abstract class AbstractStructureNode
implements FieldHierarchyNode {
    private static final String ATTRIBUTE_TAG = "TagNumber";
    private static final String ATTRIBUTE_COMPLEX_TYPE = "ComplexType";
    private static final String ATTRIBUTE_AUTOMAP_CONDITION = "AutoConditionMap";
    private static final String ATTRIBUTE_NAME = "Name";
    private static final String ATTRIBUTE_TOOL_TIP = "Tooltip";
    private final FieldStructure myParent;
    protected final FieldHierarchyNode.ComplexType myComplexType;
    protected final boolean myIsAutoConditionMapAllowed;
    protected final String myName;
    protected final int myTagNumber;
    protected final String myCanonicalName;
    private final List<String> myContextNames;
    private final String myToolTip;

    protected AbstractStructureNode(FieldStructure parent, String name, int tagNumber, FieldHierarchyNode.ComplexType complexType, boolean autoConditionMapAllowed, List<String> contextNames, String toolTip) {
        if (name == null) {
            throw new IllegalArgumentException("name parameter must not be null.");
        }
        this.myName = name;
        this.myParent = parent;
        this.myTagNumber = tagNumber;
        this.myComplexType = complexType;
        this.myIsAutoConditionMapAllowed = autoConditionMapAllowed;
        this.myCanonicalName = this.myParent == null ? this.myName : this.myParent.getCanonicalName() + this.myParent.getSeparator() + this.myName;
        this.myContextNames = AbstractStructureNode.getContextNames(contextNames);
        this.myToolTip = toolTip;
    }

    @Override
    public int getTagNumber() {
        return this.myTagNumber;
    }

    @Override
    public String getFieldName() {
        return this.myName;
    }

    @Override
    public FieldHierarchyNode.ComplexType getComplexType() {
        return this.myComplexType;
    }

    @Override
    public FieldStructure getParent() {
        return this.myParent;
    }

    public abstract FieldHierarchyNode getChildByName(String var1);

    @Override
    public String getCanonicalName() {
        return this.myCanonicalName;
    }

    @Override
    public List<String> getContextNames() {
        return this.myContextNames != null ? Collections.unmodifiableList(this.myContextNames) : Collections.emptyList();
    }

    @Override
    public boolean isContextField() {
        return this.myContextNames != null;
    }

    public boolean isAutoConditionMapAllowed() {
        return this.myIsAutoConditionMapAllowed;
    }

    @Override
    public String getTooltip() {
        return this.myToolTip;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.myComplexType == null ? 0 : this.myComplexType.hashCode());
        result = 31 * result + (this.myIsAutoConditionMapAllowed ? 1231 : 1237);
        result = 31 * result + (this.myName == null ? 0 : this.myName.hashCode());
        result = 31 * result + (this.myCanonicalName == null ? 0 : this.myCanonicalName.hashCode());
        result = 31 * result + (this.myToolTip == null ? 0 : this.myToolTip.hashCode());
        result = 31 * result + (this.myContextNames == null ? 0 : this.myContextNames.hashCode());
        result = 31 * result + this.myTagNumber;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractStructureNode other = (AbstractStructureNode)obj;
        if (this.myComplexType != other.myComplexType) {
            return false;
        }
        if (this.myIsAutoConditionMapAllowed != other.myIsAutoConditionMapAllowed) {
            return false;
        }
        if (this.myName == null ? other.myName != null : !this.myName.equals(other.myName)) {
            return false;
        }
        if (this.myCanonicalName == null ? other.myCanonicalName != null : !this.myCanonicalName.equals(other.myCanonicalName)) {
            return false;
        }
        if (this.myToolTip == null ? other.myToolTip != null : !this.myToolTip.equals(other.myToolTip)) {
            return false;
        }
        if (this.myContextNames == null ? other.myContextNames != null : !this.myContextNames.equals(other.myContextNames)) {
            return false;
        }
        return this.myTagNumber == other.myTagNumber;
    }

    protected static String getNameFromXml(Node xml) {
        return XMLUtil.getAttributeValue(xml.getAttributes(), ATTRIBUTE_NAME, null);
    }

    protected static FieldHierarchyNode.ComplexType getComplexTypeFromXml(Node xml) {
        FieldHierarchyNode.ComplexType ret = FieldHierarchyNode.ComplexType.NONE;
        String complexTypeStr = XMLUtil.getAttributeValue(xml.getAttributes(), ATTRIBUTE_COMPLEX_TYPE, null);
        if (complexTypeStr != null) {
            ret = FieldHierarchyNode.ComplexType.valueOf(complexTypeStr);
        }
        return ret;
    }

    protected static boolean getIsAutoConditionMapAllowedFromXml(Node xml) {
        return Boolean.parseBoolean(XMLUtil.getAttributeValue(xml.getAttributes(), ATTRIBUTE_AUTOMAP_CONDITION, "false"));
    }

    protected static int getTagFromXml(Node xml) {
        int ret = -1;
        String tagStr = XMLUtil.getAttributeValue(xml.getAttributes(), ATTRIBUTE_TAG, "");
        if (tagStr.matches("\\d+")) {
            ret = Integer.valueOf(tagStr);
        }
        return ret;
    }

    protected static String getToolTipFromXml(Node xml) {
        return xml != null ? XMLUtil.getAttributeValue(xml.getAttributes(), ATTRIBUTE_TOOL_TIP, null) : null;
    }

    private static List<String> getContextNames(List<String> contextNames) {
        if (contextNames == null) {
            return null;
        }
        if (contextNames.isEmpty()) {
            return Collections.emptyList();
        }
        return new ArrayList<String>(contextNames);
    }
}

