/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.defs;

import com.ericsson.ere.dataset.DataSetFactory;
import com.ericsson.ere.dataset.DefaultDataSetFactory;
import com.ericsson.ere.dataset.LegacyDataSetFactory;
import com.ericsson.ere.dataset.jump.JumperSupport;
import com.ericsson.ere.defs.ClassRepositoryUser;
import com.ericsson.ere.defs.DataRepository;
import com.ericsson.ere.defs.DataRepositoryImpl;
import com.ericsson.ere.defs.ServiceFieldStructure;
import com.ericsson.ere.defs.ServiceFieldValidator;
import com.ericsson.ere.defs.ServiceFieldValidators;
import com.ericsson.ere.exception.ServiceDataException;
import com.ericsson.ere.exception.ServiceException;
import com.ericsson.ere.selectiontree.interfaces.SelectionTreeNodeMigrator;
import com.ericsson.ere.selectiontree.mdu.filter.MultiDataUpdateFilterFactory;
import ericsson.ere.datatype.interfaces.ValueClassFactory;
import ericsson.ere.defs.AbstractStructureNode;
import ericsson.ere.defs.ClassRepositoryWithContext;
import ericsson.ere.defs.DefaultFieldRepository;
import ericsson.ere.defs.ElementAndContext;
import ericsson.ere.defs.EreClassLoader;
import ericsson.ere.defs.FieldContextField;
import ericsson.ere.defs.FieldCreationManager;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.defs.FieldRepository;
import ericsson.ere.defs.FieldRepositoryWrapper;
import ericsson.ere.defs.FieldStructure;
import ericsson.ere.defs.InvalidFieldException;
import ericsson.ere.defs.PluginName;
import ericsson.ere.exception.EreException;
import ericsson.ere.interfaces.Condition;
import ericsson.ere.interfaces.FieldHierarchyNode;
import ericsson.ere.interfaces.XMLInitializable;
import ericsson.ere.management.ContextKey;
import ericsson.ere.management.FieldContext;
import ericsson.ere.util.NodeListIterable;
import ericsson.ere.xml.DomWriter;
import ericsson.ere.xml.XMLUtil;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ClassRepository
implements FieldCreationManager {
    public static final String PARA_TYPE_IN = "IN";
    public static final String PARA_TYPE_OUT = "OUT";
    public static final String PARA_TYPE_VARIABLE = "VARIABLE";
    public static final String PARA_TYPE_VIRTUAL = "VIRTUAL";
    public static final String PARA_TYPE_INTERNAL = "INTERNAL";
    public static final String[] INPUT_TYPES = new String[]{"IN", "VIRTUAL"};
    public static final String[] OUTPUT_TYPES = new String[]{"OUT", "VARIABLE"};
    private static final String TAG_FIELD = "Field";
    private static final String TAG_SERVICE_DEFINITION = "ServiceDefinition";
    private static final String TAG_SETTINGS = "Settings";
    private List<PluginName> baseConditionList;
    private Map<String, String> baseConditionClasses;
    private Map<String, String> baseConditionProfiles;
    private Map<String, List<String>> baseConditionDataType;
    private Map<String, String> baseConditionComments;
    private Map<String, String> connectedBaseConditions;
    private Map<String, String> definedConditionField;
    private Map<String, String> fieldComments;
    private Map<String, String> modifierComments;
    private List<PluginName> modifierList;
    private Object mySimulationFactory;
    private String mySimulationFactoryClass;
    private List<PluginName> myFieldStructureBaseConditionList;
    private Map<String, String> myFieldStructureBaseConditionClasses;
    private Map<String, String> myFieldStructureBaseConditionProfiles;
    private Map<String, List<String>> myFieldStructureBaseConditionCollectionType;
    private Map<String, String> myFieldStructureBaseConditionComments;
    private Map<String, String> definedConditionClasses;
    private Map<String, String> definedConditionProfiles;
    private Map<String, String> modifierClasses;
    private Map<String, String> modifierProfiles;
    private DataSetFactory myDataSetFactory;
    private List<PluginName> definedConditionList;
    private Map<String, String> myTariffStructureClasses;
    private Map<String, String> myTariffStructureProfiles;
    private List<String> myTariffStructureList;
    private Map<String, String> myNodeTypeClasses;
    private Map<String, String> myNodeTypeProfiles;
    private List<String> myNodeTypeList;
    private String myUtilsXmlString;
    private MultiDataUpdateFilterFactory myFilterFactory;
    private String myFilterFactoryName;
    private String myServiceName;
    private Element myFieldsRoot;
    private DataRepository myDataRepository;
    protected FieldRepositoryWrapper myFieldRepository;
    private Object myTreeRootObject;
    private Map<String, Element> myContexts;
    private Map<String, ElementAndContext> myServiceProviderContextFields;
    private Map<String, ElementAndContext> myRatingPlanContextFields;
    private String myContextFieldIdentifier;
    private JumperSupport myJumperSupporter;
    private String myMigratorClassName;
    private SelectionTreeNodeMigrator myMigrator;
    private String myDefaultConditionClass;
    private String myDefaultConditionProfileClass;
    private String myDefaultModifierClass;
    private String myDefaultModifierProfileClass;
    private ServiceFieldStructure myFieldStructure;

    public ClassRepository() {
        this.baseConditionList = new ArrayList<PluginName>();
        this.baseConditionClasses = new HashMap<String, String>();
        this.baseConditionProfiles = new HashMap<String, String>();
        this.baseConditionDataType = new HashMap<String, List<String>>();
        this.baseConditionComments = new HashMap<String, String>();
        this.connectedBaseConditions = new HashMap<String, String>();
        this.definedConditionField = new HashMap<String, String>();
        this.fieldComments = new HashMap<String, String>();
        this.modifierComments = new HashMap<String, String>();
        this.modifierList = new ArrayList<PluginName>();
        this.myFieldStructureBaseConditionList = new ArrayList<PluginName>();
        this.myFieldStructureBaseConditionClasses = new HashMap<String, String>();
        this.myFieldStructureBaseConditionProfiles = new HashMap<String, String>();
        this.myFieldStructureBaseConditionCollectionType = new HashMap<String, List<String>>();
        this.myFieldStructureBaseConditionComments = new HashMap<String, String>();
        this.definedConditionClasses = new HashMap<String, String>();
        this.definedConditionProfiles = new HashMap<String, String>();
        this.modifierClasses = new HashMap<String, String>();
        this.modifierProfiles = new HashMap<String, String>();
        this.definedConditionList = new ArrayList<PluginName>();
        this.myTariffStructureClasses = new HashMap<String, String>();
        this.myTariffStructureProfiles = new HashMap<String, String>();
        this.myTariffStructureList = new ArrayList<String>(5);
        this.myNodeTypeClasses = new HashMap<String, String>();
        this.myNodeTypeProfiles = new HashMap<String, String>();
        this.myNodeTypeList = new ArrayList<String>(5);
        this.myFieldRepository = new FieldRepositoryWrapper(new DefaultFieldRepository(null));
        this.myServiceProviderContextFields = new HashMap<String, ElementAndContext>();
        this.myRatingPlanContextFields = new HashMap<String, ElementAndContext>();
        this.myDefaultConditionClass = "com.ericsson.ere.selectiontree.conditions.ImmutableDummyCondition";
        this.myDefaultConditionProfileClass = "com.ericsson.ere.selectiontree.conditions.DummyConditionProfile";
        this.myDefaultModifierClass = "com.ericsson.ere.selectiontree.modifiers.ImmutableDummyModifier";
        this.myDefaultModifierProfileClass = "com.ericsson.ere.selectiontree.modifiers.DummyModifierProfile";
    }

    protected ClassRepository(String s) {
    }

    public void init(Element definitionRootElement) throws Exception {
        this.init(definitionRootElement, null);
    }

    public void init(Document definitionDoc) throws Exception {
        this.init(definitionDoc, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void init(Document definitionDocument, Document conditionDocumentDoc) throws Exception {
        Element definitionRootElement = null;
        Element conditionRootElement = null;
        if (definitionDocument == null) {
            throw new EreException("ClassRepository: No field document given");
        }
        definitionRootElement = definitionDocument.getDocumentElement();
        if (conditionDocumentDoc == null) {
            if (XMLUtil.getNamedElement(TAG_SETTINGS, definitionRootElement.getChildNodes()) == null) throw new EreException("ClassRepository: No condition document given");
            conditionRootElement = XMLUtil.getNamedElement(TAG_SETTINGS, definitionRootElement.getChildNodes());
        } else {
            conditionRootElement = conditionDocumentDoc.getDocumentElement();
        }
        this.init(definitionRootElement, conditionRootElement);
    }

    public void init(Element definitionRootElement, Element conditionRootElement) throws Exception {
        Element settingsElement = XMLUtil.getNamedElement(TAG_SETTINGS, definitionRootElement.getChildNodes());
        Element settingsRootElement = settingsElement != null ? settingsElement : conditionRootElement;
        String definitionNodeName = definitionRootElement.getNodeName();
        if (!definitionNodeName.equals(TAG_SERVICE_DEFINITION)) {
            throw new EreException("ClassRepository: Invalid root tag for Service Definition must be 'ServiceDefinition' found '" + definitionNodeName + "'");
        }
        String conditionNodeName = settingsRootElement.getNodeName();
        if (!conditionNodeName.equals(TAG_SETTINGS)) {
            throw new EreException("ClassRepository: Invalid root tag for Service Condition must be 'Settings' found '" + conditionNodeName + "'");
        }
        this.myServiceName = definitionRootElement.getAttribute("Service");
        this.clearMemberContents();
        this.readStructureFromFile(settingsRootElement);
        String defaultFactory = "com.ericsson.ere.dataset.LegacyDataSetFactory";
        this.setDataSetFactory(this.getFactoryClassName(definitionRootElement, "DataSetFactory", defaultFactory));
        this.setSimulationFactory(this.getFactoryClassName(definitionRootElement, "SimulationFactory", null));
        this.setMDUFilterFactory(this.getFactoryClassName(definitionRootElement, "MDUFilterFactory", null));
        this.setMigrator(this.getFactoryClassName(definitionRootElement, "Migrator", null));
        Element dataRoot = XMLUtil.getNamedElement("Data", definitionRootElement.getChildNodes());
        this.myDataRepository = new DataRepositoryImpl(dataRoot, this);
        this.myFieldsRoot = XMLUtil.getNamedElement("Fields", definitionRootElement.getChildNodes());
        Map<String, List<String>> contextFieldBelongingMap = this.parseContextDefinition(definitionRootElement);
        this.readServiceProviderAndRatingPlanContextFields(definitionRootElement);
        DefaultFieldRepository fieldRepo = new DefaultFieldRepository(definitionRootElement, contextFieldBelongingMap, this);
        this.myFieldRepository.swapRepository(fieldRepo);
        Element utilsNode = XMLUtil.getNamedElement("Utils", definitionRootElement.getChildNodes());
        if (utilsNode != null) {
            this.myUtilsXmlString = DomWriter.elementToString(utilsNode);
        }
        this.myFieldStructure = ServiceFieldStructure.build(this, false);
        this.validateFieldStructure(this.myFieldStructure);
        if (!this.keepXml()) {
            this.myFieldsRoot = null;
            this.myContexts = null;
            this.myServiceProviderContextFields = new HashMap<String, ElementAndContext>();
            this.myRatingPlanContextFields = new HashMap<String, ElementAndContext>();
        }
    }

    private Map<String, List<String>> parseContextDefinition(Element definitionRootElement) {
        HashMap<String, List<String>> contextFieldBelongingMap = null;
        Element contextRoot = XMLUtil.getNamedElement("ContextDefinition", definitionRootElement.getChildNodes());
        if (contextRoot != null) {
            this.myContextFieldIdentifier = XMLUtil.getAttributeFromElement(contextRoot, "ContextFieldIdentifier", null);
            contextFieldBelongingMap = new HashMap<String, List<String>>();
            List<Element> contextElementList = XMLUtil.getElementNodesNamed("Context", contextRoot.getChildNodes());
            if (contextElementList.size() > 0) {
                this.myContexts = new HashMap<String, Element>(contextElementList.size());
                for (Element contextElement : contextElementList) {
                    String contextName = contextElement.getAttribute("Name");
                    this.myContexts.put(contextName, contextElement);
                    this.addFieldNamesToContextBelongingMap(contextFieldBelongingMap, contextName, contextElement.getElementsByTagName(TAG_FIELD));
                    this.addFieldNamesToContextBelongingMap(contextFieldBelongingMap, contextName, contextElement.getElementsByTagName("FieldStructure"));
                }
            }
        }
        return contextFieldBelongingMap;
    }

    private void addFieldNamesToContextBelongingMap(Map<String, List<String>> contextFieldBelongingMap, String contextName, NodeList contextFields) {
        for (Node currentFieldElement : new NodeListIterable(contextFields)) {
            String fieldName = ((Element)currentFieldElement).getAttribute("Name");
            if (fieldName == null) continue;
            if (contextFieldBelongingMap.containsKey(fieldName)) {
                contextFieldBelongingMap.get(fieldName).add(contextName);
                continue;
            }
            ArrayList<String> list = new ArrayList<String>();
            list.add(contextName);
            contextFieldBelongingMap.put(fieldName, list);
        }
    }

    private void readServiceProviderAndRatingPlanContextFields(Element definitionRootElement) {
        Element structureContextFieldsRoot = XMLUtil.getNamedElement("ServiceProviderFieldsList", definitionRootElement.getChildNodes());
        if (structureContextFieldsRoot != null) {
            List<Element> serviceProviderFieldsList = XMLUtil.getElementNodesNamed("ServiceProviderFields", structureContextFieldsRoot.getChildNodes());
            for (Element serviceProviderFieldsElement : serviceProviderFieldsList) {
                Element currentSPRatingPlanFieldsRoot;
                String serviceProviderKey = XMLUtil.getAttributeFromElement(serviceProviderFieldsElement, "key", "undefined");
                Element spFieldsElement = XMLUtil.getNamedElement("Fields", serviceProviderFieldsElement.getChildNodes());
                if (spFieldsElement != null) {
                    FieldContext spFieldContext = new FieldContext(serviceProviderKey);
                    this.myServiceProviderContextFields.put(spFieldContext.getServiceProviderStringKey(), new ElementAndContext(spFieldsElement, spFieldContext));
                }
                if ((currentSPRatingPlanFieldsRoot = XMLUtil.getNamedElement("RatingPlanFieldsList", serviceProviderFieldsElement.getChildNodes())) == null) continue;
                List<Element> ratingPlanFieldsList = XMLUtil.getElementNodesNamed("RatingPlanFields", currentSPRatingPlanFieldsRoot.getChildNodes());
                for (Element ratingPlanFieldsElement : ratingPlanFieldsList) {
                    String ratingPlanKey = XMLUtil.getAttributeFromElement(ratingPlanFieldsElement, "key", "undefined");
                    Element rpFieldsElement = XMLUtil.getNamedElement("Fields", ratingPlanFieldsElement.getChildNodes());
                    if (rpFieldsElement == null) continue;
                    FieldContext rpFieldContext = new FieldContext(serviceProviderKey, ratingPlanKey);
                    this.myRatingPlanContextFields.put(rpFieldContext.getRatingPlanStringKey(), new ElementAndContext(rpFieldsElement, rpFieldContext));
                }
            }
        }
    }

    protected void addServiceProviderAndRatingPlanContextFields(Element definitionRootElement) {
        this.readServiceProviderAndRatingPlanContextFields(definitionRootElement);
        this.myFieldStructure = ServiceFieldStructure.build(this, false);
        this.validateFieldStructure(this.myFieldStructure);
    }

    private void clearMemberContents() {
        this.baseConditionList.clear();
        this.baseConditionClasses.clear();
        this.baseConditionProfiles.clear();
        this.baseConditionDataType.clear();
        this.getDefinedConditionList().clear();
        this.definedConditionClasses.clear();
        this.definedConditionProfiles.clear();
        this.definedConditionField.clear();
        this.fieldComments.clear();
        this.modifierList.clear();
        this.modifierClasses.clear();
        this.modifierProfiles.clear();
        this.myFieldStructureBaseConditionList.clear();
        this.myFieldStructureBaseConditionClasses.clear();
        this.myFieldStructureBaseConditionProfiles.clear();
        this.myFieldStructureBaseConditionCollectionType.clear();
        this.myFieldStructureBaseConditionComments.clear();
    }

    private void validateFieldStructure(ServiceFieldStructure fieldStructure) {
        ServiceFieldStructure.RootElement root = fieldStructure.getRoot();
        ServiceFieldValidator validator = ServiceFieldValidators.createBasicFieldValidator();
        List<ServiceFieldValidator.FieldValidatorError> errors = validator.validateFieldStructure(root);
        if (!errors.isEmpty()) {
            StringBuilder b = new StringBuilder("The following errors were encountered in the field structure of service ");
            b.append(this.getServiceName()).append(":");
            for (ServiceFieldValidator.FieldValidatorError error : errors) {
                b.append("\n").append(error.getReason());
            }
            throw new ServiceException(b.toString());
        }
    }

    private String getFactoryClassName(Element parent, String factoryTag, String defaultClassName) {
        Element dataSetFactory;
        String cn;
        NodeList aList = parent.getElementsByTagName(factoryTag);
        String className = defaultClassName;
        if (aList.getLength() > 0 && (cn = (dataSetFactory = (Element)aList.item(0)).getAttribute("class")).length() != 0) {
            className = cn;
        }
        return className;
    }

    private void readStructureFromFile(Element document) {
        PluginName pluginName;
        String comment;
        String alias;
        int ii;
        NodeList childList;
        String profile;
        String className;
        String name;
        int ii2;
        NodeList aList = null;
        NamedNodeMap attributes = null;
        aList = document.getElementsByTagName("TariffStructures");
        if (aList.getLength() > 0 && aList.item(0).hasChildNodes()) {
            NodeList tariffStructures = aList.item(0).getChildNodes();
            for (ii2 = 0; ii2 < tariffStructures.getLength(); ++ii2) {
                Node tariffStructure = tariffStructures.item(ii2);
                if (!tariffStructure.hasAttributes()) continue;
                attributes = tariffStructure.getAttributes();
                name = attributes.getNamedItem("name").getNodeValue();
                className = attributes.getNamedItem("class").getNodeValue();
                profile = attributes.getNamedItem("profile").getNodeValue();
                this.addTariffStructure(name, className, profile);
            }
        }
        if ((aList = document.getElementsByTagName("Nodes")).getLength() > 0 && aList.item(0).hasChildNodes()) {
            NodeList nodes = aList.item(0).getChildNodes();
            for (ii2 = 0; ii2 < nodes.getLength(); ++ii2) {
                Node node = nodes.item(ii2);
                if (!node.hasAttributes()) continue;
                attributes = node.getAttributes();
                name = attributes.getNamedItem("name").getNodeValue();
                className = attributes.getNamedItem("class").getNodeValue();
                profile = attributes.getNamedItem("profile").getNodeValue();
                this.addNode(name, className, profile);
            }
        }
        if ((aList = document.getElementsByTagName("BaseConditions")).getLength() > 0 && aList.item(0).hasChildNodes()) {
            childList = aList.item(0).getChildNodes();
            for (ii2 = 0; ii2 < childList.getLength(); ++ii2) {
                this.addBaseConditionConfiguration(childList.item(ii2), false);
            }
        }
        if ((aList = document.getElementsByTagName("HierarchicalBaseConditions")).getLength() > 0 && aList.item(0).hasChildNodes()) {
            childList = aList.item(0).getChildNodes();
            for (ii2 = 0; ii2 < childList.getLength(); ++ii2) {
                this.addBaseConditionConfiguration(childList.item(ii2), true);
            }
        }
        if ((aList = document.getElementsByTagName("GenericConditions")).getLength() > 0 && aList.item(0).hasChildNodes()) {
            Node genericConditions = aList.item(0);
            String s = this.getOptionalAttribute(genericConditions, "defaultClass");
            if (s != null) {
                if (s.length() == 0) {
                    s = null;
                }
                this.myDefaultConditionClass = s;
            }
            if ((s = this.getOptionalAttribute(genericConditions, "defaultProfile")) != null) {
                if (s.length() == 0) {
                    s = null;
                }
                this.myDefaultConditionProfileClass = s;
            }
            NodeList childList2 = genericConditions.getChildNodes();
            for (ii = 0; ii < childList2.getLength(); ++ii) {
                alias = "";
                comment = "";
                if (!childList2.item(ii).hasAttributes()) continue;
                attributes = childList2.item(ii).getAttributes();
                String fieldName = attributes.getNamedItem("field") != null ? attributes.getNamedItem("field").getNodeValue() : "ANYSTRINGFIELD";
                name = attributes.getNamedItem("name").getNodeValue();
                if (attributes.getNamedItem("alias") != null) {
                    alias = attributes.getNamedItem("alias").getNodeValue();
                }
                pluginName = new PluginName(name, alias);
                className = attributes.getNamedItem("class").getNodeValue();
                profile = attributes.getNamedItem("profile").getNodeValue();
                this.addCondition(fieldName, pluginName, className, profile, comment);
            }
        }
        if ((aList = document.getElementsByTagName("Modifiers")).getLength() > 0 && aList.item(0).hasChildNodes()) {
            Node modifiers = aList.item(0);
            String s = this.getOptionalAttribute(modifiers, "defaultClass");
            if (s != null) {
                if (s.length() == 0) {
                    s = null;
                }
                this.myDefaultModifierClass = s;
            }
            if ((s = this.getOptionalAttribute(modifiers, "defaultProfile")) != null) {
                if (s.length() == 0) {
                    s = null;
                }
                this.myDefaultModifierProfileClass = s;
            }
            NodeList list = modifiers.getChildNodes();
            for (ii = 0; ii < list.getLength(); ++ii) {
                alias = null;
                comment = "";
                if (!list.item(ii).hasAttributes()) continue;
                attributes = list.item(ii).getAttributes();
                name = attributes.getNamedItem("name").getNodeValue();
                if (attributes.getNamedItem("alias") != null) {
                    alias = attributes.getNamedItem("alias").getNodeValue();
                }
                pluginName = new PluginName(name, alias);
                if (attributes.getNamedItem("comment") != null) {
                    comment = attributes.getNamedItem("comment").getNodeValue();
                }
                className = attributes.getNamedItem("class").getNodeValue();
                profile = attributes.getNamedItem("profile").getNodeValue();
                this.addModifier(pluginName, className, profile, comment);
            }
        }
    }

    private void addBaseConditionConfiguration(Node item, boolean isFieldStructureBaseCondition) {
        if (item.hasAttributes()) {
            NamedNodeMap attributes = item.getAttributes();
            String name = attributes.getNamedItem("name").getNodeValue();
            Node aliasNode = attributes.getNamedItem("alias");
            String alias = aliasNode != null ? aliasNode.getNodeValue() : null;
            PluginName pluginName = new PluginName(name, alias);
            Node commentNode = attributes.getNamedItem("comment");
            String comment = commentNode != null ? commentNode.getNodeValue() : "";
            String className = attributes.getNamedItem("class").getNodeValue();
            String profile = attributes.getNamedItem("profile").getNodeValue();
            if (isFieldStructureBaseCondition) {
                ArrayList<String> collectionTypeStrings = new ArrayList<String>();
                String collectionTypes = attributes.getNamedItem("collectionTypeList").getNodeValue();
                for (String collectionType : collectionTypes.split(",")) {
                    collectionTypeStrings.add(collectionType.trim());
                }
                this.addFieldStructureBaseCondition(pluginName, collectionTypeStrings, className, profile, comment);
            } else {
                ArrayList<String> dataTypeStrings = new ArrayList<String>();
                String dataTypes = attributes.getNamedItem("dataType").getNodeValue();
                for (String dataType : dataTypes.split(",")) {
                    dataTypeStrings.add(dataType.trim());
                }
                this.addBaseCondition(pluginName, dataTypeStrings, className, profile, comment);
            }
        }
    }

    private String getOptionalAttribute(Node node, String name) {
        NamedNodeMap attr;
        Node n;
        String s = null;
        if (node.hasAttributes() && (n = (attr = node.getAttributes()).getNamedItem(name)) != null) {
            s = n.getNodeValue();
        }
        return s;
    }

    public DataSetFactory getDataSetFactory() {
        return this.myDataSetFactory;
    }

    public void addBaseCondition(PluginName name, List<String> dataType, String classStr, String profileStr, String comment) {
        this.baseConditionList.add(name);
        this.baseConditionClasses.put(name.getName(), classStr);
        this.baseConditionProfiles.put(name.getName(), profileStr);
        this.baseConditionDataType.put(name.getName(), dataType);
        this.baseConditionComments.put(name.getName(), comment);
    }

    private void addFieldStructureBaseCondition(PluginName name, List<String> collectionTypes, String classStr, String profileStr, String comment) {
        this.myFieldStructureBaseConditionList.add(name);
        this.myFieldStructureBaseConditionClasses.put(name.getName(), classStr);
        this.myFieldStructureBaseConditionProfiles.put(name.getName(), profileStr);
        this.myFieldStructureBaseConditionCollectionType.put(name.getName(), collectionTypes);
        this.myFieldStructureBaseConditionComments.put(name.getName(), comment);
    }

    public String getFieldStructureBaseConditionAliasOrName(String name) {
        return this.getAliasOrName(name, this.myFieldStructureBaseConditionList);
    }

    private String getAliasOrName(String name, List<PluginName> list) {
        String retVal = null;
        for (PluginName currentPluginName : list) {
            if (!currentPluginName.getName().equals(name)) continue;
            retVal = currentPluginName.getAlias();
            break;
        }
        return retVal;
    }

    public String getBaseConditionAliasOrName(String name) {
        return this.getAliasOrName(name, this.baseConditionList);
    }

    private String getBaseConditionNameForAlias(String alias) {
        for (PluginName currentPluginName : this.baseConditionList) {
            if (!currentPluginName.getAlias().equals(alias)) continue;
            return currentPluginName.getName();
        }
        return null;
    }

    private String resolveBaseConditionName(String nameOrAlias) {
        String baseConditionName;
        if (this.getBaseConditionAliasOrName(nameOrAlias) != null) {
            baseConditionName = nameOrAlias;
        } else {
            baseConditionName = this.getBaseConditionNameForAlias(nameOrAlias);
            if (baseConditionName == null) {
                throw new InvalidFieldException("The condition identified with '" + nameOrAlias + "' could not be found in base condition list.");
            }
        }
        return baseConditionName;
    }

    public List<PluginName> getFieldStructureBaseConditions() {
        return this.myFieldStructureBaseConditionList;
    }

    public String getFieldStructureBaseConditionClass(String name) {
        return this.myFieldStructureBaseConditionClasses.get(name);
    }

    public String getFieldStructureBaseConditionProfile(String name) {
        return this.myFieldStructureBaseConditionProfiles.get(name);
    }

    public String getFieldStructureBaseConditionComment(String name) {
        return this.myFieldStructureBaseConditionComments.get(name);
    }

    public List<String> getFieldStructureBaseConditionCollectionTypes(String name) {
        return this.myFieldStructureBaseConditionCollectionType.get(name);
    }

    public List<String> getBaseConditionDataType(String alias) {
        return this.baseConditionDataType.get(alias);
    }

    public String getBaseConditionClass(String alias) {
        return this.baseConditionClasses.get(alias);
    }

    public String getBaseConditionProfile(String alias) {
        return this.baseConditionProfiles.get(alias);
    }

    public void addTariffStructure(String name, String className, String profile) {
        this.myTariffStructureList.add(name);
        this.myTariffStructureClasses.put(name, className);
        this.myTariffStructureProfiles.put(name, profile);
    }

    public void addNode(String name, String className, String profile) {
        this.myNodeTypeList.add(name);
        this.myNodeTypeClasses.put(name, className);
        this.myNodeTypeProfiles.put(name, profile);
    }

    public void addCondition(String fieldName, PluginName condName, String className, String profile, String comment) {
        this.definedConditionList.add(condName);
        this.definedConditionClasses.put(condName.getName(), className);
        this.definedConditionProfiles.put(condName.getName(), profile);
        this.definedConditionField.put(condName.getName(), fieldName);
        this.fieldComments.put(fieldName, comment);
    }

    public void addModifier(PluginName name, String className, String profile, String comment) {
        this.modifierList.add(name);
        this.modifierClasses.put(name.getName(), className);
        this.modifierProfiles.put(name.getName(), profile);
        this.modifierComments.put(name.getName(), comment);
    }

    public XMLInitializable createUtil(String context, String name) throws InstantiationException, IllegalAccessException, ClassNotFoundException, Exception {
        if (this.myUtilsXmlString == null) {
            return null;
        }
        NodeList utilityNodes = this.getUtilDefinitions();
        XMLInitializable util = null;
        Node l = XMLUtil.getElementWithNameAndAttribute("Group", "Name", context, utilityNodes);
        if (l == null) {
            l = XMLUtil.getNamedElement(context, utilityNodes);
        }
        if (l != null) {
            Node c;
            NamedNodeMap attr;
            Node n = XMLUtil.getElementWithNameAndAttribute("Util", "Name", name, l.getChildNodes());
            if (n == null) {
                n = XMLUtil.getNamedElement(name, l.getChildNodes());
            }
            if (n != null && (attr = n.getAttributes()) != null && (c = attr.getNamedItem("class")) != null) {
                String classname = c.getNodeValue();
                util = (XMLInitializable)EreClassLoader.createInstance(classname);
                return util.init(n);
            }
        }
        return null;
    }

    public NodeList getUtilDefinitions() {
        NodeList retVal = null;
        if (this.myUtilsXmlString != null) {
            try {
                retVal = XMLUtil.buildDocumentFromString(this.myUtilsXmlString).getDocumentElement().getChildNodes();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return retVal;
    }

    public NodeList getUtilDefinitions(String level) {
        Element n = XMLUtil.getNamedElement(level, this.getUtilDefinitions());
        if (n != null) {
            return n.getChildNodes();
        }
        return null;
    }

    public String[] getTariffStructureNames() {
        String[] buf = new String[this.myTariffStructureList.size()];
        return this.myTariffStructureList.toArray(buf);
    }

    public String getTariffStructureClassName(String name) {
        return this.myTariffStructureClasses.get(name);
    }

    public String getTariffStructureProfileClassName(String name) {
        return this.myTariffStructureProfiles.get(name);
    }

    public String[] getNodeTypeNames() {
        String[] buf = new String[this.myNodeTypeList.size()];
        return this.myNodeTypeList.toArray(buf);
    }

    public String getNodeTypeClassName(String name) {
        return this.myNodeTypeClasses.get(name);
    }

    public String getNodeTypeProfileClassName(String name) {
        return this.myNodeTypeProfiles.get(name);
    }

    public PluginName[] getConditionTypeNames() {
        PluginName[] buf = new PluginName[this.getDefinedConditionList().size()];
        return this.getDefinedConditionList().toArray(buf);
    }

    public String getConditionClassName(String name) {
        String s = this.definedConditionClasses.get(name);
        if (s == null) {
            s = this.myDefaultConditionClass;
        }
        return s;
    }

    public String getConditionFieldName(String condName) {
        return this.definedConditionField.get(condName);
    }

    public String getConditionProfileClassName(String name) {
        String s = this.definedConditionProfiles.get(name);
        if (s == null) {
            s = this.myDefaultConditionProfileClass;
        }
        return s;
    }

    public String getModifierAliasOrName(String name) {
        for (PluginName pname : this.modifierList) {
            if (!pname.getName().equals(name)) continue;
            return pname.getAlias();
        }
        return null;
    }

    public boolean isModifierAlias(String nameOrAlias) {
        for (PluginName pname : this.modifierList) {
            if (!pname.isAlias() || !pname.getAlias().equals(nameOrAlias)) continue;
            return true;
        }
        return false;
    }

    public String getModifierComment(String name) {
        return this.modifierComments.get(name);
    }

    public List<PluginName> getModifierList() {
        Collections.sort(this.modifierList);
        return this.modifierList;
    }

    public String[] getModifierTypeNames() {
        String[] buf = new String[this.modifierList.size()];
        for (int i = 0; i < buf.length; ++i) {
            buf[i] = this.modifierList.get(i).getName();
        }
        return buf;
    }

    public String getModifierClassName(String name) {
        String s = this.modifierClasses.get(name);
        if (s == null) {
            s = this.myDefaultModifierClass;
        }
        return s;
    }

    public String getModifierProfileClassName(String name) {
        String s = this.modifierProfiles.get(name);
        if (s == null) {
            s = this.myDefaultModifierProfileClass;
        }
        return s;
    }

    public boolean isConditionAlias(String nameOrAlias) {
        for (PluginName pname : this.definedConditionList) {
            if (!pname.isAlias() || !pname.getAlias().equals(nameOrAlias)) continue;
            return true;
        }
        return false;
    }

    public String getConditionAliasOrName(String name) {
        for (PluginName pname : this.definedConditionList) {
            if (!pname.getName().equals(name)) continue;
            return pname.getAlias();
        }
        return null;
    }

    @Deprecated
    public Condition getConditionClass(String condName) throws InstantiationException {
        Condition conditionClass;
        String clName = this.getConditionProfileClassName(condName);
        try {
            conditionClass = (Condition)EreClassLoader.createInstance(clName);
        }
        catch (InstantiationException e) {
            System.out.println("e = " + e);
            throw new InstantiationException("InstantiationException. Operation " + clName + " could not be instantiated!");
        }
        catch (IllegalAccessException e) {
            throw new InstantiationException("IllegalAccessException. Operation " + clName + " could not be instantiated!");
        }
        catch (ClassNotFoundException e) {
            throw new InstantiationException("ClassNotFoundException. Operation " + clName + " could not be instantiated!");
        }
        catch (Exception e) {
            throw new InstantiationException("Problem with : " + clName + ".");
        }
        return conditionClass;
    }

    @Deprecated
    public Object[][] getFieldTableData() {
        return this.getFieldTableData(this.myFieldRepository.getTopLevelFieldDefinitions());
    }

    protected Object[][] getFieldTableData(List<FieldDefinition> fields) {
        Object[][] object = new Object[fields.size()][2];
        int ii = 0;
        for (FieldDefinition definition : fields) {
            object[ii][0] = definition.getFieldName();
            switch (definition.getDatatype()) {
                case 13: {
                    object[ii][1] = Boolean.FALSE;
                    break;
                }
                case 6: {
                    object[ii][1] = "";
                    break;
                }
                case 12: {
                    object[ii][1] = new Double(0.0);
                    break;
                }
                case 10: 
                case 16: {
                    object[ii][1] = 0;
                    break;
                }
                case 11: 
                case 17: {
                    object[ii][1] = 0L;
                    break;
                }
                case 14: {
                    Calendar calendar = Calendar.getInstance();
                    object[ii][1] = calendar.getTime();
                    break;
                }
                case 9: 
                case 15: {
                    object[ii][1] = new Short("0");
                }
            }
            ++ii;
        }
        return object;
    }

    public String[] getNumericFieldNames() {
        ArrayList<String> list = new ArrayList<String>();
        for (FieldDefinition field : this.myFieldRepository.getTopLevelFieldDefinitions()) {
            if (!field.getTypedDataType().isNumeric()) continue;
            list.add(field.getFieldName());
        }
        return list.toArray(new String[list.size()]);
    }

    public String[] getFieldNamesOfType(int type) {
        ArrayList<String> list = new ArrayList<String>();
        for (FieldDefinition field : this.myFieldRepository.getTopLevelFieldDefinitions()) {
            if (field.getTypedDataType().getTypeIdentifier() != type) continue;
            list.add(field.getFieldName());
        }
        return list.toArray(new String[list.size()]);
    }

    public List<FieldDefinition> getFieldDefinitions() {
        return this.myFieldRepository.getTopLevelFieldDefinitions();
    }

    public synchronized FieldHierarchyNode removeField(String name) {
        List<FieldHierarchyNode> removed = this.removeFields(Collections.singletonList(name));
        return removed.size() == 0 ? null : removed.get(0);
    }

    public synchronized List<FieldHierarchyNode> removeFields(List<String> fieldNames) throws IllegalArgumentException {
        ClassRepository.checkThatListAndElementsAreNonNull(fieldNames);
        ArrayList<FieldHierarchyNode> fields = new ArrayList<FieldHierarchyNode>();
        for (String fieldName : fieldNames) {
            this.checkThatNoConditionMappedToField(fieldName);
            FieldHierarchyNode field = this.myFieldRepository.getTopLevelFieldByName(fieldName);
            if (field == null) continue;
            fields.add(field);
        }
        this.myFieldRepository.modifyAndSwapRepository(fields, null, null, null);
        return fields;
    }

    public synchronized void removeFieldContextField(FieldContextField field) {
        if (field != null) {
            this.removeFieldContextFields(Collections.singletonList(field));
        }
    }

    public synchronized void removeFieldContextFields(List<FieldContextField> fields) throws IllegalArgumentException {
        ClassRepository.checkThatListAndElementsAreNonNull(fields);
        ArrayList<FieldContextField> fieldsToRemove = new ArrayList<FieldContextField>();
        for (FieldContextField field : fields) {
            this.checkThatNoConditionMappedToField(field.getNode().getCanonicalName());
            if (!this.isTopLevelField(field.getNode())) continue;
            fieldsToRemove.add(field);
        }
        this.myFieldRepository.modifyAndSwapRepository(null, null, fieldsToRemove, null);
    }

    private boolean isTopLevelField(FieldHierarchyNode node) {
        return node != null && node.getParent() == null;
    }

    @Deprecated
    public void removeTreeDefinedField(String name) {
        FieldHierarchyNode field = this.myFieldRepository.getTopLevelFieldByName(name);
        if (field != null && field.isLeaf() && ((FieldDefinition)field).getParameterType().equals(PARA_TYPE_INTERNAL)) {
            this.removeField(name);
        }
    }

    public synchronized void removeAllTreeDefinedFields() {
        ArrayList<FieldHierarchyNode> fieldsToRemove = new ArrayList<FieldHierarchyNode>();
        for (FieldDefinition field : this.myFieldRepository.getTopLevelFieldDefinitions()) {
            if (!field.getParameterType().equals(PARA_TYPE_INTERNAL)) continue;
            fieldsToRemove.add(field);
        }
        this.myFieldRepository.modifyAndSwapRepository(fieldsToRemove, null, null, null);
    }

    public List<FieldDefinition> getWorkingParameterFields() {
        return this.myFieldRepository.getWorkingParameterFields();
    }

    public Element getContextDefinition(String contextName) {
        return this.myContexts.get(contextName);
    }

    public Set<Map.Entry<String, Element>> getAllContexts() {
        if (this.myContexts != null) {
            return this.myContexts.entrySet();
        }
        return null;
    }

    public String getContextFieldIdentifier() {
        return this.myContextFieldIdentifier;
    }

    public Set<Map.Entry<String, ElementAndContext>> getAllServiceProviderContextFields() {
        return this.myServiceProviderContextFields.entrySet();
    }

    public Set<Map.Entry<String, ElementAndContext>> getAllRatingPlanContextFields() {
        return this.myRatingPlanContextFields.entrySet();
    }

    public FieldDefinition getFieldDefinitionByName(String name) {
        FieldDefinition field = null;
        FieldHierarchyNode fieldHierarchyNode = this.myFieldRepository.getFieldByName(name);
        if (fieldHierarchyNode != null && fieldHierarchyNode.isLeaf()) {
            field = (FieldDefinition)fieldHierarchyNode;
        }
        return field;
    }

    public List<FieldDefinition> getInputFieldDefinitions() {
        return this.getFieldDefinitionsOfType(INPUT_TYPES);
    }

    public List<FieldDefinition> getCommonFieldDefinitions() {
        ArrayList<FieldDefinition> list = new ArrayList<FieldDefinition>();
        for (FieldDefinition field : this.getFieldDefinitions()) {
            if (field.isContextField()) continue;
            list.add(field);
        }
        for (FieldDefinition field : this.getWorkingParameterFields()) {
            if (field.isContextField()) continue;
            list.add(field);
        }
        return list;
    }

    public Map<String, FieldDefinition> getInputFieldDefinitionMap() {
        return this.convertFieldListToMap(this.getInputFieldDefinitions());
    }

    public List<FieldDefinition> getOutputFieldDefinitions() {
        return this.getFieldDefinitionsOfType(OUTPUT_TYPES);
    }

    public Map<String, FieldDefinition> getOutputFieldDefinitionMap() {
        return this.convertFieldListToMap(this.getOutputFieldDefinitions());
    }

    protected Map<String, FieldDefinition> convertFieldListToMap(List<FieldDefinition> l) {
        HashMap<String, FieldDefinition> map = new HashMap<String, FieldDefinition>(l.size() * 2);
        for (int i = 0; i < l.size(); ++i) {
            FieldDefinition f = l.get(i);
            map.put(f.getFieldName(), f);
        }
        return map;
    }

    private List<FieldDefinition> getFieldDefinitionsOfType(String[] parameterTypes) {
        ArrayList<FieldDefinition> list = new ArrayList<FieldDefinition>();
        block0: for (FieldDefinition field : this.myFieldRepository.getTopLevelFieldDefinitions()) {
            for (String type : parameterTypes) {
                if (!type.equals(field.getParameterType())) continue;
                list.add(field);
                continue block0;
            }
        }
        return list;
    }

    public void setDataSetFactory(DataSetFactory factory) {
        this.myDataSetFactory = factory;
    }

    private void setDataSetFactory(String className) {
        try {
            Object factory = EreClassLoader.createInstance(className);
            if (factory instanceof DataSetFactory) {
                this.myDataSetFactory = (DataSetFactory)factory;
            } else {
                System.out.println("Supplied DataSetFactory is not an instance of DataSetFactory: " + className);
                this.myDataSetFactory = new DefaultDataSetFactory();
            }
        }
        catch (IllegalAccessException e) {
            System.out.println("Failed to instantiate DataSetFactory: " + className);
            this.myDataSetFactory = new DefaultDataSetFactory();
        }
        catch (ClassNotFoundException e) {
            System.out.println("Failed to instantiate DataSetFactory: " + className);
            this.myDataSetFactory = new DefaultDataSetFactory();
        }
        catch (InstantiationException e) {
            System.out.println("Failed to instantiate DataSetFactory: " + className);
            this.myDataSetFactory = new DefaultDataSetFactory();
        }
    }

    public boolean isUsingDataSet() {
        if (this.myDataSetFactory instanceof LegacyDataSetFactory) {
            return false;
        }
        return this.myDataSetFactory != null;
    }

    private void setSimulationFactory(String className) {
        this.mySimulationFactoryClass = className;
    }

    private void setMDUFilterFactory(String className) {
        this.myFilterFactoryName = className;
    }

    private void setMigrator(String className) {
        this.myMigratorClassName = className;
    }

    public SelectionTreeNodeMigrator getMigrator() {
        if (this.myMigrator != null) {
            return this.myMigrator;
        }
        if (this.myMigratorClassName == null || this.myMigratorClassName.length() == 0) {
            return null;
        }
        try {
            this.myMigrator = (SelectionTreeNodeMigrator)EreClassLoader.createInstance(this.myMigratorClassName);
            if (this.myMigrator instanceof ClassRepositoryUser) {
                ((ClassRepositoryUser)((Object)this.myMigrator)).setClassRepository(this);
            }
        }
        catch (Exception e) {
            return null;
        }
        return this.myMigrator;
    }

    public MultiDataUpdateFilterFactory getMDUFilterFactory() throws ServiceException {
        MultiDataUpdateFilterFactory factory;
        if (this.myFilterFactoryName == null) {
            return null;
        }
        if (this.myFilterFactory != null) {
            return this.myFilterFactory;
        }
        try {
            factory = (MultiDataUpdateFilterFactory)EreClassLoader.createInstance(this.myFilterFactoryName);
        }
        catch (InstantiationException ex) {
            throw new ServiceException(this.myFilterFactoryName + " is an interface or an abstract class.", ex);
        }
        catch (IllegalAccessException ex) {
            throw new ServiceException(this.myFilterFactoryName + " is not publicly accessible.", ex);
        }
        catch (ClassNotFoundException ex) {
            throw new ServiceException(this.myFilterFactoryName + " could not be found.", ex);
        }
        catch (ClassCastException ex) {
            throw new ServiceException(this.myFilterFactoryName + " does not implement the MultiDataUpdateFilterFactory interface.", ex);
        }
        this.myFilterFactory = factory;
        return this.myFilterFactory;
    }

    public Object getSimulationFactory() {
        if (this.mySimulationFactoryClass == null) {
            return null;
        }
        if (this.mySimulationFactory != null) {
            return this.mySimulationFactory;
        }
        try {
            Object factory;
            this.mySimulationFactory = factory = EreClassLoader.createInstance(this.mySimulationFactoryClass);
        }
        catch (IllegalAccessException e) {
            System.out.println("Failed to instantiate SimulationFactory: " + this.mySimulationFactoryClass);
            this.mySimulationFactory = null;
        }
        catch (ClassNotFoundException e) {
            System.out.println("Failed to instantiate SimulationFactory: " + this.mySimulationFactoryClass);
            this.mySimulationFactory = null;
        }
        catch (InstantiationException e) {
            System.out.println("Failed to instantiate SimulationFactory: " + this.mySimulationFactoryClass);
            this.mySimulationFactory = null;
        }
        return this.mySimulationFactory;
    }

    public String getServiceName() {
        return this.myServiceName;
    }

    public Element getFieldsRootElement() {
        return this.myFieldsRoot;
    }

    public FieldStructure addFieldStructure(Element fieldStructureElement) {
        FieldStructure fieldStructure = this.createFieldStructure(fieldStructureElement);
        this.addFieldDefinition(fieldStructure);
        return fieldStructure;
    }

    private FieldStructure createFieldStructure(Element fieldStructureElement) {
        FieldStructure fieldStructure = null;
        if (fieldStructureElement != null) {
            FieldDefinition.DefaultFieldConfiguration config = new FieldDefinition.DefaultFieldConfiguration(fieldStructureElement, null, null);
            fieldStructure = FieldStructure.createFieldStructure(config, this.myFieldRepository.getSeparator());
            for (FieldHierarchyNode node : fieldStructure.getAllDescendants()) {
                if (!node.isLeaf()) continue;
                FieldDefinition field = (FieldDefinition)node;
                this.checkThatFieldXmlDoesNotContainConditionMapping(field, field.getDefinitionNode());
            }
        }
        return fieldStructure;
    }

    public FieldDefinition addField(Element fieldElement) {
        FieldDefinition fieldDefinition = this.createFieldDefinition(fieldElement);
        this.addFieldDefinition(fieldDefinition);
        return fieldDefinition;
    }

    private FieldDefinition createFieldDefinition(Element fieldElement) {
        FieldDefinition fieldDefinition = null;
        if (fieldElement != null) {
            fieldDefinition = FieldDefinition.createFromXml(fieldElement);
            this.checkThatFieldXmlDoesNotContainConditionMapping(fieldDefinition, fieldElement);
        }
        return fieldDefinition;
    }

    public List<FieldHierarchyNode> addFieldsFromXml(List<Element> fieldElements) {
        ClassRepository.checkThatListAndElementsAreNonNull(fieldElements);
        ArrayList<FieldHierarchyNode> fields = new ArrayList<FieldHierarchyNode>();
        for (Element fieldElement : fieldElements) {
            String nodeName = fieldElement.getNodeName();
            AbstractStructureNode field = null;
            if ("FieldStructure".equals(nodeName)) {
                field = this.createFieldStructure(fieldElement);
            } else if (TAG_FIELD.equals(nodeName)) {
                field = this.createFieldDefinition(fieldElement);
            } else {
                throw new IllegalArgumentException("Unknown node name for tag : " + nodeName);
            }
            fields.add(field);
        }
        this.addFields(fields);
        return fields;
    }

    public synchronized void addFieldDefinition(FieldHierarchyNode field) {
        if (field != null) {
            this.addFields(Collections.singletonList(field));
        }
    }

    public synchronized void addFields(List<FieldHierarchyNode> fields) throws IllegalArgumentException {
        ClassRepository.checkThatListAndElementsAreNonNull(fields);
        ArrayList<FieldHierarchyNode> fieldsToAdd = new ArrayList<FieldHierarchyNode>();
        for (FieldHierarchyNode field : fields) {
            this.setClassRepositoryUser(field);
            fieldsToAdd.add(field);
        }
        this.myFieldRepository.modifyAndSwapRepository(null, fieldsToAdd, null, null);
    }

    public synchronized void addFieldContextField(FieldContextField field) {
        if (field != null) {
            this.addFieldContextFields(Collections.singletonList(field));
        }
    }

    public synchronized void addFieldContextFields(List<FieldContextField> fields) throws IllegalArgumentException {
        ClassRepository.checkThatListAndElementsAreNonNull(fields);
        ArrayList<FieldContextField> fieldsToAdd = new ArrayList<FieldContextField>();
        for (FieldContextField field : fields) {
            this.setClassRepositoryUser(field.getNode());
            fieldsToAdd.add(field);
        }
        this.myFieldRepository.modifyAndSwapRepository(null, null, null, fieldsToAdd);
    }

    public List<FieldContextField> getFieldContextFields() {
        return this.myFieldRepository.getFieldContextFields();
    }

    public FieldDefinition getFieldDefinitionByName(String fieldName, String serviceProvider) {
        FieldHierarchyNode node;
        FieldDefinition fd = null;
        ContextKey contextKey = new ContextKey(serviceProvider);
        Map<String, FieldHierarchyNode> serviceProviderContextFields = this.myFieldRepository.getServiceProviderContextFields(contextKey);
        if (serviceProviderContextFields != null && (node = serviceProviderContextFields.get(fieldName)) != null && node.isLeaf()) {
            fd = (FieldDefinition)node;
        }
        return fd;
    }

    public FieldDefinition getFieldDefinitionByName(String fieldName, String serviceProvider, String ratingPlan) {
        FieldHierarchyNode node;
        Map<String, FieldHierarchyNode> ratingPlanContextFields;
        FieldHierarchyNode node2;
        FieldDefinition fd = null;
        ContextKey contextKey = new ContextKey(serviceProvider, ratingPlan);
        Map<String, FieldHierarchyNode> serviceProviderContextFields = this.myFieldRepository.getServiceProviderContextFields(contextKey);
        if (serviceProviderContextFields != null && (node2 = serviceProviderContextFields.get(fieldName)) != null && node2.isLeaf()) {
            fd = (FieldDefinition)node2;
        }
        if (fd == null && (ratingPlanContextFields = this.myFieldRepository.getRatingPlanContextFields(contextKey)) != null && (node = ratingPlanContextFields.get(fieldName)) != null && node.isLeaf()) {
            fd = (FieldDefinition)node;
        }
        return fd;
    }

    public List<FieldDefinition> getFieldDefinitions(String serviceProvider) {
        ArrayList<FieldDefinition> fds = new ArrayList<FieldDefinition>();
        ContextKey contextKey = new ContextKey(serviceProvider);
        Map<String, FieldHierarchyNode> serviceProviderContextFields = this.myFieldRepository.getServiceProviderContextFields(contextKey);
        if (serviceProviderContextFields != null) {
            for (FieldHierarchyNode node : serviceProviderContextFields.values()) {
                if (node == null || !node.isLeaf()) continue;
                fds.add((FieldDefinition)node);
            }
        }
        return fds;
    }

    public List<FieldDefinition> getFieldDefinitions(String serviceProvider, String ratingPlan) {
        Map<String, FieldHierarchyNode> ratingPlanContextFields;
        ArrayList<FieldDefinition> fds = new ArrayList<FieldDefinition>();
        ContextKey contextKey = new ContextKey(serviceProvider, ratingPlan);
        Map<String, FieldHierarchyNode> serviceProviderContextFields = this.myFieldRepository.getServiceProviderContextFields(contextKey);
        if (serviceProviderContextFields != null) {
            for (FieldHierarchyNode node : serviceProviderContextFields.values()) {
                if (node == null || !node.isLeaf()) continue;
                fds.add((FieldDefinition)node);
            }
        }
        if ((ratingPlanContextFields = this.myFieldRepository.getRatingPlanContextFields(contextKey)) != null) {
            for (FieldHierarchyNode node : ratingPlanContextFields.values()) {
                if (node == null || !node.isLeaf()) continue;
                fds.add((FieldDefinition)node);
            }
        }
        return fds;
    }

    public void setDefinedConditionList(List<PluginName> pdefinedConditionList) {
        this.definedConditionList = pdefinedConditionList;
    }

    public List<PluginName> getDefinedConditionList() {
        Collections.sort(this.definedConditionList);
        return this.definedConditionList;
    }

    public void setTreeRootObject(Object root) {
        this.myTreeRootObject = root;
    }

    public Object getTreeRootObject() {
        return this.myTreeRootObject;
    }

    public JumperSupport getJumperSupport() {
        return this.myJumperSupporter;
    }

    public void setJumperSupport(JumperSupport jumper) {
        this.myJumperSupporter = jumper;
    }

    public String getAliasForCondition(String condition) {
        int len = this.definedConditionList.size();
        for (int i = 0; i < len; ++i) {
            PluginName cond = this.definedConditionList.get(i);
            if (!cond.getName().equals(condition)) continue;
            return cond.isAlias() ? cond.getAlias() : null;
        }
        return null;
    }

    public String getAliasForModifier(String modifier) {
        int len = this.modifierList.size();
        for (int i = 0; i < len; ++i) {
            PluginName mod = this.modifierList.get(i);
            if (!mod.getName().equals(modifier)) continue;
            return mod.isAlias() ? mod.getAlias() : null;
        }
        return null;
    }

    public ServiceFieldStructure getFieldStructure() {
        return this.myFieldStructure;
    }

    public DataRepository getDataRepository() throws ServiceDataException {
        if (this.myDataRepository == null) {
            this.myDataRepository = new DataRepositoryImpl(null, this);
        }
        return this.myDataRepository;
    }

    public FieldRepository getFieldRepository() {
        return this.myFieldRepository;
    }

    protected static FieldRepositoryWrapper getInnerFieldRepositoryFromClassRepository(ClassRepository repository) {
        return repository.myFieldRepository;
    }

    protected static void switchInnerFieldRepositoryInClassRepository(ClassRepository repository, FieldRepositoryWrapper fieldRepository) {
        repository.myFieldRepository = fieldRepository;
    }

    public Map<String, String> getBaseConditionClasses() {
        return this.baseConditionClasses;
    }

    public Map<String, String> getConnectedBaseConditions() {
        return this.connectedBaseConditions;
    }

    public List<PluginName> getBaseConditionList() {
        return this.baseConditionList;
    }

    public Map<String, String> getFieldComments() {
        return this.fieldComments;
    }

    public Map<String, String> getDefinedConditionField() {
        return this.definedConditionField;
    }

    public ClassRepository getClassRepositoryWithContext(FieldContext context) {
        return new ClassRepositoryWithContext(this, context);
    }

    private void mapFieldToCondition(FieldDefinition field, Node xml) {
        if (xml != null && xml.hasChildNodes()) {
            for (Element conditionElement : XMLUtil.getElementNodesNamed("Condition", xml.getChildNodes())) {
                String condName = XMLUtil.getAttributeFromElement(conditionElement, "Name", null);
                String baseConditionName = this.resolveBaseConditionName(XMLUtil.getAttributeFromElement(conditionElement, "Object", null));
                if (condName == null) {
                    throw new InvalidFieldException("'Name' attribute missing for condition mapped to field: " + field.getFieldName());
                }
                this.connectedBaseConditions.put(condName, baseConditionName);
                String className = this.getBaseConditionClass(baseConditionName);
                String profileName = this.getBaseConditionProfile(baseConditionName);
                PluginName pluginName = new PluginName(condName, null);
                this.addCondition(field.getFieldName(), pluginName, className, profileName, field.getComment());
            }
        }
    }

    private void setClassRepositoryUser(FieldDefinition field) {
        ValueClassFactory factory;
        if (field.hasValueClassFactory() && (factory = field.getValueClassFactory()) instanceof ClassRepositoryUser) {
            ((ClassRepositoryUser)((Object)factory)).setClassRepository(this);
        }
    }

    private void setClassRepositoryUser(FieldHierarchyNode field) {
        if (field.isLeaf()) {
            this.setClassRepositoryUser((FieldDefinition)field);
        } else {
            for (FieldHierarchyNode node : field.getChildren()) {
                this.setClassRepositoryUser(node);
            }
        }
    }

    private void checkThatNoConditionMappedToField(String name) {
        if (this.definedConditionField.containsValue(name)) {
            throw new InvalidFieldException("Not allowed to remove field: " + name + ", that is mapped to a condition.");
        }
    }

    private void checkThatFieldXmlDoesNotContainConditionMapping(FieldHierarchyNode field, Node fieldElement) {
        if (fieldElement != null && XMLUtil.getElementNodesNamed("Condition", fieldElement.getChildNodes()).size() > 0) {
            throw new InvalidFieldException("Mapped conditions not allowed when adding field definition: " + field.getFieldName() + ".");
        }
    }

    private static <G> void checkThatListAndElementsAreNonNull(List<G> list) {
        if (list == null) {
            throw new IllegalArgumentException("List must not be null.");
        }
        for (G element : list) {
            if (element != null) continue;
            throw new IllegalArgumentException("List element must not be null.");
        }
    }

    @Override
    public void fieldCreated(FieldDefinition field, Node xml) {
        this.setClassRepositoryUser(field);
        if (field.getParent() != null) {
            this.checkThatFieldXmlDoesNotContainConditionMapping(field, xml);
        } else {
            this.mapFieldToCondition(field, xml);
        }
    }

    @Override
    public boolean keepXml() {
        return false;
    }
}

