/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.defs;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipException;

public class EreClassLoader {
    private static String TAG_ERECLASSLOADER = "EreClassLoader";
    private static String TAG_CLASSPATH = "ClassPath";
    private static String ATTR_VALUE = "value";
    private static String TAG_JAR = "Jar";
    private static String ATTR_NAME = "name";
    private static String TAG_MANIFEST = "Manifest";
    private static String TAG_MAINATTRIBUTES = "MainAttributes";
    private static String TAG_ATTRIBUTE = "Attribute";
    private static String ATTR_KEY = "key";
    private static String TAG_URLS = "Urls";
    private static String TAG_URL = "Url";
    private static String TAG_ERROR = "Error";
    static ClassLoader myClassLoader;
    static EreClassLoader myInstance;

    private EreClassLoader() {
        myClassLoader = this.getClass().getClassLoader();
    }

    public static void addToClassLoader(String[] paths) {
        URL[] url = new URL[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            try {
                if (!paths[i].startsWith("file:/")) {
                    if (paths[i].startsWith("/")) {
                        url[i] = new URL("file:" + paths[i]);
                        continue;
                    }
                    url[i] = new URL("file:/" + paths[i]);
                    continue;
                }
                url[i] = new URL(paths[i]);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        myClassLoader = URLClassLoader.newInstance(url, myClassLoader);
    }

    public static Object createInstance(String name) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        return Class.forName(name, true, myClassLoader).newInstance();
    }

    public static Class<?> getClass(String name) throws ClassNotFoundException {
        return Class.forName(name, true, myClassLoader);
    }

    public static void addJars(File dir) {
        if (dir.isDirectory()) {
            String[] files = dir.list(new FilenameFilter(){

                @Override
                public boolean accept(File d, String name) {
                    return name.endsWith(".jar") && new File(d, name).isFile();
                }
            });
            for (int i = 0; i < files.length; ++i) {
                files[i] = new File(dir, files[i]).getAbsolutePath();
            }
            EreClassLoader.addToClassLoader(files);
        }
    }

    public static void printPath() {
        if (myClassLoader instanceof URLClassLoader) {
            URL[] url = ((URLClassLoader)myClassLoader).getURLs();
            for (int i = 0; i < url.length; ++i) {
                System.out.println("URL: " + url[i].toString());
            }
        }
    }

    public static InputStream getResourceAsStream(String name) {
        return myClassLoader.getResourceAsStream(name);
    }

    public static ClassLoader getClassLoader() {
        return myClassLoader;
    }

    public static URL getResource(String name) {
        return myClassLoader.getResource(name);
    }

    public static StringBuffer getProperties() throws Exception {
        StringBuffer xml = new StringBuffer("\n<" + TAG_ERECLASSLOADER + ">");
        ArrayList<URL> allUrlList = new ArrayList<URL>();
        xml.append("\n\t<" + TAG_URLS + ">");
        EreClassLoader.getAllUrls(myClassLoader, allUrlList);
        for (int ii = 0; ii < allUrlList.size(); ++ii) {
            xml.append("\n\t\t<" + TAG_URL + " " + ATTR_NAME + "='" + ((URL)allUrlList.get(ii)).getFile() + "'/>");
        }
        xml.append("\n\t</Urls>");
        List<URL> urlList = EreClassLoader.getJarUrls(allUrlList);
        for (int ii = 0; ii < urlList.size(); ++ii) {
            try {
                xml.append(EreClassLoader.jarProperties(new JarFile(urlList.get(ii).getFile())));
                continue;
            }
            catch (ZipException e) {
                xml.append("\n<" + TAG_ERROR + " message=" + e.getMessage() + ">\n\tfilename " + urlList.get(ii));
                StackTraceElement[] stackElement = e.getStackTrace();
                for (int jj = 0; jj < stackElement.length; ++jj) {
                    xml.append("\t\n<Stack>" + stackElement[jj] + "</Stack>");
                }
                xml.append("\n</" + TAG_ERROR + ">");
            }
        }
        xml.append("\n</" + TAG_ERECLASSLOADER + ">");
        xml.append("\n<" + TAG_CLASSPATH + " " + ATTR_VALUE + "='" + System.getProperty("java.class.path") + "' >");
        List<String> classPathJars = EreClassLoader.examineClassPath();
        for (int ii = 0; ii < classPathJars.size(); ++ii) {
            xml.append(EreClassLoader.jarProperties(new JarFile(classPathJars.get(ii))));
        }
        xml.append("<\n/" + TAG_CLASSPATH + ">");
        return xml;
    }

    private static List<URL> getJarUrls(List<URL> allUrlList) {
        ArrayList<URL> urlJarList = new ArrayList<URL>();
        ListIterator<URL> iterator = allUrlList.listIterator();
        while (iterator.hasNext()) {
            URL currentUrl = (URL)iterator.next();
            if (!currentUrl.getFile().toLowerCase().endsWith(".jar")) continue;
            boolean found = false;
            for (int jj = 0; jj < urlJarList.size(); ++jj) {
                if (!currentUrl.equals(urlJarList.get(jj))) continue;
                found = true;
                break;
            }
            if (found) continue;
            urlJarList.add(currentUrl);
        }
        return urlJarList;
    }

    public static List<URL> getAllUrls() {
        ArrayList<URL> fullList = new ArrayList<URL>();
        ArrayList<URL> theListToReturn = new ArrayList<URL>();
        EreClassLoader.getAllUrls(myClassLoader, fullList);
        for (int ii = 0; ii < fullList.size(); ++ii) {
            if (theListToReturn.contains(fullList.get(ii))) continue;
            theListToReturn.add((URL)fullList.get(ii));
        }
        return theListToReturn;
    }

    private static void getAllUrls(ClassLoader cl, List<URL> urlList) {
        if (cl.getParent() != null) {
            EreClassLoader.getAllUrls(cl.getParent(), urlList);
        }
        if (cl instanceof URLClassLoader) {
            URL[] urls = ((URLClassLoader)myClassLoader).getURLs();
            for (int ii = 0; ii < urls.length; ++ii) {
                urlList.add(urls[ii]);
            }
        }
    }

    private static StringBuffer jarProperties(JarFile jarFile) {
        StringBuffer xml = new StringBuffer();
        xml.append("\n<" + TAG_JAR + " " + ATTR_NAME + "='" + jarFile.getName() + "'>");
        try {
            Manifest manifest = jarFile.getManifest();
            xml.append("\n\t<" + TAG_MANIFEST + ">");
            if (manifest != null) {
                Attributes attributes = manifest.getMainAttributes();
                xml.append("\n\t\t<" + TAG_MAINATTRIBUTES + ">");
                xml.append(EreClassLoader.getAttributes(attributes));
                xml.append("\n\t\t</" + TAG_MAINATTRIBUTES + ">");
            }
            xml.append("\n\t</" + TAG_MANIFEST + ">");
            xml.append("\n</" + TAG_JAR + ">");
        }
        catch (IOException e) {
            xml.append("<" + TAG_ERROR + " cause='" + e.getMessage() + "'/>");
        }
        return xml;
    }

    private static StringBuffer getAttributes(Attributes attributes) {
        StringBuffer xml = new StringBuffer();
        for (Object key : attributes.keySet()) {
            Object value = attributes.get(key);
            xml.append("\n\t\t\t<" + TAG_ATTRIBUTE + " " + ATTR_KEY + "='" + key + "' " + ATTR_VALUE + "='" + value + "'/>");
        }
        return xml;
    }

    private static List<String> examineClassPath() {
        ArrayList<String> jarFileList = new ArrayList<String>();
        String classPath = System.getProperty("java.class.path");
        StringTokenizer tokenizer = new StringTokenizer(classPath, File.pathSeparator);
        while (tokenizer.hasMoreTokens()) {
            String currentClassPathDir = tokenizer.nextToken();
            if (!currentClassPathDir.endsWith(".jar")) continue;
            boolean found = false;
            for (int ii = 0; ii < jarFileList.size(); ++ii) {
                if (!((String)jarFileList.get(ii)).equals(currentClassPathDir)) continue;
                found = true;
                break;
            }
            if (found) continue;
            jarFileList.add(currentClassPathDir);
        }
        return jarFileList;
    }

    static {
        myInstance = new EreClassLoader();
    }
}

