/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.defs;

import com.ericsson.ere.annotations.jcip.Immutable;
import ericsson.ere.defs.AbstractStructureNode;
import ericsson.ere.defs.FieldCreationManager;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.interfaces.FieldHierarchyNode;
import ericsson.ere.util.NodeListIterable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.w3c.dom.Node;

@Immutable
public final class FieldStructure
extends AbstractStructureNode {
    public static final String TAG_FIELD_STRUCTURE = "FieldStructure";
    private static final String TAG_FIELD = "Field";
    private final List<FieldHierarchyNode> myChildren;
    private final String mySeparator;

    private FieldStructure(FieldStructure parent, Node config, List<String> contexts, String separator, FieldCreationManager fieldManager) {
        super(parent, FieldStructure.getNameFromXml(config), FieldStructure.getTagFromXml(config), FieldStructure.getComplexTypeFromXml(config), FieldStructure.getIsAutoConditionMapAllowedFromXml(config), contexts, FieldStructure.getToolTipFromXml(config));
        this.mySeparator = separator;
        ArrayList<AbstractStructureNode> children = new ArrayList<AbstractStructureNode>();
        for (Node node : new NodeListIterable(config.getChildNodes(), 1)) {
            if (TAG_FIELD_STRUCTURE.equalsIgnoreCase(node.getNodeName())) {
                FieldStructure childStructure = new FieldStructure(this, node, contexts, separator, fieldManager);
                children.add(childStructure);
                continue;
            }
            if (!TAG_FIELD.equalsIgnoreCase(node.getNodeName())) continue;
            FieldDefinition fieldDefinition = FieldDefinition.createField(this, (FieldDefinition.FieldConfiguration)new FieldDefinition.DefaultFieldConfiguration(node, contexts, null), fieldManager);
            children.add(fieldDefinition);
        }
        this.myChildren = children.isEmpty() ? Collections.EMPTY_LIST : new ArrayList(children);
    }

    public static FieldStructure createFieldStructure(FieldDefinition.FieldConfiguration config, String separator, FieldCreationManager fieldManager) {
        if (config == null) {
            throw new IllegalArgumentException("Argument cannot be null.");
        }
        Node fieldNode = config.getFieldNode();
        if (fieldNode == null) {
            throw new IllegalArgumentException("Field structure XML cannot be null.");
        }
        if (!TAG_FIELD_STRUCTURE.equals(fieldNode.getNodeName())) {
            throw new IllegalArgumentException("Node name tag must be 'FieldStructure'.");
        }
        return new FieldStructure(null, fieldNode, config.getContexts(), separator, fieldManager);
    }

    public static FieldStructure createFieldStructure(FieldDefinition.FieldConfiguration config, String separator) {
        if (config == null) {
            throw new IllegalArgumentException("Argument cannot be null.");
        }
        Node fieldNode = config.getFieldNode();
        if (fieldNode == null) {
            throw new IllegalArgumentException("Field structure XML cannot be null.");
        }
        if (!TAG_FIELD_STRUCTURE.equals(fieldNode.getNodeName())) {
            throw new IllegalArgumentException("Node name tag must be 'FieldStructure'.");
        }
        return new FieldStructure(null, fieldNode, config.getContexts(), separator, null);
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    public int getChildCount() {
        return this.myChildren.size();
    }

    @Override
    public FieldHierarchyNode getChildByName(String name) {
        FieldHierarchyNode found = null;
        for (FieldHierarchyNode child : this.myChildren) {
            if (!child.getFieldName().equals(name)) continue;
            found = child;
        }
        return found;
    }

    @Override
    public List<FieldHierarchyNode> getChildren() {
        return Collections.unmodifiableList(this.myChildren);
    }

    public String getSeparator() {
        return this.mySeparator;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.myChildren == null ? 0 : this.myChildren.hashCode());
        result = 31 * result + (this.mySeparator == null ? 0 : this.mySeparator.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        FieldStructure other = (FieldStructure)obj;
        if (this.myChildren == null ? other.myChildren != null : !this.myChildren.equals(other.myChildren)) {
            return false;
        }
        return this.mySeparator.equals(other.mySeparator);
    }

    @Override
    public boolean isKey() {
        return false;
    }

    public List<FieldDefinition> getKeyFields() {
        ArrayList<FieldDefinition> keyFields = new ArrayList<FieldDefinition>();
        for (FieldHierarchyNode child : this.myChildren) {
            if (!child.isKey()) continue;
            keyFields.add((FieldDefinition)child);
        }
        return keyFields;
    }

    public String toString() {
        return String.format("%s (%s)", new Object[]{this.myCanonicalName, this.myComplexType});
    }

    public List<FieldHierarchyNode> getAllDescendants() {
        ArrayList<FieldHierarchyNode> descendants = new ArrayList<FieldHierarchyNode>();
        for (FieldHierarchyNode child : this.myChildren) {
            descendants.add(child);
            if (child.isLeaf()) continue;
            this.addChildFieldsRecursively(child, descendants);
        }
        return descendants;
    }

    private void addChildFieldsRecursively(FieldHierarchyNode field, List<FieldHierarchyNode> list) {
        for (FieldHierarchyNode child : field.getChildren()) {
            list.add(child);
            if (child.isLeaf()) continue;
            this.addChildFieldsRecursively(child, list);
        }
    }
}

