/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.defs;

import com.ericsson.ere.gui.util.SystemPropertyUtil;
import ericsson.ere.defs.RmaDefsPropertiesChangeEvent;
import ericsson.ere.defs.RmaDefsPropertiesChangeListener;
import ericsson.ere.gui.Config;
import ericsson.ere.xml.XMLUtil;
import java.awt.Toolkit;
import java.io.File;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RmaDefs {
    public static final String TAG_RMA = "Rma";
    public static final String TAG_WORKAREA = "WorkArea";
    public static final String TAG_LOGGING = "Logging";
    public static final String PROP_SOUND_SETTING = "Rma.Sound.Enabled";
    public static final String PROP_MEM_SETTING = "Rma.Mem.Enabled";
    public static final String PROP_PERIOD_SORTING_SETTING = "Rma.PeriodSorting.Sorting";
    public static final String PROP_HIGHLIGHT_CURRENT_RATING_PERIOD_SETTING = "Rma.CurrentRatingPeriod.Enabled";
    public static final String PROP_USE_LOCAL_CLIPBOARD_SETTING = "Rma.UseLocalClipboard.Enabled";
    public static final String PROP_USE_OPTIMIZED_STEP_TRACE_SETTING = "Rma.UseOptimizedStepTrace.Enabled";
    public static final String PROP_CONFIRM_SELECTION_TREE_DRAG_AND_DROP_SETTING = "Rma.ConfirmSelectionTreeDragAndDrop.Enabled";
    public static final int NAME_SORTING = 0;
    public static final int DATE_SORTING = 1;
    static final String TAG_PROPERTY = "Property";
    static final String ATTR_NAME = "name";
    static final String ATTR_VALUE = "value";
    public static Logger loggerRma = Logger.getLogger("rma");
    public static Logger loggerHelp = Logger.getLogger("rma.help");
    public static Logger loggerNavigator = Logger.getLogger("rma.navigator");
    public static Logger loggerRatingManager = Logger.getLogger("rma.ratingmanager");
    public static Logger loggerServiceDefinition = Logger.getLogger("rma.servicedefinition");
    public static Logger loggerRatingPeriod = Logger.getLogger("rma.ratingperiod");
    public static Logger loggerSimulator = Logger.getLogger("rma.simulator");
    public static Logger loggerTrace = Logger.getLogger("rma.trace");
    public static Logger loggerRatingProvisioning = Logger.getLogger("rma.ratingprovisioning");
    public static Logger loggerMultiDataUpdate = Logger.getLogger("rma.multidataupdate");
    public static String PROP_DEBUG = "Debug";
    public static String PROP_NAVIGATOR = "Navigator";
    public static String PROP_SIMULATOR = "Simulator";
    public static String PROP_COMMENT_NODE = "Comment.RatingRuleTree.Node";
    public static String PROP_COMMENT_CONDITION = "Comment.RatingRuleTree.Condition";
    public static String PROP_COMMENT_MODIFIER = "Comment.RatingRuleTree.Modifier";
    public static String PROP_LOG_FILENAME = "Logging.Filename";
    public static String PROP_LOG_USE_FILE = "Logging.UseFile";
    public static String PROP_LOG_USE_WIN = "Logging.UseWin";
    public static String PROP_LOG_MAX_ENTRIES = "Logging.MaxEntries";
    public static String PROP_LOG_FILE_FORMAT = "Logging.FileFormat";
    public static String PROP_LOG_LEVEL = "Logging.Level";
    public static String PROP_WORKINGDIRECTORY = "WorkingDirectory";
    public static String PROP_STANDALONE = "Standalone";
    private static RmaDefs INSTANCE = new RmaDefs();
    public volatile Properties properties = new CustomProperties();
    String ProductInfoFile = "File.ProductInfoFile";
    private static boolean myAsksForDefaultProperties = true;
    private static Map<String, WeakReference<ImageIcon>> myIconCache = new HashMap<String, WeakReference<ImageIcon>>();
    private static ResourceBundle myResources = null;
    private List<RmaDefsPropertiesChangeListener> myRmaSettingsChangeListeners = new ArrayList<RmaDefsPropertiesChangeListener>();

    private RmaDefs() {
    }

    private boolean isPropertyGeneral(String prop) {
        return !prop.startsWith(TAG_WORKAREA) && !prop.startsWith(TAG_LOGGING);
    }

    @Deprecated
    public void setWorkingDirectory(File dir) {
        System.setProperty(PROP_WORKINGDIRECTORY, dir.getAbsolutePath());
    }

    @Deprecated
    public File getWorkingDirectory() {
        return new File(SystemPropertyUtil.getPropertyWithOptionalJnlpPrefix(PROP_WORKINGDIRECTORY));
    }

    @Deprecated
    public String getWorkingDirectoryString() {
        return SystemPropertyUtil.getPropertyWithOptionalJnlpPrefix(PROP_WORKINGDIRECTORY);
    }

    public void storeProperty(String prefix, Element tag) {
        if (tag.getNodeName().equals(TAG_PROPERTY)) {
            String name = tag.getAttribute(ATTR_NAME);
            String value = tag.getAttribute(ATTR_VALUE);
            if (name.length() != 0) {
                if (prefix != null) {
                    name = prefix + "." + name;
                }
                this.properties.setProperty(name, value);
            }
        }
    }

    public String getXMLForProperty(String key, String prefix) {
        String value = this.properties.getProperty(key);
        if (value == null) {
            value = "";
        }
        if (prefix != null && key.startsWith(prefix)) {
            key = key.substring(prefix.length() + 1);
        }
        return "<Property" + XMLUtil.wrapInAttribute(ATTR_NAME, key) + XMLUtil.wrapValueOrEmptyStringInAttribute(ATTR_VALUE, value) + "/>";
    }

    public static String getStringResource(String key) {
        String str;
        if (key == null) {
            return "Missing resource: <null>";
        }
        try {
            str = myResources.getString(key);
        }
        catch (MissingResourceException x) {
            str = "Missing resource: " + key;
        }
        return str;
    }

    public static ImageIcon getImageIcon(String iconName) {
        return RmaDefs.getImageIconFromPath("/images/" + iconName);
    }

    public static ImageIcon getImageIconFromPath(String iconName) {
        URL iconURL;
        WeakReference<ImageIcon> cachedIconRef;
        ImageIcon icon = null;
        String key = iconName;
        if (!key.startsWith("/")) {
            key = "/" + iconName;
        }
        if (((cachedIconRef = myIconCache.get(key)) == null || (icon = (ImageIcon)cachedIconRef.get()) == null) && (iconURL = RmaDefs.class.getResource(key)) != null) {
            icon = new ImageIcon(iconURL, iconName);
            myIconCache.put(key, new WeakReference<ImageIcon>(icon));
        }
        return icon;
    }

    public static RmaDefs getInstance() {
        return INSTANCE;
    }

    @Deprecated
    public static boolean getAsksForDefaultProperties() {
        return myAsksForDefaultProperties;
    }

    @Deprecated
    public static void setAsksForDefaultProperties(boolean onOff) {
        myAsksForDefaultProperties = onOff;
    }

    public void saveRmaConfig() {
        this.saveRmaConfig("RmaProperties.xml");
    }

    public void saveRmaConfigSav() {
        this.saveRmaConfig("RmaProperties.xml.sav");
    }

    public String getDebugProperty() {
        String retDebug = this.properties.getProperty(PROP_DEBUG);
        if (retDebug == null) {
            retDebug = "off";
        }
        return retDebug;
    }

    public boolean useCommentCondition() {
        String propValue = this.properties.getProperty(PROP_COMMENT_CONDITION);
        return propValue == null || !propValue.equalsIgnoreCase("no");
    }

    public boolean useCommentNode() {
        String propValue = this.properties.getProperty(PROP_COMMENT_NODE);
        return propValue == null || !propValue.equalsIgnoreCase("no");
    }

    public boolean useCommentModifier() {
        String propValue = this.properties.getProperty(PROP_COMMENT_MODIFIER);
        return propValue == null || !propValue.equalsIgnoreCase("no");
    }

    public boolean getSoundSetting() {
        return Boolean.parseBoolean(this.properties.getProperty(PROP_SOUND_SETTING, "true"));
    }

    public void setSoundSetting(boolean newSoundSetting) {
        this.properties.setProperty(PROP_SOUND_SETTING, Boolean.toString(newSoundSetting));
    }

    public void setMemorySetting(boolean newMemSetting) {
        this.properties.setProperty(PROP_MEM_SETTING, Boolean.toString(newMemSetting));
    }

    public boolean shouldMemoryStatusBeVisible() {
        return Boolean.parseBoolean(this.properties.getProperty(PROP_MEM_SETTING, "false"));
    }

    public void controlledBeep() {
        if (this.getSoundSetting()) {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public int getPeriodSortingSetting() {
        return Integer.parseInt(this.properties.getProperty(PROP_PERIOD_SORTING_SETTING, Integer.toString(0)));
    }

    public void setPeriodSortingSetting(int newSoundSetting) {
        this.properties.setProperty(PROP_PERIOD_SORTING_SETTING, Integer.toString(newSoundSetting));
    }

    public boolean getHighlightCurrentRatingPeriodSetting() {
        return Boolean.parseBoolean(this.properties.getProperty(PROP_HIGHLIGHT_CURRENT_RATING_PERIOD_SETTING, "false"));
    }

    public void setHighlightCurrentRatingPeriodSetting(boolean newRatingPeriodSetting) {
        this.properties.setProperty(PROP_HIGHLIGHT_CURRENT_RATING_PERIOD_SETTING, Boolean.toString(newRatingPeriodSetting));
    }

    public boolean getUseLocalClipboardSetting() {
        return Boolean.parseBoolean(this.properties.getProperty(PROP_USE_LOCAL_CLIPBOARD_SETTING, "True"));
    }

    public void setLocalUseClipboardSetting(boolean useClipboardSetting) {
        this.properties.setProperty(PROP_USE_LOCAL_CLIPBOARD_SETTING, Boolean.toString(useClipboardSetting));
    }

    public boolean getUseOptimizedStepTrace() {
        return Boolean.parseBoolean(this.properties.getProperty(PROP_USE_OPTIMIZED_STEP_TRACE_SETTING, "False"));
    }

    public void setUseOptimizedStepTrace(boolean useOptimizedStepTrace) {
        this.properties.setProperty(PROP_USE_OPTIMIZED_STEP_TRACE_SETTING, Boolean.toString(useOptimizedStepTrace));
    }

    public boolean getConfirmSelectionTreeDragAndDropSetting() {
        return Boolean.parseBoolean(this.properties.getProperty(PROP_CONFIRM_SELECTION_TREE_DRAG_AND_DROP_SETTING, "False"));
    }

    public void setConfirmSelectionTreeDragAndDropSetting(boolean confirmSelectionTreeDragAndDropSetting) {
        this.properties.setProperty(PROP_CONFIRM_SELECTION_TREE_DRAG_AND_DROP_SETTING, Boolean.toString(confirmSelectionTreeDragAndDropSetting));
    }

    private void saveRmaConfig(String fileName) {
        StringBuffer xml = new StringBuffer();
        xml.append(this.getXMLForProperties("  ", TAG_RMA));
        xml.append(this.getXMLForProperties("  ", TAG_WORKAREA));
        xml.append(this.getXMLForProperties("  ", TAG_LOGGING));
        try {
            Config.getInstance().saveConfig(fileName, xml.toString());
        }
        catch (Exception e) {
            loggerRma.warning(String.format("Failed to write RMA configuration to '%s': %s", fileName, e.getMessage()));
        }
    }

    private boolean isSpecificTag(String tag) {
        return tag.equals(TAG_WORKAREA) || tag.equals(TAG_LOGGING);
    }

    private String getXMLForProperties(String indent, String tag) {
        boolean isSpecific = this.isSpecificTag(tag);
        StringBuffer contents = new StringBuffer();
        Enumeration<Object> e = this.properties.keys();
        while (e.hasMoreElements()) {
            String key = e.nextElement().toString();
            if ((!isSpecific || !key.startsWith(tag)) && (isSpecific || !this.isPropertyGeneral(key))) continue;
            contents.append(indent);
            contents.append("  ");
            contents.append(this.getXMLForProperty(key, isSpecific ? tag : null));
            contents.append('\n');
        }
        StringBuffer xml = new StringBuffer();
        if (contents.length() > 0) {
            xml.append(indent);
            xml.append("<");
            xml.append(tag);
            xml.append(">\n");
            xml.append(contents);
            xml.append(indent);
            xml.append("</");
            xml.append(tag);
            xml.append(">\n");
        }
        return xml.toString();
    }

    private void readPropertiesForTag(String tag) {
        boolean isSpecific = this.isSpecificTag(tag);
        Vector<Node> config = Config.getInstance().getConfigFor(tag);
        if (config != null) {
            for (int i = 0; i < config.size(); ++i) {
                Element e = (Element)config.get(i);
                this.storeProperty(isSpecific ? tag : null, e);
            }
        }
    }

    public void addRmaDefsPropertiesChangeListener(RmaDefsPropertiesChangeListener listener) {
        this.myRmaSettingsChangeListeners.add(listener);
    }

    public void removeRmaDefsPropertiesChangeListener(RmaDefsPropertiesChangeListener listener) {
        this.myRmaSettingsChangeListeners.remove(listener);
    }

    private void fireRmaDefsPropertiesChangeEvent(RmaDefsPropertiesChangeEvent event) {
        for (RmaDefsPropertiesChangeListener listener : this.myRmaSettingsChangeListeners) {
            listener.propertiesChange(event);
        }
    }

    public void commitChanges() {
        this.fireRmaDefsPropertiesChangeEvent(new RmaDefsPropertiesChangeEvent(this));
    }

    public void saveNodeConfig() {
        Config.getInstance().saveNodeConfig();
    }

    static {
        myAsksForDefaultProperties = true;
        loggerHelp.setLevel(Level.OFF);
        loggerRatingManager.setLevel(Level.OFF);
        loggerServiceDefinition.setLevel(Level.OFF);
        loggerRatingPeriod.setLevel(Level.OFF);
        loggerSimulator.setLevel(Level.OFF);
        loggerTrace.setLevel(Level.OFF);
        myResources = ResourceBundle.getBundle("ericsson.ere.defs.RmaDefs");
    }

    private class CustomProperties
    extends Properties {
        private boolean myPropertiesLoaded = false;
        private boolean myLoadingProperties = false;

        private CustomProperties() {
        }

        @Override
        public void clear() {
            this.myPropertiesLoaded = false;
            super.clear();
        }

        @Override
        public synchronized String getProperty(String key) {
            this.ensurePropertiesLoaded();
            return super.getProperty(key);
        }

        @Override
        public synchronized Object setProperty(String key, String value) {
            if (!this.myLoadingProperties) {
                this.ensurePropertiesLoaded();
            }
            return super.setProperty(key, value);
        }

        @Override
        public synchronized Enumeration<Object> keys() {
            this.ensurePropertiesLoaded();
            return super.keys();
        }

        private void ensurePropertiesLoaded() {
            if (!this.myPropertiesLoaded) {
                this.myLoadingProperties = true;
                try {
                    RmaDefs.this.readPropertiesForTag(RmaDefs.TAG_RMA);
                    RmaDefs.this.readPropertiesForTag(RmaDefs.TAG_WORKAREA);
                    RmaDefs.this.readPropertiesForTag(RmaDefs.TAG_LOGGING);
                }
                finally {
                    this.myLoadingProperties = false;
                    this.myPropertiesLoaded = true;
                }
            }
        }
    }
}

