/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.gui;

import com.ericsson.ere.gui.diff.DiffToolPanel;
import com.ericsson.ere.gui.frame.RmaFrameEvent;
import com.ericsson.ere.gui.frame.RmaFrameListener;
import ericsson.ere.defs.EreClassLoader;
import ericsson.ere.defs.RmaDefs;
import ericsson.ere.gui.GuiServiceCenter;
import ericsson.ere.gui.RmaFrameSupport;
import ericsson.ere.gui.actions.AboutAction;
import ericsson.ere.gui.actions.CascadeAction;
import ericsson.ere.gui.actions.CloseAllAction;
import ericsson.ere.gui.actions.CloseOthersAction;
import ericsson.ere.gui.actions.SavePositionsAction;
import ericsson.ere.gui.actions.TileAction;
import ericsson.ere.gui.help.HelpItem;
import ericsson.ere.gui.help.HelpSystem;
import ericsson.ere.gui.log.LoggerTablePanel;
import ericsson.ere.gui.util.UtilMenuItem;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import javax.help.CSH;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MenuBuilder
implements RmaFrameListener {
    public static final String TAG_UTILITIESLIST = "UtilityList";
    public static final String TAG_UTILITYNODE = "Utility";
    public static final String ATTR_NAME = "Name";
    public static final String MENU_ICON = "Icon";
    public static final String ATTR_SERVICE = "Service";
    public static final String ATTR_CLASS = "Class";
    public static final String ATTR_SIZE = "Size";
    private JMenu myWindowMenu = null;
    private int myFrameCount = 0;
    private JMenuItem myCloseAllMenuItem;
    private JMenuItem myCloseOthersMenuItem;
    private Map<JInternalFrame, JMenuItem> myWindowFrameMenuMap = new HashMap<JInternalFrame, JMenuItem>();

    public MenuBuilder() {
        RmaFrameSupport.removeRmaFrameListenerByClass(MenuBuilder.class);
        RmaFrameSupport.addRmaFrameListener(this);
    }

    @Deprecated
    public static MenuBuilder getInstance() {
        return null;
    }

    public JMenuBar build(GuiServiceCenter guiSC) {
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(this.buildFileMenu(guiSC));
        menuBar.add(this.buildUtilMenu(guiSC));
        menuBar.add(this.buildWindowMenu());
        menuBar.add(this.buildHelpMenu());
        return menuBar;
    }

    private JMenu buildFileMenu(GuiServiceCenter guiSC) {
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic('F');
        fileMenu.add(guiSC.saveMenuAction);
        fileMenu.add(guiSC.importMenuAction);
        fileMenu.add(guiSC.saveAsMenuAction);
        fileMenu.addSeparator();
        fileMenu.add(guiSC.navigatorWindowAction);
        fileMenu.addSeparator();
        fileMenu.add(guiSC.settingsAction);
        fileMenu.addSeparator();
        fileMenu.add(guiSC.exitAction);
        return fileMenu;
    }

    private JMenu buildUtilMenu(GuiServiceCenter guiSC) {
        JMenu utilMenu = new JMenu("Util");
        utilMenu.setMnemonic('U');
        if (guiSC.getConfiguredUtilities().isEmpty()) {
            utilMenu.setEnabled(false);
        } else {
            utilMenu.setEnabled(true);
            Map<String, Element> utilities = guiSC.getConfiguredUtilities();
            Hashtable<String, JMenu> submenues = new Hashtable<String, JMenu>();
            for (Map.Entry<String, Element> entry : utilities.entrySet()) {
                String utility = entry.getKey();
                Element element = entry.getValue();
                int pos = utility.indexOf(46);
                if (pos < 0) {
                    ImageIcon utilIcon = RmaDefs.getImageIcon(element.getAttribute(MENU_ICON));
                    JMenuItem utilityItem = new JMenuItem(element.getAttribute(ATTR_NAME), utilIcon);
                    utilityItem.addActionListener(new UtilityAction(element));
                    utilMenu.add(utilityItem);
                    continue;
                }
                String service = utility.substring(0, pos);
                JMenu subMenu = (JMenu)submenues.get(service);
                if (subMenu == null) {
                    subMenu = new JMenu(service);
                    utilMenu.add(subMenu);
                    submenues.put(service, subMenu);
                }
                JMenuItem utilityItem = new JMenuItem(element.getAttribute(ATTR_NAME));
                utilityItem.addActionListener(new UtilityAction(element));
                subMenu.add(utilityItem);
                subMenu.setActionCommand(utility);
            }
        }
        return utilMenu;
    }

    private JMenu buildWindowMenu() {
        JMenu windowMenu = new JMenu("Window");
        windowMenu.setMnemonic('W');
        this.myCloseOthersMenuItem = windowMenu.add(new CloseOthersAction());
        this.myCloseOthersMenuItem.setEnabled(false);
        this.myCloseAllMenuItem = windowMenu.add(new CloseAllAction());
        this.myCloseAllMenuItem.setEnabled(false);
        windowMenu.addSeparator();
        windowMenu.add(new CascadeAction());
        windowMenu.add(new TileAction());
        windowMenu.add(new SavePositionsAction());
        this.myWindowMenu = windowMenu;
        return windowMenu;
    }

    public JMenuItem addFrameSelector(JInternalFrame frame) {
        if (this.myWindowMenu == null) {
            return null;
        }
        JMenuItem mi = new JMenuItem(frame.getTitle());
        if (this.myFrameCount == 0) {
            this.myWindowMenu.insertSeparator(0);
        }
        this.myWindowMenu.insert(mi, 0);
        ++this.myFrameCount;
        if (!this.myCloseAllMenuItem.isEnabled()) {
            this.myCloseAllMenuItem.setEnabled(true);
        }
        if (!this.myCloseOthersMenuItem.isEnabled() && this.myFrameCount > 1) {
            this.myCloseOthersMenuItem.setEnabled(true);
        }
        frame.addPropertyChangeListener(new MenuCaptionTitleUpdater(mi));
        return mi;
    }

    public void removeFrameSelector(JMenuItem item) {
        if (this.myWindowMenu == null) {
            return;
        }
        --this.myFrameCount;
        this.myWindowMenu.remove(item);
        if (this.myFrameCount == 0) {
            this.myWindowMenu.remove(0);
            this.myCloseAllMenuItem.setEnabled(false);
        }
        if (this.myFrameCount <= 1) {
            this.myCloseOthersMenuItem.setEnabled(false);
        }
    }

    private JMenu buildHelpMenu() {
        JMenu helpMenu = new JMenu("Help");
        helpMenu.setMnemonic('H');
        helpMenu.add(new AboutAction());
        String[] helpBrokerId = HelpSystem.getInstance().getRegisteredHelpBrokerIds();
        for (int ii = 0; ii < helpBrokerId.length; ++ii) {
            HelpItem helpItem = HelpSystem.getInstance().getHelpItem(helpBrokerId[ii]);
            if (helpItem.getHelpBroker() != null) {
                JMenuItem help = new JMenuItem(helpItem.getMenuName(), RmaDefs.getImageIcon("about.png"));
                help.addActionListener(new CSH.DisplayHelpFromSource(helpItem.getHelpBroker()));
                helpMenu.add(help);
                continue;
            }
            RmaDefs.loggerHelp.warning("HelpBroker is not valid, " + helpBrokerId[ii] + " helpset is " + helpItem.getHelpSetString());
        }
        return helpMenu;
    }

    @Override
    public void frameActivated(RmaFrameEvent event) {
        RmaFrameSupport frame = event.getFrame();
        if (!this.myWindowFrameMenuMap.containsKey(frame)) {
            this.frameCreated(event);
        }
    }

    @Override
    public void frameCreated(RmaFrameEvent event) {
        JMenuItem menuItem = this.addFrameSelector(event.getFrame());
        if (menuItem != null) {
            this.myWindowFrameMenuMap.put(event.getFrame(), menuItem);
            menuItem.addActionListener(new SelectFrameAction(event.getFrame()));
        }
    }

    @Override
    public void frameDeactivated(RmaFrameEvent event) {
    }

    @Override
    public void frameRemoved(RmaFrameEvent event) {
        JMenuItem menuItem = this.myWindowFrameMenuMap.remove(event.getFrame());
        if (menuItem != null) {
            this.removeFrameSelector(menuItem);
        }
    }

    static class MenuCaptionTitleUpdater
    implements PropertyChangeListener {
        private JMenuItem myItem;

        public MenuCaptionTitleUpdater(JMenuItem item) {
            this.myItem = item;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("title")) {
                this.myItem.setText((String)evt.getNewValue());
            }
        }
    }

    static class SelectFrameAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private JInternalFrame myFrame;

        public SelectFrameAction(JInternalFrame frame) {
            this.myFrame = frame;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.myFrame.isIcon()) {
                GuiServiceCenter.setIconNoVeto(this.myFrame, false);
            }
            GuiServiceCenter.setSelectedNoVeto(this.myFrame, true);
        }
    }

    static class UtilityAction
    extends AbstractAction {
        private static final long serialVersionUID = -2226953403587503694L;
        String myService;
        String myClass;
        Dimension mySize = null;
        Element myElement;

        public UtilityAction(Element e) {
            this.myElement = e;
            this.myService = e.getAttribute(MenuBuilder.ATTR_SERVICE);
            this.myClass = e.getAttribute(MenuBuilder.ATTR_CLASS);
            String aSize = e.getAttribute(MenuBuilder.ATTR_SIZE);
            if (aSize != null && aSize.length() > 0) {
                try {
                    StringTokenizer token = new StringTokenizer(aSize, ",");
                    int width = Integer.parseInt(token.nextToken());
                    int height = Integer.parseInt(token.nextToken());
                    this.mySize = new Dimension(width, height);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                Class<?> utilClass = EreClassLoader.getClass(this.myClass);
                Action a = this.mapToDefinedAction(utilClass);
                if (a == null) {
                    this.showUtility(utilClass);
                } else {
                    a.actionPerformed(e);
                }
            }
            catch (Exception x) {
                System.err.println("Failed to instantiate " + this.myClass);
                x.printStackTrace(System.err);
            }
        }

        private void showUtility(Class<?> utilClass) throws Exception {
            GuiServiceCenter guiSC = GuiServiceCenter.getInstance();
            RmaFrameSupport frame = new RmaFrameSupport();
            Class[] argTypes = new Class[]{JInternalFrame.class, Node.class};
            Constructor<?> constructor = utilClass.getDeclaredConstructor(argTypes);
            Object[] arguments = new Object[]{frame, this.myElement};
            UtilMenuItem comp = (UtilMenuItem)constructor.newInstance(arguments);
            guiSC.enableHelpKey(comp.getComponent(), comp.getClass().toString(), null);
            if (!frame.isShowing()) {
                frame.setTitle(comp.getTitle());
                frame.setResizable(comp.isResizable());
                frame.setClosable(comp.isClosable());
                frame.setMaximizable(comp.isMaximizable());
                frame.setIconifiable(comp.isIconifiable());
                frame.getContentPane().add(comp.getComponent(), "Center");
                if (!guiSC.setWindowPosition(frame)) {
                    if (this.mySize != null) {
                        frame.setSize(this.mySize);
                    } else {
                        frame.pack();
                    }
                }
                frame.setVisible(true);
                guiSC.getDesktopPane().add((Component)frame, "Center");
                frame.setSelected(true);
            }
        }

        private Action mapToDefinedAction(Class<?> clazz) {
            AbstractAction ret = null;
            if (clazz == LoggerTablePanel.class) {
                ret = GuiServiceCenter.getInstance().logToolAction;
            } else if (clazz == DiffToolPanel.class) {
                ret = GuiServiceCenter.getInstance().diffToolAction;
            }
            return ret;
        }
    }
}

