/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.gui;

import com.ericsson.ere.defs.SettingsRepository;
import com.ericsson.ere.gui.AbstractRmaPlugin;
import com.ericsson.ere.gui.RmaArguments;
import com.ericsson.ere.gui.navigator.NavigatorConfigLoader;
import com.ericsson.ere.gui.simulator.input.db.DatabaseAccess;
import com.ericsson.ere.gui.util.ExceptionUtil;
import com.ericsson.ere.gui.util.SystemPropertyUtil;
import com.ericsson.ere.util.JavaVersionChecker;
import ericsson.ere.defs.RmaDefs;
import ericsson.ere.gui.Config;
import ericsson.ere.gui.GuiServiceCenter;
import ericsson.ere.gui.PluginHandler;
import ericsson.ere.gui.RmaFrameSupport;
import ericsson.ere.gui.SplashScreen2;
import ericsson.ere.gui.StatusPanel;
import ericsson.ere.gui.interfaces.RmaInterface;
import ericsson.ere.gui.util.DialogFactory;
import ericsson.ere.gui.util.UtilMenuItem;
import ericsson.ere.management.Debug;
import ericsson.ere.progress.ProgressIndicator;
import ericsson.ere.xml.XMLUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.io.File;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.w3c.dom.Document;

public class Rma
extends AbstractRmaPlugin
implements WindowFocusListener {
    public static final SettingsRepository.Setting<String> RMA_ARG_USERDIR_BASE_OVERRIDE = SettingsRepository.Setting.create("userdir.base.override", null);
    public static final String RMA_HIDE_SPLASH_PROPERTY = "rma.hide.splash";
    private static final long serialVersionUID = 1L;
    private static final int MAX_PROGRESS = 1000;
    public static final String INTERNAL_SERVER_WORKING_DIR = "internalERE/";
    private static final double MAIN_WINDOW_WIDTH_FACTOR = 0.6;
    private static final double MAIN_WINDOW_HEIGHT_FACTOR = 0.9;
    private JFrame myFrameOwner;
    private RmaInterface myRmaOwner;

    @Deprecated
    public Rma(RmaInterface owner) {
        boolean standAlone;
        this.myRmaOwner = owner;
        boolean bl = standAlone = owner == null;
        if (!standAlone) {
            Rma.loadConfiguration();
        }
        this.init(null);
    }

    private Rma(RmaInterface owner, RmaArguments args) {
        this.myRmaOwner = owner;
        this.init(args);
    }

    private void init(RmaArguments args) {
        this.setupFrameLookAndFeel();
        GuiServiceCenter.newInstance();
        GuiServiceCenter guiSC = GuiServiceCenter.getInstance();
        Debug.setLevel(RmaDefs.getInstance().getDebugProperty());
        SplashScreen2 splash = null;
        ProgressIndicator progress = null;
        if (this.myRmaOwner == null && Rma.showSplash()) {
            splash = new SplashScreen2(1000);
            progress = splash.getProgressIndicator(1)[0];
            guiSC.setSplash(splash);
        }
        System.setProperty("Rma", "Gui");
        RmaDefs.getInstance().saveRmaConfigSav();
        Rma.recreateDatabaseConfigFile();
        RmaDefs.getInstance().saveNodeConfig();
        guiSC.setMainWindow(this);
        guiSC.enableHelpKey(guiSC.getContentPane(), this.getClass().toString(), null);
        this.setupListeners();
        this.setupGUI(guiSC, args);
        this.loadNavigatorConfig(progress);
        RmaDefs.loggerRma.info("GUI Started");
        if (splash != null) {
            splash.dismiss();
        }
        guiSC.showOrHideNavigator();
    }

    private static boolean showSplash() {
        boolean hide = Boolean.parseBoolean(SystemPropertyUtil.getPropertyWithOptionalJnlpPrefix(RMA_HIDE_SPLASH_PROPERTY));
        return !hide;
    }

    private static void recreateDatabaseConfigFile() {
        File databaseConfigFile = new File(Config.getInstance().getUserDir() + File.separatorChar + "DatabaseConfig.xml");
        if (databaseConfigFile.exists()) {
            try {
                DatabaseAccess.loadDatabaseConfig();
                DatabaseAccess.saveDatabaseConfig();
            }
            catch (Exception e) {
                RmaDefs.loggerRma.warning("Failed to save database configuration.");
            }
        }
    }

    private void setupFrameLookAndFeel() {
        String appName = RmaDefs.getStringResource("app.name");
        this.setTitle(appName);
        this.setName(appName);
        this.setIconImage(RmaDefs.getImageIcon("econ_launcher_square_32x32.png").getImage());
    }

    private void setupGUI(GuiServiceCenter guiSC, RmaArguments args) {
        JPanel contentPane = new JPanel(new BorderLayout());
        this.setContentPane(contentPane);
        guiSC.setupComponents(args);
        this.setJMenuBar(guiSC.menuBar);
        contentPane.add((Component)guiSC.getToolBar(), "North");
        contentPane.add((Component)StatusPanel.getInstance(), "South");
        if (!guiSC.setWindowPosition(this)) {
            this.moveAndSizeRelativeToScreen();
        }
    }

    @Override
    public void setContentPane(Container pane) {
        if (pane instanceof JPanel) {
            GuiServiceCenter.getInstance().setContentPane((JPanel)pane);
        }
        super.setContentPane(pane);
    }

    private void setupListeners() {
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                GuiServiceCenter.getInstance().exitAction.actionPerformed(null);
            }
        });
        this.addWindowFocusListener(this);
    }

    private void moveAndSizeRelativeToScreen() {
        Toolkit tk = this.getToolkit();
        Dimension screenDim = tk.getScreenSize();
        int mainScreenWidth = (int)((double)screenDim.width * 0.6);
        int mainScreenHeight = (int)((double)screenDim.height * 0.9);
        this.setSize(mainScreenWidth, mainScreenHeight);
        this.setLocationRelativeTo(null);
    }

    private static void loadConfiguration() {
        System.setProperty("awt.dnd.drag.threshold", "8");
        Config.getInstance().readConfig();
        PluginHandler.loadPlugins();
    }

    protected void loadNavigatorConfig(ProgressIndicator progress) {
        try {
            NavigatorConfigLoader navigatorConfigLoader = NavigatorConfigLoader.getInstance();
            navigatorConfigLoader.loadManagerFromXML(progress);
        }
        catch (Exception e) {
            ExceptionUtil.handleException(e, "navigator", 2, "Navigator configuration could not be loaded", true);
        }
    }

    @Deprecated
    public boolean performCorrectExit() {
        GuiServiceCenter guiSC = GuiServiceCenter.getInstance();
        return guiSC.prepareForExit();
    }

    @Override
    public void dispose() {
        RmaFrameSupport.clearRmaFrameListeners();
        super.dispose();
    }

    public static Rma constructRma(RmaInterface rmaInterface) {
        Rma.loadConfiguration();
        return new Rma(rmaInterface, null);
    }

    public static Rma constructRma(RmaArguments arguments) {
        String userDirOverride = arguments.getUserDirOverride();
        if (userDirOverride != null) {
            Config.settings().setValue(RMA_ARG_USERDIR_BASE_OVERRIDE, userDirOverride);
        }
        Rma.loadConfiguration();
        return new Rma(null, arguments);
    }

    public static void main(String[] args) {
        String NEEDED_VERSION = "1.8.0";
        final RmaArguments arguments = RmaArguments.parseArguments(args);
        Rma.checkJavaVersion("1.8.0");
        ExceptionGroup exceptionThreadGroup = new ExceptionGroup();
        new Thread((ThreadGroup)exceptionThreadGroup, "Init thread"){

            @Override
            public void run() {
                Rma rma = Rma.constructRma(arguments);
                rma.setVisible(true);
            }
        }.start();
    }

    private static void checkJavaVersion(String neededVersion) {
        String javaVersion = System.getProperty("java.version");
        String javaURL = "http://www.java.com";
        if (!JavaVersionChecker.isVersionCompatible(neededVersion)) {
            String title = "Wrong java version: " + javaVersion;
            String message = "This application needs at least Java version " + neededVersion + ",\nwhich can be downloaded freely from " + "http://www.java.com";
            DialogFactory.getErrorDialog(title, message);
            System.exit(1);
        }
    }

    protected void addUtility(Class<UtilMenuItem> util, String title, Dimension size) {
        try {
            String config = "<Utility" + XMLUtil.wrapInAttribute("Name", title) + XMLUtil.wrapInAttribute("Class", util.getName());
            if (size != null) {
                config = config + XMLUtil.wrapInAttribute("Size", size.width + "," + size.height);
            }
            config = config + "/>";
            config = XMLUtil.wrapXMLInTag("RmaConfig", XMLUtil.wrapXMLInTag("UtilityList", config));
            Document doc = XMLUtil.documentFromString(config);
            Config.getInstance().loadConfig(doc.getDocumentElement());
            this.setJMenuBar(GuiServiceCenter.getInstance().createMenuBar());
        }
        catch (Exception e) {
            DialogFactory.getErrorDialog("RMA", "Couldn't add utility to Rma\n" + e.getMessage());
        }
    }

    @Override
    public void windowGainedFocus(WindowEvent arg0) {
        if (this.myRmaOwner != null && this.myRmaOwner.isConfigUpdated()) {
            this.loadNavigatorConfig(null);
        }
    }

    public void setFrameOwner(JFrame frameOwner) {
        this.myFrameOwner = frameOwner;
        GuiServiceCenter.getInstance().setMainWindow(frameOwner);
    }

    public JFrame getFrameOwner() {
        return this.myFrameOwner;
    }

    @Override
    public void performExit() {
        if (this.myFrameOwner == null && this.myRmaOwner == null) {
            System.exit(0);
        } else {
            this.dispose();
        }
    }

    @Override
    public void windowLostFocus(WindowEvent arg0) {
    }

    public static class ExceptionGroup
    extends ThreadGroup {
        public ExceptionGroup() {
            super("ExceptionGroup");
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            try {
                ExceptionUtil.handleException(e, "navigator", 2, "An exception occurred on thread " + t.getName(), true);
            }
            catch (Exception ex) {
                ex.printStackTrace(System.err);
                JOptionPane.showMessageDialog(this.findActiveFrame(), ex.toString() + "\nCheck the error console for stack trace...", "An exception occurred", 0);
            }
        }

        private Frame findActiveFrame() {
            Frame[] frames = JFrame.getFrames();
            for (int i = 0; i < frames.length; ++i) {
                Frame frame = frames[i];
                if (!frame.isVisible()) continue;
                return frame;
            }
            return null;
        }
    }
}

