/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.gui;

import com.ericsson.ere.swing.SelfUpdatingMemoryViewer;
import ericsson.ere.defs.RmaDefs;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class StatusPanel
extends JMenuBar {
    public static Color ERICSSON_DARK_BLUE_100 = new Color(0, 50, 88);
    public static Color ERICSSON_ORANGE = new Color(255, 153, 0);
    private final int LOGO_WIDTH = 100;
    private static final StatusPanel myInstance = new StatusPanel();
    private JTextField myStatusMsgField;
    private JPanel myMemoryViewPanel;

    private StatusPanel() {
        this.setLayout(new BoxLayout(this, 1));
        this.setBackground(ERICSSON_ORANGE);
        JPanel extra = new JPanel();
        extra.setBackground(ERICSSON_DARK_BLUE_100);
        extra.setLayout(new BoxLayout(extra, 0));
        ImageIcon eri_logo = RmaDefs.getImageIcon("ELOGO-WHITE_98.png");
        int height = eri_logo.getIconHeight() + 6;
        JLabel logo = new JLabel(eri_logo);
        logo.setPreferredSize(new Dimension(110, height));
        this.myStatusMsgField = new JTextField();
        this.myStatusMsgField.setEditable(false);
        this.myStatusMsgField.setBorder(BorderFactory.createLoweredBevelBorder());
        this.myStatusMsgField.setOpaque(false);
        this.myStatusMsgField.setForeground(Color.white);
        this.setPreferredSize(new Dimension(-1, height));
        this.myMemoryViewPanel = this.createMemoryViewPanel();
        this.myMemoryViewPanel.setVisible(false);
        extra.add(logo);
        extra.add(this.myStatusMsgField);
        extra.add(this.myMemoryViewPanel);
        this.add(extra);
        this.setBorder(BorderFactory.createMatteBorder(1, -1, -1, -1, ERICSSON_ORANGE));
    }

    private JPanel createMemoryViewPanel() {
        GridLayout lm = new GridLayout(1, 1);
        JPanel panel = new JPanel(lm);
        panel.setBorder(BorderFactory.createEmptyBorder(3, 2, 3, 2));
        panel.setOpaque(false);
        return panel;
    }

    public static StatusPanel getInstance() {
        return myInstance;
    }

    public static StatusPanel getNewInstance() {
        return new StatusPanel();
    }

    public void setStatusMsg(String statusMsg) {
        if (!statusMsg.equals(this.myStatusMsgField.getText())) {
            this.myStatusMsgField.setText(statusMsg);
        }
    }

    public String getStatusMsg() {
        return this.myStatusMsgField.getText();
    }

    @Deprecated
    public void startProgressIndicator() {
    }

    @Deprecated
    public void stopProgressIndicator() {
    }

    public void hideMemoryStatus() {
        if (this.myMemoryViewPanel.getComponentCount() > 0) {
            this.myMemoryViewPanel.remove(0);
        }
        this.myMemoryViewPanel.setVisible(false);
    }

    public void showMemoryStatus() {
        if (this.myMemoryViewPanel.getComponentCount() == 0) {
            SelfUpdatingMemoryViewer viewer = new SelfUpdatingMemoryViewer(10);
            viewer.setPreferredSize(new Dimension(120, -1));
            this.myMemoryViewPanel.add(viewer);
            viewer.startSelfUpdate();
        }
        this.myMemoryViewPanel.setVisible(true);
    }
}

