/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.gui.actions;

import ericsson.ere.defs.RmaDefs;
import ericsson.ere.gui.GuiServiceCenter;
import ericsson.ere.gui.RmaFrameSupport;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;

public class SavePositionsAction
extends AbstractAction {
    public SavePositionsAction() {
        super("Save Window Positions");
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        JDesktopPane desk = GuiServiceCenter.getInstance().getDesktopPane();
        JInternalFrame[] frames = desk.getAllFrames();
        for (int i = frames.length - 1; i >= 0; --i) {
            if (frames[i].isIcon()) continue;
            this.savePosition(frames[i]);
        }
        this.savePosition(GuiServiceCenter.getInstance().getMainWindow());
    }

    private void savePosition(Component frame) {
        int x = frame.getX();
        int y = frame.getY();
        Dimension size = frame.getSize();
        Properties properties = RmaDefs.getInstance().properties;
        String className = frame.getClass().toString();
        int pos = className.lastIndexOf(46);
        if (pos >= 0) {
            className = className.substring(pos + 1);
        }
        if (frame instanceof RmaFrameSupport && frame instanceof JInternalFrame) {
            className = ((JInternalFrame)frame).getTitle();
        }
        className = "WorkArea." + className;
        properties.setProperty(className + ".x", Integer.toString(x));
        properties.setProperty(className + ".y", Integer.toString(y));
        properties.setProperty(className + ".width", Integer.toString(size.width));
        properties.setProperty(className + ".height", Integer.toString(size.height));
    }
}

