/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.gui.actions;

import ericsson.ere.gui.GuiServiceCenter;
import java.awt.event.ActionEvent;
import java.beans.PropertyVetoException;
import javax.swing.AbstractAction;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;

public class TileAction
extends AbstractAction {
    public TileAction() {
        super("Tile");
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        JDesktopPane desk = GuiServiceCenter.getInstance().getDesktopPane();
        JInternalFrame[] frames = desk.getAllFrames();
        int frameCount = 0;
        if (frames.length == 0) {
            return;
        }
        for (int i = 0; i < frames.length; ++i) {
            if (frames[i].isIcon()) continue;
            ++frameCount;
        }
        int cols = (int)Math.sqrt(frameCount);
        int rows = frameCount / cols;
        int extra = frameCount % cols;
        int width = desk.getWidth() / cols;
        int height = desk.getHeight() / rows;
        int r = 0;
        int c = 0;
        for (int i = 0; i < frames.length; ++i) {
            if (frames[i].isIcon()) continue;
            try {
                frames[i].setMaximum(false);
                frames[i].reshape(c * width, r * height, width, height);
                if (rows != ++r) continue;
                r = 0;
                if (cols != ++c + extra) continue;
                height = desk.getHeight() / ++rows;
                continue;
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }
}

