/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.gui.log.logfile;

import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.LogRecord;

public class TempLogFileFormatter
extends Formatter {
    private static char NUL = '\u0000';

    @Override
    public String getHead(Handler h) {
        return "";
    }

    @Override
    public String format(LogRecord rec) {
        StringBuilder msg = new StringBuilder();
        msg.append(rec.getSequenceNumber());
        msg.append(NUL);
        msg.append(rec.getMillis());
        msg.append(NUL);
        msg.append(rec.getLevel().getName());
        msg.append(NUL);
        msg.append(this.removeAsciiNullFromString(rec.getSourceClassName()));
        msg.append(" ");
        msg.append(this.removeAsciiNullFromString(rec.getSourceMethodName()));
        msg.append(NUL);
        msg.append(rec.getMessage());
        msg.append("\r\n");
        return msg.toString();
    }

    private String removeAsciiNullFromString(String string) {
        return string.replace(NUL, ' ');
    }

    @Override
    public String getTail(Handler h) {
        return "";
    }
}

