/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.gui.log.logtable;

import com.ericsson.ere.util.CompressedString;
import ericsson.ere.gui.log.logtable.LogTableEntry;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import java.util.logging.LogRecord;
import javax.swing.table.AbstractTableModel;

public class LogTableModel
extends AbstractTableModel {
    private static LogTableModel instance = null;
    Vector<LogTableEntry> logEntries = new Vector(1000);
    Vector<LogTableEntry> visibleLogEntries = new Vector(1000);
    int maxEntries = 2000;
    SimpleDateFormat formatter = new SimpleDateFormat("yyyy.MM.dd  HH:mm:ss.SSS");
    String locationFilter = "";
    String searchFilter = "";
    static final String COL_ENTRY = "Entry";
    static final String COL_TIME = "Time";
    static final String COL_LOCATION = "Location";
    static final String COL_LEVEL = "Level";
    static final String COL_MESSAGE = "Message";
    static final String[] colNames = new String[]{"Entry", "Time", "Location", "Level", "Message"};

    private LogTableModel() {
    }

    public static LogTableModel getInstance() {
        if (instance == null) {
            instance = new LogTableModel();
        }
        return instance;
    }

    @Override
    public String getColumnName(int column) {
        return colNames[column];
    }

    @Override
    public int getColumnCount() {
        return colNames.length;
    }

    @Override
    public int getRowCount() {
        return this.visibleLogEntries.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        try {
            LogTableEntry tEntry = this.visibleLogEntries.elementAt(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return tEntry.sequenceNumber;
                }
                case 1: {
                    return tEntry.timeString;
                }
                case 2: {
                    return tEntry.source;
                }
                case 3: {
                    return tEntry.level;
                }
                case 4: {
                    return tEntry.message.getPreview();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public Object getEntryAt(int row) {
        LogTableEntry result = null;
        try {
            result = this.visibleLogEntries.elementAt(row);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return result;
    }

    public synchronized void add(LogRecord record) {
        LogTableEntry tEntry = new LogTableEntry();
        Date date = new Date(record.getMillis());
        tEntry.sequenceNumber = record.getSequenceNumber();
        tEntry.time = date;
        tEntry.timeString = this.formatter.format(date);
        tEntry.source = record.getSourceClassName() + "::" + record.getSourceMethodName();
        tEntry.level = record.getLevel();
        tEntry.levelString = tEntry.level.getName();
        tEntry.getLoggerName = record.getLoggerName();
        tEntry.message = new CompressedString(record.getMessage());
        if (this.logEntries.size() >= this.maxEntries) {
            this.logEntries.remove(0);
        }
        this.logEntries.add(tEntry);
        this.updateVisibleEntries();
        this.fireTableDataChanged();
    }

    private void updateVisibleEntries() {
        LogTableEntry tEntry = null;
        this.visibleLogEntries.clear();
        Enumeration<LogTableEntry> e = this.logEntries.elements();
        while (e.hasMoreElements()) {
            tEntry = e.nextElement();
            if (!tEntry.source.contains(this.locationFilter) || !tEntry.message.getPreview().contains(this.searchFilter) && !tEntry.message.toString().contains(this.searchFilter)) continue;
            this.visibleLogEntries.add(tEntry);
        }
    }

    public void setMaxEntries(int maxEntries) {
        this.maxEntries = maxEntries;
    }

    public void limitVisibleLocation(String text) {
        this.locationFilter = text;
        this.updateVisibleEntries();
        this.fireTableDataChanged();
    }

    public void limitVisibleSearch(String text) {
        this.searchFilter = text;
        this.updateVisibleEntries();
        this.fireTableDataChanged();
    }

    public void clearAllEntries() {
        this.visibleLogEntries.clear();
        this.logEntries.clear();
        this.fireTableDataChanged();
    }

    public void clearLogEntry(LogTableEntry anyEntry) {
        this.logEntries.remove(anyEntry);
        this.visibleLogEntries.remove(anyEntry);
        this.fireTableDataChanged();
    }
}

