/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.gui.ratingrules;

import com.ericsson.ere.gui.diff.DiffProgressDialog;
import com.ericsson.ere.gui.ratingrules.SelectionTree;
import com.ericsson.ere.gui.util.ExceptionUtil;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.RmaDefs;
import ericsson.ere.gui.ratingrules.AdvancedSearchPanel;
import ericsson.ere.gui.ratingrules.RatingRuleFrame;
import ericsson.ere.gui.ratingrules.SelectorPanel;
import ericsson.ere.gui.ratingrules.SimpleSearchPanel;
import ericsson.ere.gui.ratingrules.nodes.BooleanTest;
import ericsson.ere.gui.ratingrules.nodes.Finder;
import ericsson.ere.gui.ratingrules.nodes.FinderResult;
import ericsson.ere.gui.ratingrules.nodes.NodePredicate;
import ericsson.ere.gui.ratingrules.nodes.TariffDAGNode;
import ericsson.ere.gui.util.ArrayListModel;
import ericsson.ere.gui.util.GuiUtil;
import ericsson.ere.gui.util.PaletteFrame;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.Collections;
import javax.swing.AbstractAction;
import javax.swing.JInternalFrame;
import javax.swing.JTabbedPane;
import javax.swing.SwingWorker;
import javax.swing.tree.TreePath;

public class FindPalette
extends PaletteFrame {
    static final String[] OPERATIONS = new String[]{RmaDefs.getStringResource("ratingrules.find.operation.0"), RmaDefs.getStringResource("ratingrules.find.operation.1")};
    static final String[] DEFAULT_SELECTORS = new String[]{RmaDefs.getStringResource("ratingrules.find.selector.0"), RmaDefs.getStringResource("ratingrules.find.selector.1"), RmaDefs.getStringResource("ratingrules.find.selector.2"), RmaDefs.getStringResource("ratingrules.find.selector.8")};
    static final String[] STQ_SELECTORS = new String[]{RmaDefs.getStringResource("ratingrules.find.selector.3"), RmaDefs.getStringResource("ratingrules.find.selector.4"), RmaDefs.getStringResource("ratingrules.find.selector.5")};
    static final String[] PRODUCT_TAG_SELECTORS = new String[]{RmaDefs.getStringResource("ratingrules.find.selector.6"), RmaDefs.getStringResource("ratingrules.find.selector.7")};
    static final String FIND_LBL = RmaDefs.getStringResource("ratingrules.find.labels.find");
    static final String LINKS_LBL = RmaDefs.getStringResource("ratingrules.find.labels.links");
    static final String ROOT_LBL = RmaDefs.getStringResource("ratingrules.find.labels.root");
    static final String MATCH_LBL = RmaDefs.getStringResource("ratingrules.find.labels.match");
    static final String MATCHCONT_LBL = RmaDefs.getStringResource("ratingrules.find.labels.match.cont");
    static final String INVERSE_LBL = RmaDefs.getStringResource("ratingrules.find.labels.inverse");
    private SelectionTree myTree;
    private JTabbedPane myTabbedPane;
    private SimpleSearchPanel mySimpleSearchPanel;
    private AdvancedSearchPanel myAdvancedSearchPanel;

    public FindPalette(SelectionTree tree) {
        super(RmaDefs.getStringResource("ratingrules.find.title"), true, true);
        this.setFrameIcon(RmaDefs.getImageIcon("find.png"));
        this.setPreferredSize(new Dimension(600, 300));
        this.myTree = tree;
        this.initComponents();
        this.getRootPane().setDefaultButton(this.mySimpleSearchPanel.getFindButton());
        this.pack();
    }

    @Deprecated
    public FindPalette(SelectionTree tree, ClassRepository rep) {
        this(tree);
    }

    private void initComponents() {
        this.myTabbedPane = new JTabbedPane();
        this.myTabbedPane.setTabLayoutPolicy(1);
        this.myTabbedPane.setFocusable(false);
        FindAction fa = new FindAction();
        this.mySimpleSearchPanel = new SimpleSearchPanel(fa, this.myTree);
        this.myAdvancedSearchPanel = AdvancedSearchPanel.buildPanelWithPredicatesAndResultView(fa, this.myTree);
        this.myTabbedPane.addTab(RmaDefs.getStringResource("ratingrules.find.tab.simplesearch"), this.mySimpleSearchPanel);
        this.myTabbedPane.addTab(RmaDefs.getStringResource("ratingrules.find.tab.advancedsearch"), this.myAdvancedSearchPanel);
        this.add(this.myTabbedPane);
    }

    public JInternalFrame getInternalFrame() {
        return this;
    }

    public static class PredicateHolder {
        NodePredicate predicate;
        SelectorPanel selectorPanel;

        PredicateHolder(NodePredicate predicate) {
            this.predicate = predicate;
        }
    }

    private class FindWorker
    extends SwingWorker<Void, Void> {
        private DiffProgressDialog myProgressDialog;

        FindWorker(DiffProgressDialog progressDialog) {
            this.myProgressDialog = progressDialog;
        }

        @Override
        protected Void doInBackground() throws Exception {
            TariffDAGNode searchRoot;
            NodePredicate pred;
            boolean followLinks;
            boolean isSimpleSearch = FindPalette.this.myTabbedPane.getSelectedIndex() == 0;
            StringBuilder pathSoFarByRef = new StringBuilder();
            if (isSimpleSearch) {
                followLinks = true;
                pred = Finder.createQuickSearchStringPredicate(FindPalette.this.mySimpleSearchPanel.getSearchText());
                searchRoot = FindPalette.this.myTree.getTreeRoot();
            } else {
                followLinks = FindPalette.this.myAdvancedSearchPanel.isLinkChecked();
                pred = FindPalette.this.myAdvancedSearchPanel.createAdvancedPredicate();
                if (FindPalette.this.myAdvancedSearchPanel.isInverseChecked()) {
                    pred = new BooleanTest("NOT", Collections.singletonList(pred));
                }
                searchRoot = this.getSearchRootWithPath(pathSoFarByRef);
            }
            RatingRuleFrame frame = GuiUtil.getClosestParentOfClass(FindPalette.this, RatingRuleFrame.class);
            GuiUtil.setBusyCursor(frame);
            ArrayListModel<FinderResult> model = new ArrayListModel<FinderResult>();
            FindPalette.this.mySimpleSearchPanel.showEmptyResult(false);
            FindPalette.this.myAdvancedSearchPanel.showEmptyResult(false);
            Finder.findMatchingNodes(searchRoot, pred, followLinks, pathSoFarByRef.toString(), model);
            if (isSimpleSearch) {
                FindPalette.this.mySimpleSearchPanel.setResultModel(model);
                if (model.size() == 0) {
                    FindPalette.this.mySimpleSearchPanel.showEmptyResult(true);
                }
            } else {
                FindPalette.this.myAdvancedSearchPanel.setResultModel(model);
                if (model.size() == 0) {
                    FindPalette.this.myAdvancedSearchPanel.showEmptyResult(true);
                }
            }
            GuiUtil.setDefaultCursor(frame);
            return null;
        }

        private TariffDAGNode getSearchRootWithPath(StringBuilder pathSoFarByRef) {
            Object o;
            TreePath path;
            TariffDAGNode searchRoot = FindPalette.this.myTree.getTreeRoot();
            if (!FindPalette.this.myAdvancedSearchPanel.isRootChecked() && (path = FindPalette.this.myTree.getTreeComponent().getSelectionPath()) != null && (o = path.getLastPathComponent()) != null) {
                searchRoot = (TariffDAGNode)o;
                Object[] p = path.getPath();
                int len = p.length - 1;
                for (int i = 0; i < len; ++i) {
                    TariffDAGNode n = (TariffDAGNode)p[i];
                    pathSoFarByRef.append('/');
                    pathSoFarByRef.append(n.getNodeId());
                }
            }
            return searchRoot;
        }

        @Override
        protected void done() {
            try {
                this.get();
                this.myProgressDialog.setVisible(false);
                super.done();
            }
            catch (Exception e) {
                ExceptionUtil.handleException(e, "ratingRuleFrame", 1, "An error occurred while searching.", true);
            }
        }
    }

    private class FindAction
    extends AbstractAction {
        FindAction() {
            this.putValue("Name", FIND_LBL);
            this.putValue("SmallIcon", RmaDefs.getImageIcon("find.png"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.updatePredicatesFromUI();
            Window owner = GuiUtil.getClosestWindowParent(FindPalette.this);
            DiffProgressDialog progressDialog = DiffProgressDialog.showDialog(owner, RmaDefs.getStringResource("ratingrules.find.searching"));
            progressDialog.setTitle(RmaDefs.getStringResource("ratingrules.find.search.dialog"));
            progressDialog.setSize(210, 120);
            FindWorker worker = new FindWorker(progressDialog);
            worker.execute();
            progressDialog.setVisible(true);
        }

        private void updatePredicatesFromUI() {
            for (PredicateHolder ph : FindPalette.this.myAdvancedSearchPanel.getPredicateModel()) {
                ph.predicate = ph.selectorPanel.createPredicate();
            }
        }
    }
}

