/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.gui.ratingrules;

import com.ericsson.ere.dataset.jump.SelectionTreeDestination;
import com.ericsson.ere.functioncontrol.FunctionContext;
import com.ericsson.ere.functioncontrol.FunctionManager;
import com.ericsson.ere.functioncontrol.FunctionManagerImpl;
import com.ericsson.ere.functioncontrol.FunctionState;
import com.ericsson.ere.functioncontrol.FunctionToken;
import com.ericsson.ere.gui.appaction.ApplicationAction;
import com.ericsson.ere.gui.appaction.ApplicationActionStateHandler;
import com.ericsson.ere.gui.navigator.NavigatorTree;
import com.ericsson.ere.gui.navigator.NavigatorTreeUtil;
import com.ericsson.ere.gui.navigator.nodes.AbstractNavigatorNode;
import com.ericsson.ere.gui.navigator.nodes.RatingPeriodNode;
import com.ericsson.ere.gui.ratingrules.SaveEvent;
import com.ericsson.ere.gui.ratingrules.SaveListener;
import com.ericsson.ere.gui.ratingrules.SelectionTree;
import com.ericsson.ere.gui.ratingrules.SelectionTreeActionHandlerImpl;
import com.ericsson.ere.gui.ratingrules.SelectionTreeImpl;
import com.ericsson.ere.gui.ratingrules.SelectionTreePopupMenu;
import com.ericsson.ere.gui.ratingrules.SelectionTreeSaveHandler;
import com.ericsson.ere.gui.ratingrules.SelectionTreeSaveHandlerImpl;
import com.ericsson.ere.gui.simulator.SimulationErrorException;
import com.ericsson.ere.gui.simulator.SimulationExecutionEvent;
import com.ericsson.ere.gui.simulator.SimulationExecutionListener;
import com.ericsson.ere.gui.simulator.SimulatorPanel;
import com.ericsson.ere.gui.simulator.SimulatorPanelInterface;
import com.ericsson.ere.gui.simulator.SimulatorTreeOwner;
import com.ericsson.ere.gui.simulator.tree.TraceTreeGUI;
import com.ericsson.ere.gui.util.ExceptionUtil;
import com.ericsson.ere.gui.util.Version;
import com.ericsson.ere.interfaces.ProxyTargetEditor;
import com.ericsson.ere.proxy.AbstractEreProxy;
import com.ericsson.ere.proxy.ActiveSavedRatingPlanProxy;
import com.ericsson.ere.proxy.RatingPeriodProxy;
import com.ericsson.ere.proxy.RatingPlanProxy;
import com.ericsson.ere.proxy.ServiceProviderProxy;
import com.ericsson.ere.selectiontree.SelectionTreeNodeFactoryImpl;
import com.ericsson.ere.swing.EDT;
import ericsson.ere.RatingData;
import ericsson.ere.datatype.Time;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.RmaDefs;
import ericsson.ere.gui.GuiServiceCenter;
import ericsson.ere.gui.RmaFrameInterface;
import ericsson.ere.gui.RmaFrameSupport;
import ericsson.ere.gui.StatusPanel;
import ericsson.ere.gui.interfaces.RatingExecutor;
import ericsson.ere.gui.interfaces.RatingResultEvaluator;
import ericsson.ere.gui.ratingrules.RatingJTreeErrorHandler;
import ericsson.ere.gui.ratingrules.RatingJTreeNodeFactory;
import ericsson.ere.gui.ratingrules.RatingRuleFrameJumper;
import ericsson.ere.gui.ratingrules.RatingRuleTree;
import ericsson.ere.gui.ratingrules.TrafficTreeStructureHolder;
import ericsson.ere.gui.ratingrules.bookmarks.AddBookmarkAction;
import ericsson.ere.gui.ratingrules.bookmarks.BookmarkFileUtil;
import ericsson.ere.gui.ratingrules.bookmarks.BookmarkItem;
import ericsson.ere.gui.ratingrules.bookmarks.BookmarksPane;
import ericsson.ere.gui.ratingrules.bookmarks.OpenBookmarksAction;
import ericsson.ere.gui.ratingrules.nodes.TSTariffStructure;
import ericsson.ere.gui.ratingrules.nodes.TariffDAGModel;
import ericsson.ere.gui.ratingrules.nodes.TariffDAGNode;
import ericsson.ere.gui.util.DialogFactory;
import ericsson.ere.gui.util.ProgressDialog;
import ericsson.ere.gui.util.SwingWorker;
import ericsson.ere.integration.settingsmap.Parameter;
import ericsson.ere.integration.settingsmap.SettingsMap;
import ericsson.ere.interfaces.RatingRuleBuilderErrorHandler;
import ericsson.ere.interfaces.RatingRuleTreeNodeFactory;
import ericsson.ere.interfaces.TariffStructure;
import ericsson.ere.interfaces.XMLInitializable;
import ericsson.ere.management.ContextAwareServiceContainer;
import ericsson.ere.management.DateUtil;
import ericsson.ere.management.FieldContext;
import ericsson.ere.management.RatingPeriod;
import ericsson.ere.management.Service;
import ericsson.ere.progress.NullProgressIndicator;
import ericsson.ere.progress.ProgressIndicator;
import ericsson.ere.ratingrules.FatalParsingError;
import ericsson.ere.ratingrules.RatingBuilderErrorHandler;
import ericsson.ere.ratingrules.RatingRuleBuilder;
import ericsson.ere.util.StringUtil;
import ericsson.ere.values.DoubleValue;
import ericsson.ere.values.LongValue;
import ericsson.ere.xml.XMLUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.TreePath;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RatingRuleFrame
extends RmaFrameSupport
implements RmaFrameInterface,
ActionListener,
ApplicationActionStateHandler,
ProxyTargetEditor {
    private static final String EMPTY_FILENAME = "";
    public static final String PARAM_ALLOW_PASTE_SPECIAL = "allow-paste-special";
    public static final String PARAM_ALLOW_SAVE = "allow-save";
    public static final String PARAM_ALLOW_SPEED_TYPING = "allow-speed-typing";
    public static final String PARAM_SHOW_TESTGEN = "show-testgen";
    public static final String PARAM_SHOW_BRANCH_SEARCH = "branch-search";
    public static final String PARAM_SHOW_FIND_PARAMETERS = "show-find-parameters";
    public static final String PARAM_SHOW_MULTI_DATA_UPDATE = "multi-data-update";
    public static final String PARAM_EDITING_PROXY = "editing-proxy";
    private static final String PROP_USE_BOOKMARKS = "use-bookmarks";
    public static final String PARAM_ALLOW_IMPORT = "allow-import";
    private JSplitPane myContentSplitPane;
    protected BookmarksPane myBookmarksPane;
    protected JTabbedPane myTreeAndSimData;
    protected JTabbedPane myTableAndTraceData;
    protected SimulatorPanelInterface mySimulatorPanel;
    protected JTextArea myTraceDestination;
    protected TraceTreeGUI myTraceTreeDestination;
    protected String myFileName;
    protected ContextAwareServiceContainer myServiceContainer;
    protected RatingPeriodDescription myPeriodDescription;
    private final String myNavigatorPath;
    private List<Action> myToolBarActionList = new ArrayList<Action>();
    private final SettingsMap mySettings;
    public static final String TAG_LBL_TAB_RRT = "Selection Tree";
    public static final String TAG_LBL_TAB_SIM = "Simulation";
    private SelectionTreeSaveHandler mySaveHandler;
    private SelectionTreeActionHandlerImpl myActionHandler;
    private SelectionTree mySelectionTree;
    private boolean myShowSimulationTab = true;
    private TrafficTreeStructureHolder myTrafficStructureHolder;

    public static RatingRuleFrame createSafelyForProxy(final RatingPeriodProxy ratingPeriodProxy, final TreePath navigatorPath, final Service service, Element ratingRuleTreeElement, ProgressIndicator progress) throws Exception {
        ProgressIndicator pi = progress != null ? progress : new NullProgressIndicator();
        ProgressIndicator[] indicators = pi.splitProgress(3);
        RatingRuleFrame.setJumperSupport(service, ratingPeriodProxy.getParentRatingPlanProxy());
        FieldContext fieldContext = new FieldContext(ratingPeriodProxy.getServiceProviderName(), ratingPeriodProxy.getRatingPlanName());
        ClassRepository classRepository = service.getClassRepository(fieldContext);
        RatingJTreeNodeFactory nodeFactory = new RatingJTreeNodeFactory(service.getId(), classRepository);
        final TSTariffStructure root = RatingRuleFrame.buildStructure(nodeFactory, ratingRuleTreeElement, EMPTY_FILENAME, indicators[0]);
        final SettingsMap settings = RatingRuleFrame.readControllingProperties(ratingPeriodProxy);
        RatingRuleFrame.prepareGUI(root, settings, indicators[1]);
        RatingRuleFrame frame = RatingRuleFrame.createGUI(new Callable<RatingRuleFrame>(){

            @Override
            public RatingRuleFrame call() throws Exception {
                RatingRuleFrame rrf = new RatingRuleFrame(ratingPeriodProxy, navigatorPath, service, root, settings);
                return rrf;
            }
        }, indicators[2]);
        return frame;
    }

    private static void prepareGUI(TSTariffStructure root, SettingsMap settings, ProgressIndicator progress) {
        progress.progressStart();
        progress.setInfo("Preparing editor...");
        TariffDAGModel model = new TariffDAGModel(null, root);
        model.updateSettings(settings);
        root.setTreeModel(model);
        root.isNodeValid();
        progress.progressFinished();
    }

    public static RatingRuleFrame createSafelyForFile(final RatingPeriodDescription periodDescription, final Service service, RatingPlanProxy ratingPlanProxy, final boolean useSimulation, ProgressIndicator progress) throws Exception {
        if (periodDescription == null || StringUtil.isEmptyString(periodDescription.getFileName())) {
            throw new IllegalArgumentException("Rating period is null, or the rating period file name is empty.");
        }
        if (service == null) {
            throw new IllegalArgumentException("Service must be non-null.");
        }
        ProgressIndicator pi = progress != null ? progress : new NullProgressIndicator();
        ProgressIndicator[] indicators = pi.splitProgress(3);
        if (ratingPlanProxy != null) {
            RatingRuleFrame.setJumperSupport(service, ratingPlanProxy);
        }
        FieldContext fieldContext = new FieldContext(periodDescription.getServiceProviderName(), periodDescription.getRatingPlanName());
        ClassRepository classRepository = service.getClassRepository(fieldContext);
        RatingJTreeNodeFactory nodeFactory = new RatingJTreeNodeFactory(service.getId(), classRepository);
        final TSTariffStructure root = RatingRuleFrame.buildStructure(nodeFactory, null, periodDescription.getFileName(), indicators[0]);
        final SettingsMap settings = RatingRuleFrame.readControllingProperties(null);
        RatingRuleFrame.prepareGUI(root, settings, indicators[1]);
        RatingRuleFrame frame = RatingRuleFrame.createGUI(new Callable<RatingRuleFrame>(){

            @Override
            public RatingRuleFrame call() throws Exception {
                RatingRuleFrame rrf = new RatingRuleFrame(periodDescription, service, useSimulation, root, settings);
                return rrf;
            }
        }, indicators[2]);
        return frame;
    }

    private static void setJumperSupport(Service service, RatingPlanProxy rp) {
        SelectionTreeDestination ownDestination = new SelectionTreeDestination(rp.getName(), service.getId(), rp.getServiceProviderProxy().getName());
        service.setJumperSupport(new RatingRuleFrameJumper(rp.getRatingManagerProxy(), ownDestination));
    }

    private static RatingRuleFrame createGUI(Callable<RatingRuleFrame> callable, ProgressIndicator progress) throws Exception {
        progress.progressStart();
        progress.setInfo("Creating editor...");
        RatingRuleFrame frame = EDT.runAndWait(callable);
        progress.progressFinished();
        return frame;
    }

    protected RatingRuleFrame(RatingPeriodProxy ratingPeriodProxy, TreePath navigatorPath, Service service, TSTariffStructure root, SettingsMap settings) throws Exception {
        super(EMPTY_FILENAME);
        this.myPeriodDescription = new RatingPeriodDescription(ratingPeriodProxy, EMPTY_FILENAME);
        this.myNavigatorPath = NavigatorTreeUtil.pathToString(navigatorPath);
        RatingPlanProxy rpProxy = ratingPeriodProxy.getParentRatingPlanProxy();
        FieldContext context = new FieldContext(rpProxy.getServiceProviderProxy().getName(), rpProxy.getName());
        this.myServiceContainer = ContextAwareServiceContainer.createContainerWithContext(service, context);
        this.mySettings = settings;
        this.commonConstruction(ratingPeriodProxy, root, null);
    }

    protected RatingRuleFrame(RatingPeriodDescription periodDescription, Service service, boolean useSimulation, TSTariffStructure root, SettingsMap settings) throws Exception {
        super(EMPTY_FILENAME);
        this.myPeriodDescription = periodDescription;
        this.myFileName = periodDescription.getFileName();
        this.myServiceContainer = ContextAwareServiceContainer.createContainerWithContext(service, this.createFieldContext());
        this.myNavigatorPath = null;
        this.myShowSimulationTab = useSimulation;
        this.mySettings = settings;
        this.commonConstruction(null, root, root.getNodeName());
    }

    private FieldContext createFieldContext() {
        return new FieldContext(this.myPeriodDescription.getServiceProviderName(), this.myPeriodDescription.getRatingPlanName());
    }

    private void commonConstruction(RatingPeriodProxy proxy, TSTariffStructure root, String sessionName) throws Exception {
        this.init(root, proxy);
        this.resetModified();
        this.configureOnlineHelp();
        this.setSessionName(sessionName);
        this.setWindowPosition();
    }

    private void configureOnlineHelp() {
        GuiServiceCenter.getInstance().enableHelpKey(this, this.getClass().toString(), null);
        if (this.myTraceDestination != null) {
            GuiServiceCenter.getInstance().enableHelpKey(this.myTraceDestination, "class ericsson.ere.gui.simulation.Trace", null);
        }
    }

    private static TSTariffStructure buildStructure(RatingRuleTreeNodeFactory nodeFactory, Element treeElement, String fileName, ProgressIndicator progress) throws Exception {
        TSTariffStructure root;
        progress.progressStart();
        progress.setInfo("Building tree structure...");
        RatingJTreeErrorHandler errorHandler = new RatingJTreeErrorHandler();
        RatingRuleBuilder builder = new RatingRuleBuilder(nodeFactory, (RatingRuleBuilderErrorHandler)errorHandler);
        if (treeElement != null) {
            Node parent;
            Element structure = treeElement;
            if (!"TariffStructure".equals(structure.getNodeName())) {
                structure = XMLUtil.getFirstElementNamed("TariffStructure", structure);
                assert (structure != null) : "Tree structure element not found.";
            }
            if ((parent = structure.getParentNode()) != null) {
                parent.removeChild(structure);
            }
            root = (TSTariffStructure)builder.buildFromElement(structure, progress);
        } else if (!StringUtil.isEmptyString(fileName)) {
            root = (TSTariffStructure)builder.buildFromFile(fileName, progress);
        } else {
            throw new IllegalArgumentException("Must have either a tree structure element or a file name.");
        }
        progress.progressFinished();
        return root;
    }

    protected void setWindowPosition() {
        if (!GuiServiceCenter.getInstance().setWindowPosition(this)) {
            this.setSize(new Dimension(650, 500));
        }
    }

    public RatingPeriodProxy getRatingPeriodProxy() {
        if (!this.hasNavigatorConnection()) {
            return null;
        }
        RatingPeriodNode node = this.getPeriodNode();
        return node != null ? (RatingPeriodProxy)node.getProxy() : null;
    }

    public RatingPeriod getRatingPeriod() {
        return this.myPeriodDescription.createFakeRatingPeriod();
    }

    public boolean displaySimTab() {
        this.myTreeAndSimData.setSelectedIndex(1);
        return true;
    }

    protected void init(TSTariffStructure rootNode, RatingPeriodProxy proxy) throws Exception {
        this.setFrameIcon(RmaDefs.getImageIcon("text_tree.png"));
        RatingRuleTree ratingRuleTree = this.setupRatingRuleTree(rootNode, proxy);
        if (this.myShowSimulationTab) {
            this.createTrafficStructureHolder();
            this.myTraceDestination = new JTextArea();
            this.myTraceDestination.setEditable(false);
            this.myTraceDestination.setFont(new Font("Monospaced", 0, 12));
            this.myTraceDestination.setName("RatingRuleFrame.JTextArea.TraceDestination");
            this.myTraceTreeDestination = new TraceTreeGUI();
            this.mySimulatorPanel = this.buildSimulatorPanel();
        }
        this.myTreeAndSimData = new JTabbedPane();
        TabMouseListener tabListener = new TabMouseListener();
        this.myTreeAndSimData.addMouseListener(tabListener);
        this.myTreeAndSimData.addChangeListener(new TabChangeListener());
        this.myTreeAndSimData.setName("RatingRuleFrame.TreeAndSimDataTab");
        if (!this.isSaveAllowed()) {
            ratingRuleTree.setBackground(new Color(240, 240, 240));
        }
        JScrollPane treeScrollPanel = new JScrollPane(ratingRuleTree);
        treeScrollPanel.setName("RatingRuleFrame.TreeAndSimDataTab.TreeScrollPane");
        this.myTreeAndSimData.addTab(TAG_LBL_TAB_RRT, null, treeScrollPanel, "Defines selection tree structure");
        if (this.myShowSimulationTab) {
            JPanel simulationPanel = (JPanel)((Object)this.mySimulatorPanel);
            simulationPanel.setName("RatingRuleFrame.TreeAndSimDataTab.SimulationPanel");
            this.myTreeAndSimData.addTab(TAG_LBL_TAB_SIM, null, simulationPanel, "Defines simulator test cases");
        }
        this.myTableAndTraceData = new JTabbedPane();
        this.myTableAndTraceData.addMouseListener(tabListener);
        this.myTableAndTraceData.setPreferredSize(this.myTreeAndSimData.getPreferredSize());
        this.myTableAndTraceData.setName("RatingRuleFrame.SettingsAndTraceTab");
        JComponent editTable = ratingRuleTree.getEditTable();
        this.myTableAndTraceData.addTab("Settings", null, editTable, "Configures settings");
        if (this.myShowSimulationTab) {
            this.myTableAndTraceData.addTab("Trace", null, new JScrollPane(this.myTraceDestination), "Displays the simulation trace");
            this.myTableAndTraceData.addTab("Step Trace", null, this.myTraceTreeDestination, "Displays the simulation tree");
        }
        final JSplitPane treeSplitPane = new JSplitPane(1, this.myTreeAndSimData, this.myTableAndTraceData);
        treeSplitPane.setDividerSize(8);
        treeSplitPane.setOneTouchExpandable(true);
        treeSplitPane.setBorder(null);
        List<BookmarkItem> bookmarks = new ArrayList<BookmarkItem>();
        if (this.shouldShowBookmarks()) {
            try {
                bookmarks = BookmarkFileUtil.getBookmarksForTreeFromFile(rootNode.getVersion().getId());
            }
            catch (Exception ex) {
                ExceptionUtil.handleException(ex, "ratingRuleFrame", 1, "Failed to extract bookmark configuration from file.", false);
            }
        }
        this.myBookmarksPane = new BookmarksPane(ratingRuleTree, bookmarks);
        this.myBookmarksPane.setVisible(false);
        this.myContentSplitPane = new JSplitPane(1, this.myBookmarksPane, treeSplitPane);
        this.myContentSplitPane.setEnabled(false);
        this.myContentSplitPane.setDividerLocation(0);
        this.myContentSplitPane.setDividerSize(0);
        this.myContentSplitPane.setBorder(null);
        this.getContentPane().add((Component)this.myContentSplitPane, "Center");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                treeSplitPane.setResizeWeight(0.5);
                treeSplitPane.setDividerLocation(0.5);
            }
        });
        this.populateToolBarActionList();
        if (this.myToolBarActionList.size() > 0) {
            JToolBar toolBar = new JToolBar();
            for (int i = 0; i < this.myToolBarActionList.size(); ++i) {
                toolBar.add(this.myToolBarActionList.get(i));
            }
            this.getContentPane().add((Component)toolBar, "North");
        }
        StatusPanel.getInstance().setStatusMsg(EMPTY_FILENAME);
    }

    private void createTrafficStructureHolder() {
        assert (this.mySelectionTree != null && this.mySelectionTree.getTreeRoot() != null);
        ClassRepository classRepository = this.myServiceContainer.getClassRepository();
        this.myTrafficStructureHolder = new TrafficTreeStructureHolder(this.mySelectionTree, classRepository, this.myPeriodDescription.getRatingPlanName());
    }

    private RatingRuleTree setupRatingRuleTree(TSTariffStructure rootNode, RatingPeriodProxy proxy) {
        ClassRepository classRepository = this.myServiceContainer.getClassRepository();
        this.mySelectionTree = new SelectionTreeImpl(this.mySettings, classRepository);
        this.mySaveHandler = proxy != null ? SelectionTreeSaveHandlerImpl.createForProxy(this.mySelectionTree, this.myServiceContainer, new SelectionTreeSaveHandlerImpl.RatingPeriodProxyWrapper(){

            @Override
            public RatingPeriodProxy getProxy() {
                return RatingRuleFrame.this.getRatingPeriodProxy();
            }
        }) : SelectionTreeSaveHandlerImpl.createForFile(this.mySelectionTree, this.myServiceContainer, this.myFileName);
        this.mySaveHandler.addSaveListener(new FrameSaveListener());
        this.myActionHandler = new SelectionTreeActionHandlerImpl(this.mySelectionTree, this.mySaveHandler, this.myServiceContainer);
        RatingRuleTree rrt = new RatingRuleTree(classRepository, this.mySettings);
        this.mySelectionTree.setTree(rrt);
        this.myActionHandler.setupDragAndDrop();
        SelectionTreePopupMenu popupMenu = new SelectionTreePopupMenu(this.mySelectionTree, this.myActionHandler, this.mySettings);
        rrt.setPopupMenu(popupMenu);
        this.mySelectionTree.getUndoableTree().openANewStructure(rootNode);
        return rrt;
    }

    protected static SettingsMap readControllingProperties(RatingPeriodProxy proxy) {
        SettingsMap settings = new SettingsMap();
        boolean hasProxy = proxy != null;
        settings.setParameter(PARAM_EDITING_PROXY, Boolean.toString(hasProxy), 3, false);
        if (hasProxy) {
            FunctionContext ctx = FunctionContext.build().withProxy(proxy).get();
            FunctionManager mgr = FunctionManagerImpl.getInstance();
            FunctionState testGenState = mgr.getStateForFunction(FunctionToken.TEST_GENERATION_TOOL, ctx);
            FunctionState speedTypingState = mgr.getStateForFunction(FunctionToken.SPEED_TYPING, ctx);
            FunctionState specialPasteState = mgr.getStateForFunction(FunctionToken.PASTE_SPECIAL, ctx);
            FunctionState bookmarksState = mgr.getStateForFunction(FunctionToken.BOOKMARKS, ctx);
            FunctionState branchSearchState = mgr.getStateForFunction(FunctionToken.BRANCH_SEARCH, ctx);
            FunctionState multiDataUpdateState = mgr.getStateForFunction(FunctionToken.MULTI_DATA_UPDATE, ctx);
            FunctionState showFindParameterState = mgr.getStateForFunction(FunctionToken.SHOW_FIND_PARAMETERS, ctx);
            settings.setParameter(PARAM_SHOW_TESTGEN, Boolean.toString(testGenState.getState() == FunctionState.State.ON), 3, true);
            settings.setParameter(PARAM_ALLOW_PASTE_SPECIAL, Boolean.toString(specialPasteState.getState() == FunctionState.State.ON), 3, true);
            settings.setParameter(PARAM_ALLOW_SPEED_TYPING, Boolean.toString(speedTypingState.getState() == FunctionState.State.ON), 3, true);
            settings.setParameter(PARAM_SHOW_BRANCH_SEARCH, Boolean.toString(branchSearchState.getState() == FunctionState.State.ON), 3, true);
            settings.setParameter(PARAM_SHOW_MULTI_DATA_UPDATE, Boolean.toString(multiDataUpdateState.getState() == FunctionState.State.ON), 3, true);
            settings.setProperty(PROP_USE_BOOKMARKS, Boolean.toString(bookmarksState.getState() == FunctionState.State.ON));
            settings.setParameter(PARAM_SHOW_FIND_PARAMETERS, Boolean.toString(showFindParameterState.getState() == FunctionState.State.ON), 3, true);
        }
        settings.setParameter(PARAM_ALLOW_SAVE, Boolean.toString(RatingRuleFrame.isSaveAllowed(proxy)), 3, false);
        settings.setParameter(PARAM_ALLOW_IMPORT, Boolean.toString(RatingRuleFrame.isImportAllowed(proxy)), 3, false);
        return settings;
    }

    private void populateToolBarActionList() {
        if (this.shouldShowBookmarks()) {
            OpenBookmarksAction openBookmarksAction = new OpenBookmarksAction(this.myContentSplitPane, this.myBookmarksPane.getTable());
            this.myToolBarActionList.add(openBookmarksAction);
            this.myToolBarActionList.add(new AddBookmarkAction(this.myBookmarksPane.getTable(), this.getRatingRuleTree(), openBookmarksAction, this.myBookmarksPane));
        }
    }

    JTabbedPane getTreeAndSimData() {
        return this.myTreeAndSimData;
    }

    JTabbedPane getSettingsAndTraceData() {
        return this.myTableAndTraceData;
    }

    @Override
    public boolean save(ProgressIndicator progress) {
        return this.mySaveHandler.save(progress) == SelectionTreeSaveHandler.SaveResult.SUCCESS;
    }

    private void saveBookmarks(boolean forceSave) {
        if (this.shouldShowBookmarks() && (this.myBookmarksPane.isChanged() || forceSave)) {
            try {
                List<BookmarkItem> bookmarkList = this.myBookmarksPane.getBookmarkList();
                String treeId = this.mySelectionTree.getVersion().getId();
                BookmarkFileUtil.saveBookmarksForTreeToFile(treeId, bookmarkList);
                this.myBookmarksPane.resetChanged();
            }
            catch (Exception ex) {
                ExceptionUtil.handleException(ex, "ratingRuleFrame", 1, "An error occured while saving bookmarks file.", false);
            }
        }
    }

    public void saveAs(ProgressIndicator progress) {
        this.mySaveHandler.saveAs(progress);
    }

    @Override
    public void export(ProgressIndicator progress) {
        this.mySaveHandler.export(progress);
    }

    public void setVersion(long version) {
        Version currentVersion = this.mySelectionTree.getTreeRoot().getVersion();
        currentVersion.setVersion(version);
    }

    public void saveToMultipleEREs() {
        this.mySaveHandler.saveToMultipleEREs();
    }

    @Override
    public void importFile() {
        this.myActionHandler.openAction(null);
    }

    private String getRatingRuleFrameTitle() {
        String defaultTitle;
        RatingPeriodProxy proxy = this.getRatingPeriodProxy();
        String string = defaultTitle = proxy == null ? this.myFileName : proxy.getDefaultWindowTitle();
        if (!this.isSaveAllowed()) {
            defaultTitle = defaultTitle + " (Read-only)";
        }
        return defaultTitle;
    }

    public void setSessionName(String name) {
        if (name != null) {
            this.setTitle(this.getRatingRuleFrameTitle() + " - " + name);
        } else {
            this.setTitle(this.getRatingRuleFrameTitle());
        }
    }

    public RatingRuleTree getRatingRuleTree() {
        return (RatingRuleTree)this.mySelectionTree.getTreeComponent();
    }

    protected SimulatorPanelInterface buildSimulatorPanel() {
        JPanel spi;
        if (this.myServiceContainer.getService().getSimulationFactory() == null) {
            spi = new ericsson.ere.gui.simulation.SimulatorPanel(this.myServiceContainer, this.myTraceDestination, new InternalRatingExecutor());
        } else {
            SimulatorPanel panel = new SimulatorPanel(this.myServiceContainer, this.myTraceDestination, this.myTraceTreeDestination, new SimulatorTreeOwnerImpl());
            panel.addSimulationExecutionListener(new SimulationExecutionHandler());
            spi = panel;
        }
        return spi;
    }

    public boolean isModified() {
        return this.mySelectionTree.isModified();
    }

    public void resetModified() {
        this.mySelectionTree.resetModified();
    }

    @Override
    public boolean isOkToDiscardChanges() {
        int result = 0;
        boolean hasSaved = true;
        if (this.isModified()) {
            result = DialogFactory.getQuestionDialogWithCancel(this, "Selection Tree modified - " + this.getTitle(), "Save Changes ?\n" + this.getTitle());
            if (result == 2 || result == -1) {
                return false;
            }
            if (result == 0) {
                final ProgressDialog progressDialog = new ProgressDialog("RMA", "Saving Selection Tree");
                SwingWorker worker = new SwingWorker(){

                    @Override
                    public Object construct() {
                        ProgressIndicator progress = progressDialog.getProgressIndicator();
                        return RatingRuleFrame.this.save(progress);
                    }

                    @Override
                    public void finished() {
                        progressDialog.dispose();
                    }
                };
                worker.start();
                progressDialog.setVisible(true);
                hasSaved = (Boolean)worker.get();
            }
        } else {
            this.saveBookmarks(false);
        }
        if (this.mySimulatorPanel != null && this.mySimulatorPanel.isModified()) {
            result = DialogFactory.getQuestionDialogWithCancel(this, this.getTitle() + " - Save Simulator data", "Save Changes ?\nSimulator data " + this.getTitle());
            if (result == 2 || result == -1) {
                return false;
            }
            if (result == 0) {
                if (this.mySimulatorPanel instanceof SimulatorPanel && !((SimulatorPanel)this.mySimulatorPanel).isSaveAllowed()) {
                    return false;
                }
                this.mySimulatorPanel.saveAction(new ActionEvent(this, 0, "closing"));
            }
        }
        return hasSaved;
    }

    public boolean supportsInternalVars() {
        return this.mySelectionTree.getTreeRoot().supportsTreeDefinedFields();
    }

    public SimulatorPanelInterface getSimulatorPanel() {
        return this.mySimulatorPanel;
    }

    private boolean isSaveAllowed() {
        Parameter sp = this.mySettings.getParameter(PARAM_ALLOW_SAVE);
        return sp != null && Boolean.parseBoolean(sp.getValue());
    }

    public static boolean isImportAllowed(RatingPeriodProxy proxy) {
        if (proxy == null) {
            return true;
        }
        return RatingRuleFrame.getStateForImportAllowed(proxy).getState() == FunctionState.State.ON;
    }

    private static FunctionState getStateForImportAllowed(RatingPeriodProxy proxy) {
        FunctionManager mgr = FunctionManagerImpl.getInstance();
        FunctionContext ctx = FunctionContext.build().withProxy(proxy).get();
        FunctionState state = mgr.getStateForFunction(FunctionToken.IMPORT_ALLOWED, ctx);
        return state;
    }

    private boolean shouldShowBookmarks() {
        String value = this.mySettings.getProperty(PROP_USE_BOOKMARKS);
        return Boolean.parseBoolean(value);
    }

    private static boolean isSaveAllowed(RatingPeriodProxy proxy) {
        if (proxy == null) {
            return true;
        }
        return RatingRuleFrame.getStateForSaveAllowed(proxy).getState() == FunctionState.State.ON;
    }

    private static FunctionState getStateForSaveAllowed(RatingPeriodProxy proxy) {
        FunctionManager mgr = FunctionManagerImpl.getInstance();
        FunctionContext ctx = FunctionContext.build().withProxy(proxy).get();
        FunctionState state = mgr.getStateForFunction(FunctionToken.SAVE_SELECTION_TREE, ctx);
        return state;
    }

    @Override
    public boolean isApplicationActionSupported(ApplicationAction action) {
        switch (action) {
            case SAVE: {
                return this.isSaveAllowed();
            }
        }
        return false;
    }

    @Override
    public String getContentDescription() {
        return TAG_LBL_TAB_RRT;
    }

    public RatingPeriodNode getPeriodNode() {
        if (!this.hasNavigatorConnection()) {
            return null;
        }
        NavigatorTree tree = (NavigatorTree)GuiServiceCenter.getInstance().getNavigatorTree();
        TreePath treePath = tree.stringToPath(this.myNavigatorPath);
        AbstractNavigatorNode node = (AbstractNavigatorNode)treePath.getLastPathComponent();
        return node instanceof RatingPeriodNode ? (RatingPeriodNode)node : null;
    }

    private boolean hasNavigatorConnection() {
        return this.myNavigatorPath != null;
    }

    public Service getService() {
        return this.myServiceContainer.getService();
    }

    @Override
    public boolean isEditingProxy(AbstractEreProxy aProxy) {
        boolean openForEdit = false;
        RatingPeriodProxy openFrameProxy = this.getRatingPeriodProxy();
        if (openFrameProxy != null) {
            if (aProxy instanceof ServiceProviderProxy) {
                ServiceProviderProxy serviceProvProxy = (ServiceProviderProxy)aProxy;
                for (RatingPlanProxy ratingPlanProxy : serviceProvProxy.getRatingPlanList()) {
                    if (!this.periodProxyIsChildOfPlanProxy(openFrameProxy, ratingPlanProxy)) continue;
                    openForEdit = true;
                    break;
                }
            } else if (aProxy instanceof RatingPlanProxy) {
                openForEdit = this.periodProxyIsChildOfPlanProxy(openFrameProxy, (RatingPlanProxy)aProxy);
            } else if (aProxy instanceof RatingPeriodProxy) {
                openForEdit = this.periodProxyIsFoundInList(openFrameProxy, Collections.singletonList((RatingPeriodProxy)aProxy));
            }
        }
        return openForEdit;
    }

    private boolean periodProxyIsChildOfPlanProxy(RatingPeriodProxy thePeriodProxy, RatingPlanProxy thePlanProxy) {
        boolean openForEdit = false;
        if (thePlanProxy instanceof ActiveSavedRatingPlanProxy) {
            ActiveSavedRatingPlanProxy activeSavedRatingPlanProxy = (ActiveSavedRatingPlanProxy)thePlanProxy;
            openForEdit = this.periodProxyIsFoundInList(thePeriodProxy, activeSavedRatingPlanProxy.getSavedListProxy().getRatingPeriodList());
            if (!openForEdit) {
                openForEdit = this.periodProxyIsFoundInList(thePeriodProxy, activeSavedRatingPlanProxy.getActiveListProxy().getRatingPeriodList());
            }
        } else {
            openForEdit = this.periodProxyIsFoundInList(thePeriodProxy, thePlanProxy.getRatingPeriodList());
        }
        return openForEdit;
    }

    private boolean periodProxyIsFoundInList(RatingPeriodProxy thePeriodProxy, List<RatingPeriodProxy> thePeriodProxyList) {
        boolean openForEdit = false;
        for (RatingPeriodProxy ratingPeriodProxy : thePeriodProxyList) {
            if (!thePeriodProxy.equals(ratingPeriodProxy) && !this.periodProxyParamsAreEqual(thePeriodProxy, ratingPeriodProxy)) continue;
            openForEdit = true;
            break;
        }
        return openForEdit;
    }

    private boolean periodProxyParamsAreEqual(RatingPeriodProxy theFirstPeriodProxy, RatingPeriodProxy theSecondPeriodProxy) {
        return theFirstPeriodProxy.getName().equals(theSecondPeriodProxy.getName()) && theFirstPeriodProxy.getRatingPeriodStartTime().equals(theSecondPeriodProxy.getRatingPeriodStartTime()) && theFirstPeriodProxy.getParentRatingPlanProxy().getName().equals(theSecondPeriodProxy.getParentRatingPlanProxy().getName()) && theFirstPeriodProxy.getServiceProviderName().equals(theSecondPeriodProxy.getServiceProviderName());
    }

    static class RatingPeriodDescription {
        private final String myPeriodName;
        private final String myPlanName;
        private final String myServiceProviderName;
        private final Time myPeriodTime;
        private final String myFileName;
        private final String myServiceId;

        RatingPeriodDescription(RatingPeriodProxy periodProxy, String fileName) {
            this(periodProxy.getName(), periodProxy.getParentRatingPlanProxy(), periodProxy.getRatingPeriodTime(), fileName);
        }

        RatingPeriodDescription(String name, RatingPlanProxy planProxy, Time periodTime, String fileName) {
            this.myPeriodName = name;
            this.myPlanName = planProxy.getName();
            this.myServiceProviderName = planProxy.getServiceProviderProxy().getName();
            this.myServiceId = planProxy.getServiceName();
            this.myPeriodTime = periodTime;
            this.myFileName = fileName;
        }

        String getServiceProviderName() {
            return this.myServiceProviderName;
        }

        String getRatingPlanName() {
            return this.myPlanName;
        }

        String getFileName() {
            return this.myFileName;
        }

        RatingPeriod createFakeRatingPeriod() {
            Calendar ratingPeriodStartTime = null;
            if (this.myPeriodTime != null) {
                ratingPeriodStartTime = DateUtil.parse(this.myPeriodTime.toString());
            }
            return new RatingPeriod(this.myPeriodName, this.myPlanName, this.myServiceId, this.myServiceProviderName, RatingRuleFrame.EMPTY_FILENAME, "rev", ratingPeriodStartTime, Calendar.getInstance());
        }
    }

    private class SimulationExecutionHandler
    implements SimulationExecutionListener {
        private SimulationExecutionHandler() {
        }

        @Override
        public void simulationFailed(SimulationExecutionEvent.SimulationFailedEvent e) {
            Throwable err = e.getError();
            if (err instanceof FatalParsingError) {
                long logNumber = ExceptionUtil.handleException(err, "simulation", 1, "Simulation failed!", false);
                String msg = "Failed to run simulation! See log entry " + logNumber + " for more details.\n\nReason:\n\n" + err.getMessage();
                JOptionPane.showMessageDialog(RatingRuleFrame.this, msg, "Simulation failed", 0);
            } else if (err instanceof SimulationErrorException) {
                DialogFactory.getErrorDialog("RMA Simulation", err.getMessage());
            } else {
                ExceptionUtil.handleException(err, "simulation", 1, "Simulation failed!", true);
            }
        }

        @Override
        public void simulationFinished(SimulationExecutionEvent.SimulationFinishedEvent e) {
            boolean isDisplayingTraceTree;
            boolean bl = isDisplayingTraceTree = RatingRuleFrame.this.myTableAndTraceData.getSelectedIndex() == 2;
            if (!isDisplayingTraceTree || e.getCaseCount() > 1) {
                RatingRuleFrame.this.myTableAndTraceData.setSelectedIndex(1);
            } else {
                RatingRuleFrame.this.myTableAndTraceData.setSelectedIndex(2);
            }
            RatingRuleFrame.this.myTableAndTraceData.getSelectedComponent().validate();
        }

        @Override
        public void simulationStarting(SimulationExecutionEvent.SimulationStartingEvent e) {
            if (!RatingRuleFrame.this.mySelectionTree.isTreeValid()) {
                DialogFactory.getErrorDialog("RMA Simulation", "RMA cannot simulate the case until the Selection Tree is valid!");
                e.cancel();
            } else if (e.getCaseCount() == 0) {
                DialogFactory.getErrorDialog("RMA Simulation error", "At least one simulation case must be selected first.");
                e.cancel();
            }
        }
    }

    private class SimulatorTreeOwnerImpl
    implements SimulatorTreeOwner {
        private SimulatorTreeOwnerImpl() {
        }

        @Override
        public RatingPeriodProxy getRatingPeriodProxy() {
            return RatingRuleFrame.this.getRatingPeriodProxy();
        }

        @Override
        public com.ericsson.ere.selectiontree.interfaces.TariffStructure getCurrentSelectionTree() throws Exception {
            return RatingRuleFrame.this.myTrafficStructureHolder.getSelectionTreeStructure();
        }

        @Override
        public void indicateDebugMode(boolean state) {
            int index = RatingRuleFrame.this.myTreeAndSimData.indexOfTab(RatingRuleFrame.TAG_LBL_TAB_SIM);
            if (state) {
                RatingRuleFrame.this.myTreeAndSimData.setIconAt(index, RmaDefs.getImageIcon("bug_red16.png"));
            } else {
                RatingRuleFrame.this.myTreeAndSimData.setIconAt(index, null);
            }
        }
    }

    private class InternalRatingExecutor
    implements RatingExecutor {
        protected TariffStructure myCurrentStructure;
        private RatingResultEvaluator myRatingDataValidator;

        private InternalRatingExecutor() {
        }

        private void setupRatingDataValidator() {
            ClassRepository classRep = RatingRuleFrame.this.myServiceContainer.getClassRepository();
            XMLInitializable validator = null;
            try {
                validator = classRep.createUtil("Simulator", "ResultEvaluator");
            }
            catch (Exception x) {
                ExceptionUtil.handleException(x, "ratingRuleFrame", 1, "Failed to create Simulator:ResultEvaluator - corrupt config? (Not using a validator)", false);
            }
            if (validator != null && validator instanceof RatingResultEvaluator) {
                this.myRatingDataValidator = (RatingResultEvaluator)((Object)validator);
            }
        }

        @Override
        public boolean execute(RatingData theData, Map expected) throws Exception {
            if (this.myCurrentStructure == null) {
                throw new IllegalArgumentException("Rating structure not set up");
            }
            if (theData == null) {
                throw new IllegalArgumentException("RatingData is null");
            }
            DoubleValue aDouble = new DoubleValue(0.0);
            LongValue aLong = new LongValue();
            this.myCurrentStructure.rate(theData, aDouble, aLong);
            if (expected != null && this.myRatingDataValidator != null) {
                return this.myRatingDataValidator.check(theData, expected, RatingRuleFrame.this.myTraceDestination);
            }
            return true;
        }

        @Override
        public void setSessionName(String name) {
            RatingRuleFrame.this.setSessionName(name);
        }

        @Override
        public void setUp() throws Exception {
            String xmlCode = this.getTariffStructureXml();
            ClassRepository classRep = RatingRuleFrame.this.myServiceContainer.getClassRepository();
            SelectionTreeNodeFactoryImpl nodeFactory = new SelectionTreeNodeFactoryImpl(classRep, RatingRuleFrame.this.myPeriodDescription.getRatingPlanName());
            RatingBuilderErrorHandler errorHandler = new RatingBuilderErrorHandler();
            RatingRuleBuilder tariffBuilder = new RatingRuleBuilder(nodeFactory, (RatingRuleBuilderErrorHandler)errorHandler);
            this.myCurrentStructure = (TariffStructure)tariffBuilder.buildFromString(xmlCode);
            this.setupRatingDataValidator();
            RatingRuleFrame.this.myTableAndTraceData.setSelectedIndex(1);
        }

        @Override
        public void tearDown() throws Exception {
            this.myCurrentStructure = null;
        }

        private String getTariffStructureXml() {
            TSTariffStructure node = RatingRuleFrame.this.mySelectionTree.getTreeRoot();
            StringWriter buf = new StringWriter();
            PrintWriter out = new PrintWriter(buf);
            ((TariffDAGNode)node).print(out, 0, RatingRuleFrame.EMPTY_FILENAME);
            out.flush();
            out.close();
            return buf.toString();
        }
    }

    private class FrameSaveListener
    implements SaveListener {
        private FrameSaveListener() {
        }

        @Override
        public void beforeSave(SaveEvent evt) {
            if (evt.getSaveKind() == SaveEvent.SaveKind.Save && !RatingRuleFrame.this.isSaveAllowed()) {
                evt.veto();
            }
        }

        @Override
        public void hasSaved(SaveEvent evt) {
            if (evt.getSaveKind() == SaveEvent.SaveKind.Save) {
                RatingRuleFrame.this.saveBookmarks(true);
            }
        }
    }

    protected class TabMouseListener
    extends MouseAdapter {
        protected TabMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            Component c;
            if (e.getButton() == 1 && e.getClickCount() == 2 && (c = e.getComponent()) instanceof JTabbedPane) {
                JTabbedPane tab = (JTabbedPane)e.getComponent();
                int index = tab.getSelectedIndex();
                if (tab == RatingRuleFrame.this.myTreeAndSimData) {
                    RatingRuleFrame.this.myTableAndTraceData.setSelectedIndex(index);
                } else if (tab == RatingRuleFrame.this.myTableAndTraceData && index >= 0 && index < RatingRuleFrame.this.myTreeAndSimData.getTabCount()) {
                    RatingRuleFrame.this.myTreeAndSimData.setSelectedIndex(index);
                }
            }
        }
    }

    protected class TabChangeListener
    implements ChangeListener {
        protected TabChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (RatingRuleFrame.this.myTreeAndSimData.getSelectedComponent() == RatingRuleFrame.this.mySimulatorPanel) {
                RatingRuleFrame.this.mySimulatorPanel.focusGained();
                RatingRuleFrame.this.myTrafficStructureHolder.prepareTreeStructure();
            }
        }
    }
}

