/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.gui.ratingrules.bookmarks;

import ericsson.ere.gui.Config;
import ericsson.ere.gui.ratingrules.bookmarks.BookmarkItem;
import ericsson.ere.gui.ratingrules.nodes.DOMUtil;
import ericsson.ere.xml.DomWriter;
import ericsson.ere.xml.XMLUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class BookmarkFileUtil {
    private static final String PATH_ATTR = "path";
    private static final String NAME_ATTR = "name";
    private static final String TREE_ID_ATTR = "treeId";
    private static final String BOOKMARK_COLLECTION_TAG = "BookmarkCollection";
    private static final String BOOKMARK_ITEM_TAG = "BookmarkItem";
    private static final String BOOKMARK_CONFIGURATION_TAG = "BookmarkConfiguration";
    private static final String BOOKMARK_CONFIG_FILE_NAME = Config.getInstance().getUserDir() + File.separatorChar + "BookmarksConfig.xml";

    private BookmarkFileUtil() {
        throw new AssertionError((Object)"Not allowed to instantiate this utility class");
    }

    public static List<BookmarkItem> getBookmarksForTreeFromFile(String treeId) throws Exception {
        return BookmarkFileUtil.getBookmarksForTreeFromFile(treeId, new File(BOOKMARK_CONFIG_FILE_NAME));
    }

    private static List<BookmarkItem> getBookmarksForTreeFromFile(String treeId, File file) throws Exception {
        Element rootElement;
        Element collectionElement;
        ArrayList<BookmarkItem> bookmarkList = new ArrayList<BookmarkItem>();
        Document document = BookmarkFileUtil.readDocumentFromFile(file);
        if (document != null && (collectionElement = (Element)XMLUtil.getElementWithNameAndAttribute(BOOKMARK_COLLECTION_TAG, TREE_ID_ATTR, treeId, (rootElement = document.getDocumentElement()).getChildNodes())) != null) {
            for (Node bookmark : XMLUtil.getElementChildren(collectionElement)) {
                String name = XMLUtil.unEscape(((Element)bookmark).getAttribute(NAME_ATTR));
                String path = XMLUtil.unEscape(((Element)bookmark).getAttribute(PATH_ATTR));
                bookmarkList.add(new BookmarkItem(name, path));
            }
        }
        return bookmarkList;
    }

    public static void saveBookmarksForTreeToFile(String treeId, List<BookmarkItem> bookmarkList) throws ParserConfigurationException, IOException {
        File file = new File(BOOKMARK_CONFIG_FILE_NAME);
        boolean fileIsOk = file.exists();
        if (!fileIsOk && bookmarkList.size() > 0) {
            fileIsOk = file.createNewFile();
        }
        if (fileIsOk) {
            BookmarkFileUtil.saveBookmarksForTreeToFile(treeId, bookmarkList, file);
        } else {
            Logger.getLogger("rma.ratingRuleFrame").warning("Unable to create BookmarksConfig.xml. The bookmarks for the selection tree will not be saved.");
        }
    }

    private static void saveBookmarksForTreeToFile(String treeId, List<BookmarkItem> bookmarkList, File file) throws ParserConfigurationException, IOException {
        Element root;
        boolean hasNewBookmarks = bookmarkList.size() > 0;
        Document document = null;
        document = BookmarkFileUtil.readDocumentFromFile(file);
        if (document != null) {
            root = document.getDocumentElement();
        } else {
            Logger.getLogger("rma.ratingRuleFrame").warning("Existing bookmarks configuration cannot be read and will be replaced by new configuration.");
            document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            root = BookmarkFileUtil.createRootElement(document);
        }
        Element existingBookmarkCollectionElement = BookmarkFileUtil.extractCollectionFromRoot(root, treeId);
        if (existingBookmarkCollectionElement != null) {
            root.removeChild(existingBookmarkCollectionElement);
        }
        if (hasNewBookmarks) {
            Element newBookmarkCollectionElement = BookmarkFileUtil.createBookmarkCollectionElement(bookmarkList, document, treeId);
            DOMUtil.adoptNode(document, newBookmarkCollectionElement);
            root.appendChild(newBookmarkCollectionElement);
        }
        BookmarkFileUtil.writeElementToFile(root, file);
    }

    private static Document readDocumentFromFile(File file) throws ParserConfigurationException, IOException {
        if (file.length() > 0L) {
            try {
                return XMLUtil.buildDocumentFromFile(file);
            }
            catch (SAXException ex) {
                Logger.getLogger("rma.ratingRuleFrame").warning("Failed to extract configuration from bookmarks file.");
            }
        }
        return null;
    }

    private static Element extractCollectionFromRoot(Element root, String treeId) {
        return (Element)XMLUtil.getElementWithNameAndAttribute(BOOKMARK_COLLECTION_TAG, TREE_ID_ATTR, treeId, root.getChildNodes());
    }

    private static Element createRootElement(Document document) {
        Element root = document.createElement(BOOKMARK_CONFIGURATION_TAG);
        DOMUtil.adoptNode(document, root);
        document.appendChild(root);
        return root;
    }

    private static Element createBookmarkCollectionElement(List<BookmarkItem> bookmarkList, Document document, String treeId) {
        Element newBookmarkCollectionElement = document.createElement(BOOKMARK_COLLECTION_TAG);
        newBookmarkCollectionElement.setAttribute(TREE_ID_ATTR, treeId);
        for (BookmarkItem currentItem : bookmarkList) {
            Element newBookmarkItemElement = document.createElement(BOOKMARK_ITEM_TAG);
            newBookmarkItemElement.setAttribute(NAME_ATTR, XMLUtil.escape(currentItem.getName()));
            newBookmarkItemElement.setAttribute(PATH_ATTR, XMLUtil.escape(currentItem.getPathString()));
            DOMUtil.adoptNode(document, newBookmarkItemElement);
            newBookmarkCollectionElement.appendChild(newBookmarkItemElement);
        }
        return newBookmarkCollectionElement;
    }

    private static void writeElementToFile(Element rootElement, File file) throws FileNotFoundException {
        try (PrintWriter writer = new PrintWriter(file);){
            writer.write(DomWriter.elementToStringIndent(rootElement));
        }
    }
}

