/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.gui.ratingrules.bookmarks;

import ericsson.ere.gui.ratingrules.bookmarks.BookmarkItem;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class BookmarkTableCellRenderer
extends DefaultTableCellRenderer {
    private static final int TOOL_TIP_LENGTH = 80;

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean cellHasFocus, int row, int column) {
        JLabel theRenderer = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, cellHasFocus, row, column);
        BookmarkItem bookmark = (BookmarkItem)value;
        theRenderer.setToolTipText(this.createToolTipString(bookmark.getPathString()));
        String additionalText = "";
        Color textColor = Color.BLACK;
        if (!bookmark.isValid()) {
            additionalText = " (invalid)";
            textColor = Color.RED;
        }
        theRenderer.setText(" " + bookmark.toString() + additionalText);
        theRenderer.setForeground(textColor);
        return theRenderer;
    }

    private String createToolTipString(String path) {
        String string = new String("<HTML>");
        if (path.length() > 80) {
            String[] subStrings = path.split("/");
            int nextNewLine = 86;
            int numberOfBreaks = 0;
            for (int i = 0; i < subStrings.length; ++i) {
                if (string.length() + subStrings[i].length() > nextNewLine) {
                    string = string + "<BR>";
                    ++numberOfBreaks;
                    nextNewLine = string.length() + 80;
                }
                string = string + subStrings[i] + "/";
            }
            if (string.endsWith("/")) {
                string = string.substring(0, string.length() - 1);
            }
        } else {
            string = string + path;
        }
        return string + "</HTML>";
    }
}

