/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.gui.ratingrules.bookmarks;

import ericsson.ere.defs.RmaDefs;
import ericsson.ere.gui.GuiServiceCenter;
import ericsson.ere.gui.util.DialogFactory;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;

public class DeleteBookmarkAction
extends AbstractAction {
    private JTable myTable = null;
    private boolean myShowMessage = true;

    public DeleteBookmarkAction(JTable table) {
        super("Delete bookmark");
        this.myTable = table;
        ImageIcon icon = RmaDefs.getImageIcon("bookmark_delete.png");
        this.putValue("SmallIcon", icon);
        this.putValue("ShortDescription", "Delete selected bookmark");
    }

    public DeleteBookmarkAction(JTable table, boolean showMessage) {
        this(table);
        this.myShowMessage = showMessage;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int selectedRow = this.myTable.getSelectedRow();
        if (selectedRow > -1) {
            boolean performDelete = true;
            if (this.myShowMessage) {
                performDelete = DialogFactory.getQuestionDialog(GuiServiceCenter.getInstance().getMainWindow(), "Delete bookmark", "Do you really want to delete the selected bookmark(s)? This cannot be undone.");
            }
            if (performDelete) {
                while (selectedRow != -1) {
                    ((DefaultTableModel)this.myTable.getModel()).removeRow(selectedRow);
                    selectedRow = this.myTable.getSelectedRow();
                }
            }
        }
    }
}

