/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.gui.ratingrules.nodes;

import ericsson.ere.gui.ratingrules.nodes.BooleanTest;
import ericsson.ere.gui.ratingrules.nodes.FinderResult;
import ericsson.ere.gui.ratingrules.nodes.NodeIdMatch;
import ericsson.ere.gui.ratingrules.nodes.NodePredicate;
import ericsson.ere.gui.ratingrules.nodes.ParameterPredicate;
import ericsson.ere.gui.ratingrules.nodes.TariffDAGNode;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;

public final class Finder {
    private Finder() {
    }

    public static List<FinderResult> findMatchingNodes(TariffDAGNode root, NodePredicate p, boolean followLinks, String path, List<FinderResult> res) {
        LinkedList<String> pathList = new LinkedList<String>();
        pathList.add(path);
        return Finder.findInternal(root, p, followLinks, pathList, res);
    }

    private static List<FinderResult> findInternal(TariffDAGNode node, NodePredicate p, boolean followLinks, List<String> pathList, List<FinderResult> res) {
        int len;
        String id = node.getNodeId();
        if (p.test(node)) {
            res.add(Finder.resultFromPathAndNode(pathList, node));
        }
        if ((len = node.getChildCount()) > 0) {
            pathList.add(id);
            if (!node.isLink() || followLinks) {
                for (int i = 0; i < len; ++i) {
                    TariffDAGNode child = (TariffDAGNode)node.getChildAt(i);
                    Finder.findInternal(child, p, followLinks, pathList, res);
                }
            }
            pathList.remove(pathList.size() - 1);
        }
        return res;
    }

    private static FinderResult resultFromPathAndNode(List<String> pathList, TariffDAGNode node) {
        StringBuffer buf = new StringBuffer(200);
        for (String path : pathList) {
            buf.append(path).append('/');
        }
        buf.append(node.getNodeId());
        return new FinderResult(buf.toString(), node);
    }

    @Deprecated
    public static NodePredicate createSearchStringPredicate(String searchString) {
        return new NameIDMatchPredicateCreator().createPredicate(searchString);
    }

    public static NodePredicate createQuickSearchStringPredicate(String searchString) {
        return new ParameterPredicateCreator().createPredicate(searchString);
    }

    public static NodePredicate createComplexPredicate(List<NodePredicate> predicates, boolean matchAll) {
        String op = matchAll ? "AND" : "OR";
        BooleanTest testResult = new BooleanTest(op, predicates);
        return testResult;
    }

    private static class ParameterPredicateCreator
    extends PredicateCreator {
        private ParameterPredicateCreator() {
        }

        @Override
        protected NodePredicate createSpecificPredicate(String searchString) {
            return new ParameterPredicate("", 4, searchString);
        }
    }

    private static class NameIDMatchPredicateCreator
    extends PredicateCreator {
        private NameIDMatchPredicateCreator() {
        }

        @Override
        protected NodePredicate createSpecificPredicate(String searchString) {
            return new NodeIdMatch(searchString, 1, false);
        }
    }

    private static abstract class PredicateCreator {
        private PredicateCreator() {
        }

        NodePredicate createPredicate(String searchString) {
            ArrayList<NodePredicate> predicates = new ArrayList<NodePredicate>();
            boolean matchAll = true;
            StringTokenizer tokens = new StringTokenizer(searchString);
            while (tokens.hasMoreTokens()) {
                String token = tokens.nextToken();
                if ("OR".equals(token)) {
                    matchAll = false;
                    continue;
                }
                NodePredicate p = this.createSpecificPredicate(token);
                predicates.add(p);
            }
            if (predicates.isEmpty()) {
                predicates.add(new NodePredicate(){

                    @Override
                    public boolean test(TariffDAGNode node) {
                        return false;
                    }
                });
            }
            return Finder.createComplexPredicate(predicates, matchAll);
        }

        abstract NodePredicate createSpecificPredicate(String var1);
    }
}

