/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.gui.ratingrules.nodes;

import ericsson.ere.gui.ratingrules.nodes.NodePredicate;
import ericsson.ere.gui.ratingrules.nodes.TariffDAGNode;
import ericsson.ere.util.StringUtil;

public class NodeIdMatch
implements NodePredicate {
    static final long serialVersionUID = 1L;
    public static final String[] OPERATORS = new String[]{"equals", "contains", "starts with", "ends with"};
    public static final int EQUALS = 0;
    public static final int CONTAINS = 1;
    public static final int STARTS_WITH = 2;
    public static final int ENDS_WITH = 3;
    private final String myMatch;
    private final int myOperator;
    private final boolean myIsCaseSensitive;

    public NodeIdMatch(String match, int operation, boolean matchCase) {
        this.myMatch = match;
        this.myOperator = operation;
        this.myIsCaseSensitive = matchCase;
    }

    @Override
    public boolean test(TariffDAGNode node) {
        String name;
        boolean rc = this.evaluate(node.getNodeId());
        if (!rc && (name = node.getNodeName()) != null) {
            rc = this.evaluate(name);
        }
        return rc;
    }

    private boolean evaluate(String str) {
        boolean ignoreCase = !this.myIsCaseSensitive;
        boolean rc = false;
        if (!StringUtil.isEmptyString(this.myMatch)) {
            switch (this.myOperator) {
                case 0: {
                    if (this.myIsCaseSensitive) {
                        rc = str.equals(this.myMatch);
                        break;
                    }
                    rc = str.equalsIgnoreCase(this.myMatch);
                    break;
                }
                case 1: {
                    if (this.myIsCaseSensitive) {
                        rc = str.indexOf(this.myMatch) >= 0;
                        break;
                    }
                    int len = str.length();
                    for (int i = 0; i < len && !(rc = str.regionMatches(true, i, this.myMatch, 0, this.myMatch.length())); ++i) {
                    }
                    break;
                }
                case 2: {
                    rc = str.regionMatches(ignoreCase, 0, this.myMatch, 0, this.myMatch.length());
                    break;
                }
                case 3: {
                    int startIndex = str.length() - this.myMatch.length();
                    rc = str.regionMatches(ignoreCase, startIndex, this.myMatch, 0, this.myMatch.length());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown operation in NodeIdMatch: " + this.myOperator);
                }
            }
        }
        return rc;
    }

    public String getNameOrId() {
        return this.myMatch;
    }

    public int getOperator() {
        return this.myOperator;
    }

    public boolean isCaseSensitive() {
        return this.myIsCaseSensitive;
    }
}

