/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.gui.ratingrules.nodes;

import ericsson.ere.gui.ratingrules.nodes.NodePredicate;
import ericsson.ere.gui.ratingrules.nodes.TariffDAGNode;

public class RefCountPredicate
implements NodePredicate {
    static final long serialVersionUID = 1L;
    public static final String[] OPERATORS = new String[]{"=", "!=", ">", "<"};
    public static final int EQUALS = 0;
    public static final int NOT_EQUALS = 1;
    public static final int GREATER_THAN = 2;
    public static final int LESS_THAN = 3;
    private final int myMatch;
    private final int myOperator;

    public RefCountPredicate(int match, int operation) {
        this.myMatch = match;
        this.myOperator = operation;
    }

    @Override
    public boolean test(TariffDAGNode node) {
        boolean rc;
        int refCount = node.getRefererCount();
        switch (this.myOperator) {
            case 0: {
                rc = refCount == this.myMatch;
                break;
            }
            case 1: {
                rc = refCount != this.myMatch;
                break;
            }
            case 2: {
                rc = refCount > this.myMatch;
                break;
            }
            case 3: {
                rc = refCount < this.myMatch;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown operation in RefCount: " + this.myOperator);
            }
        }
        return rc;
    }

    public int getReferenceCount() {
        return this.myMatch;
    }

    public int getOperator() {
        return this.myOperator;
    }
}

