/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.gui.ratingrules.nodes;

import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.PluginName;
import ericsson.ere.defs.RmaDefs;
import ericsson.ere.gui.ratingrules.nodes.TSElement;
import ericsson.ere.gui.ratingrules.nodes.TariffDAGNode;
import ericsson.ere.interfaces.ConditionProfile;
import ericsson.ere.interfaces.TariffStructureVisitor;
import ericsson.vareditor.variable.DropDownVariable;
import ericsson.vareditor.variable.Variable;
import org.w3c.dom.Node;

public class TSCondition
extends TSElement {
    private static final boolean USE_COMMENT = RmaDefs.getInstance().useCommentCondition();

    public TSCondition(ClassRepository rep) {
        super(rep);
    }

    @Override
    protected void initForNewElement(String name, String type) throws Exception {
        this.commonInit(name);
    }

    @Override
    protected void initForLoadedElement(Node iterator, boolean fullInit) throws Exception {
        String name = this.getName();
        this.setTypename(name);
        this.commonInit(name);
    }

    private void commonInit(String name) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        this.setAlias(this.myClassRep.getAliasForCondition(name));
        this.createProfile(name, this.myClassRep.getConditionProfileClassName(name));
    }

    @Override
    protected boolean shouldUseCommentParameter() {
        return USE_COMMENT;
    }

    @Override
    protected Variable createNameVariable(Node iterator, String name) {
        DropDownVariable nameVar = new DropDownVariable("Name", PluginName.aliasToArray(this.myClassRep.getDefinedConditionList()), PluginName.nameToArray(this.myClassRep.getDefinedConditionList()), (Object)name);
        return nameVar;
    }

    @Override
    public int getNodeType() {
        return 2;
    }

    public ConditionProfile getConditionProfile() {
        return (ConditionProfile)this.getClassProfile();
    }

    @Override
    public void startVisit(TariffStructureVisitor v) throws Exception {
        v.enterCondition(this);
    }

    @Override
    public void endVisit(TariffStructureVisitor v) throws Exception {
        v.leaveCondition(this);
    }

    @Override
    protected boolean isTypeChangingReference(String ref) {
        return "Name".equals(ref);
    }

    @Override
    protected boolean defaultAllowsAddCondition(TariffDAGNode treeNode) {
        return false;
    }

    @Override
    protected boolean defaultAllowsAddLink(TariffDAGNode treeNode) {
        return false;
    }

    @Override
    protected boolean defaultAllowsAddModifier(TariffDAGNode treeNode) {
        return false;
    }

    @Override
    protected boolean defaultAllowsAddNode(TariffDAGNode treeNode) {
        return false;
    }
}

