/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.gui.ratingrules.nodes;

import com.ericsson.ere.util.HTMLUtil;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.RmaDefs;
import ericsson.ere.gui.ratingrules.nodes.TSElement;
import ericsson.ere.gui.ratingrules.nodes.TariffDAGNode;
import ericsson.ere.interfaces.TariffNodeLink;
import ericsson.ere.interfaces.TariffStructureNode;
import ericsson.ere.interfaces.TariffStructureVisitor;
import ericsson.ere.xml.XMLUtil;
import ericsson.vareditor.variable.BoolVariable;
import ericsson.vareditor.variable.StringVariable;
import ericsson.vareditor.variable.VarListUtil;
import ericsson.vareditor.variable.Variable;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TSLink
extends TSElement
implements TariffNodeLink {
    private int myType;
    private boolean myIsLocked = true;
    private static final boolean USE_COMMENT;
    private String myTarget;
    private String myComment;
    private String myId;
    private static final Map<String, Integer> myTariffStructureNodeTypes;

    public TSLink(ClassRepository rep) {
        super(rep);
    }

    @Override
    protected void initForNewElement(String name, String type) throws Exception {
        this.myType = -1;
        Integer t = myTariffStructureNodeTypes.get(type);
        if (t != null) {
            this.myType = t;
        }
    }

    @Override
    protected String extractNameFromXml(Node node) {
        return XMLUtil.getAttributeFromElement((Element)node, "target", "");
    }

    @Override
    protected void initForLoadedElement(Node node, boolean fullInit) throws Exception {
        this.myIsLocked = Boolean.valueOf(XMLUtil.getAttributeFromElement((Element)node, "locked", "true"));
        String name = node.getNodeName();
        Integer type = myTariffStructureNodeTypes.get(name);
        if (type == null) {
            throw new IllegalArgumentException("Unknown link type: " + name);
        }
        this.myType = type;
    }

    @Override
    protected boolean usesProfile() {
        return false;
    }

    @Override
    public String getLinkPath() {
        return this.getName();
    }

    @Override
    public void setTarget(TariffStructureNode n) throws Exception {
        if (this.getChildCount() > 0) {
            if (n != this.getChildAt(0)) {
                throw new IllegalArgumentException("Link already contains child");
            }
        } else {
            this.addLink(n);
        }
    }

    @Override
    public void startVisit(TariffStructureVisitor v) throws Exception {
        switch (this.getNodeType()) {
            case 0: {
                v.enterTariffStructure(this);
                break;
            }
            case 1: {
                v.enterNode(this);
                break;
            }
            case 2: {
                v.enterCondition(this);
                break;
            }
            case 3: {
                v.enterModifier(this);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown link type: " + this.getNodeType()));
            }
        }
    }

    @Override
    public void endVisit(TariffStructureVisitor v) throws Exception {
        switch (this.getNodeType()) {
            case 0: {
                v.leaveTariffStructure(this);
                break;
            }
            case 1: {
                v.leaveNode(this);
                break;
            }
            case 2: {
                v.leaveCondition(this);
                break;
            }
            case 3: {
                v.leaveModifier(this);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown link type: " + this.getNodeType()));
            }
        }
    }

    public StringBuffer getPathToRoot(TariffStructureNode n, StringBuffer buf) {
        TariffStructureNode p = (TariffStructureNode)n.getParent();
        if (p != null) {
            buf.insert(0, n.getNodeId());
            buf.insert(0, '/');
            return this.getPathToRoot(p, buf);
        }
        return buf;
    }

    public String getPathToRoot(TariffStructureNode n) {
        return this.getPathToRoot(n, new StringBuffer()).toString();
    }

    @Override
    protected void noProfilePrint(PrintWriter out, int indentLevel, String indentMarker) {
        String tag;
        String id = this.getId().trim();
        String comment = this.getComment();
        String target = this.getTarget();
        for (int i = 0; i < indentLevel; ++i) {
            out.print(indentMarker);
        }
        switch (this.myType) {
            case 0: {
                tag = "TariffStructure";
                break;
            }
            case 1: {
                tag = "Node";
                break;
            }
            case 2: {
                tag = "Condition";
                break;
            }
            case 3: {
                tag = "Tariff";
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown link type: " + this.myType));
            }
        }
        out.print("<");
        out.print(tag);
        if (!"".equals(id)) {
            out.print(" id=\"" + XMLUtil.escape(id) + "\"");
        }
        out.print(" type=\"link\" target=\"" + XMLUtil.escape(target) + "\"");
        out.print(" locked=\"" + XMLUtil.escape(Boolean.toString(this.isLocked())) + "\"");
        out.print(">");
        if (USE_COMMENT && comment != null && comment.length() > 0) {
            out.println();
            for (int i = 0; i < indentLevel; ++i) {
                out.print(indentMarker);
            }
            out.println("<Comment>" + XMLUtil.escape(comment) + "</Comment>");
        }
        out.print("</");
        out.print(tag);
        out.println(">");
    }

    @Override
    public String getDescription() {
        return this.getName();
    }

    @Override
    public String getAdditionalInfo() {
        String info = "<html><b>" + this.getName() + "</b>";
        String id = this.getId().trim();
        if (!"".equals(id)) {
            info = info + " [" + HTMLUtil.escape(id) + "]";
        }
        if (this.isLocked()) {
            info = info + " (Locked)";
        }
        info = info + "</html>";
        return info;
    }

    @Override
    protected List<Variable> getBaseVariables(Node iterator, List<Variable> oldStateVariables) {
        List<Variable> vars = super.getBaseVariables(iterator, oldStateVariables);
        BoolVariable lockedVar = new BoolVariable("Locked", this.isLocked());
        vars.add(lockedVar);
        return vars;
    }

    @Override
    protected Variable createNameVariable(Node node, String name) {
        StringVariable nameVar = new StringVariable("Target", name);
        ((Variable)nameVar).setAllowEdit(false);
        return nameVar;
    }

    @Override
    public String getTypename() {
        if (this.getChildCount() == 0) {
            return "";
        }
        return ((TariffDAGNode)this.getChildAt(0)).getTypename();
    }

    @Override
    public boolean isLocked() {
        if (this.state().hasVariables()) {
            return (Boolean)VarListUtil.getValueForName(this.state().stateVariables(), "Locked");
        }
        return this.myIsLocked;
    }

    public String getTarget() {
        return this.getName();
    }

    @Override
    public int getNodeType() {
        return this.myType;
    }

    @Override
    public String getNodeId() {
        String id = this.getId().trim();
        if ("".equals(id)) {
            id = this.getTarget();
        }
        id = id.replace('/', '\\');
        return id;
    }

    public void setNodeId(String newId) {
        this.setId(newId);
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public boolean isLink() {
        return true;
    }

    public static String checkDuplicatesInPath(Object[] path, int i, int[] foundIndex) {
        return TSLink.checkDuplicatesInPath(path, i, foundIndex, new HashSet<TariffStructureNode>());
    }

    public static String checkDuplicatesInPath(Object[] path, int i, int[] foundIndex, Set<TariffStructureNode> processedNodes) {
        if (i >= path.length) {
            return null;
        }
        if (i == path.length - 1) {
            return null;
        }
        TariffStructureNode node = (TariffStructureNode)path[i];
        TariffStructureNode child = (TariffStructureNode)path[i + 1];
        String searchedId = child.getNodeId();
        int len = node.getChildCount();
        if (!processedNodes.contains(child)) {
            for (int j = 0; j < len; ++j) {
                TariffStructureNode c = (TariffStructureNode)node.getChildAt(j);
                if (!searchedId.equals(c.getNodeId()) || c == child) continue;
                foundIndex[0] = i;
                return searchedId;
            }
            processedNodes.add(child);
        }
        return TSLink.checkDuplicatesInPath(path, i + 1, foundIndex, processedNodes);
    }

    public static String convertPathToXMLLink(Object[] selectionPath) {
        StringBuffer out = new StringBuffer();
        StringBuffer buf = new StringBuffer();
        int[] foundIndex = new int[1];
        String dupl = TSLink.checkDuplicatesInPath(selectionPath, 0, foundIndex);
        if (dupl != null) {
            throw new IllegalArgumentException("Duplicate ID (" + dupl + ") found at node " + selectionPath[foundIndex[0]]);
        }
        buf.append("/");
        int len = selectionPath.length;
        for (int i = 1; i < len; ++i) {
            TariffStructureNode node = (TariffStructureNode)selectionPath[i];
            buf.append(XMLUtil.escape(node.getNodeId()));
            if (i == len - 1) continue;
            buf.append("/");
        }
        TariffStructureNode lastNode = (TariffStructureNode)selectionPath[len - 1];
        String tag = "NULL";
        int type = lastNode.getNodeType();
        switch (type) {
            case 0: {
                tag = "TariffStructure";
                break;
            }
            case 1: {
                tag = "Node";
                break;
            }
            case 2: {
                tag = "Condition";
                break;
            }
            case 3: {
                tag = "Tariff";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown link type: " + type);
            }
        }
        out.append("<");
        out.append(tag);
        out.append(" id=\"");
        out.append("");
        out.append("\" type=\"link\" target=\"");
        out.append(buf.toString());
        out.append("\">");
        out.append("</");
        out.append(tag);
        out.append(">");
        return out.toString();
    }

    public void setParameters(String reference, Object value) {
        this.setModified();
        String str = String.valueOf(value);
        boolean isInitialized = this.state().hasVariables();
        if ("Target".equalsIgnoreCase(reference)) {
            if (isInitialized) {
                this.setName(str);
            } else {
                this.myTarget = str;
            }
        } else if ("Id".equalsIgnoreCase(reference)) {
            if (isInitialized) {
                this.setId(str);
            } else {
                this.myId = str;
            }
        } else if ("Comment".equalsIgnoreCase(reference)) {
            if (isInitialized) {
                this.setComment(str);
            } else {
                this.myComment = str;
            }
        } else if ("Locked".equalsIgnoreCase(reference)) {
            this.setLocked((Boolean)value);
        }
        if (!isInitialized) {
            this.triggerTreeUpdate(false);
        }
    }

    protected void setLocked(boolean locked) {
        if (this.state().hasVariables()) {
            List<Variable> vars = this.getOrCreateStateVariables();
            Variable var = VarListUtil.getVariableForKey(vars, "Locked");
            assert (var != null);
            var.setValue(locked);
        } else {
            this.myIsLocked = locked;
        }
        this.setModified();
    }

    @Override
    protected boolean internalIsNodeValid(boolean invokedByParent) {
        boolean valid;
        boolean bl = valid = this.checkChildrenValidity() && this.getChildCount() == 1;
        if (!invokedByParent) {
            this.notifyParentAndReferersAboutValidStatusChange(valid);
        }
        return valid;
    }

    @Override
    protected boolean isTypeChangingReference(String ref) {
        return false;
    }

    @Override
    protected boolean shouldUseCommentParameter() {
        return USE_COMMENT;
    }

    @Override
    public String getComment() {
        if (this.state().hasVariables() || this.myComment == null) {
            return super.getComment();
        }
        return this.myComment;
    }

    @Override
    protected String getId() {
        if (this.state().hasVariables() || this.myId == null) {
            return super.getId();
        }
        return this.myId;
    }

    @Override
    protected String getName() {
        if (this.state().hasVariables() || this.myTarget == null) {
            return super.getName();
        }
        return this.myTarget;
    }

    @Override
    protected boolean needUninitializedStateReconstruction() {
        return this.isModified();
    }

    @Override
    protected boolean reconstructUninitializedState(boolean force) {
        boolean b = super.reconstructUninitializedState(force);
        if (b || force) {
            this.myTarget = null;
            this.myComment = null;
            this.myId = null;
            this.clearTemporaryVariableList();
        }
        return b;
    }

    @Override
    protected void childChangedValidStatus(TSElement child, Boolean valid) {
        if (valid != null) {
            this.myChildValidCache.put(child, valid);
        } else {
            this.myChildValidCache.remove(child);
        }
        this.notifyParentAndReferersAboutValidStatusChange(valid);
    }

    @Override
    protected boolean defaultAllowsAddCondition(TariffDAGNode treeNode) {
        return false;
    }

    @Override
    protected boolean defaultAllowsAddLink(TariffDAGNode treeNode) {
        return false;
    }

    @Override
    protected boolean defaultAllowsAddModifier(TariffDAGNode treeNode) {
        return false;
    }

    @Override
    protected boolean defaultAllowsAddNode(TariffDAGNode treeNode) {
        return false;
    }

    static {
        myTariffStructureNodeTypes = new HashMap<String, Integer>();
        myTariffStructureNodeTypes.put("Condition", 2);
        myTariffStructureNodeTypes.put("TariffStructure", 0);
        myTariffStructureNodeTypes.put("Node", 1);
        myTariffStructureNodeTypes.put("Tariff", 3);
        myTariffStructureNodeTypes.put("Modifier", 3);
        myTariffStructureNodeTypes.put("Action", 3);
        USE_COMMENT = RmaDefs.getInstance().useCommentNode();
    }
}

