/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.gui.ratingrules.nodes;

import com.ericsson.ere.gui.util.Version;
import com.ericsson.vareditor.document.LimitLeadingAndTrailingSpacesStringDocument;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.RmaDefs;
import ericsson.ere.gui.ratingrules.nodes.TDFChangeEvent;
import ericsson.ere.gui.ratingrules.nodes.TSElement;
import ericsson.ere.gui.ratingrules.nodes.TariffDAGNode;
import ericsson.ere.interfaces.ClassProfile;
import ericsson.ere.interfaces.TariffStructureVisitor;
import ericsson.ere.interfaces.XMLInitializable;
import ericsson.ere.ratingrules.RatingRuleBuilder;
import ericsson.ere.structure.AbstractTariffStructureProfile;
import ericsson.ere.xml.XMLUtil;
import ericsson.vareditor.variable.LongVariable;
import ericsson.vareditor.variable.StringVariable;
import ericsson.vareditor.variable.VarListUtil;
import ericsson.vareditor.variable.Variable;
import ericsson.vareditor.variable.treedefinedfields.TreeDefinedFieldSupport;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.tree.DefaultTreeModel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TSTariffStructure
extends TSElement
implements Version.VersionUpdateListener {
    private static final String LBL_SERVICE_ID = "Service Id";
    private static final String LBL_SERVICE = "Service";
    private static final boolean USE_COMMENT = RmaDefs.getInstance().useCommentNode();
    private String myRatingPlan = null;
    private Version myVersion;
    private List<TSElement> myTDFUsersList;

    @Deprecated
    public TSTariffStructure(DefaultTreeModel m, ClassRepository rep) {
        super(rep);
    }

    public TSTariffStructure(ClassRepository rep) {
        super(rep);
    }

    @Override
    public void init(String name) throws Exception {
        this.init(name, "TariffStructure");
    }

    @Override
    protected String extractNameFromXml(Node node) {
        return XMLUtil.getAttributeFromElement((Element)node, "Name", "");
    }

    @Override
    protected void initForNewElement(String name, String type) throws Exception {
        this.myVersion = new Version(this);
        String profileClass = this.myClassRep.getTariffStructureProfileClassName(type);
        this.createProfile(type, profileClass);
    }

    @Override
    protected void initForLoadedElement(Node iterator, boolean fullInit) throws Exception {
        String type = XMLUtil.getAttributeFromElement((Element)iterator, "type", "TariffStructure");
        this.setTypename(type);
        Element versionElement = XMLUtil.getNamedElement("Version", iterator.getChildNodes());
        this.myVersion = versionElement != null ? new Version(versionElement, this) : new Version(this);
        String profileClass = this.myClassRep.getTariffStructureProfileClassName(type);
        this.createProfile(type, profileClass);
        this.applyTreeDefinedFields();
    }

    public void applyTreeDefinedFields() {
        ClassProfile prof = this.getClassProfile();
        if (prof instanceof TreeDefinedFieldSupport) {
            this.myClassRep.removeAllTreeDefinedFields();
            if (!this.state().isConfiguredByXML()) {
                this.syncDOMStructure(true);
            }
            ((TreeDefinedFieldSupport)((Object)prof)).updateClassRepository(this.state().getXMLConfig());
        }
    }

    @Override
    protected List<Variable> getBaseVariables(Node iterator, List<Variable> oldStateVariables) {
        List<Variable> vars;
        ClassProfile prof = this.getClassProfile();
        if (prof instanceof AbstractTariffStructureProfile) {
            AbstractTariffStructureProfile atsProf = (AbstractTariffStructureProfile)prof;
            vars = new ArrayList<Variable>(20);
            if (iterator != null) {
                vars.addAll(atsProf.getBaseVariables(iterator, this.myClassRep));
            } else {
                List<Variable> baseVars = atsProf.getBaseVariables(oldStateVariables, this.myClassRep);
                Variable v = VarListUtil.getVariableForName(baseVars, "Name");
                v.setValue(this.getName());
                vars.addAll(baseVars);
            }
        } else {
            vars = super.getBaseVariables(iterator, oldStateVariables);
        }
        LongVariable versionVar = new LongVariable("Version", this.myVersion.getVersion());
        ((Variable)versionVar).setKey("Version");
        ((Variable)versionVar).setAllowEdit(false);
        vars.add(versionVar);
        return vars;
    }

    @Override
    protected String getDefaultId() {
        return "root";
    }

    @Override
    protected Variable createNameVariable(Node iterator, String name) {
        StringVariable nameVar = new StringVariable("Name", name, new LimitLeadingAndTrailingSpacesStringDocument(true));
        ((Variable)nameVar).setAllowEdit(false);
        return nameVar;
    }

    public String getServiceId() {
        List<Variable> vars = this.getOrCreateStateVariables();
        String serviceId = VarListUtil.getValueStringForName(vars, LBL_SERVICE);
        if (serviceId == null) {
            serviceId = VarListUtil.getValueStringForName(vars, LBL_SERVICE_ID);
        }
        return serviceId;
    }

    public void setServiceId(String serviceId) {
        List<Variable> vars = this.getOrCreateStateVariables();
        Variable serviceVar = VarListUtil.getVariableForName(vars, LBL_SERVICE);
        if (serviceVar == null) {
            serviceVar = new StringVariable(LBL_SERVICE, serviceId);
            serviceVar.setAllowEdit(false);
            vars.add(serviceVar);
        }
        serviceVar.setValue(serviceId);
        Variable serviceIdVar = VarListUtil.getVariableForName(vars, LBL_SERVICE_ID);
        if (serviceIdVar != null) {
            serviceIdVar.setValue(serviceId);
        }
    }

    @Deprecated
    public String getName(List<Variable> vars) {
        return VarListUtil.getValueStringForName(vars, "Name");
    }

    @Deprecated
    public String getComment(List<Variable> vars) {
        return XMLUtil.unEscape(VarListUtil.getValueStringForName(vars, "Comment"));
    }

    public String getCreatedDate() {
        List<Variable> vars = this.getOrCreateStateVariables();
        return VarListUtil.getTimeValueForName(vars, "Created").toString();
    }

    public String getSavedDate() {
        List<Variable> vars = this.getOrCreateStateVariables();
        return VarListUtil.getTimeValueForName(vars, "Saved").toString();
    }

    @Override
    protected void printCustom(PrintWriter out, int indentLevel, String indentMarker) {
        this.myVersion.print(out, indentLevel, indentMarker);
    }

    @Override
    public int getNodeType() {
        return 0;
    }

    @Override
    public void startVisit(TariffStructureVisitor v) throws Exception {
        v.enterTariffStructure(this);
    }

    @Override
    public void endVisit(TariffStructureVisitor v) throws Exception {
        v.leaveTariffStructure(this);
    }

    @Override
    public String getTypename() {
        return this.state().type;
    }

    public void setRatingPlan(String ratingPlanNode) {
        this.myRatingPlan = ratingPlanNode;
    }

    public String getRatingPlan() {
        return this.myRatingPlan;
    }

    public Version getVersion() {
        return this.myVersion;
    }

    @Deprecated
    public ClassProfile getProfile() {
        return this.getClassProfile();
    }

    public void setVersion(Version version) {
        this.myVersion.set(version);
    }

    public void updateLastModifiedDate() {
        this.myVersion.updateLastModifiedDate();
    }

    @Override
    public void versionUpdated() throws Exception {
        this.setModified();
        if (this.state().shouldUseVariables()) {
            Variable versionVar = VarListUtil.getVariableForName(this.getOrCreateStateVariables(), "Version");
            if (versionVar != null) {
                versionVar.setValue(this.myVersion.getVersion());
            }
        } else {
            Node node = this.state().getXMLConfig();
            assert (node != null) : "Unexpected - initData is null!";
            Element versionElement = XMLUtil.getNamedElement("Version", node.getChildNodes());
            if (versionElement != null) {
                Node newVersion = XMLUtil.buildDocumentFromString(this.myVersion.getXml()).getDocumentElement();
                newVersion = node.getOwnerDocument().importNode(newVersion, false);
                node.replaceChild(newVersion, versionElement);
            }
            this.clearTemporaryVariableList();
        }
    }

    public boolean supportsTreeDefinedFields() {
        return this.getClassProfile() instanceof TreeDefinedFieldSupport;
    }

    @Override
    protected boolean isTypeChangingReference(String ref) {
        return false;
    }

    @Override
    protected boolean shouldUseCommentParameter() {
        return USE_COMMENT;
    }

    @Override
    public void notifyTDFChange(TDFChangeEvent event) {
        if (this.myTDFUsersList != null) {
            for (TSElement tdfUser : this.myTDFUsersList) {
                tdfUser.notifyTDFChange(event);
            }
        }
    }

    @Override
    public String[] getTreeDefinedFieldInUse() {
        String[] fields = null;
        if (this.myTDFUsersList != null) {
            LinkedList<String> fieldList = new LinkedList<String>();
            for (TSElement tdfUser : this.myTDFUsersList) {
                String[] tdfUserFields = tdfUser.getTreeDefinedFieldInUse();
                if (tdfUserFields == null) continue;
                for (String tdf : tdfUserFields) {
                    fieldList.add(tdf);
                }
            }
            fields = fieldList.toArray(new String[fieldList.size()]);
        }
        return fields != null && fields.length > 0 ? fields : null;
    }

    void addTDFUser(TSElement element) {
        if (element.isProfileTreeDefinedFieldUser()) {
            if (this.myTDFUsersList == null) {
                this.myTDFUsersList = new LinkedList<TSElement>();
            }
            this.myTDFUsersList.add(element);
        }
    }

    void removeTDFUser(TSElement element) {
        if (this.myTDFUsersList != null) {
            this.myTDFUsersList.remove(element);
        }
    }

    public TSTariffStructure buildCopy(RatingRuleBuilder builder) throws Exception {
        if (!this.state().hasXMLConfig()) {
            throw new IllegalStateException("Cannot build a copy without XML configuration - call updateDOMStructure() first.");
        }
        Document doc = XMLUtil.getEmptyDocument();
        Node domCopy = doc.importNode(this.state().getXMLConfig(), true);
        XMLInitializable root = builder.build(domCopy);
        if (!(root instanceof TSTariffStructure)) {
            throw new IllegalArgumentException("Builder did not produce a TSTariffStructure root.");
        }
        return (TSTariffStructure)root;
    }

    public synchronized Node getUpdatedXMLConfiguration() {
        if (!this.isNodeValid()) {
            throw new IllegalStateException("Cannot get updated XML configuration since the node is invalid.");
        }
        this.syncDOMStructure(true);
        return this.state().getXMLConfig();
    }

    public synchronized Node getUpdatedXMLConfigurationClone() {
        Node n = this.getUpdatedXMLConfiguration();
        return n.cloneNode(true);
    }

    @Override
    protected boolean defaultAllowsAddCondition(TariffDAGNode treeNode) {
        return false;
    }

    @Override
    protected boolean defaultAllowsAddLink(TariffDAGNode treeNode) {
        return false;
    }

    @Override
    protected boolean defaultAllowsAddModifier(TariffDAGNode treeNode) {
        return false;
    }

    @Override
    protected boolean defaultAllowsAddNode(TariffDAGNode treeNode) {
        return true;
    }
}

