/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.gui.ratingrules.nodes;

import ericsson.ere.defs.RmaDefs;
import ericsson.ere.gui.ratingrules.nodes.IconProvider;
import ericsson.ere.gui.ratingrules.nodes.TSElement;
import ericsson.ere.gui.ratingrules.nodes.TariffDAGNode;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

public class TariffCellRenderer
extends DefaultTreeCellRenderer {
    private static final int TOOLTIP_CUTOFF_LENGTH = 150;
    public static final int NO_TARGET = 0;
    public static final int DEFS_FREE = 1;
    public static final int TARGET_TIED = 2;
    public static final int NO_LINK = 0;
    public static final int LINK = 1;
    public static final int LOCKED_LINK = 2;
    private int hoverOverRow = -1;
    private TariffDAGNode myNode;
    public static final Icon[][][] ICONS = new Icon[][][]{{{RmaDefs.getImageIcon("text_tree.png"), RmaDefs.getImageIcon("folder16.png"), RmaDefs.getImageIcon("condition16.png"), RmaDefs.getImageIcon("modifier16.png")}, {null, RmaDefs.getImageIcon("folder_link16.png"), RmaDefs.getImageIcon("condition_link16.png"), RmaDefs.getImageIcon("modifier_link16.png")}, {null, RmaDefs.getImageIcon("folder_link_locked16.png"), RmaDefs.getImageIcon("condition_link_locked16.png"), RmaDefs.getImageIcon("modifier_link_locked16.png")}}, {{null, RmaDefs.getImageIcon("folder16.png"), RmaDefs.getImageIcon("condition16.png"), RmaDefs.getImageIcon("modifier16.png")}, {null, RmaDefs.getImageIcon("folder_link16.png"), RmaDefs.getImageIcon("condition_link16.png"), RmaDefs.getImageIcon("modifier_link16.png")}, {null, RmaDefs.getImageIcon("folder_link_locked16.png"), RmaDefs.getImageIcon("condition_link_locked16.png"), RmaDefs.getImageIcon("modifier_link_locked16.png")}}, {{null, RmaDefs.getImageIcon("folder_target16.png"), RmaDefs.getImageIcon("condition_target16.png"), RmaDefs.getImageIcon("modifier_target16.png")}, {null, RmaDefs.getImageIcon("folder_target16.png"), RmaDefs.getImageIcon("condition_target16.png"), RmaDefs.getImageIcon("modifier_target16.png")}, {null, RmaDefs.getImageIcon("folder_target16.png"), RmaDefs.getImageIcon("condition_target16.png"), RmaDefs.getImageIcon("modifier_target16.png")}}};
    public static final Icon DEFS_NODE_ICON = RmaDefs.getImageIcon("defs16.png");

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean focus) {
        TariffDAGNode node;
        super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, focus);
        if (!(value instanceof TariffDAGNode)) {
            return this;
        }
        this.myNode = node = (TariffDAGNode)value;
        this.setIcon(this.getIconForNode(node));
        this.updateForegroundIfNecessary(node);
        String text = node.getDescription();
        if (row == this.hoverOverRow) {
            text = "<html><u>" + text + "</u>";
        }
        this.setText(text);
        return this;
    }

    protected void updateForegroundIfNecessary(TariffDAGNode node) {
        this.setForeground(node.isNodeValid() ? Color.BLACK : Color.RED);
    }

    private Icon getIconForNode(TariffDAGNode node) {
        TSElement elem;
        Icon icon = null;
        if (node instanceof TSElement && (elem = (TSElement)node).profileImplementsOrExtends(IconProvider.class)) {
            IconProvider provider = (IconProvider)((Object)elem.getClassProfile());
            icon = provider.getIconForNode(node);
        }
        if (icon == null) {
            icon = TariffCellRenderer.getIconForValue(node);
        }
        return icon;
    }

    public static Icon getIconForValue(TariffDAGNode node) {
        int nodeType = node.getNodeType();
        int targetType = 0;
        int linkType = 0;
        if ("Defs".equals(node.getTypename())) {
            return DEFS_NODE_ICON;
        }
        if (node.isLink()) {
            linkType = node.isLocked() ? 2 : 1;
        } else if (node.getRefererCount() > 0) {
            targetType = 2;
        }
        return ICONS[targetType][linkType][nodeType];
    }

    public void setHoverOverRow(int rowForLocation) {
        this.hoverOverRow = rowForLocation;
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        if (this.myNode != null) {
            return this.getToolTipFromNode(this.myNode);
        }
        return super.getToolTipText(event);
    }

    private String getToolTipFromNode(TariffDAGNode node) {
        String toolTip = node.getAdditionalInfo();
        if (toolTip.length() > 150) {
            String toolTipString = toolTip;
            String toolTipStringShortened = toolTip.substring(0, 150);
            if (toolTipStringShortened.lastIndexOf("<") > toolTipStringShortened.lastIndexOf(">")) {
                toolTip = toolTipString.substring(0, toolTipString.lastIndexOf("<") - 1) + "...";
            }
            toolTip = toolTipStringShortened + "...";
        }
        return toolTip;
    }
}

