/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.gui.ratingrules.nodes;

import java.util.HashSet;
import java.util.Set;

public class ValidityCache<T> {
    private Set<T> myValidSet = new HashSet<T>();
    private Set<T> myInvalidSet = new HashSet<T>();
    private boolean myContainsInvalid = false;

    public void put(T item, boolean valid) {
        if (this.contains(item) && this.isValid(item) != valid) {
            this.remove(item);
        }
        if (valid) {
            this.myValidSet.add(item);
        } else {
            this.myInvalidSet.add(item);
            this.myContainsInvalid = true;
        }
    }

    public boolean remove(T item) {
        boolean removed = this.myValidSet.remove(item);
        if (!removed && (removed = this.myInvalidSet.remove(item)) && this.myInvalidSet.size() == 0) {
            this.myContainsInvalid = false;
        }
        return removed;
    }

    public boolean containsAnyInvalid() {
        return this.myContainsInvalid;
    }

    public boolean contains(T item) {
        return this.myValidSet.contains(item) || this.myInvalidSet.contains(item);
    }

    public boolean containsInvalidBesides(T item) {
        if (this.myInvalidSet.contains(item)) {
            return this.myInvalidSet.size() > 1;
        }
        return this.containsAnyInvalid();
    }

    public boolean isValid(T item) {
        if (this.myValidSet.contains(item)) {
            return true;
        }
        if (this.myInvalidSet.contains(item)) {
            return false;
        }
        throw new IllegalArgumentException("Item is not in the cache.");
    }
}

