/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.gui.util;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.JDialog;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;

public abstract class AbstractDialog
extends JDialog
implements ComponentListener {
    private Frame owner = null;
    private int minimumWidth = 0;
    private int minimumHeight = 0;

    public AbstractDialog(Frame owner, boolean modal) {
        super(owner, modal);
        this.owner = owner;
        this.addComponentListener(this);
    }

    public void performCancel() {
        this.setVisible(false);
        this.dispose();
    }

    public void setMinimumWidthHeight(int width, int height) {
        this.minimumWidth = Toolkit.getDefaultToolkit().getScreenSize().width - 40 < width ? Toolkit.getDefaultToolkit().getScreenSize().width - 40 : width;
        this.minimumHeight = Toolkit.getDefaultToolkit().getScreenSize().height - 40 < height ? Toolkit.getDefaultToolkit().getScreenSize().height - 40 : height;
    }

    public void center() {
        Rectangle appBounds = this.owner.getBounds();
        Rectangle dlgBounds = this.getBounds();
        int xLoc = (appBounds.width - dlgBounds.width) / 2 + appBounds.x;
        int yLoc = (appBounds.height - dlgBounds.height) / 2 + appBounds.y;
        if (xLoc < 0) {
            xLoc = 0;
        }
        if (yLoc < 0) {
            yLoc = 0;
        }
        this.setLocation(xLoc, yLoc);
    }

    public void centerScreen() {
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds(d.width / 2 - this.getWidth() / 2, d.height / 2 - this.getHeight() / 2, this.getWidth(), this.getHeight());
    }

    @Override
    protected JRootPane createRootPane() {
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractDialog.this.performCancel();
            }
        };
        JRootPane rp = new JRootPane();
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        rp.registerKeyboardAction(actionListener, stroke, 2);
        return rp;
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        if (this.getSize().width < this.minimumWidth) {
            this.setSize(this.minimumWidth, this.getHeight());
        }
        if (this.getSize().height < this.minimumHeight) {
            this.setSize(this.getSize().width, this.minimumHeight);
        }
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }
}

