/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.gui.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.swing.AbstractListModel;

public class ArrayListModel<E>
extends AbstractListModel
implements List<E> {
    private static final long serialVersionUID = 1L;
    private ArrayList<E> delegate = new ArrayList();

    @Override
    public void add(int index, E element) {
        this.delegate.add(index, element);
        this.fireIntervalAdded(this, index, index);
    }

    @Override
    public boolean add(E element) {
        boolean rv = this.delegate.add(element);
        int index = this.delegate.size() - 1;
        this.fireIntervalAdded(this, index, index);
        return rv;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        int before = this.delegate.size();
        boolean rv = this.delegate.addAll(c);
        int after = this.delegate.size() - 1;
        if (before <= after) {
            this.fireIntervalAdded(this, before, after);
        }
        return rv;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        int preItems = this.delegate.size();
        boolean rv = this.delegate.addAll(index, c);
        int postItems = this.delegate.size();
        int noOfAdded = postItems - preItems;
        if (noOfAdded > 0) {
            this.fireIntervalAdded(this, index, index + noOfAdded - 1);
        }
        return rv;
    }

    @Override
    public void clear() {
        int index1 = this.delegate.size() - 1;
        this.delegate.clear();
        if (index1 >= 0) {
            this.fireIntervalRemoved(this, 0, index1);
        }
    }

    @Override
    public boolean contains(Object elem) {
        return this.delegate.contains(elem);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.delegate.containsAll(c);
    }

    public void ensureCapacity(int minCapacity) {
        this.delegate.ensureCapacity(minCapacity);
    }

    @Override
    public boolean equals(Object o) {
        return this.delegate.equals(o);
    }

    @Override
    public E get(int index) {
        return this.delegate.get(index);
    }

    @Override
    public Object getElementAt(int index) {
        return this.delegate.get(index);
    }

    @Override
    public int getSize() {
        return this.delegate.size();
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public int indexOf(Object elem) {
        return this.delegate.indexOf(elem);
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return new ImmutableListIterator<E>(this.delegate.listIterator());
    }

    @Override
    public int lastIndexOf(Object elem) {
        return this.delegate.lastIndexOf(elem);
    }

    @Override
    public ListIterator<E> listIterator() {
        return new ImmutableListIterator<E>(this.delegate.listIterator());
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return new ImmutableListIterator<E>(this.delegate.listIterator(index));
    }

    @Override
    public E remove(int index) {
        E rv = this.delegate.remove(index);
        this.fireIntervalRemoved(this, index, index);
        return rv;
    }

    @Override
    public boolean remove(Object o) {
        int index = this.delegate.indexOf(o);
        if (index >= 0) {
            this.delegate.remove(index);
            this.fireIntervalRemoved(this, index, index);
        }
        return index >= 0;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException("ArrayListModel.removeAll()");
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException("ArrayListModel.retainAll()");
    }

    @Override
    public E set(int index, E element) {
        E rv = this.delegate.get(index);
        this.delegate.set(index, element);
        this.fireContentsChanged(this, index, index);
        return rv;
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException("ArrayListModel.subList()");
    }

    public void trimToSize() {
        this.delegate.trimToSize();
    }

    @Override
    public Object[] toArray() {
        return this.delegate.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.delegate.toArray(a);
    }

    private static class ImmutableListIterator<T>
    implements ListIterator<T> {
        private ListIterator<T> _i;

        public ImmutableListIterator(ListIterator<T> i) {
            this._i = i;
        }

        @Override
        public void add(Object o) {
            throw new UnsupportedOperationException("ImmutableListIterator.add()");
        }

        @Override
        public boolean hasNext() {
            return this._i.hasNext();
        }

        @Override
        public boolean hasPrevious() {
            return this._i.hasPrevious();
        }

        @Override
        public T next() {
            return this._i.next();
        }

        @Override
        public int nextIndex() {
            return this._i.nextIndex();
        }

        @Override
        public T previous() {
            return this._i.previous();
        }

        @Override
        public int previousIndex() {
            return this._i.previousIndex();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("ImmutableListIterator.remove()");
        }

        @Override
        public void set(Object o) {
            throw new UnsupportedOperationException("ImmutableListIterator.set()");
        }
    }
}

