/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.gui.util;

import com.ericsson.ere.gui.util.ExceptionUtil;
import com.ericsson.ere.swing.EDT;
import ericsson.ere.gui.Config;
import ericsson.ere.gui.GuiServiceCenter;
import ericsson.ere.gui.util.ErrorDialog;
import ericsson.ere.gui.util.LoginDialog;
import ericsson.ere.gui.util.ProgressDialog;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Callable;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class DialogFactory {
    private static void disposeSplashIfVisible() {
        if (Config.getInstance() != null && GuiServiceCenter.getInstance().getSplash() != null && GuiServiceCenter.getInstance().getSplash().isVisible()) {
            GuiServiceCenter.getInstance().getSplash().dispose();
        }
    }

    public static boolean getQuestionDialog(Component frame, String header, String question) {
        DialogFactory.disposeSplashIfVisible();
        Object[] options = new Object[]{"Yes", "Cancel"};
        int n = DialogFactory.showOptionDialog(frame, question, header, 0, 3, options, options[0]);
        return n > 0 ? false : n != -1;
    }

    public static int getQuestionDialogWithCancel(Component frame, String header, String question) {
        DialogFactory.disposeSplashIfVisible();
        Object[] options = new Object[]{"Yes", "No", "Cancel"};
        return DialogFactory.showOptionDialog(frame, question, header, 0, 3, options, options[0]);
    }

    @Deprecated
    public static int getOptionDialogWithYesNoCancel(Component frame, String header, String question) {
        return DialogFactory.getQuestionDialogWithCancel(frame, header, question);
    }

    public static boolean getQuestionDialogCustomButtons(Component frame, String header, String question, String Option1, String Option2) {
        DialogFactory.disposeSplashIfVisible();
        Object[] options = new Object[]{Option1, Option2};
        int n = DialogFactory.showOptionDialog(frame, question, header, 0, 3, options, options[0]);
        return n > 0 ? false : n != -1;
    }

    public static void getErrorDialog(String infoHeader, String infoMessage) {
        DialogFactory.getErrorDialog(GuiServiceCenter.getInstance().getMainWindow(), infoHeader, infoMessage);
    }

    public static void getErrorDialog(Component parent, String infoHeader, String infoMessage) {
        DialogFactory.disposeSplashIfVisible();
        DialogFactory.showMessageDialog(parent, infoMessage, infoHeader, 0);
    }

    public static void getErrorDialog(String infoHeader, String infoMessage, Throwable extendedInfo) {
        DialogFactory.getErrorDialog(null, infoHeader, infoMessage, extendedInfo);
    }

    public static void getErrorDialog(Component owner, final String infoHeader, final String infoMessage, Throwable extendedInfo) {
        DialogFactory.disposeSplashIfVisible();
        StringBuilder b = new StringBuilder();
        StackTraceElement[] elements = extendedInfo.getStackTrace();
        for (int i = 0; i < elements.length; ++i) {
            b.append(elements[i]).append('\n');
        }
        final String extInfo = b.toString();
        final Window window = DialogFactory.getWindowForComponent(owner);
        ErrorDialog d = DialogFactory.runOnEDTWithoutException(new Callable<ErrorDialog>(){

            @Override
            public ErrorDialog call() throws Exception {
                ErrorDialog d = new ErrorDialog(window, infoHeader, infoMessage, extInfo);
                return d;
            }
        });
        d.setVisible(true);
    }

    private static Window getWindowForComponent(Component owner) {
        if (owner == null) {
            return GuiServiceCenter.getInstance().getMainWindow();
        }
        if (owner instanceof Frame || owner instanceof Dialog) {
            return (Window)owner;
        }
        return DialogFactory.getWindowForComponent(owner.getParent());
    }

    public static void getInformationDialog(Component frame, String header, String question) {
        DialogFactory.disposeSplashIfVisible();
        DialogFactory.showMessageDialog(frame, question, header, 1);
    }

    public static void getWarningDialog(Component frame, String header, String message) {
        DialogFactory.disposeSplashIfVisible();
        DialogFactory.showMessageDialog(frame, message, header, 2);
    }

    public static int showOptionDialog(Component owner, String header, String question, String[] options) {
        DialogFactory.disposeSplashIfVisible();
        return DialogFactory.showOptionDialog(owner, question, header, -1, 1, options, null);
    }

    public static int showCustomOptionDialog(Component owner, String header, String question, String[] options, int optionType, int messageType) {
        DialogFactory.disposeSplashIfVisible();
        return DialogFactory.showOptionDialog(owner, question, header, optionType, messageType, options, null);
    }

    public static Config.UserInfo showLoginDialog(String username) {
        return DialogFactory.showLoginDialog(null, username);
    }

    public static Config.UserInfo showLoginDialog(final String serverName, final String username) {
        DialogFactory.disposeSplashIfVisible();
        LoginDialog li = DialogFactory.runOnEDTWithoutException(new Callable<LoginDialog>(){

            @Override
            public LoginDialog call() throws Exception {
                LoginDialog li = new LoginDialog(serverName, username);
                return li;
            }
        });
        li.setVisible(true);
        if (li.isAccepted()) {
            return new Config.UserInfo(li.getUsername(), li.getPassword());
        }
        return null;
    }

    public static void showProgressDialogWithDelay(Frame owner, ProgressDialog dialog, int delayInMillis) {
        DelayedProgressHandler handler = new DelayedProgressHandler(owner, dialog, delayInMillis);
        handler.startTimer();
    }

    private static void showMessageDialog(final Component owner, final Object message, final String title, final int type) {
        DialogFactory.runOnEDTWithoutException(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                JOptionPane.showMessageDialog(owner, message, title, type);
                return null;
            }
        });
    }

    public static int showOptionDialog(final Component owner, final Object message, final String title, final int optionType, final int messageType, final Object[] options, final Object initialValue) {
        int ret = DialogFactory.runOnEDTWithoutException(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return JOptionPane.showOptionDialog(owner, message, title, optionType, messageType, null, options, initialValue);
            }
        });
        return ret;
    }

    private static <T> T runOnEDTWithoutException(Callable<T> code) {
        T ret;
        try {
            ret = EDT.runAndWait(code);
        }
        catch (Exception ex) {
            throw new AssertionError((Object)ex);
        }
        return ret;
    }

    private static class DelayedProgressHandler {
        private JDialog myHiddenDialog;
        private ProgressDialog myProgressDialog;
        private int myDelay;
        private Frame myOwner;

        DelayedProgressHandler(Frame owner, ProgressDialog dialog, int delayInMillis) {
            this.myDelay = delayInMillis;
            this.myProgressDialog = dialog;
            this.myOwner = owner;
            this.myHiddenDialog = new JDialog(owner, "", true);
            this.myHiddenDialog.setSize(0, 0);
            this.myHiddenDialog.setUndecorated(true);
        }

        void startTimer() {
            Timer t = new Timer();
            t.schedule(new TimerTask(){

                @Override
                public void run() {
                    this.sleepUntilNoModalDialogExists();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (myProgressDialog.isDisplayable()) {
                                myProgressDialog.setVisible(true);
                            }
                            myHiddenDialog.dispose();
                        }
                    });
                }
            }, this.myDelay);
            this.myHiddenDialog.setVisible(true);
        }

        private void sleepUntilNoModalDialogExists() {
            try {
                while (this.isModalDialogVisible()) {
                    Thread.sleep(200L);
                }
            }
            catch (Exception e) {
                ExceptionUtil.handleException(e, "dialogFactory", 0, "Exception when waiting for modal dialog to close.", false);
            }
        }

        private boolean isModalDialogVisible() throws Exception {
            boolean returnValue = EDT.runAndWait(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    Window[] ownedWindows;
                    boolean visibleDialog = false;
                    for (Window win : ownedWindows = myOwner.getOwnedWindows()) {
                        if (win == myHiddenDialog || !(win instanceof JDialog) || !win.isVisible() || !((JDialog)win).isModal()) continue;
                        visibleDialog = true;
                        break;
                    }
                    return visibleDialog;
                }
            });
            return returnValue;
        }
    }
}

