/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.gui.util;

import ericsson.ere.datatype.DataType;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.gui.interfaces.SimulationEditor;
import ericsson.ere.interfaces.XMLInitializable;
import ericsson.ere.xml.XMLUtil;
import ericsson.vareditor.variable.DropDownVariable;
import ericsson.vareditor.variable.Variable;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class EnumEditor
implements XMLInitializable,
SimulationEditor {
    private FieldDefinition myField = null;
    private List<String> myEditStrings = null;
    private List<String> myEditValues = null;

    @Override
    public XMLInitializable init(Node defs) {
        List<Element> l = XMLUtil.getElementNodesNamed("Enum", defs.getChildNodes());
        this.myEditStrings = new ArrayList<String>(l.size());
        this.myEditValues = new ArrayList<String>(l.size());
        for (Element node : l) {
            boolean isValid = false;
            Node name = null;
            Node value = null;
            if (node.hasAttributes()) {
                NamedNodeMap attr = node.getAttributes();
                name = attr.getNamedItem("name");
                if (name == null) {
                    name = attr.getNamedItem("Name");
                }
                if ((value = attr.getNamedItem("value")) == null) {
                    value = attr.getNamedItem("Value");
                }
                if (name != null && value != null) {
                    this.myEditStrings.add(name.getNodeValue());
                    this.myEditValues.add(value.getNodeValue());
                    isValid = true;
                }
            }
            if (isValid) continue;
            throw new IllegalArgumentException("Enum has mandatory attributes: \"name\" and \"value\"");
        }
        return this;
    }

    public String[] getEditStrings() {
        return this.myEditStrings.toArray(new String[this.myEditStrings.size()]);
    }

    public String[] getValues() {
        return this.myEditValues.toArray(new String[this.myEditValues.size()]);
    }

    @Override
    public String getEditStringForValue(String val) {
        int index;
        if (this.myEditValues != null && (index = this.myEditValues.indexOf(val)) >= 0) {
            return this.myEditStrings.get(index);
        }
        return null;
    }

    @Override
    public String getValueForEditString(String editString) {
        int index;
        String s = editString;
        if (this.myEditValues != null && (index = this.myEditStrings.indexOf(editString)) >= 0) {
            s = this.myEditValues.get(index);
        }
        return s;
    }

    @Override
    public boolean isValidEditString(String editString) {
        return this.myEditStrings.indexOf(editString) >= 0;
    }

    @Override
    public boolean isValidValueString(String value) {
        return this.myEditValues.indexOf(value) >= 0;
    }

    @Override
    public void setFieldDefinition(FieldDefinition f) {
        this.myField = f;
    }

    @Override
    public Variable createVariable() {
        String dfltStr;
        String selected;
        Object[] choices = this.getEditStrings();
        String name = this.myField.getFieldName();
        String string = selected = this.myEditValues.size() == 0 ? null : this.myEditValues.get(0);
        if (this.myField.hasDefaultValue() && this.isValidValueString(dfltStr = this.myField.getDefaultValue())) {
            selected = dfltStr;
        }
        return new DropDownVariable(name, choices, this.getValues(), (Object)selected);
    }

    public void removeUnparsableValues(DataType dataType) {
        ArrayList<String> editStrings = new ArrayList<String>();
        ArrayList<String> editValues = new ArrayList<String>();
        for (int i = 0; i < this.myEditValues.size(); ++i) {
            boolean isParseValue;
            boolean bl = isParseValue = dataType.parseValue(this.myEditValues.get(i)) != null;
            if (!isParseValue) continue;
            editStrings.add(this.myEditStrings.get(i));
            editValues.add(this.myEditValues.get(i));
        }
        this.myEditStrings = editStrings;
        this.myEditValues = editValues;
    }
}

