/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.gui.util;

import java.awt.Color;
import java.awt.Dimension;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.StringTokenizer;
import javax.swing.JTextPane;
import javax.swing.text.AbstractDocument;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class InformationPane
extends JTextPane {
    public static final int NORMAL = 0;
    public static final int BOLD = 1;
    public static final int ITALIC = 2;
    public static final int UNDERLINE = 3;
    static final int DEFAULT_MAX_LINES = 1000;
    AbstractDocument myDoc;
    SimpleAttributeSet myDefaultAttrs;
    SimpleAttributeSet myIndentAttrs;
    int myMaxLines = 1000;
    boolean lineWrap = false;

    public InformationPane() {
        super(new DefaultStyledDocument());
        this.setEditable(false);
        this.myDefaultAttrs = new SimpleAttributeSet(this.getParagraphAttributes());
        this.myIndentAttrs = new SimpleAttributeSet(this.myDefaultAttrs);
        StyleConstants.setFirstLineIndent(this.myIndentAttrs, 5.0f);
        StyleConstants.setLeftIndent(this.myIndentAttrs, 5.0f);
        StyleConstants.setFirstLineIndent(this.myDefaultAttrs, 0.0f);
        StyleConstants.setLeftIndent(this.myDefaultAttrs, 0.0f);
        this.myDoc = (AbstractDocument)((Object)this.getStyledDocument());
    }

    public void addInformationWithTimestamp(String info, Color color, int style) {
        SimpleDateFormat sdf = new SimpleDateFormat();
        if (this.myDoc.getLength() > 0) {
            this.addText('\n' + sdf.format(new Date()) + " : " + info, color, style, false);
        } else {
            this.addText(sdf.format(new Date()) + " : " + info, color, style, false);
        }
    }

    public void addInformation(String info, Color color, int style) {
        this.addText(info.toString(), color, style, true);
    }

    public void addText(String info, Color color, int style, boolean indent) {
        SimpleAttributeSet attrs = new SimpleAttributeSet();
        attrs = new SimpleAttributeSet();
        StyleConstants.setForeground(attrs, color);
        switch (style) {
            case 0: {
                break;
            }
            case 1: {
                StyleConstants.setBold(attrs, true);
                break;
            }
            case 2: {
                StyleConstants.setItalic(attrs, true);
                break;
            }
            case 3: {
                StyleConstants.setUnderline(attrs, true);
            }
        }
        if (indent) {
            this.setParagraphAttributes(this.myIndentAttrs, true);
        } else {
            this.setParagraphAttributes(this.myDefaultAttrs, true);
        }
        if (!info.endsWith("\n")) {
            info = info + '\n';
        }
        try {
            String text = this.myDoc.getText(0, this.myDoc.getLength());
            StringTokenizer loggerTokens = new StringTokenizer(text, "\n");
            StringTokenizer infoTokens = new StringTokenizer(info, "\n");
            if (loggerTokens.countTokens() + infoTokens.countTokens() > this.myMaxLines) {
                for (int i = 0; i < infoTokens.countTokens() && loggerTokens.hasMoreTokens(); ++i) {
                    String line = loggerTokens.nextToken();
                    this.myDoc.remove(0, line.length() + 1);
                }
            }
            this.myDoc.insertString(this.myDoc.getLength(), info.toString(), attrs);
            this.setCaretPosition(this.myDoc.getLength());
        }
        catch (Exception e) {
            System.out.println("Something wrong with the information logger");
            e.printStackTrace();
        }
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        if (this.lineWrap) {
            return super.getScrollableTracksViewportWidth();
        }
        return false;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.lineWrap) {
            return super.getPreferredSize();
        }
        Dimension d = super.getPreferredSize();
        d.width = 10000;
        return d;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        if (this.lineWrap) {
            return super.getPreferredScrollableViewportSize();
        }
        return this.getPreferredSize();
    }

    public void setLineWrap(boolean wrap) {
        this.lineWrap = wrap;
    }
}

