/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.gui.util;

import ericsson.ere.gui.GuiServiceCenter;
import ericsson.ere.gui.util.AbstractDialog;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class LoginDialog
extends AbstractDialog {
    private JButton myCancelButton;
    private JButton myOKButton;
    private JPanel myButtonPanel;
    private JPanel myMainPanel;
    private JPasswordField myPasswordField;
    private JTextField myUsernameField;
    private boolean myIsAccepted = false;
    private String myUsername;
    private String myPassword;
    private String myServerName;

    public LoginDialog(String serverName, String username) {
        super((Frame)GuiServiceCenter.getInstance().getMainWindow(), true);
        this.myServerName = serverName;
        this.initComponents();
        this.getRootPane().setDefaultButton(this.myOKButton);
        if (username != null && !username.equals("")) {
            this.myUsernameField.setText(username);
        } else {
            this.myUsernameField.setText("");
        }
        this.myPasswordField.setText("");
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                JTextField focusedComponent;
                JTextField jTextField = focusedComponent = LoginDialog.this.myUsernameField.getText().isEmpty() ? LoginDialog.this.myUsernameField : LoginDialog.this.myPasswordField;
                if (!LoginDialog.this.requestFocusInWindow()) {
                    LoginDialog.this.requestFocus();
                }
                ((Component)focusedComponent).requestFocusInWindow();
            }
        });
        this.center();
    }

    public LoginDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    private void initComponents() {
        JLabel usernameLabel = new JLabel();
        JLabel passwordLabel = new JLabel();
        this.myMainPanel = new JPanel();
        this.myUsernameField = new JTextField(){

            @Override
            protected void processFocusEvent(FocusEvent e) {
                super.processFocusEvent(e);
                if (e.getID() == 1004) {
                    this.selectAll();
                }
            }
        };
        this.myPasswordField = new JPasswordField();
        this.myButtonPanel = new JPanel();
        this.myOKButton = new JButton();
        this.myCancelButton = new JButton();
        this.setName("LoginDialog");
        this.myUsernameField.setName("LoginDialog.Username");
        this.myPasswordField.setName("LoginDialog.Password");
        this.myOKButton.setName("LoginDialog.OkButton");
        this.myCancelButton.setName("LoginDialog.CancelButton");
        if (this.myServerName != null && !this.myServerName.equals("")) {
            this.setTitle("Login to " + this.myServerName);
        } else {
            this.setTitle("Login");
        }
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                LoginDialog.this.closeDialog();
            }
        });
        this.myMainPanel.setLayout(new GridBagLayout());
        this.myMainPanel.setBorder(new TitledBorder(new EtchedBorder(), "Enter Login Information"));
        usernameLabel.setFont(new Font("Dialog", 0, 12));
        usernameLabel.setText("User Name:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 0, 4);
        this.myMainPanel.add((Component)usernameLabel, gridBagConstraints);
        this.myUsernameField.setColumns(10);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        gridBagConstraints.weightx = 1.0;
        this.myMainPanel.add((Component)this.myUsernameField, gridBagConstraints);
        passwordLabel.setFont(new Font("Dialog", 0, 12));
        passwordLabel.setText("Password:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.myMainPanel.add((Component)passwordLabel, gridBagConstraints);
        this.myPasswordField.setColumns(10);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        gridBagConstraints.weightx = 1.0;
        this.myMainPanel.add((Component)this.myPasswordField, gridBagConstraints);
        this.myOKButton.setText("OK");
        this.myOKButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoginDialog.this.btnOKActionPerformed(evt);
            }
        });
        this.myButtonPanel.add(this.myOKButton);
        this.myCancelButton.setText("Cancel");
        this.myCancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoginDialog.this.performCancel();
            }
        });
        this.myButtonPanel.add(this.myCancelButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        this.myMainPanel.add((Component)this.myButtonPanel, gridBagConstraints);
        this.getContentPane().add((Component)this.myMainPanel, "Center");
        this.pack();
    }

    private void btnOKActionPerformed(ActionEvent evt) {
        this.myUsername = this.myUsernameField.getText();
        this.myPassword = new String(this.myPasswordField.getPassword());
        this.myIsAccepted = true;
        this.closeDialog();
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    public boolean isAccepted() {
        return this.myIsAccepted;
    }

    public String getUsername() {
        return this.myUsername;
    }

    public String getPassword() {
        return this.myPassword;
    }
}

