/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.gui.util;

import com.ericsson.ere.dataset.DataSetFactory;
import com.ericsson.ere.datatype.EREDateFactory;
import com.ericsson.ere.datatype.EREDateUtil;
import com.ericsson.ere.datatype.ERETimeFactory;
import com.ericsson.ere.datatype.ValueResolver;
import com.ericsson.ere.interfaces.LocationDependent;
import com.ericsson.ere.math.RatingDecimal;
import com.ericsson.ere.selectiontree.util.AmountUtil;
import com.ericsson.ere.selectiontree.util.ValueFieldCompositeObject;
import com.ericsson.ere.util.FieldDefinitionUtil;
import com.ericsson.ere.util.Location;
import com.ericsson.ere.util.Predicate;
import ericsson.ere.datatype.BcdString;
import ericsson.ere.datatype.DataType;
import ericsson.ere.datatype.Decimal;
import ericsson.ere.datatype.MonetaryUnits;
import ericsson.ere.datatype.OctetString;
import ericsson.ere.datatype.UnsignedInt16;
import ericsson.ere.datatype.UnsignedInt32;
import ericsson.ere.datatype.UnsignedInt8;
import ericsson.ere.datatype.factory.DefaultAmountFactory;
import ericsson.ere.datatype.interfaces.AmountFactory;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.EreClassLoader;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.defs.FieldDefinitionHelper;
import ericsson.ere.defs.RmaDefs;
import ericsson.ere.gui.interfaces.SimulationEditor;
import ericsson.ere.gui.util.EnumEditor;
import ericsson.ere.gui.util.IndexVariableFactory;
import ericsson.ere.interfaces.XMLInitializable;
import ericsson.ere.management.DateUtil;
import ericsson.ere.util.StringUtil;
import ericsson.vareditor.variable.AmountVariable;
import ericsson.vareditor.variable.BaseVariable;
import ericsson.vareditor.variable.BcdStringVariable;
import ericsson.vareditor.variable.BitPatternInputVariable;
import ericsson.vareditor.variable.BoolVariable;
import ericsson.vareditor.variable.ClassRepositoryUser;
import ericsson.vareditor.variable.DateAndTimeVariable;
import ericsson.vareditor.variable.DecimalVariable;
import ericsson.vareditor.variable.DoubleVariable;
import ericsson.vareditor.variable.DropDownVariable;
import ericsson.vareditor.variable.InfoVariable;
import ericsson.vareditor.variable.IntegerVariable;
import ericsson.vareditor.variable.LongVariable;
import ericsson.vareditor.variable.MonetaryUnitsVariable;
import ericsson.vareditor.variable.NotAllowedVariable;
import ericsson.vareditor.variable.OctetStringVariable;
import ericsson.vareditor.variable.RatingDecimalVariable;
import ericsson.vareditor.variable.ShortVariable;
import ericsson.vareditor.variable.StringVariable;
import ericsson.vareditor.variable.UIntegerVariable;
import ericsson.vareditor.variable.ULongVariable;
import ericsson.vareditor.variable.UShortVariable;
import ericsson.vareditor.variable.UnsignedInt16Variable;
import ericsson.vareditor.variable.UnsignedInt32Variable;
import ericsson.vareditor.variable.UnsignedInt8Variable;
import ericsson.vareditor.variable.ValueFieldVariable;
import ericsson.vareditor.variable.Variable;
import ericsson.vareditor.variable.treedefinedfields.tdfvariables.TDFBoolVariable;
import ericsson.vareditor.variable.treedefinedfields.tdfvariables.TDFLongVariable;
import ericsson.vareditor.variable.treedefinedfields.tdfvariables.TDFStringVariable;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.naming.OperationNotSupportedException;
import org.w3c.dom.NamedNodeMap;

public class VariableFactory {
    VariableFactory() {
    }

    public static Variable createStringVariable(NamedNodeMap attributes) {
        BaseVariable variable;
        String name = attributes.getNamedItem("Name").getNodeValue();
        String defaultValue = "";
        String format = "String";
        if (attributes.getNamedItem("Default") != null) {
            defaultValue = attributes.getNamedItem("Default").getNodeValue();
        }
        if (attributes.getNamedItem("Format") != null) {
            format = attributes.getNamedItem("Format").getNodeValue();
        }
        if (format.equals("String")) {
            variable = new StringVariable(name, defaultValue);
        } else if (format.equals("HexString")) {
            variable = new StringVariable(name, defaultValue);
        } else if (format.equals("DecString")) {
            variable = new StringVariable(name, defaultValue);
        } else if (format.equals("Choice")) {
            String choices = attributes.getNamedItem("Choices").getNodeValue();
            StringTokenizer tokenizer = new StringTokenizer(choices, "\n\t\r\u0000,;", false);
            Vector<String> vector = new Vector<String>();
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if (token.length() == 0) continue;
                vector.add(token);
            }
            if (vector.size() > 0) {
                Object[] choiceArr = new String[vector.size()];
                for (int ii = 0; ii < vector.size(); ++ii) {
                    choiceArr[ii] = (String)vector.get(ii);
                }
                variable = new DropDownVariable(name, (Object)defaultValue, choiceArr);
            } else {
                variable = new StringVariable("Misstake", "");
            }
        } else {
            variable = format.equals("File") ? new StringVariable("File Not implemented ...", "") : new StringVariable("Misstake", "");
        }
        return variable;
    }

    public static Variable createDateVariable(NamedNodeMap attributes) {
        return VariableFactory.createTypeBasedVariable(DataType.DATE, attributes, EREDateFactory.today());
    }

    public static DateAndTimeVariable createDateVariable(String label, String key, FieldDefinition fieldDefinition) {
        DateAndTimeVariable variable = new DateAndTimeVariable(label, DateAndTimeVariable.Content.DATE);
        if (key != null) {
            variable.setKey(key);
        }
        if (fieldDefinition != null) {
            String eotLabel;
            String botLabel = fieldDefinition.getFieldSettings().get("BeginningOfTimeLabel");
            if (!StringUtil.isEmptyString(botLabel)) {
                variable.setBeginningOfTimeText(botLabel);
            }
            if (!StringUtil.isEmptyString(eotLabel = fieldDefinition.getFieldSettings().get("EndOfTimeLabel"))) {
                variable.setEndOfTimeText(eotLabel);
            }
        }
        return variable;
    }

    public static DateAndTimeVariable createDateTimeVariable(String label, String key, FieldDefinition fieldDefinition) {
        DateAndTimeVariable variable = new DateAndTimeVariable(label, DateAndTimeVariable.Content.DATE_TIME);
        if (key != null) {
            variable.setKey(key);
        }
        if (fieldDefinition != null) {
            String eotLabel;
            String botLabel = fieldDefinition.getFieldSettings().get("BeginningOfTimeLabel");
            if (!StringUtil.isEmptyString(botLabel)) {
                variable.setBeginningOfTimeText(botLabel);
            }
            if (!StringUtil.isEmptyString(eotLabel = fieldDefinition.getFieldSettings().get("EndOfTimeLabel"))) {
                variable.setEndOfTimeText(eotLabel);
            }
        }
        return variable;
    }

    public static Variable createTimeOfDayVariable(NamedNodeMap attributes) {
        String name = attributes.getNamedItem("Name").getNodeValue();
        String defaultValue = (String)VariableFactory.parseAttributeValue(DataType.STRING, attributes, "Default", "");
        return new DateAndTimeVariable(name, DateAndTimeVariable.Content.TIME, defaultValue);
    }

    public static Variable createDoubleVariable(NamedNodeMap attributes) {
        Variable variable = VariableFactory.createTypeBasedVariable(DataType.DOUBLE, attributes, 0.0, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        String defValue = (String)VariableFactory.parseAttributeValue(DataType.STRING, attributes, "Default", null);
        if (defValue != null && DataType.DOUBLE.parseValue(defValue) == null) {
            variable = new DoubleVariable(variable.getLabel(), defValue);
        }
        return variable;
    }

    public static Variable createIntegerVariable(NamedNodeMap attributes) {
        return VariableFactory.createTypeBasedVariable(DataType.INTEGER, attributes, 0);
    }

    public static Variable createUIntegerVariable(NamedNodeMap attributes) {
        return VariableFactory.createTypeBasedVariable(DataType.UNSIGNEDINT, attributes, 0);
    }

    public static Variable createLongVariable(NamedNodeMap attributes) {
        return VariableFactory.createTypeBasedVariable(DataType.LONG, attributes, 0L);
    }

    public static Variable createULongVariable(NamedNodeMap attributes) {
        return VariableFactory.createTypeBasedVariable(DataType.UNSIGNEDLONG, attributes, 0L);
    }

    public static Variable createShortVariable(NamedNodeMap attributes) {
        return VariableFactory.createTypeBasedVariable(DataType.SHORT, attributes, (short)0);
    }

    public static Variable createUShortVariable(NamedNodeMap attributes) {
        return VariableFactory.createTypeBasedVariable(DataType.UNSIGNEDSHORT, attributes, (short)0);
    }

    public static Variable createBooleanVariable(NamedNodeMap attributes) {
        return VariableFactory.createTypeBasedVariable(DataType.BOOLEAN, attributes, false);
    }

    public static Variable createUnsignedInt32Variable(NamedNodeMap attributes) {
        return VariableFactory.createTypeBasedVariable(DataType.UNSIGNEDINT32, attributes, new UnsignedInt32(0L));
    }

    public static Variable createUnsignedInt16Variable(NamedNodeMap attributes) {
        return VariableFactory.createTypeBasedVariable(DataType.UNSIGNEDINT16, attributes, new UnsignedInt16(0));
    }

    public static Variable createUnsignedInt8Variable(NamedNodeMap attributes) {
        return VariableFactory.createTypeBasedVariable(DataType.UNSIGNEDINT8, attributes, new UnsignedInt8(0));
    }

    public static Variable createMonetaryUnitsVariable(NamedNodeMap attributes) {
        return VariableFactory.createTypeBasedVariable(DataType.MONETARYUNITS, attributes, new MonetaryUnits("0.0"));
    }

    public static Variable createDecimalVariable(NamedNodeMap attributes) {
        return VariableFactory.createTypeBasedVariable(DataType.DECIMAL, attributes, new Decimal("0.0"));
    }

    public static Variable createTimeVariable(NamedNodeMap attributes) {
        return VariableFactory.createTypeBasedVariable(DataType.TIME, attributes, ERETimeFactory.now());
    }

    public static Variable createOctetStringVariable(NamedNodeMap attributes) {
        Variable variable;
        String dt = DataType.OCTETSTRING.getTypeName();
        String name = attributes.getNamedItem("Name").getNodeValue();
        String defVal = (String)VariableFactory.parseAttributeValue(DataType.STRING, attributes, "Default", "");
        String mode = (String)VariableFactory.parseAttributeValue(DataType.STRING, attributes, "Mode", null);
        boolean isAscii = "Ascii".equals(mode);
        try {
            OctetString octetString = OctetStringVariable.stringToOctetString(defVal, !isAscii);
            variable = VariableFactory.getVariableOfDataType(dt, name, attributes, null, null, octetString);
        }
        catch (Exception e) {
            variable = new StringVariable(name, "ERROR for OctetString");
        }
        return variable;
    }

    public static Variable createBcdStringVariable(NamedNodeMap attributes) {
        Variable variable = VariableFactory.createTypeBasedVariable(DataType.BCDSTRING, attributes, new BcdString(""));
        String defValue = (String)VariableFactory.parseAttributeValue(DataType.STRING, attributes, "Default", null);
        if (defValue != null && DataType.BCDSTRING.parseValue(defValue) == null) {
            variable = new StringVariable(variable.getLabel(), "ERROR for BcdString");
        }
        return variable;
    }

    public static Variable createDurationVariable(NamedNodeMap attributes) throws OperationNotSupportedException {
        throw new OperationNotSupportedException("VariableFactory.createDurationVariable NOT yet implemented");
    }

    @Deprecated
    public static Variable createObjectVariable(NamedNodeMap attributes, String editorClass) {
        return VariableFactory.createObjectVariable(attributes, editorClass, null);
    }

    public static Variable createObjectVariable(NamedNodeMap attributes, String editorClass, FieldDefinition fieldDef) {
        String name = attributes.getNamedItem("Name").getNodeValue();
        Variable variable = null;
        if (StringUtil.isEmptyString(editorClass)) {
            return new InfoVariable(name, "No editor specified for field " + name);
        }
        try {
            SimulationEditor editor = (SimulationEditor)EreClassLoader.createInstance(editorClass);
            if (fieldDef != null) {
                editor.setFieldDefinition(fieldDef);
            }
            variable = editor.createVariable();
            variable.setLabel(name);
        }
        catch (Exception e1) {
            return new InfoVariable(name, "Editor could not be instantiated for field " + name);
        }
        return variable;
    }

    private static Variable createTypeBasedVariable(ValueResolver resolver, NamedNodeMap attributes, Object defaultValue) {
        return VariableFactory.createTypeBasedVariable(resolver, attributes, defaultValue, null, null);
    }

    private static Variable createTypeBasedVariable(ValueResolver resolver, NamedNodeMap attributes, Object defaultValue, Object defaultMin, Object defaultMax) {
        String dt = resolver.getDataType().getTypeName();
        String name = attributes.getNamedItem("Name").getNodeValue();
        Object value = VariableFactory.parseAttributeValue(resolver, attributes, "Default", defaultValue);
        Object min = VariableFactory.parseAttributeValue(resolver, attributes, "Min", defaultMin);
        Object max = VariableFactory.parseAttributeValue(resolver, attributes, "Max", defaultMax);
        return VariableFactory.getVariableOfDataType(dt, name, attributes, min, max, value);
    }

    private static Object parseAttributeValue(ValueResolver resolver, NamedNodeMap attributes, String attr, Object defaultValue) {
        String val;
        Object oval;
        Object value = defaultValue;
        if (attributes.getNamedItem(attr) != null && (oval = resolver.parseValueString(val = attributes.getNamedItem(attr).getNodeValue())) != null) {
            value = oval;
        }
        return value;
    }

    public static Variable getVariableOfDataType(String dataType, String label, NamedNodeMap attributes, Object min, Object max, Object value) {
        String strValue;
        DataType dt = DataType.lookup(dataType);
        Variable newVar = null;
        Object defaultValue = null;
        Object maxValue = null;
        Object minValue = null;
        if (dt != null) {
            minValue = min != null && min instanceof String ? dt.parseValue((String)min) : dt.castObject(min);
            maxValue = max != null && max instanceof String ? dt.parseValue((String)max) : dt.castObject(max);
            defaultValue = value != null && value instanceof String ? dt.parseValue((String)value) : dt.castObject(value);
        }
        String string = strValue = defaultValue != null ? dt.makeParseableString(defaultValue) : "";
        if (dataType.equals("TDFBoolVariable")) {
            newVar = new TDFBoolVariable(label, Boolean.valueOf(strValue));
        } else if (dataType.equals("TDFLongVariable")) {
            newVar = new TDFLongVariable(label, Long.parseLong(strValue));
        } else if (dataType.equals("TDFStringVariable")) {
            newVar = new TDFStringVariable(label, strValue);
        } else if (dt != null) {
            newVar = VariableFactory.createVariableOfDataType(dt, label, attributes, (Number)minValue, (Number)maxValue, strValue);
        }
        return newVar;
    }

    public static Variable createVariableOfDataType(DataType dataType, String label, NamedNodeMap attributes, Number minValue, Number maxValue, String value) {
        BaseVariable newVar = null;
        if (dataType == null) {
            throw new IllegalArgumentException("dataType may not be null");
        }
        switch (dataType) {
            case SHORT: {
                if (minValue != null && maxValue != null) {
                    newVar = new ShortVariable(label, value, minValue.intValue(), maxValue.intValue());
                    break;
                }
                newVar = new ShortVariable(label, value);
                break;
            }
            case INTEGER: {
                if (minValue != null && maxValue != null) {
                    newVar = new IntegerVariable(label, value, minValue.intValue(), maxValue.intValue());
                    break;
                }
                newVar = new IntegerVariable(label, value);
                break;
            }
            case LONG: {
                if (minValue != null && maxValue != null) {
                    newVar = new LongVariable(label, value, minValue.longValue(), maxValue.longValue());
                    break;
                }
                newVar = new LongVariable(label, value);
                break;
            }
            case DOUBLE: {
                if (minValue != null && maxValue != null) {
                    newVar = new DoubleVariable(label, value, minValue.doubleValue(), maxValue.doubleValue());
                    break;
                }
                newVar = new DoubleVariable(label, value);
                break;
            }
            case STRING: {
                newVar = new StringVariable(label, value);
                break;
            }
            case TIME: 
            case DATE: {
                DateAndTimeVariable.Content content;
                DateAndTimeVariable.Content content2 = content = dataType == DataType.DATE ? DateAndTimeVariable.Content.DATE : DateAndTimeVariable.Content.DATE_TIME;
                if (EREDateUtil.isBoundaryDateDefaultLabel(value)) {
                    newVar = new DateAndTimeVariable(label, content, value);
                    ((Variable)newVar).setValue(value.toString());
                    break;
                }
                Calendar cal = DateUtil.parse(value);
                newVar = new DateAndTimeVariable(label, content, cal);
                break;
            }
            case BOOLEAN: {
                newVar = new BoolVariable(label, Boolean.parseBoolean(value));
                break;
            }
            case UNSIGNEDINT: {
                if (minValue != null && maxValue != null) {
                    newVar = new UIntegerVariable(label, value, new BigInteger(DataType.UIntegerParser(minValue.intValue())), new BigInteger(DataType.UIntegerParser(maxValue.intValue())));
                    break;
                }
                newVar = new UIntegerVariable(label, value);
                break;
            }
            case UNSIGNEDSHORT: {
                if (minValue != null && maxValue != null) {
                    newVar = new UShortVariable(label, value, new BigInteger(DataType.UShortParser(minValue.shortValue())), new BigInteger(DataType.UShortParser(maxValue.shortValue())));
                    break;
                }
                newVar = new UShortVariable(label, value);
                break;
            }
            case UNSIGNEDLONG: {
                if (minValue != null && maxValue != null) {
                    newVar = new ULongVariable(label, value, new BigInteger(DataType.ULongParser(minValue.longValue())), new BigInteger(DataType.ULongParser(maxValue.longValue())));
                    break;
                }
                newVar = new ULongVariable(label, value);
                break;
            }
            case MONETARYUNITS: {
                newVar = new MonetaryUnitsVariable(label, value);
                break;
            }
            case DECIMAL: {
                newVar = new DecimalVariable(label, value);
                break;
            }
            case RATINGDECIMAL: {
                if (minValue != null && maxValue != null) {
                    newVar = new RatingDecimalVariable(label, value, (RatingDecimal)minValue, (RatingDecimal)maxValue);
                    break;
                }
                newVar = new RatingDecimalVariable(label, value);
                break;
            }
            case OCTETSTRING: {
                try {
                    String mode = "Hex";
                    if (attributes != null && attributes.getNamedItem("Mode") != null) {
                        mode = attributes.getNamedItem("Mode").getNodeValue();
                    }
                    int modeValue = "Ascii".equals(mode) ? 1 : 0;
                    newVar = new OctetStringVariable(label, OctetString.valueOf(value), modeValue);
                }
                catch (Exception e) {
                    RmaDefs.loggerServiceDefinition.warning("ERROR could not create OctetString variable in VariableFactory: " + e);
                }
                break;
            }
            case BCDSTRING: {
                newVar = new BcdStringVariable(label, value);
                break;
            }
            case UNSIGNEDINT32: {
                if (minValue != null && maxValue != null) {
                    newVar = new UnsignedInt32Variable(label, value, minValue.longValue(), maxValue.longValue());
                    break;
                }
                newVar = new UnsignedInt32Variable(label, value);
                break;
            }
            case UNSIGNEDINT16: {
                if (minValue != null && maxValue != null) {
                    newVar = new UnsignedInt16Variable(label, value, minValue.intValue(), maxValue.intValue());
                    break;
                }
                newVar = new UnsignedInt16Variable(label, value);
                break;
            }
            case UNSIGNEDINT8: {
                if (minValue != null && maxValue != null) {
                    newVar = new UnsignedInt8Variable(label, value, (int)Integer.valueOf(minValue.toString()), (int)Integer.valueOf(maxValue.toString()));
                    break;
                }
                newVar = new UnsignedInt8Variable(label, value);
                break;
            }
            case AMOUNT: {
                newVar = new AmountVariable(label, value, false);
                break;
            }
            case OBJECT: {
                newVar = new StringVariable(label, value);
            }
        }
        return newVar;
    }

    @Deprecated
    public static Variable createAmountVariable(NamedNodeMap attributes, String factoryClassName, String allowNegative) {
        String value = null;
        boolean allowNegativeNumber = false;
        if (allowNegative.toLowerCase().equals("true")) {
            allowNegativeNumber = true;
        }
        String name = attributes.getNamedItem("Name").getNodeValue();
        if (attributes.getNamedItem("Default") != null) {
            value = attributes.getNamedItem("Default").getNodeValue();
        }
        if (value == null) {
            value = "0";
        }
        AmountVariable variable = new AmountVariable(name, value, allowNegativeNumber);
        return variable;
    }

    public static AmountVariable createAmountVariableForField(String label, String key, ClassRepository repository, String field, String value, boolean defaultAllowNegative) {
        if (field == null || repository == null) {
            throw new IllegalArgumentException("Null repository or field not permitted.");
        }
        return VariableFactory.createAmountVariableForField(label, key, repository, repository.getFieldDefinitionByName(field), value, defaultAllowNegative);
    }

    public static AmountVariable createAmountVariableForField(String label, String key, ClassRepository repository, FieldDefinition fieldDef, String value, boolean defaultAllowNegative) {
        if (fieldDef == null) {
            throw new IllegalArgumentException("Null field not permitted.");
        }
        return VariableFactory.privCreateAmountVariableForField(label, key, repository, fieldDef, value, defaultAllowNegative);
    }

    public static AmountVariable createAmountVariable(String label, String key, ClassRepository repository, String value, boolean allowNegativeNumber) {
        return VariableFactory.privCreateAmountVariableForField(label, key, repository, null, value, allowNegativeNumber);
    }

    private static AmountVariable privCreateAmountVariableForField(String label, String key, ClassRepository repository, FieldDefinition fieldDef, String value, boolean defaultAllowNegative) {
        String useValue;
        String useLabel;
        AmountFactory factory;
        DataType dataType;
        if (repository == null) {
            throw new IllegalArgumentException("Null repository or field not permitted.");
        }
        if (fieldDef != null && (dataType = fieldDef.getTypedDataType()) != DataType.AMOUNT) {
            throw new IllegalArgumentException("Not an amount field.");
        }
        boolean allowNegativeNumber = fieldDef != null ? AmountUtil.allowsNegativeAmount(fieldDef, defaultAllowNegative) : defaultAllowNegative;
        DataSetFactory dsfactory = repository.getDataSetFactory();
        AmountFactory amountFactory = factory = dsfactory == null ? null : dsfactory.createDataSet().getAmountFactory();
        if (factory == null) {
            factory = DefaultAmountFactory.getInstance();
        }
        if ((useLabel = label) == null) {
            String string = useLabel = fieldDef != null ? fieldDef.getFieldName() : "";
        }
        if ((useValue = value) == null) {
            useValue = fieldDef != null && fieldDef.hasDefaultValue() ? fieldDef.getDefaultValue() : "";
        }
        AmountVariable variable = new AmountVariable(useLabel, useValue, allowNegativeNumber);
        if (key != null) {
            variable.setKey(key);
        }
        if (factory != null) {
            variable.setAmountFactory(factory);
        }
        return variable;
    }

    public static Variable createRatingDecimalVariable(NamedNodeMap attributes) {
        return VariableFactory.createTypeBasedVariable(DataType.RATINGDECIMAL, attributes, RatingDecimal.ZERO);
    }

    @Deprecated
    public static Variable createIndexVariableForField(String label, FieldDefinition fd, ClassRepository classRepository) {
        return VariableFactory.createIndexVariableForField(label, fd, IndexType.Pos_Integer_Numeric, classRepository, null);
    }

    @Deprecated
    public static Variable createIndexVariableForField(String label, FieldDefinition fd, IndexType indextype, ClassRepository classRepository, ValueFieldCompositeObject defaultObject) {
        String name = label == null ? fd.getFieldName() : label;
        return VariableFactory.createIndexVariableForField(fd, indextype, classRepository, defaultObject, name);
    }

    public static Variable createIndexVariableForField(FieldDefinition fieldDefinition, ClassRepository classRepository, String defaultLabel) {
        return VariableFactory.createIndexVariableForField(fieldDefinition, IndexType.Pos_Integer_Numeric, classRepository, null, defaultLabel);
    }

    public static Variable createIndexVariableForField(FieldDefinition fieldDefinition, IndexType indexType, ClassRepository classRepository, ValueFieldCompositeObject defaultObject, String defaultLabel) {
        boolean allowMultiInput = indexType == IndexType.Numeric_Range;
        IndexVariableFactory factory = IndexVariableFactory.buildFactory().withMultipleInputAllowed(allowMultiInput).andRepository(classRepository);
        return factory.createIndexVariableForField(defaultLabel, null, fieldDefinition, defaultObject);
    }

    @Deprecated
    public static Variable createVariableForFieldDefinition(FieldDefinition fieldDefinition, IndexType indexType, ClassRepository classRepository, ValueFieldCompositeObject defaultObject, String defaultLabel) {
        String dfltString;
        ValueFieldCompositeObject obj = defaultObject;
        final FieldDefinition kfd = classRepository.getFieldDefinitionByName(defaultLabel);
        assert (kfd != null) : "Key field " + fieldDefinition.getKeyField() + " not found in class repository.";
        DataType keyDataType = kfd.getTypedDataType();
        String fieldname = kfd.getFieldName();
        final String min = FieldDefinitionHelper.getMinValue(kfd);
        final String max = FieldDefinitionHelper.getMaxValue(kfd);
        String string = dfltString = kfd.getDefaultValue() != null ? kfd.getDefaultValue() : keyDataType.makeParseableString(keyDataType.createDefaultInstance());
        if (obj == null) {
            obj = ValueFieldCompositeObject.createForValue(dfltString, keyDataType);
        } else if (obj.getValueDataType() != keyDataType) {
            obj = obj.getValueDataType() == null && keyDataType.parseValue(obj.getFieldOrValueAsString()) != null ? ValueFieldCompositeObject.createForValue(obj.getFieldOrValueAsString(), keyDataType) : ValueFieldCompositeObject.createForValue(dfltString, keyDataType);
        }
        IndexVariableFactory factory = VariableFactory.buildIndexVariableFactory().withRepository(classRepository);
        String[] keyFields = factory.extractFieldNameListForDataType(keyDataType);
        ValueFieldVariable.ValueType[] types = new ValueFieldVariable.ValueType[]{new ValueFieldVariable.ValueType(null, keyDataType){

            @Override
            public Variable createVariable(String label, String value) {
                Variable var;
                String useValue;
                String string = useValue = value != null ? value : dfltString;
                if (this.getDataType() == DataType.DATE) {
                    var = VariableFactory.createDateVariable(label, label, kfd);
                    ((Variable)var).setValue(value);
                } else {
                    var = VariableFactory.getVariableOfDataType(this.getDataType().getTypeName(), label, null, min, max, useValue);
                }
                return var;
            }
        }};
        return ValueFieldVariable.createForMultipleTypes(fieldname, obj, keyFields, types);
    }

    @Deprecated
    public static Variable createFieldOrValueVariableForField(String label, FieldDefinition fd, IndexType indexType, ClassRepository classRepository, DataType dataType, ValueFieldCompositeObject defaultObject) {
        throw new IllegalArgumentException("This method returns incorrect variable lists and should not be used.");
    }

    @Deprecated
    public static Variable createInputVariable(String label, String key, FieldDefinition fieldDef, ClassRepository rep, String defaultValue) throws Exception {
        return VariableFactory.createInputVariable(label, key, fieldDef, rep, defaultValue, null);
    }

    public static Variable createInputVariable(String label, String key, FieldDefinition fieldDef, ClassRepository rep, String defaultValue, Location location) throws Exception {
        if (fieldDef == null) {
            return null;
        }
        DataType theType = fieldDef.getTypedDataType();
        return VariableFactory.createInputVariable(label, key, fieldDef, rep, defaultValue, location, theType);
    }

    public static Variable createInputVariable(String label, String key, FieldDefinition fieldDef, ClassRepository rep, String defaultValue, Location location, DataType theType) throws Exception {
        if (fieldDef == null) {
            return null;
        }
        DataType dataType = theType;
        if (dataType == null) {
            dataType = fieldDef.getTypedDataType();
        }
        String labelToUse = label != null ? label : fieldDef.getFieldName();
        XMLInitializable editComponent = VariableFactory.extractEditComponentIfPresent(fieldDef);
        Variable theVariable = null;
        boolean setValue = true;
        Object varValueObject = null;
        String varValueString = defaultValue;
        if (varValueString == null) {
            if (fieldDef.isArray()) {
                ValueResolver resolver = FieldDefinitionUtil.createValueResolver(rep, fieldDef);
                varValueObject = resolver.createDefaultInstance();
            } else {
                varValueString = fieldDef.getDefaultValue();
            }
        }
        if (VariableFactory.isSimulationEditorForLocation(editComponent, location)) {
            if (fieldDef.hasValueClassFactory() && varValueString != null) {
                varValueObject = fieldDef.getValueClassFactory().parseValueString(varValueString);
            }
            SimulationEditor simEdit = (SimulationEditor)((Object)editComponent);
            simEdit.setFieldDefinition(fieldDef);
            if (simEdit instanceof EnumEditor) {
                ((EnumEditor)simEdit).removeUnparsableValues(dataType);
            }
            if ((theVariable = simEdit.createVariable()) instanceof ClassRepositoryUser) {
                ((ClassRepositoryUser)((Object)theVariable)).setClassRepository(rep);
            }
            if (theVariable instanceof BitPatternInputVariable) {
                ((BitPatternInputVariable)theVariable).setIsFoldable(false);
            }
            theVariable.setLabel(labelToUse);
            VariableFactory.updateVariableWithKeyIfNotNull(theVariable, key);
        } else {
            switch (dataType) {
                case OBJECT: {
                    theVariable = new NotAllowedVariable(labelToUse, dataType.getTypeName() + " NOT supported");
                    setValue = false;
                    break;
                }
                case AMOUNT: {
                    theVariable = VariableFactory.createAmountVariableForField(labelToUse, key, rep, fieldDef, null, false);
                    break;
                }
                case DATE: {
                    theVariable = VariableFactory.createDateVariable(labelToUse, key, fieldDef);
                    break;
                }
                case TIME: {
                    theVariable = VariableFactory.createDateTimeVariable(labelToUse, key, fieldDef);
                    break;
                }
                default: {
                    Object temp = dataType.createDefaultInstance();
                    theVariable = VariableFactory.getVariableOfDataType(dataType.getTypeName(), labelToUse, fieldDef.getVariableAttributes(), null, null, temp);
                    VariableFactory.updateVariableWithKeyIfNotNull(theVariable, key);
                }
            }
        }
        if (setValue) {
            if (varValueObject != null) {
                theVariable.setValue(varValueObject);
            } else if (varValueString != null) {
                theVariable.setValue(varValueString);
            }
        }
        return theVariable;
    }

    public static IndexVariableFactory.IndexVariableFactoryBuilder buildIndexVariableFactory() {
        return IndexVariableFactory.buildFactory();
    }

    private static boolean isSimulationEditorForLocation(Object editComponent, Location location) {
        if (!(editComponent instanceof SimulationEditor)) {
            return false;
        }
        if (!(editComponent instanceof LocationDependent)) {
            return true;
        }
        return location == null || ((LocationDependent)editComponent).isApplicableIn(location);
    }

    private static XMLInitializable extractEditComponentIfPresent(FieldDefinition fieldDef) throws Exception {
        XMLInitializable editComponent = fieldDef.createUtil("EditComponent");
        if (editComponent == null) {
            editComponent = fieldDef.createUtil("InputRestriction");
        }
        return editComponent;
    }

    private static void updateVariableWithKeyIfNotNull(Variable variable, String key) {
        if (key != null) {
            variable.setKey(key);
        }
    }

    static class ExcludeNonmappableFieldPredicate
    implements Predicate<String> {
        private ClassRepository myRep;

        ExcludeNonmappableFieldPredicate(ClassRepository repository) {
            this.myRep = repository;
        }

        @Override
        public boolean test(String object) {
            FieldDefinition def = this.myRep.getFieldDefinitionByName(object);
            return def != null && def.isAutoConditionMapAllowed();
        }
    }

    public static enum IndexType {
        Numeric_Range,
        Pos_Integer_Numeric,
        Alphanumeric;

    }
}

