/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.integration.config;

import ericsson.ere.integration.config.ConfigurationException;
import ericsson.ere.integration.util.ObjectRepository;
import ericsson.ere.xml.XMLUtil;
import java.util.Hashtable;
import java.util.List;
import org.w3c.dom.Element;

public class ArgumentHandler {
    public static final String TAG_ARGUMENT = "Argument";
    public static final String ATTR_NAME = "Name";
    public static final String ATTR_VALUE = "Value";
    public static final String ATTR_DESCRIPTION = "Description";
    Hashtable<String, Object> myArguments = new Hashtable();

    public ArgumentHandler(Element root) throws ConfigurationException {
        List<Element> argumentList = XMLUtil.getElementNodesNamed(TAG_ARGUMENT, root.getChildNodes());
        for (int i = 0; i < argumentList.size(); ++i) {
            if (!(argumentList.get(i) instanceof Element)) continue;
            Element argument = argumentList.get(i);
            String name = argument.getAttribute(ATTR_NAME);
            if (name == null || name.length() == 0) {
                throw new ConfigurationException("Name was not found in Argument-tag: " + argument.toString());
            }
            String value = argument.getAttribute(ATTR_VALUE);
            if (value != null && value.length() > 0) {
                this.myArguments.put(name, value);
                continue;
            }
            if (argument.getAttribute("Class").length() > 0 || argument.getAttribute("ObjectRef").length() > 0) {
                try {
                    Object o = ObjectRepository.getInstance().getObject(argument);
                    if (o == null) continue;
                    this.myArguments.put(name, o);
                    continue;
                }
                catch (Exception e) {
                    throw new ConfigurationException(e.getMessage());
                }
            }
            throw new ConfigurationException("Argument tag faulty: " + argument.toString());
        }
    }

    public Object getArgument(String argument) {
        return this.myArguments.get(argument);
    }

    public String getArgumentAsString(String argument) {
        Object o = this.myArguments.get(argument);
        if (o != null) {
            return o.toString();
        }
        return null;
    }

    public int getArgumentAsInt(String argument) {
        Object o = this.myArguments.get(argument);
        if (o != null) {
            try {
                return Integer.parseInt(o.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return -1;
    }

    public boolean hasArgument(String argument) {
        return this.myArguments.get(argument) != null;
    }

    public boolean isArgumentAnInt(String argument) {
        try {
            Integer.parseInt(this.myArguments.get(argument).toString());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

