/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.integration.connector.http;

import com.ericsson.ere.constraint.ConstraintModel;
import com.ericsson.ere.constraint.entity.Constrainable;
import com.ericsson.ere.constraint.entity.Constraint;
import com.ericsson.ere.constraint.entity.ConstraintTarget;
import com.ericsson.ere.constraint.entity.ConstraintTargetType;
import com.ericsson.ere.functioncontrol.FunctionContext;
import com.ericsson.ere.functioncontrol.FunctionController;
import com.ericsson.ere.functioncontrol.FunctionControllerProvider;
import com.ericsson.ere.functioncontrol.FunctionState;
import com.ericsson.ere.functioncontrol.FunctionToken;
import com.ericsson.ere.gui.navigator.NavigatorTree;
import com.ericsson.ere.gui.navigator.popupmenus.ServicePopupMenu;
import com.ericsson.ere.proxy.EreProxy;
import com.ericsson.ere.proxy.InternalEreProxy;
import com.ericsson.ere.proxy.RatingManagerProxy;
import com.ericsson.ere.proxy.ServiceListProxy;
import com.ericsson.ere.proxy.factory.DefaultProxyFactory;
import com.ericsson.ere.proxy.factory.ProxyFactory;
import com.ericsson.ere.selectiontree.structures.DebugDefaultTreeStructureProfile;
import ericsson.ere.integration.connector.AbstractConnector;
import ericsson.ere.integration.connector.http.HttpClientConnector;
import ericsson.ere.integration.connector.http.NavigatorMenuBuilder;
import ericsson.ere.integration.connector.http.RatingManagerMenuBuilder;
import ericsson.ere.xml.XMLUtil;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DebugHttpClientConnector
extends HttpClientConnector
implements FunctionControllerProvider {
    @Override
    public ProxyFactory getProxyFactory() {
        return new DebugProxyFactory();
    }

    @Override
    public FunctionController getFunctionController() {
        return new PermitAllFunctionController();
    }

    @Override
    public NavigatorMenuBuilder getNavigatorMenuBuilderForNavigatorTree(NavigatorTree tree) {
        return new RatingManagerMenuBuilder(tree){

            @Override
            public void registerCustomPopupMenus(NavigatorTree tree) {
                super.registerCustomPopupMenus(tree);
                tree.registerPopupMenu(new ServicePopupMenu(tree), CustomServiceListProxy.class);
            }
        };
    }

    private static class PermitAllFunctionController
    implements FunctionController {
        private PermitAllFunctionController() {
        }

        @Override
        public FunctionState getStateForFunction(FunctionToken token, FunctionContext ctx) {
            return FunctionState.createFunctionState(FunctionState.State.ON);
        }
    }

    private static class CustomServiceListProxy
    extends ServiceListProxy {
        private XPathFactory myXPathFactory = XPathFactory.newInstance();

        CustomServiceListProxy(AbstractConnector anyConnector, RatingManagerProxy parentProxy) {
            super(anyConnector, parentProxy);
        }

        @Override
        protected Element getNewServiceDefinition(String name) throws Exception {
            Element def = super.getNewServiceDefinition(name);
            ConstraintModel model = this.createConstraintModel();
            String xml = model.getXMLRepresentation();
            Element constraints = XMLUtil.documentFromString(xml).getDocumentElement();
            Node copy = def.getOwnerDocument().importNode(constraints, true);
            def.appendChild(copy);
            return def;
        }

        @Override
        protected Element getNewServiceSettings() throws Exception {
            Element set = super.getNewServiceSettings();
            XPath xp = this.myXPathFactory.newXPath();
            Node node = (Node)xp.evaluate("//TariffStructure[@name='TariffStructure']/@profile", set, XPathConstants.NODE);
            node.setNodeValue(DebugDefaultTreeStructureProfile.class.getName());
            return set;
        }

        private ConstraintModel createConstraintModel() {
            ConstraintTarget allFeatures = ConstraintTarget.createTargetForAll(ConstraintTargetType.FEATURE);
            Constraint allConditionFeatures = new Constraint.ConstraintBuilder(allFeatures, Constrainable.createGeneral(Constrainable.ConstrainableType.CONDITION)).setInclude().build();
            Constraint allModifierFeatures = new Constraint.ConstraintBuilder(allFeatures, Constrainable.createGeneral(Constrainable.ConstrainableType.MODIFIER)).setInclude().build();
            Constraint allNodeFeatures = new Constraint.ConstraintBuilder(allFeatures, Constrainable.createGeneral(Constrainable.ConstrainableType.NODE)).setInclude().build();
            Constraint allTariffStructureFeatures = new Constraint.ConstraintBuilder(allFeatures, Constrainable.createGeneral(Constrainable.ConstrainableType.TARIFF_STRUCTURE)).setInclude().build();
            ConstraintModel model = ConstraintModel.createEmptyModel();
            model.addConstraint(allConditionFeatures);
            model.addConstraint(allModifierFeatures);
            model.addConstraint(allNodeFeatures);
            model.addConstraint(allTariffStructureFeatures);
            return model;
        }
    }

    private static class DebugProxyFactory
    extends DefaultProxyFactory {
        private DebugProxyFactory() {
        }

        @Override
        public RatingManagerProxy createRatingManagerProxy(AbstractConnector connector, EreProxy parentProxy) {
            if (!(parentProxy instanceof InternalEreProxy)) {
                throw new IllegalArgumentException("The DebugHttpClientConnector can only be used for the internal ERE.");
            }
            return super.createRatingManagerProxy(connector, parentProxy);
        }

        @Override
        public ServiceListProxy createServiceListProxy(AbstractConnector connector, RatingManagerProxy parentProxy) {
            return new CustomServiceListProxy(connector, parentProxy);
        }
    }
}

