/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.integration.connector.http;

import com.ericsson.ere.gui.editors.propertyeditor.DefaultNavigatorNodeEditor;
import com.ericsson.ere.gui.editors.propertyeditor.DefaultNewRatingPeriodProxyEditor;
import com.ericsson.ere.gui.editors.propertyeditor.DefaultNewServiceProxyEditor;
import com.ericsson.ere.gui.editors.propertyeditor.DefaultRatingPeriodProxySettingsEditor;
import com.ericsson.ere.gui.editors.propertyeditor.DefaultSaveAsRatingPeriodProxyEditor;
import com.ericsson.ere.gui.editors.propertyeditor.DefaultServiceProxySettingsEditor;
import com.ericsson.ere.proxy.RatingManagerProxy;
import com.ericsson.ere.proxy.RatingPeriodProxy;
import com.ericsson.ere.proxy.RatingPlanProxy;
import com.ericsson.ere.proxy.ServiceListProxy;
import com.ericsson.ere.proxy.ServiceProviderProxy;
import com.ericsson.ere.proxy.ServiceProxy;
import com.ericsson.ere.util.TypedKey;
import ericsson.ere.integration.connector.AbstractConnector;
import ericsson.ere.integration.connector.EreCommunicationException;
import ericsson.ere.integration.connector.EreConnector;
import ericsson.ere.integration.connector.RatingRuleTreeConnector;
import ericsson.ere.integration.connector.ServiceConnector;
import ericsson.ere.integration.connector.http.HttpRequestSender;
import ericsson.ere.integration.connector.http.RemotePropertyHandler;
import ericsson.ere.integration.settingsmap.SettingsMap;
import ericsson.ere.management.RatingPeriod;
import ericsson.ere.management.Service;
import ericsson.ere.xml.DomWriter;
import ericsson.ere.xml.XMLUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class HttpClientConnector
extends AbstractConnector
implements RemotePropertyHandler {
    private HttpRequestSender mySender;
    private Element ratingManagerElement = null;
    private SettingsMap myErePropertyMap = null;
    private String myServiceProviderName = null;
    private String myRatingPlanName = null;
    private String myRatingPeriodName = null;
    private String myStartTime = null;
    private String myRatingPeriodServiceName;
    private String myServiceName = null;
    private String myServiceDefinitionFile = null;
    private String myServiceConditionFile = null;

    @Override
    public SettingsMap getErePropertyMap() {
        return this.myErePropertyMap;
    }

    @Override
    public void init(String type, SettingsMap settings) throws EreCommunicationException {
        if (this.myErePropertyMap == null) {
            this.myErePropertyMap = settings;
        } else {
            this.myErePropertyMap.updateParametersFrom(settings);
        }
        this.mySender = this.createRequestSender();
    }

    protected HttpRequestSender createRequestSender() {
        return new HttpRequestSender(this.myErePropertyMap);
    }

    @Override
    public boolean isAlive() {
        try {
            return this.mySender.isAlive();
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public String getRatingManagerName() {
        return this.ratingManagerElement != null ? this.ratingManagerElement.getAttribute("Name") : "Rating Manager";
    }

    @Override
    public void refreshRatingManagerDocument() throws EreCommunicationException {
        try {
            this.ratingManagerElement = this.mySender.getRatingManagerElement();
        }
        catch (Exception e) {
            throw new EreCommunicationException((EreConnector)this, e.getMessage(), e);
        }
    }

    @Override
    public Element getServiceElement(String serviceName) throws EreCommunicationException {
        Element elementToReturn = null;
        try {
            String xml = this.mySender.getServiceXMLString(serviceName);
            Element root = XMLUtil.buildDocumentFromString(xml).getDocumentElement();
            elementToReturn = XMLUtil.getFirstElementNamed("Service", root);
        }
        catch (Exception e) {
            throw new EreCommunicationException((EreConnector)this, e.getMessage(), e);
        }
        return elementToReturn;
    }

    @Override
    public Service getService(String serviceName) throws EreCommunicationException {
        try {
            return this.mySender.getService(serviceName);
        }
        catch (Exception e) {
            throw new EreCommunicationException((EreConnector)this, e.getMessage(), e);
        }
    }

    @Override
    public String getId() {
        return this.mySender.getId();
    }

    @Override
    public Element getRatingPeriodRuleTree(RatingPeriodProxy ratingPeriodProxy) throws EreCommunicationException {
        Element ratingPeriodRuleTreeElement = null;
        try {
            ratingPeriodRuleTreeElement = this.mySender.getRatingPeriodRuleTree(ratingPeriodProxy);
        }
        catch (Exception e) {
            throw new EreCommunicationException((EreConnector)this, e.getMessage(), e);
        }
        return ratingPeriodRuleTreeElement;
    }

    @Deprecated
    public Document getRatingPeriodRuleTree(RatingPeriod ratingPeriod) throws EreCommunicationException {
        try {
            String xmlDefinition = this.mySender.getRatingPeriodRuleTree(ratingPeriod);
            return XMLUtil.buildDocumentFromString(xmlDefinition);
        }
        catch (Exception e) {
            throw new EreCommunicationException((EreConnector)this, e.getMessage(), e);
        }
    }

    @Override
    public String[] getServiceList() throws EreCommunicationException {
        try {
            return this.mySender.getServiceList();
        }
        catch (Exception e) {
            throw new EreCommunicationException((EreConnector)this, e.getMessage(), e);
        }
    }

    @Override
    public Element getServiceListElement() throws EreCommunicationException {
        Element result = XMLUtil.getFirstElementNamed("ServiceList", this.ratingManagerElement);
        return result;
    }

    public Vector<String> getServiceProviderList() {
        Vector<String> result = new Vector<String>();
        Element serviceProviderListElement = XMLUtil.getFirstElementNamed("ServiceProviderList", this.ratingManagerElement);
        List<Element> providers = XMLUtil.getElementNodesNamed("ServiceProvider", serviceProviderListElement.getChildNodes());
        result.addAll(this.getAttributeValues(providers, "Name"));
        return result;
    }

    public Vector<String> getRatingPlanNameList(String serviceProviderName) throws EreCommunicationException {
        Vector<String> result = new Vector<String>();
        Element serviceProviderListElement = XMLUtil.getFirstElementNamed("ServiceProviderList", this.ratingManagerElement);
        Node selectedProvider = XMLUtil.getElementWithNameAndAttribute("ServiceProvider", "Name", serviceProviderName, serviceProviderListElement.getChildNodes());
        if (selectedProvider != null) {
            List<Element> plans = XMLUtil.getElementNodesNamed("RatingPlan", selectedProvider.getChildNodes());
            result.addAll(this.getAttributeValues(plans, "Name"));
        }
        return result;
    }

    private List<String> getAttributeValues(List<Element> elems, String attr) {
        ArrayList<String> result = new ArrayList<String>();
        for (Element e : elems) {
            if (!e.hasAttribute(attr)) continue;
            result.add(e.getAttribute(attr));
        }
        return result;
    }

    @Override
    public Element getRatingPlanElement(String serviceProviderName, String ratingPlanName) throws EreCommunicationException {
        Element result = null;
        Element serviceProviderListElement = XMLUtil.getFirstElementNamed("ServiceProviderList", this.ratingManagerElement);
        Node selectedProvider = XMLUtil.getElementWithNameAndAttribute("ServiceProvider", "Name", serviceProviderName, serviceProviderListElement.getChildNodes());
        if (selectedProvider != null) {
            Node selectedPlan = XMLUtil.getElementWithNameAndAttribute("RatingPlan", "Name", ratingPlanName, selectedProvider.getChildNodes());
            result = (Element)selectedPlan;
        }
        return result;
    }

    @Override
    public void createServiceProvider(SettingsMap model) throws EreCommunicationException {
        try {
            this.mySender.createServiceProvider(model);
        }
        catch (Exception e) {
            throw new EreCommunicationException((EreConnector)this, e.getMessage(), e);
        }
    }

    @Override
    public void updateServiceProvider(ServiceProviderProxy serviceProviderProxy, SettingsMap newValues) throws EreCommunicationException {
        try {
            this.mySender.updateServiceProvider(serviceProviderProxy, newValues);
        }
        catch (Exception e) {
            throw new EreCommunicationException((EreConnector)this, e.getMessage(), e);
        }
    }

    @Override
    public void removeServiceProvider(ServiceProviderProxy serviceProviderProxy) throws EreCommunicationException {
        try {
            this.mySender.removeServiceProvider(serviceProviderProxy);
        }
        catch (Exception e) {
            throw new EreCommunicationException((EreConnector)this, e.getMessage(), e);
        }
    }

    @Override
    public void createRatingPlan(ServiceProviderProxy serviceProviderProxy, SettingsMap newValues) throws EreCommunicationException {
        try {
            this.mySender.createRatingPlan(serviceProviderProxy, newValues);
        }
        catch (Exception e) {
            throw new EreCommunicationException((EreConnector)this, e.getMessage(), e);
        }
    }

    @Override
    public void updateRatingPlan(RatingPlanProxy ratingPlanProxy, SettingsMap newValues) throws EreCommunicationException {
        try {
            this.mySender.updateRatingPlan(ratingPlanProxy, newValues);
        }
        catch (Exception e) {
            throw new EreCommunicationException((EreConnector)this, e.getMessage(), e);
        }
    }

    @Override
    public void updateRatingPeriod(RatingPeriodProxy ratingPeriodProxy, SettingsMap newValues) throws EreCommunicationException {
        try {
            String newRatingPeriodName = newValues.getParameterAsString("Name");
            String newStartDate = newValues.getParameterAsString("Start date");
            Element oldRatingPeriod = this.mySender.getRatingPeriodRuleTree(ratingPeriodProxy);
            Element tariffStructureElement = XMLUtil.getFirstElementNamed("TariffStructure", oldRatingPeriod);
            tariffStructureElement.setAttribute("Name", newRatingPeriodName);
            this.mySender.updateRatingPeriod(ratingPeriodProxy, newValues);
            String tString = DomWriter.elementToString(tariffStructureElement);
            this.mySender.updateRatingPeriod(ratingPeriodProxy.getServiceProviderName(), ratingPeriodProxy.getRatingPlanName(), newRatingPeriodName, newStartDate, tString);
        }
        catch (Exception e) {
            throw new EreCommunicationException((EreConnector)this, e.getMessage(), e);
        }
    }

    @Override
    public void removeRatingPlan(RatingPlanProxy ratingPlanProxy) throws EreCommunicationException {
        try {
            this.mySender.removeRatingPlan(ratingPlanProxy);
        }
        catch (Exception e) {
            throw new EreCommunicationException((EreConnector)this, e.getMessage(), e);
        }
    }

    @Override
    public Element getRatingPeriodElement(RatingPeriodProxy ratingPeriodProxy) throws EreCommunicationException {
        try {
            String xml = this.mySender.getRatingPeriod(ratingPeriodProxy);
            NodeList responseList = XMLUtil.buildDocumentFromString(xml).getDocumentElement().getChildNodes();
            if (responseList.getLength() < 0) {
                throw new Exception("RatingPeriod '" + ratingPeriodProxy.getName() + "' NOT in the Response");
            }
            return XMLUtil.getNamedElement("RatingPeriod", responseList);
        }
        catch (Exception e) {
            throw new EreCommunicationException((EreConnector)this, e.getMessage(), e);
        }
    }

    @Override
    public void createRatingPeriod(RatingPlanProxy ratingPlanProxy, SettingsMap newValues, Element newStructureXML) throws EreCommunicationException {
        try {
            this.mySender.createRatingPeriod(ratingPlanProxy, newValues, newStructureXML);
        }
        catch (Exception e) {
            throw new EreCommunicationException((EreConnector)this, e.getMessage(), e);
        }
    }

    @Override
    public void removeRatingPeriod(RatingPeriodProxy ratingPeriodProxy) throws EreCommunicationException {
        try {
            this.mySender.removeRatingPeriod(ratingPeriodProxy);
        }
        catch (Exception e) {
            throw new EreCommunicationException((EreConnector)this, e.getMessage(), e);
        }
    }

    @Override
    public void createService(ServiceListProxy serviceListProxy, SettingsMap newValues, Element newDefinitionXML, Element newConditionXML) throws EreCommunicationException {
        try {
            this.mySender.createService(serviceListProxy, newValues, newDefinitionXML, newConditionXML);
        }
        catch (Exception e) {
            throw new EreCommunicationException((EreConnector)this, e.getMessage(), e);
        }
    }

    @Override
    public void removeService(ServiceProxy serviceProxy) throws EreCommunicationException {
        try {
            this.mySender.removeService(serviceProxy);
        }
        catch (Exception e) {
            throw new EreCommunicationException((EreConnector)this, e.getMessage(), e);
        }
    }

    @Override
    public void updateService(ServiceProxy serviceProxy, SettingsMap newValues) throws EreCommunicationException {
        try {
            this.mySender.updateService(serviceProxy, newValues);
        }
        catch (Exception e) {
            throw new EreCommunicationException((EreConnector)this, e.getMessage(), e);
        }
    }

    @Override
    public void updateServiceCondition(Service service) throws EreCommunicationException {
        throw new EreCommunicationException(this, "NOT implemented yet !");
    }

    @Override
    public void updateServiceDefinition(Service service) throws EreCommunicationException {
        throw new EreCommunicationException(this, "NOT implemented yet !");
    }

    @Override
    public void updateRatingManager(RatingManagerProxy managerProxy, SettingsMap newValues) throws EreCommunicationException {
        try {
            this.mySender.updateRatingManager(managerProxy, newValues);
        }
        catch (Exception e) {
            throw new EreCommunicationException((EreConnector)this, e.getMessage(), e);
        }
    }

    @Deprecated
    public void setRatingPeriodProperties(String serviceProviderName, String ratingPlanName, String ratingPeriodName, String startTime) {
        this.myServiceProviderName = serviceProviderName;
        this.myRatingPlanName = ratingPlanName;
        this.myRatingPeriodName = ratingPeriodName;
        this.myStartTime = startTime;
    }

    protected void setRatingPeriodProperties(String serviceName, String serviceProviderName, String ratingPlanName, String ratingPeriodName, String startTime) {
        this.myRatingPeriodServiceName = serviceName;
        this.myServiceProviderName = serviceProviderName;
        this.myRatingPlanName = ratingPlanName;
        this.myRatingPeriodName = ratingPeriodName;
        this.myStartTime = startTime;
    }

    @Override
    public RatingRuleTreeConnector getRatingRuleTreeConnector(RatingPeriodProxy ratingPeriodProxy) throws EreCommunicationException {
        HttpClientConnector myConnector = new HttpClientConnector();
        myConnector.init(null, (SettingsMap)this.getErePropertyMap().clone());
        myConnector.setRatingPeriodProperties(ratingPeriodProxy.getServiceName(), ratingPeriodProxy.getServiceProviderName(), ratingPeriodProxy.getRatingPlanName(), ratingPeriodProxy.getName(), ratingPeriodProxy.getRatingPeriodStartTime());
        return myConnector;
    }

    @Override
    public void updateRatingPlan(Element ratingPeriodStructureElement) throws EreCommunicationException {
        try {
            String tString = DomWriter.elementToString(ratingPeriodStructureElement);
            this.mySender.updateRatingPeriod(this.myServiceProviderName, this.myRatingPlanName, this.myRatingPeriodName, this.myStartTime, tString);
        }
        catch (Exception e) {
            throw new EreCommunicationException((EreConnector)this, e.getMessage(), e);
        }
    }

    @Override
    public void disConnect() {
        this.mySender.forgetCredentials();
    }

    protected void setServiceProperties(String serviceName, String definitionFile, String conditionFile) {
        this.myServiceName = serviceName;
        this.myServiceDefinitionFile = definitionFile;
        this.myServiceConditionFile = conditionFile;
    }

    @Override
    public ServiceConnector getServiceConnector(ServiceProxy serviceProxy) throws EreCommunicationException {
        HttpClientConnector myConnector = new HttpClientConnector();
        myConnector.init(null, (SettingsMap)this.getErePropertyMap().clone());
        myConnector.setServiceProperties(serviceProxy.getName(), serviceProxy.getServiceDefinitionFileName(), serviceProxy.getServiceConditionFileName());
        return myConnector;
    }

    @Override
    public void updateService(Element serviceDefinitionStructure, Element serviceConditionStructure, boolean forced) throws EreCommunicationException {
        try {
            String definitionStructureBuffer = DomWriter.nodeToString(serviceDefinitionStructure, true);
            String conditionStructureBuffer = DomWriter.nodeToString(serviceConditionStructure, true);
            this.mySender.updateService(this.myServiceName, this.myServiceDefinitionFile, this.myServiceConditionFile, definitionStructureBuffer, conditionStructureBuffer, forced);
        }
        catch (EreCommunicationException ece) {
            ece.setConnector(this);
            throw ece;
        }
        catch (Exception e) {
            throw new EreCommunicationException((EreConnector)this, e.getMessage(), e);
        }
    }

    @Override
    public void updateService(Element definitionStruct, Element conditionStruct, SettingsMap settings, boolean forced) throws EreCommunicationException {
        try {
            String definitionStructureBuffer = DomWriter.nodeToString(definitionStruct, true);
            String conditionStructureBuffer = DomWriter.nodeToString(conditionStruct, true);
            String serviceDefFile = settings.getParameterAsString("Service definition file");
            String serviceCondFile = settings.getParameterAsString("Service condition file");
            this.mySender.updateService(this.myServiceName, serviceDefFile, serviceCondFile, definitionStructureBuffer, conditionStructureBuffer, forced);
        }
        catch (EreCommunicationException ece) {
            ece.setConnector(this);
            throw ece;
        }
        catch (Exception e) {
            throw new EreCommunicationException((EreConnector)this, e.getMessage(), e);
        }
    }

    @Override
    @Deprecated
    public String getProperty(String key) {
        if (this.myErePropertyMap.getParameter(key) != null) {
            return this.myErePropertyMap.getParameter(key).getValue();
        }
        return null;
    }

    @Override
    public Class<?> getEditProxyEditorForClass(Class<?> editorFor) {
        if (editorFor == RatingPeriodProxy.class) {
            return DefaultRatingPeriodProxySettingsEditor.class;
        }
        if (editorFor == ServiceProxy.class) {
            return DefaultServiceProxySettingsEditor.class;
        }
        return DefaultNavigatorNodeEditor.class;
    }

    @Override
    public Class<?> getCreateProxyEditorForClass(Class<?> editorFor) {
        if (editorFor == RatingPeriodProxy.class) {
            return DefaultNewRatingPeriodProxyEditor.class;
        }
        if (editorFor == ServiceProxy.class) {
            return DefaultNewServiceProxyEditor.class;
        }
        return DefaultNavigatorNodeEditor.class;
    }

    @Override
    public Class<?> getSaveAsProxyEditorForClass() {
        return DefaultSaveAsRatingPeriodProxyEditor.class;
    }

    @Override
    public String[] getRemoteProperties(TypedKey[] keys) throws EreCommunicationException {
        return this.getProperties(keys);
    }

    @Override
    public String getRemoteProperty(TypedKey key) throws EreCommunicationException {
        String[] result = this.getProperties(new TypedKey[]{key});
        return result != null ? result[0] : null;
    }

    private String[] getProperties(TypedKey[] keys) throws EreCommunicationException {
        String[] properties = null;
        try {
            if (this.myServiceName != null) {
                properties = this.mySender.getServiceProperties(this.myServiceName, keys);
            } else if (this.myRatingPeriodName != null) {
                properties = this.mySender.getRatingPeriodProperties(this.myRatingPeriodServiceName, this.myServiceProviderName, this.myRatingPlanName, this.myRatingPeriodName, this.myStartTime, keys);
            }
        }
        catch (EreCommunicationException ece) {
            ece.setConnector(this);
            throw ece;
        }
        catch (Exception e) {
            throw new EreCommunicationException((EreConnector)this, e.getMessage(), e);
        }
        return properties;
    }

    @Override
    public void setRemoteProperties(TypedKey[] keys, String[] values) throws EreCommunicationException {
        this.setProperties(keys, values);
    }

    @Override
    public void setRemoteProperty(TypedKey key, String value) throws EreCommunicationException {
        this.setProperties(new TypedKey[]{key}, new String[]{value});
    }

    private void setProperties(TypedKey[] keys, String[] values) throws EreCommunicationException {
        try {
            if (this.myServiceName != null) {
                this.mySender.updateServiceProperties(this.myServiceName, keys, values);
            } else if (this.myRatingPeriodName != null) {
                this.mySender.updateRatingPeriodProperties(this.myRatingPeriodServiceName, this.myServiceProviderName, this.myRatingPlanName, this.myRatingPeriodName, this.myStartTime, keys, values);
            }
        }
        catch (EreCommunicationException ece) {
            ece.setConnector(this);
            throw ece;
        }
        catch (Exception e) {
            throw new EreCommunicationException((EreConnector)this, e.getMessage(), e);
        }
    }
}

