/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.integration.defs;

import ericsson.ere.xml.XMLUtil;

public class EreXmlCommand {
    public static final String CR = "\r";
    public static final String NL = "\n";
    public static final String TAG_REQUEST = "Request";
    public static final String TAG_USER = "User";
    public static final String TAG_RATINGMANAGER = "RatingManager";
    public static final String TAG_SERVICELIST = "ServiceList";
    public static final String TAG_SERVICE = "Service";
    public static final String TAG_MANAGER = "Manager";
    public static final String TAG_SERVICEPROVIDERLIST = "ServiceProviderList";
    public static final String TAG_SERVICEPROVIDER = "ServiceProvider";
    public static final String TAG_RATINGPLAN = "RatingPlan";
    public static final String TAG_RATINGPERIOD = "RatingPeriod";
    public static final String TAG_RATINGRULETREE = "RatingRuleTree";
    public static final String TAG_DEFINITION_FILE = "DefinitionFile";
    public static final String TAG_CONDITION_FILE = "ConditionFile";
    public static final String TAG_ERROR = "Error";
    public static final String TAG_PROPERTY = "Property";
    public static final String TAG_NEW_VALUES = "NewValues";
    public static final String TAG_PROVISIONING_EXCEPTION = "EreProvisioningException";
    public static final String LBL_NAME = "Name";
    public static final String LBL_DEFINITION_FILE = "Service definition file";
    public static final String LBL_CONDITION_FILE = "Service condition file";
    public static final String LBL_SERVICE = "Service";
    public static final String LBL_START_DATE = "Start date";
    public static final String LBL_RATINGSTRUCT_FILEREF = "Selection Tree file";
    public static final String LBL_RATINGRULETREE_FILEREF = "Rating Tree file";
    public static final String ATTR_MO = "MO";
    public static final String ATTR_OPERATION = "Operation";
    public static final String ATTR_SESSIONID = "SessionId";
    public static final String ATTR_NAME = "Name";
    public static final String ATTR_NEW_NAME = "NewName";
    public static final String ATTR_PWD = "Pwd";
    public static final String ATTR_SERVICE = "Service";
    public static final String ATTR_START_DATE = "StartDate";
    public static final String ATTR_NEW_STARTDATE = "NewStartDate";
    public static final String ATTR_RATINGSTRUCT_FILEREF = "RatingStructureFile";
    public static final String ATTR_DEFINITION_FILE = "DefinitionFile";
    public static final String ATTR_CONDITION_FILE = "ConditionLeafClassFile";
    public static final String ATTR_KEY = "key";
    public static final String ATTR_VALUE = "value";
    public static final String ATTR_NODE = "Node";
    public static final String ATTR_NODE_VALUE_INTERNAL = "internal";
    public static final String MO_SESSION = "Session";
    public static final String MO_RATINGMANAGER = "RatingManager";
    public static final String MO_SERVICE = "Service";
    public static final String MO_RATINGPERIOD = "RatingPeriod";
    public static final String MO_SERVICEPROVIDER = "ServiceProvider";
    public static final String MO_RATINGPLAN = "RatingPlan";
    public static final String MO_ECHO = "Echo";
    public static final String OP_LOGIN = "Login";
    public static final String OP_LOGOUT = "Logout";
    public static final String OP_GET = "Get";
    public static final String OP_CREATE = "Create";
    public static final String OP_DELETE = "Delete";
    public static final String OP_SET = "Set";
    public static final String OP_GET_PROPERTY = "GetProperty";
    public static final String OP_SET_PROPERTY = "SetProperty";
    public static final String EXT_RATINGRULEFILE = ".xml";
    public static final String VERSION_PREFIX = "_rev_";

    public static String createTag(String tag) {
        return "<" + tag + "/>";
    }

    public static String createAttribute(String name, String value) {
        return " " + name + "=\"" + value + "\" ";
    }

    public static String createProcessInstructionTag() {
        return EreXmlCommand.createProcessInstructionTag("1.0", "UTF-8");
    }

    public static String createProcessInstructionTag(String version, String encoding) {
        return "<?xml version=\"" + version + "\" encoding=\"" + encoding + "\"?>";
    }

    public static String createRequestStartTag(String mo, String operation, String sessionId) {
        return "<Request " + EreXmlCommand.createAttribute(ATTR_MO, mo) + EreXmlCommand.createAttribute(ATTR_OPERATION, operation) + EreXmlCommand.createAttribute(ATTR_SESSIONID, sessionId) + " >";
    }

    public static String createRequestEndTag() {
        return "</Request>";
    }

    public static String createTagWithAttributes(String tag, String ... attributes) {
        String s = "<" + tag;
        for (String attr : attributes) {
            if (!attr.startsWith(" ")) {
                s = s + " ";
            }
            s = s + attr;
        }
        return s + "/>";
    }

    @Deprecated
    public static String createTagWithAttribute(String tag, String attr1) {
        return "<" + tag + attr1 + "/>";
    }

    @Deprecated
    public static String createTagWithAttribute(String tag, String attr1, String attr2) {
        return "<" + tag + attr1 + attr2 + "/>";
    }

    @Deprecated
    public static String createTagWithAttribute(String tag, String attr1, String attr2, String attr3) {
        return "<" + tag + attr1 + attr2 + attr3 + "/>";
    }

    @Deprecated
    public static String createTagWithAttribute(String tag, String attr1, String attr2, String attr3, String attr4) {
        return "<" + tag + attr1 + attr2 + attr3 + attr4 + "/>";
    }

    public static String createStartTag(String tag) {
        return "<" + tag + ">";
    }

    public static String createStartTagWithAttributes(String tag, String ... attributes) {
        String s = "<" + tag;
        for (String attr : attributes) {
            if (!attr.startsWith(" ")) {
                s = s + " ";
            }
            s = s + attr;
        }
        return s + ">";
    }

    @Deprecated
    public static String createStartTagWithAttribute(String tag, String attr1) {
        return "<" + tag + attr1 + ">";
    }

    @Deprecated
    public static String createStartTagWithAttribute(String tag, String attr1, String attr2) {
        return "<" + tag + attr1 + attr2 + ">";
    }

    @Deprecated
    public static String createStartTagWithAttribute(String tag, String attr1, String attr2, String attr3) {
        return "<" + tag + attr1 + attr2 + attr3 + ">";
    }

    @Deprecated
    public static String createStartTagWithAttribute(String tag, String attr1, String attr2, String attr3, String attr4) {
        return "<" + tag + attr1 + attr2 + attr3 + attr4 + ">";
    }

    @Deprecated
    public static String createStartTagWithAttribute(String tag, String attr1, String attr2, String attr3, String attr4, String attr5) {
        return "<" + tag + attr1 + attr2 + attr3 + attr4 + attr5 + ">";
    }

    public static String createEndTag(String tag) {
        return "</" + tag + ">";
    }

    public static String loginRequest(String moName, String userName, String password, boolean isInternalEre) {
        String userTagWithAttributes = EreXmlCommand.createTagWithAttributes(TAG_USER, EreXmlCommand.createAttribute("Name", XMLUtil.escape(userName)), EreXmlCommand.createAttribute(ATTR_PWD, XMLUtil.escape(password)));
        if (isInternalEre) {
            userTagWithAttributes = EreXmlCommand.createTagWithAttributes(TAG_USER, EreXmlCommand.createAttribute("Name", XMLUtil.escape(userName)), EreXmlCommand.createAttribute(ATTR_PWD, XMLUtil.escape(password)), EreXmlCommand.createAttribute(ATTR_NODE, XMLUtil.escape(ATTR_NODE_VALUE_INTERNAL)));
        }
        StringBuffer request = new StringBuffer();
        request.append(EreXmlCommand.createProcessInstructionTag("1.0", "UTF-8")).append(NL).append(EreXmlCommand.createRequestStartTag(moName, OP_LOGIN, "0")).append(NL).append(userTagWithAttributes).append(NL).append(EreXmlCommand.createRequestEndTag());
        return request.toString();
    }

    public static String loginRequest(String userName, String password, boolean isInternalEre) {
        return EreXmlCommand.loginRequest(MO_SESSION, userName, password, isInternalEre);
    }

    public static String loginRequest(String userName, String password) {
        return EreXmlCommand.loginRequest(userName, password, false);
    }

    public static String logoutRequest(String userName, String password, String sessionId) {
        return EreXmlCommand.createProcessInstructionTag("1.0", "UTF-8") + NL + EreXmlCommand.createRequestStartTag(MO_SESSION, OP_LOGOUT, sessionId) + NL + EreXmlCommand.createTagWithAttributes(TAG_USER, EreXmlCommand.createAttribute("Name", XMLUtil.escape(userName)), EreXmlCommand.createAttribute(ATTR_PWD, XMLUtil.escape(password))) + NL + EreXmlCommand.createRequestEndTag();
    }

    public static String createRatingManagerGetRequest(String sessionId) {
        return EreXmlCommand.createProcessInstructionTag("1.0", "UTF-8") + NL + EreXmlCommand.createRequestStartTag("RatingManager", OP_GET, sessionId) + NL + EreXmlCommand.createTag("RatingManager") + NL + EreXmlCommand.createRequestEndTag();
    }

    public static String createServiceListGetRequest(String sessionId) {
        return EreXmlCommand.createProcessInstructionTag("1.0", "UTF-8") + NL + EreXmlCommand.createRequestStartTag("Service", OP_GET, sessionId) + NL + EreXmlCommand.createRequestEndTag();
    }
}

