/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.integration.gui;

import ericsson.ere.gui.util.DialogFactory;
import ericsson.ere.gui.util.FileFilterImpl;
import ericsson.ere.gui.util.SwingWorker;
import ericsson.ere.integration.gui.DirectoryString;
import ericsson.ere.integration.gui.FileLoader;
import ericsson.ere.integration.gui.FileString;
import ericsson.ere.integration.gui.FilterBySuffix;
import ericsson.ere.integration.gui.HistoryRequest;
import ericsson.ere.integration.gui.MyCellRenderer;
import ericsson.ere.integration.sender.HTTPServerSender;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Iterator;
import java.util.TreeSet;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class RequestSender
extends JPanel {
    private JPanel myWorkArea;
    private JScrollPane requestSC;
    private JScrollPane responseSC;
    private int SelectionType = 0;
    private JList myXmlList;
    private DefaultListModel myListModel;
    private File myFile;
    private FilterBySuffix myFilter;
    private String myPath;
    private JTextField fileRootTextField;
    private JTextArea requestJTextArea;
    private JTextArea responseJTextArea;
    private JButton sendJButton;
    private JTextField myHostName = new JTextField("localhost");
    private JTextField myPortNumber = new JTextField("9000");
    private JTextField myUser = new JTextField();
    private JTextField myPwd = new JPasswordField();
    private JTextField myNoOfSendRequests = new JTextField("1", 5);
    private JTextField mySessionIdField = new JTextField("1", 9);
    private JButton myLoginButton = new JButton("Login");
    private JButton myLogoutButton = new JButton("Logout");
    private String mySessionId = "1";
    private DefaultComboBoxModel myHistory = new DefaultComboBoxModel();
    private JComboBox historyComboBox = new JComboBox(this.myHistory);
    private int myNumberOfRequests = 0;
    private HTTPServerSender mySender = new HTTPServerSender();

    private JScrollPane makeRequestJTextArea() {
        this.requestSC = new JScrollPane();
        this.requestJTextArea = new JTextArea();
        this.requestSC.setViewportView(this.requestJTextArea);
        return this.requestSC;
    }

    private JScrollPane makeResponseJTextArea() {
        this.responseSC = new JScrollPane();
        this.responseJTextArea = new JTextArea();
        this.responseSC.setViewportView(this.responseJTextArea);
        return this.responseSC;
    }

    private JPanel makeRequestButtonPanel() {
        JPanel myRequestButtonJPanel = new JPanel(new GridBagLayout());
        GridBagConstraints myConstr = new GridBagConstraints();
        myConstr.insets = new Insets(17, 5, 5, 5);
        this.sendJButton = new JButton("Send");
        this.sendJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingWorker worker = new SwingWorker(){

                    @Override
                    public Object construct() {
                        RequestSender.this.setButtonEnabled(false);
                        for (int i = 0; i < Integer.parseInt(RequestSender.this.myNoOfSendRequests.getText()); ++i) {
                            RequestSender.this.doRequest();
                        }
                        return null;
                    }

                    @Override
                    public void finished() {
                        RequestSender.this.setButtonEnabled(true);
                    }
                };
                worker.start();
            }
        });
        JButton clearJButton = new JButton("Clear");
        clearJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RequestSender.this.clearJTextfield(RequestSender.this.requestJTextArea);
            }
        });
        JButton mySaveJButton = new JButton("Save");
        mySaveJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RequestSender.this.savePushed();
            }
        });
        JButton mySaveAsJButton = new JButton("SaveAs");
        mySaveAsJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RequestSender.this.saveAsPushed();
            }
        });
        myConstr.fill = 0;
        myConstr.anchor = 13;
        myRequestButtonJPanel.add((Component)new JLabel("Send"), myConstr);
        myRequestButtonJPanel.add((Component)this.myNoOfSendRequests, myConstr);
        myRequestButtonJPanel.add((Component)new JLabel(" time(s)"), myConstr);
        myRequestButtonJPanel.add((Component)this.sendJButton, myConstr);
        myRequestButtonJPanel.add((Component)clearJButton, myConstr);
        myRequestButtonJPanel.add((Component)mySaveJButton, myConstr);
        myRequestButtonJPanel.add((Component)mySaveAsJButton, myConstr);
        JPanel extra = new JPanel(new BorderLayout());
        extra.add((Component)myRequestButtonJPanel, "East");
        this.myLoginButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RequestSender.this.login();
            }
        });
        this.myLogoutButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RequestSender.this.logout();
            }
        });
        return extra;
    }

    private void clearJTextfield(JTextArea clearThisJTextArea) {
        clearThisJTextArea.setText("");
    }

    private void savePushed() {
        if (this.requestJTextArea.getText().length() < 1) {
            DialogFactory.getErrorDialog("ErrorDialogHeader", "nothingToSave");
            return;
        }
        if (this.myXmlList.getSelectedValue() == null) {
            DialogFactory.getErrorDialog("ErrorDialogHeader", "UseSaveAsInstead");
            return;
        }
        String FullFilePath = this.fileRootTextField.getText() + File.separator + this.myXmlList.getSelectedValue().toString();
        File theFileToSave = new File(FullFilePath);
        theFileToSave.delete();
        try {
            FileLoader.saveFile(this.requestJTextArea.getText(), FullFilePath);
        }
        catch (Exception m) {
            DialogFactory.getErrorDialog("ErrorDialogHeader", "CouldNotSaveFile");
        }
    }

    private void saveAsPushed() {
        int returnVal;
        if (this.requestJTextArea.getText().length() < 1) {
            DialogFactory.getErrorDialog("ErrorDialogHeader", "nothingToSave");
            return;
        }
        JFileChooser chooser = new JFileChooser();
        FileFilterImpl filter = new FileFilterImpl();
        filter.addExtension("xml");
        filter.setDescription("XML - files");
        chooser.setFileFilter(filter);
        chooser.setCurrentDirectory(new File(this.myPath));
        int dialogAnswer = 2;
        while ((returnVal = chooser.showSaveDialog(this)) == 0) {
            File outfile = chooser.getSelectedFile();
            dialogAnswer = 0;
            if (outfile.exists()) {
                dialogAnswer = DialogFactory.getQuestionDialogWithCancel(this, "File exists", "The file '" + outfile.getPath() + " exists, overwrite existing file?");
            }
            if (dialogAnswer != 2) {
                try {
                    if (dialogAnswer == 0) {
                        FileLoader.saveFile(this.requestJTextArea.getText(), outfile.getPath());
                    }
                }
                catch (Exception e) {
                    DialogFactory.getErrorDialog("Error saving file ", "Could not save " + outfile.getPath() + " due to :\n" + e.getMessage());
                }
            }
            if (dialogAnswer == 2) continue;
        }
    }

    public RequestSender() {
        this.mySender.init();
        this.mySender.setLogLevel(4);
        this.historyComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object obj = RequestSender.this.myHistory.getSelectedItem();
                if (obj instanceof HistoryRequest) {
                    HistoryRequest request = (HistoryRequest)obj;
                    RequestSender.this.requestJTextArea.setText(request.getRequest());
                }
            }
        });
        this.historyComboBox.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent evt) {
                char ch = evt.getKeyChar();
                if (ch == '\u007f') {
                    RequestSender.this.myHistory.removeElement(RequestSender.this.historyComboBox.getSelectedItem());
                }
            }

            @Override
            public void keyReleased(KeyEvent evt) {
            }

            @Override
            public void keyTyped(KeyEvent evt) {
            }
        });
        this.myWorkArea = new JPanel(new BorderLayout());
        this.setLayout(new BorderLayout());
        this.add((Component)this.myWorkArea, "Center");
        this.setVisible(true);
    }

    public void init() {
        this.buildThisPanel();
    }

    private void buildThisPanel() {
        JPanel upperGridJPanel = new JPanel(new BorderLayout());
        JPanel reqHeader = new JPanel();
        reqHeader.setLayout(new BoxLayout(reqHeader, 0));
        reqHeader.add(this.historyComboBox);
        JPanel responseHeader = new JPanel(new BorderLayout());
        upperGridJPanel.add((Component)reqHeader, "North");
        upperGridJPanel.add((Component)this.makeRequestJTextArea(), "Center");
        upperGridJPanel.add((Component)this.makeRequestButtonPanel(), "South");
        JPanel lowerGridJPanel = new JPanel(new BorderLayout());
        lowerGridJPanel.add((Component)responseHeader, "North");
        lowerGridJPanel.add((Component)this.makeResponseJTextArea(), "Center");
        JButton myClearJButton = new JButton("Clear");
        myClearJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RequestSender.this.clearJTextfield(RequestSender.this.responseJTextArea);
            }
        });
        JPanel myP = new JPanel(new GridBagLayout());
        GridBagConstraints myConstr = new GridBagConstraints();
        myConstr.insets = new Insets(17, 5, 5, 5);
        myP.add((Component)myClearJButton, myConstr);
        JPanel newPanel = new JPanel(new BorderLayout());
        newPanel.add((Component)myP, "East");
        lowerGridJPanel.add((Component)newPanel, "South");
        JSplitPane inputOutputSplitPane = new JSplitPane(0, upperGridJPanel, lowerGridJPanel);
        inputOutputSplitPane.setDividerLocation(200);
        this.myWorkArea.add((Component)new JLabel("RequestSender"), "North");
        JSplitPane splitPane = new JSplitPane(1, this.getFileTree(), inputOutputSplitPane);
        splitPane.setOneTouchExpandable(true);
        splitPane.setDividerLocation(250);
        JPanel myMainRightPanel = new JPanel(new BorderLayout());
        myMainRightPanel.add((Component)splitPane, "Center");
        this.myWorkArea.add((Component)myMainRightPanel, "Center");
    }

    private JPanel getFileTree() {
        JPanel fileJPanel = new JPanel(new BorderLayout());
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.add((Component)new JLabel("XML Requests (*.xml)"), "West");
        fileJPanel.add((Component)topPanel, "North");
        JScrollPane myScrollPane = new JScrollPane();
        this.myListModel = new DefaultListModel();
        this.myXmlList = new JList(this.myListModel);
        this.myXmlList.setSelectionMode(this.SelectionType);
        MyCellRenderer myRenderer = new MyCellRenderer();
        this.myXmlList.setCellRenderer(myRenderer);
        myScrollPane.setViewportView(this.myXmlList);
        this.myFile = new File(".");
        try {
            this.myFile = new File(this.myFile.getCanonicalPath());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.myFilter = new FilterBySuffix();
        this.myFilter.addSuffix("xml");
        this.fillListModel(this.myFile);
        JPanel fileMainPanel = new JPanel(new BorderLayout());
        this.fileRootTextField = new JTextField(this.myFile.getPath());
        this.myPath = this.myFile.getPath();
        JPanel gridbagPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 1;
        c.insets = new Insets(5, 6, 5, 5);
        c.fill = 1;
        c.weightx = 0.0;
        gridbagPanel.add((Component)new JLabel("Host "), c);
        c.gridwidth = 0;
        gridbagPanel.add((Component)this.myHostName, c);
        c.gridwidth = 1;
        c.gridy = 1;
        gridbagPanel.add((Component)new JLabel("Port "), c);
        c.gridwidth = 0;
        gridbagPanel.add((Component)this.myPortNumber, c);
        c.gridwidth = 1;
        c.gridy = 2;
        gridbagPanel.add((Component)new JLabel("User "), c);
        c.gridwidth = 0;
        gridbagPanel.add((Component)this.myUser, c);
        c.gridwidth = 1;
        c.gridy = 3;
        gridbagPanel.add((Component)new JLabel("Pwd "), c);
        c.gridwidth = 0;
        gridbagPanel.add((Component)this.myPwd, c);
        c.gridwidth = 1;
        c.gridy = 4;
        this.mySessionIdField.setEditable(false);
        gridbagPanel.add((Component)this.mySessionIdField, c);
        gridbagPanel.add((Component)this.myLoginButton, c);
        gridbagPanel.add((Component)this.myLogoutButton, c);
        c.gridy = 5;
        gridbagPanel.add((Component)new JLabel("SessionId"), c);
        c.gridx = 1;
        gridbagPanel.add((Component)this.mySessionIdField, c);
        c.gridy = 6;
        c.gridx = 0;
        gridbagPanel.add((Component)new JLabel("Dir "), c);
        c.gridwidth = 0;
        c.weightx = 1.0;
        gridbagPanel.add((Component)this.fileRootTextField, c);
        this.fileRootTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RequestSender.this.dirEntered();
            }
        });
        fileMainPanel.add((Component)gridbagPanel, "North");
        fileMainPanel.add((Component)myScrollPane, "Center");
        fileJPanel.add((Component)fileMainPanel, "Center");
        this.myXmlList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                SwingWorker worker = new SwingWorker(){

                    @Override
                    public Object construct() {
                        RequestSender.this.setButtonEnabled(false);
                        RequestSender.this.xmlFileClicked();
                        return null;
                    }

                    @Override
                    public void finished() {
                        RequestSender.this.setButtonEnabled(true);
                    }
                };
                if (!evt.getValueIsAdjusting()) {
                    worker.start();
                }
            }
        });
        this.myXmlList.repaint();
        return fileJPanel;
    }

    private void fillListModel(File file_in) {
        String[] allFiles = file_in.list(this.myFilter);
        Object[] ObjectHolder = new Object[allFiles.length];
        this.myListModel.removeAllElements();
        if (file_in.getParentFile() != null) {
            this.myListModel.addElement(new FileString("", ".."));
        }
        int numberOfDirs = 0;
        int numberOfFiles = 0;
        for (int u = 0; u < allFiles.length; ++u) {
            try {
                String FullFilePath = file_in.getPath() + File.separator + allFiles[u];
                if (this.isDirectory(FullFilePath)) {
                    ObjectHolder[u] = new DirectoryString(FullFilePath, allFiles[u]);
                    ++numberOfDirs;
                    continue;
                }
                ObjectHolder[u] = new FileString(FullFilePath, allFiles[u]);
                ++numberOfFiles;
                continue;
            }
            catch (Exception U) {
                this.responseJTextArea.setText(this.responseJTextArea.getText() + "Exception in getpath : " + U.getMessage());
            }
        }
        TreeSet<String> mySortedDirectories = new TreeSet<String>();
        TreeSet<String> mySortedFiles = new TreeSet<String>();
        for (int i = 0; i < ObjectHolder.length; ++i) {
            try {
                if (ObjectHolder[i] instanceof DirectoryString && !(ObjectHolder[i] instanceof FileString)) {
                    mySortedDirectories.add(ObjectHolder[i].toString());
                    continue;
                }
                mySortedFiles.add(ObjectHolder[i].toString());
                continue;
            }
            catch (Exception F2) {
                this.responseJTextArea.setText("Exception in casting : " + F2.getMessage());
            }
        }
        Iterator it = mySortedDirectories.iterator();
        while (it.hasNext()) {
            String nameOfCurrentNode = ((String)it.next()).toString();
            for (int z = 0; z < ObjectHolder.length; ++z) {
                if (!ObjectHolder[z].toString().equalsIgnoreCase(nameOfCurrentNode)) continue;
                this.myListModel.addElement(ObjectHolder[z]);
            }
        }
        it = mySortedFiles.iterator();
        while (it.hasNext()) {
            String nameOfCurrentNode = ((String)it.next()).toString();
            for (int q = 0; q < ObjectHolder.length; ++q) {
                if (!ObjectHolder[q].toString().equalsIgnoreCase(nameOfCurrentNode)) continue;
                this.myListModel.addElement(ObjectHolder[q]);
            }
        }
        try {
            this.fileRootTextField.setText(file_in.getPath());
            this.myPath = file_in.getPath();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void dirEntered() {
        String directory = this.fileRootTextField.getText();
        if (this.isDirectory(directory)) {
            this.fillListModel(new File(directory));
        } else {
            DialogFactory.getErrorDialog("Error", "TheEnteredDirectoryIsNotValid");
        }
    }

    private void setButtonEnabled(boolean trueOrFalse) {
        this.sendJButton.setEnabled(trueOrFalse);
    }

    private boolean isDirectory(String path) {
        File myTempFile;
        try {
            myTempFile = new File(path);
        }
        catch (Exception J) {
            return false;
        }
        return myTempFile.isDirectory();
    }

    private void xmlFileClicked() {
        Object FileName_1 = this.myXmlList.getSelectedValue();
        String FileName = "";
        if (FileName_1 == null) {
            return;
        }
        FileName = FileName_1.toString();
        if (FileName.equalsIgnoreCase("..")) {
            this.myXmlList.removeAll();
            this.myFile = this.myFile.getParentFile();
            this.responseJTextArea.setText("");
            this.requestJTextArea.setText("");
            this.fillListModel(this.myFile);
            this.updateUI();
            return;
        }
        String FullFilePath = this.fileRootTextField.getText() + File.separator + FileName;
        this.responseJTextArea.setText("");
        this.requestJTextArea.setText("");
        if (this.isDirectory(FullFilePath)) {
            this.myFile = new File(FullFilePath);
            this.myXmlList.removeAll();
            this.fillListModel(this.myFile);
            this.updateUI();
            return;
        }
        try {
            String file = FileLoader.getInstance().loadFile(FullFilePath);
            this.requestJTextArea.setText(file);
            this.requestSC.getVerticalScrollBar().setValue(0);
            this.requestSC.getHorizontalScrollBar().setValue(0);
        }
        catch (Exception e) {
            this.requestJTextArea.setText("WrongInFile * " + FullFilePath + "* : " + e.getMessage() + " Path : " + this.fileRootTextField.getText());
        }
        catch (OutOfMemoryError e) {
            DialogFactory.getErrorDialog(null, "FiletooBig");
        }
    }

    private void doRequest() {
        this.mySender.setSessionId(this.mySessionId);
        try {
            this.mySender.setHost(this.myHostName.getText());
            this.mySender.setPort(this.myPortNumber.getText());
            this.mySender.send(this.requestJTextArea.getText());
            String response = this.mySender.getResponse();
            this.responseJTextArea.append(response);
            ++this.myNumberOfRequests;
            this.myHistory.addElement(new HistoryRequest(this.myNumberOfRequests, this.requestJTextArea.getText(), response));
        }
        catch (Exception e) {
            this.responseJTextArea.append("Exception : " + e);
        }
    }

    private void login() {
        try {
            String request = "<Request MO=\"Session\" Operation=\"Login\" ><User Name=\"" + this.myUser.getText() + "\" Pwd=\"" + this.myPwd.getText() + "\"/></Request>";
            this.mySender.setHost(this.myHostName.getText());
            this.mySender.setPort(this.myPortNumber.getText());
            this.mySender.setLoginRequest(request);
            this.mySender.connect();
            this.mySessionIdField.setText(this.mySender.getSessionId());
            this.mySessionId = this.mySender.getSessionId();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void logout() {
        String request = "<Request MO=\"Session\" Operation=\"Logout\" SessionId=\"" + this.mySessionId + "\"><User Name=\"" + this.myUser.getText() + "\" Pwd=\"" + this.myPwd.getText() + "\"/></Request>";
        System.out.println(request);
        try {
            this.mySender.setHost(this.myHostName.getText());
            this.mySender.setPort(this.myPortNumber.getText());
            this.mySender.setLogoutRequest(request);
            this.mySender.setSessionId(this.mySessionId);
            this.mySender.disconnect();
            this.mySessionIdField.setText("Logged out");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        RequestSender mySend = new RequestSender();
        JFrame myFrame = new JFrame("Request sender");
        WindowAdapter l = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        };
        myFrame.getContentPane().add(mySend);
        myFrame.addWindowListener(l);
        myFrame.setSize(850, 600);
        myFrame.setLocation(0, 0);
        mySend.init();
        myFrame.setVisible(true);
    }
}

