/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.integration.log;

import java.util.logging.Level;

public class LogLevels {
    public static final int LOG_LEVEL_DEBUG = 4;
    public static final int LOG_LEVEL_INFO = 3;
    public static final int LOG_LEVEL_WARNING = 2;
    public static final int LOG_LEVEL_ERROR = 1;

    public static String getLevelString(int logLevel) {
        String logString;
        switch (logLevel) {
            case 1: {
                logString = "ERROR";
                break;
            }
            case 3: {
                logString = "INFO";
                break;
            }
            case 2: {
                logString = "WARNING";
                break;
            }
            case 4: {
                logString = "DEBUG";
                break;
            }
            default: {
                logString = "UNKNOWN(" + logLevel + ")";
            }
        }
        return logString;
    }

    public static Level toLevel(int logLevel) {
        Level level = null;
        switch (logLevel) {
            case 1: {
                level = Level.SEVERE;
                break;
            }
            case 3: {
                level = Level.INFO;
                break;
            }
            case 2: {
                level = Level.WARNING;
                break;
            }
            case 4: {
                level = Level.FINE;
            }
        }
        return level;
    }

    public static int toLogLevel(Level level) {
        int levelValue = level.intValue();
        int logLevel = levelValue <= Level.FINE.intValue() ? 4 : (levelValue <= Level.INFO.intValue() ? 3 : (levelValue <= Level.WARNING.intValue() ? 2 : (levelValue < Level.OFF.intValue() ? 1 : 0)));
        return logLevel;
    }
}

