/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.integration.management;

import ericsson.ere.defs.EreClassLoader;
import ericsson.ere.integration.log.EreIntegrationLogInterface;
import ericsson.ere.integration.management.AbstractAction;
import ericsson.ere.integration.management.EreRequestParser;
import ericsson.ere.integration.management.RequestParser;
import ericsson.ere.integration.receiver.requesthandler.XmlRequestHandler;
import ericsson.ere.integration.receiver.session.SessionHandler;
import ericsson.ere.integration.receiver.transport.HttpTransport;
import ericsson.ere.management.EreManager;
import java.net.Socket;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EreRequestTask
implements Runnable {
    private RequestParser myParser = null;
    private Socket myConnection;
    private EreIntegrationLogInterface myLog = null;
    private EreManager myEreManager = null;
    private SessionHandler mySessionHandler = null;

    public EreRequestTask() {
    }

    public EreRequestTask(Socket theConnection, EreManager ereManager, SessionHandler sessionHandler, EreIntegrationLogInterface log) {
        this.myEreManager = ereManager;
        this.mySessionHandler = sessionHandler;
        this.myConnection = theConnection;
        this.myLog = log;
    }

    public void init(Node setting) throws Exception {
        if (setting == null) {
            this.myParser = new EreRequestParser();
            ((AbstractAction)((Object)this.myParser)).setSessionHandler(this.mySessionHandler);
            ((AbstractAction)((Object)this.myParser)).setEreManager(this.myEreManager);
            this.myParser.init();
        } else {
            Element parserElement = (Element)setting;
            String className = "";
            try {
                className = parserElement.getAttribute("Class");
                this.myParser = (RequestParser)EreClassLoader.createInstance(className);
                if (this.myParser instanceof AbstractAction) {
                    ((AbstractAction)((Object)this.myParser)).setSessionHandler(this.mySessionHandler);
                    ((AbstractAction)((Object)this.myParser)).setEreManager(this.myEreManager);
                }
                if (parserElement.hasChildNodes()) {
                    this.myParser.init(parserElement.getChildNodes());
                } else {
                    this.myParser.init(null);
                }
            }
            catch (Exception e) {
                throw new InstantiationException(e.getClass().getSimpleName() + ": Failed to instantiate from class " + className + " for the following reason:\n" + e.getMessage());
            }
        }
    }

    private boolean hasLogger() {
        return this.myLog != null;
    }

    public void setLog(EreIntegrationLogInterface log) {
        this.myLog = log;
        if (this.hasLogger() && this.myLog.isLevel(3)) {
            this.myLog.print(3, "This logger was set for EreRequestTask.");
        }
    }

    @Override
    public void run() {
        HttpTransport transport = new HttpTransport(this.myConnection, this.myLog, new XmlRequestHandler(this.myParser, this.myLog, "UTF-8"), "UTF-8");
        transport.run();
    }
}

